/*!
 * PHPWind UI Library 
 * @Copyright 	: Copyright 2011, phpwind.com
 * @Descript	: 相片批量修改
 * @Author		: siweiran@gmail.com
 * @Depend		: core.js、jquery.js(1.7 or later)
 * $Id: dialog.js 8433 2012-04-18 12:23:53Z chris.chencq $			:
 */
;(function(){
	var photosWrap = $("#photosModify"),
		photosName = photosWrap.find("input[class=input]"),
		photosDesc = photosWrap.find("textarea"),
		photoAll = $("#photo_info_all"),
		photoAllname = photoAll.find("input[class=input]"),
		photoAllDes = photoAll.find("textarea"),
		btnSubmit = $(".btn_submit"),
		allForm = $("#allForm"),
		albumid = $("#albumid").val(),
		picIdList = $("#picIdList").val().split("|"),
		isAll = 0,//是否进行过批量修改
		changeIdArr = [],//保存单独修改过的图片id
		params = {'cover':"",'albumid':albumid,'commonTitle':"",'commonDesc':"",'customs':[],'photos':picIdList},//保存参数的对象
		radios = $("input[type=radio]");
	
	function checkAll(obj,num,checktype) {
	       var $obj = obj,
           		max = $obj.attr('maxlength') || num,
           		$info = $obj.next();
	       $obj.bind('keyup change', function () {
	    	   isAll=1;
	    	   var _val = $(this).val(),
               	_curL = _val.length;
           if (_curL == 0) {
               $info.html("0/" + max);
           } else if (_curL < max) {
               $info.html(_curL + "/" + max);
           } else {
               $info.html('<b style="color:#f30">' + _curL + "</b>/" + max);
           }
           if(checktype){
	           photosName.each(function(i){
	               $(this).val(_val);
	               check($(this),10);
	           });
           }else{
        	    photosDesc.each(function(i){
        	    	$(this).val(_val);
        	    	check($(this),100);
        	    });
           }
       })
	}
    //限制字符 不区分中英文字符数
    function check(obj, num) {
        var $obj = obj,
            max = $obj.attr('maxlength') || num,
            $info = $obj.next(),
            objVal = $obj.val().length;
        if (objVal >= 0 && objVal < max) {
            $info.html('<b>' + objVal + "</b>/" + max);
        }else{
        	$info.html('<b style="color:#f30">' + objVal + "</b>/" + max);
        }
        $obj.bind('keyup', function () {
            var _val = $(this).val(),
                _curL = _val.length;
            if (_curL == 0) {
                $info.html("0/" + max);
            } else if (_curL < max) {
                $info.html(_curL + "/" + max);
            } else {
                $info.html('<b style="color:#f30">' + _curL + "</b>/" + max);
            }
        })
    }
       
    //判断标题与描述是否修改
    function modifyTitDes(obj){
    	var oldVal=obj.val();
        obj.change(function(){
        	var $this=$(this);
        		var id = $this.data("id");
        		if(!contains(changeIdArr,id)){
        			changeIdArr.push(id)
        		}
        		else{
        			return;
        		}
        })
    }
    
    //判断元素是否存在数组里面,未考虑数组元素是对象的情况
    function contains(arr, obj) {
        for (var i = 0; i < arr.length; i++) {
            if (arr[i] === obj) {
                return true;
            }
        }
        return false;
    }
    function isTitleOk(arr){
    	for(var i=0,len=arr.length;i<len;i++){
    		var obj=$("#title"+arr[i]);
    		if($.trim(obj.val()).length===0)
    			return false;
    	}
    	return true;
    }
    function showAjaxData(url, data, type, dataType, sucCallBack) {
        $.ajax({
            url: url,
            data: data,
            type: type ? type : "POST",
            dataType: dataType,
            success: function (data) {
                sucCallBack(data);
            },
            error: function () {
                Wind.Util.resultTip({
                    error: true,
                    msg: "请求出错,请重试",
                    follow: false
                });
            }
        })
    }
   
    checkAll(photoAllname,10,true)||checkAll(photoAllDes,100);  
    photosName.each(function(i){
        check($(this),10);
        modifyTitDes($(this))
    });
    photosDesc.each(function(i){
    	check($(this),100);
    	modifyTitDes($(this))
    });
    //确定封面
    radios.click(function(){
    	params['cover']=$(this).val();
    })
    //提交数据
    btnSubmit.bind('click',function(e){
    	 e.preventDefault(); 
    	 params['commonTitle'] = photoAllname.val();
    	 params['commonDesc'] = photoAllDes.val(); 	 
    	 //清空数组,防止重复累加
    	 params.customs.length=0;
    	 if(changeIdArr.length>0){
    		 for(var i=0,len=changeIdArr.length;i<len;i++){
    			 var photo=new Object();
    			 	pid = changeIdArr[i];
    			 photo.id=pid;
    			 photo.title = $("#title"+pid).val();
    			 photo.descrip = $("#descrip"+pid).val();
    			params.customs.push(photo);
    		 }
    	 }
    	 if(!isAll &&　params['cover']==="" && params['commonTitle']==="" && params['commonDesc']==="" && params['customs'].length===0){
    		 //console.log("未修改");
    		 window.location.href=jumpUrl;
    	 }else if(!isTitleOk(picIdList)){
    		   Wind.Util.resultTip({
	                 error: true,
	                 msg: "图片标题不能为空",
	                 follow: false
	             });
		        return false;
    	 }
    	 else{ 	 
    		 var url = allForm.attr('action');
    		 	var callback=function(data){
    		 		if(data.state === "success"){
    		 		   Wind.Util.resultTip({
    		                 msg: "修改成功"
    		             });
    		 		  window.location.href=jumpUrl;
    		 		}else{
    		 			  Wind.Util.resultTip({
    		 				 error: true,
     		                 msg: data.message
     		             });
    		 		}
    		 	}
    		 	//console.log(JSON.stringify(params));
    		  showAjaxData(url,params,"Get","JSON",callback); 	
    	 }
    })
})()