/*!
 * PHPWind UI Library
 * @Copyright   : Copyright 2011, phpwind.com
 * @Descript    : 相册图片浏览
 * @Author      : siweiran@gmail.com
 * @Depend      : core.js、jquery.js(1.7 or later)
 * $Id: dialog.js 8433 2012-04-18 12:23:53Z chris.chencq $          :
 */
var imgContent = $("#imgContent"),
    pName = $("#photoName"),
    pDescript = $("#photoDescrip"),
    commtentsNum = $("#photo_comments_num"),
    _pre = $("#photo_pre"),
    _next = $("#photo_next"),
    report = $("#report"),
    picloading = $("#picloading"),
    textareaTips = $("#textareaTips"),
    $btnSubmit = $("#btn_submit_comment"),
    rotateRight = $("#rotateRight"),
    rotateLeft = $("#rotateLeft");
function checkLength(obj, maxlen,isfocus) {
    var len = obj.val().length;
    if (len>0 && len <= maxlen){
    	return true;
    }
    else{
    	if(isfocus){
    		obj.focus();
    	}
    	if($("#errorTitle").length){
    		$("#errorTitle").show();
    	}
    	return false;
    }
}
function DrawImage(ImgD, iwidth, iheight) {
    //参数(图片,允许的宽度,允许的高度)
    var image = new Image();
    image.src = ImgD.src;
    if (image.width > 0 && image.height > 0) {
        if (image.width / image.height >= iwidth / iheight) {
            if (image.width > iwidth) {
                ImgD.width = iwidth;
                ImgD.height = (image.height * iwidth) / image.width;
            } else {
                ImgD.width = image.width;
                ImgD.height = image.height;
            }
        } else {
            if (image.height > iheight) {
                ImgD.height = iheight;
                ImgD.width = (image.width * iheight) / image.height;
            } else {
                ImgD.width = image.width;
                ImgD.height = image.height;
            }
        }
    }
}

//图片旋转插件 http://code.google.com/p/jquery-rotate/
jQuery.fn.rotate = function(angle, whence) {
    var p = this.get(0);
    if (!whence) {
        p.angle = ((p.angle == undefined ? 0 : p.angle) + angle) % 360;
    } else {
        p.angle = angle;
    }
    if (p.angle >= 0) {
        var rotation = Math.PI * p.angle / 180;
    } else {
        var rotation = Math.PI * (360 + p.angle) / 180;
    }
    var costheta = Math.cos(rotation);
    var sintheta = Math.sin(rotation);
    if (document.all && !window.opera) {
        var canvas = document.createElement('img');
        canvas.src = p.src;
        canvas.height = p.height;
        canvas.width = p.width;
        canvas.style.filter = "progid:DXImageTransform.Microsoft.Matrix(M11=" + costheta + ",M12=" + (-sintheta) + ",M21=" + sintheta + ",M22=" + costheta + ",SizingMethod='auto expand')";
    } else {
        var canvas = document.createElement('canvas');
        if (!p.oImage) {
            canvas.oImage = new Image();
            canvas.oImage.src = p.src;
            canvas.oImage.width = p.width;
            canvas.oImage.height = p.height;
        } else {
            canvas.oImage = p.oImage;
        }

        canvas.style.width = canvas.width = Math.abs(costheta * canvas.oImage.width) + Math.abs(sintheta * canvas.oImage.height);
        canvas.style.height = canvas.height = Math.abs(costheta * canvas.oImage.height) + Math.abs(sintheta * canvas.oImage.width);
        var context = canvas.getContext('2d');
        context.save();
        if (rotation <= Math.PI / 2) {
            context.translate(sintheta * canvas.oImage.height, 0);
            console.log("1"+canvas.oImage.height)
        } else if (rotation <= Math.PI) {
        	 console.log("2")
            context.translate(canvas.oImage.width, -costheta * canvas.oImage.height);
        } else if (rotation <= 1.5 * Math.PI) {
        	 console.log("3"+canvas.oImage.width)
            context.translate(-costheta * canvas.oImage.width, canvas.height);
        } else {
            context.translate(0, -sintheta * canvas.oImage.width);
        }
        context.rotate(rotation);
        context.drawImage(canvas.oImage, 0, 0, canvas.oImage.width, canvas.oImage.height);
        context.restore();
    }
    canvas.id = p.id;
    canvas.angle = p.angle;
    p.parentNode.replaceChild(canvas, p);
}

jQuery.fn.rotateRight = function(angle) {
    this.rotate(angle == undefined ? 90 : angle);
}

jQuery.fn.rotateLeft = function(angle) {
    this.rotate(angle == undefined ? -90 : -angle);
}
rotateLeft.click(function() {
    $("#rotate").rotateLeft()
    return false;
});
rotateRight.click(function() {
    $("#rotate").rotateRight()
    return false;
})
//限制字符 不区分中英文字符数


function check(obj, tips, num) {
    var $obj = obj,
        max = $obj.attr('maxlength') || num,
        $info = tips,
        objVal = $obj.val().length;
    if (objVal > 0) {
        $info.html('<b>' + objVal + "</b>/" + max);
    }
    $obj.bind('keyup change', function() {
        var _val = $(this).val(),
            _curL = _val.length;
        if (_curL == 0) {
            $info.html("0/" + max);
        } else if (_curL < max) {
            $info.html(_curL + "/" + max);
        } else {
            $info.html('<b style="color:#f30">' + _curL + "</b>/" + max);
        }
    })
}

function showAjaxData(url, data, type, dataType, sucCallBack) {
    $.ajax({
        url: url,
        data: data,
        type: type ? type : "POST",
        dataType: dataType,
        success: function(data) {
            sucCallBack(data);
        },
        error: function() {
            Wind.Util.resultTip({
                error: true,
                msg: "请求出错,请重试",
                follow: false
            });
        }
    })
}

function slider(options) {
    this.setOptions(options);
    this.photoList = this.options.photoList;
    this.photo_list_item = this.options.photo_list_item;
    this.photo_len = this.photo_list_item.length; //缩略图的个数
    this.pic_edit = this.options.pic_edit;
    this.pic_del = this.options.pic_del;
    this.pic_handle = this.options.pic_handle; //隐藏的input，保存当前图片的id
    this.comment_content = this.options.comment_content;
    this.commentV = this.options.commentV;
    this.currentId = this.pic_handle.val();
    this.page = this.options.page || 10; //每版显示10条       
    this.dis = this.options.dis || 59; //单位缩略图间距              
    this.perNum = this.options.perNum || 5; //每次移动5条           
    this.exifInfoArr = []; //保存照片EXIF信息        
    this.picCommentArr = [] //保存照片的评论信息
    this.init();
}
slider.prototype = {
    init: function() {
        this.changHash();
        var _this = this,
            curId = location.hash.substr(1);
        //重写photo_mini_list的宽度
        _this.photoList.css("width", _this.photo_len * _this.dis);
        //确定当前小图的位置
        _this.setPosition($("#photo_" + curId));
        //举报的图片id
        report.data("typeid", curId);
        //左右按钮绑定事件
        _this.buttonClick();
        buttonStatus(this.commentV, $btnSubmit);
        //点击缩略图
        $("#photo_mini_list a").bind('click', function(e) {
            e.preventDefault();
            var $this = $(this);
            _this.displayImage($this);
        })
        $("#nextPic").bind('click', function() {
            _this.nextPic(true);
        })
        $("#prePic").bind('click', function() {
            _this.prePic(true);
        })
        _this.operatePic();
        _this.submitComment();
        _this.loadExif();
        //删除回复操作
        _this.comment_content.find('.pop_close').live('click', function(e) {
            e.preventDefault();
            var $this = $(this),
                $id = $this.attr('data-del');
            _this.deleteComment($this, $id);
        })

        //left、right键
        $(document).bind('keydown', function(event) {
            if (event.keyCode == 37) {
                _this.prePic(true);
            }
            if (event.keyCode == 39) {
                _this.nextPic(true);
            }
        })
        //评论分页
        this.comment_content.find(".pages_next,.pages_pre").live("click",function(e){
        	e.preventDefault();
        	var $this = $(this);
        	_this.loadComment(_this.currentId,{},$this.attr("href"),true);
        })
        check(this.commentV, textareaTips, 140);
    },
    //改变url的hash值,用于刷新页面后定向当前页
    changHash: function() {
        var _this = this,
            currentId = _this.currentId,
            hash = (!window.location.hash) ? "#" + currentId : window.location.hash;
        window.location.hash = hash;
    },
    setOptions: function(options) {
        this.options = {
            photoList: $("#photo_mini_list"),
            photo_list_item: $("#photo_mini_list li"),
            pic_edit: $("#pic_edit"),
            pic_del: $("#pic_del"),
            pic_handle: $("#curPicId"),
            comment_content: $("#photo_comments"),
            commentV: $("#J_fresh_post_ta")
        }
        $.extend(this.options, options)
    },
    //左右按钮绑定事件
    buttonClick: function() {
        var _this = this;
        _pre.on('click', function(e) {
            e.preventDefault();
            var p_left = _this.photoList.css("left");
            if (p_left != "0px") {
                _this.move("right");
            } else {
                return false;
            }
        })
        _next.on('click', function(e) {
            e.preventDefault();
            if (!_this.isLastEleView()) {
                _this.move("left");
            } else {
                return false;
            }
        })
    },
    //判断最后一个元素是否出现在可视范围内
    isLastEleView: function() {
        var _this = this,
            lastEle = $("#photo_mini_list li:last"),
            p_left = parseInt(_this.photoList.css("left")),
            s_left = p_left < 0 ? Math.abs(p_left) : p_left,
            wrapwidth = this.page * this.dis;
        if (s_left + wrapwidth >= lastEle.position().left) {
            return true;
        } else {
            return false;
        }
    },
    //点击缩略图显示大图 ,ele为a元素
    displayImage: function(ele) {
        var _this = this,
            url = ele.attr('data-img'),
            $id = ele.attr("data-id");
        ele.parent().addClass('current').siblings().removeClass('current');
        //先执行onload事件然后再给src赋值
        _this.preloadImg(url);
        location.hash = $id;
        //改变ID,用于删除、编辑操作
        _this.currentId = $id;
        //_this.pic_handle.val($id);
        //举报的图片id
        report.data("typeid", $id);
        _this.firstLastMove(ele.parent());
        _this.loadPicInfo(ele);
        _this.loadComment($id,{photoid:$id,page:1})
    },
    //图片预加载
    preloadImg: function(url) {
        var img = new Image();
        img.id = "rotate";
        picloading.show(); //显示loading
        img.onload = function() {
            img.onload = null;
            picloading.hide();
            if ($.browser.version == "6.0") { //ie6不支持maxwidth,需要对其进行等比缩放
                DrawImage(img, 600, 400);
            }
            imgContent.html(img)
        }
        img.onerror = function() {
            Wind.Util.resultTip({
                error: true,
                msg: "图片加载失败"
            })
        }
        img.src = url; //先执行onload事件然后再给src复制
    },
    //对图片的编辑、删除操作
    operatePic: function() {
        var _this = this;
        _this.pic_del.bind('click', function(e) {
            e.preventDefault();
            _this.deletePic($(this));
        })
        _this.pic_edit.bind('click', function(e) {
            e.preventDefault();
            _this.editPic($(this));
        })
    },
    //获取当前图片的索引 从1开始
    getSlideIndex: function(cur) {
        return this.photo_list_item.index(cur) + 1;
    },
    //根据当前索引计算cur元素的left值
    computeLeft: function(cur) {
        var index = this.getSlideIndex(cur),
            page = this.page,
            dis = this.dis,
            left = 0,
            num = parseInt(index / page);
        if (index < page) {
            left = 0;
        }
        //如果当前显示的索引刚好是page的整数倍,小图居中显示
        else if (index % page == 0) {
            var n = parseInt(page / 2);
            left = ((num - 1) * page + n) * dis;
        } else {
            left = num * page * dis;
        }
        return left;
    },
    //当前版块的最左边或者最右边
    firstLastMove: function(ele) {
        var cur_li = ele,
            _this = this,
            cur_left = cur_li.position().left,
            p_left = parseInt(_this.photoList.css("left")),
            s_left = p_left < 0 ? Math.abs(p_left) : p_left,
            index = _this.getSlideIndex(cur_li),
            r_dis = (_this.page - 1) * _this.dis;
        if (s_left == cur_left && index > 1) {
            _this.move('right');
        }
        if (s_left + r_dis === cur_left) {
            _this.move('left');
        }
    },
    setPosition: function(cur) {
        var left = this.computeLeft(cur),
            _left = "-" + left + "px",
            ele = cur.find('a');
        this.displayImage(ele);
        this.photoList.css({
            "left": _left
        });
        this.buttonisActive()
    },
    nextPic: function(showTips) {
    	var curEl = this.photoList.find(".current"),nextEl = curEl.next();
        if (nextEl.length) {
            var link = nextEl.find("a");
            link.trigger('click');
            return true;
        } else {
        	if(showTips){
                Wind.Util.resultTip({
                    error: true,
                    msg: "这是最后一张,没有下一张啦",
                    follow: false
                });
        	}
            return false;
        }
    },
    prePic: function(showTips) {
    	var curEl = this.photoList.find(".current"),preEl = curEl.prev();
        if (preEl.length) {
            var link = preEl.find("a");
           this.firstLastMove(curEl);
            link.trigger('click');
            return true;
        } else {
         	if(showTips){
                Wind.Util.resultTip({
                    error: true,
                    msg: "这是第一张,没有上一张啦",
                    follow: false
                });
        	}
            return false;
        }
    },
    move: function(dir) {
        var moveLen = this.perNum * this.dis;
        var _this = this;
        if (!this.photoList.is(":animated")) {
            if (dir == "left") {
                this.photoList.animate({
                    left: '-=' + moveLen
                }, function() {
                    _this.buttonisActive()
                });
            } else {
                this.photoList.animate({
                    left: '+=' + moveLen
                }, function() {
                    _this.buttonisActive()
                });
            }
        }
    },
    buttonisActive: function() {
        var p_left = this.photoList.css("left");
        if (this.photo_len < this.page) {
            _pre.addClass("pre_disabled");
            _next.addClass("next_disabled");
        } else if (p_left == "0px") {
            _pre.addClass("pre_disabled");
            _next.removeClass("next_disabled");
            return false;
        } else if (this.isLastEleView()) {
            _next.addClass("next_disabled");
            _pre.removeClass("pre_disabled");
            return false;
        } else {
            _pre.removeClass("pre_disabled");
            _next.removeClass("next_disabled");
        }
    },
    //加载图片的标题以及评论
    loadPicInfo: function(ele) {
        pName.html(ele.attr("data-pname"));
        pDescript.html(ele.attr("data-pdes"));
    },
    //删除图片
    deletePic: function(ele) {
        var _this = this,
            id = _this.currentId;
        ajaxConfirm({
            elem: ele,
            href: ele.attr('href') + "&photoid=" + id,
            msg: "照片删除后不可恢复,确定删除吗?",
            callback: function() {
                Wind.Util.resultTip({
                    msg: '删除成功'
                });
                if(_this.nextPic()||_this.prePic()){
                	$("#photo_" + id).remove();
                }
                else{//相册只有一张图片的情况跳转到图片上传页面
                	window.location.href=url.jumpToUpload;
                }
            }
        });
    },
    //编辑图片
    editPic: function(ele) {
        var _this = this,
            id = _this.currentId,
            url = ele.attr('href');
        var sucCallBack = function(data) {
                if (ajaxTempError(data)) {
                    Wind.dialog.html(data, {
                        position: 'fixed',
                        title: '编辑照片',
                        isMask: false,
                        isDrag: true,
                        callback: function() {
                            var $form = $("#J_edit_photo"),
                                $btnSubmit = $("#btn_edit_photo"),
                                photoName = $form.find("input[name=name]"),
                                photoDes = $form.find("textarea[name=descrip]");
                            //即时显示字数
                            check(photoName, photoName.next(), 10) || check(photoDes, photoDes.next(), 100);
                            $btnSubmit.on('click', function(e) {
                                e.preventDefault();
                                if (checkLength(photoName, 20, true)) 
                                	_this.sendEditData($form);
                            })
                        }
                    })
                }
            }
        if ($("#J_edit_photo").length) {
            return false;
        } else {
            showAjaxData(url, {
                photoid: id
            }, "post", 'html', sucCallBack);
        }
    },
    sendEditData: function($obj) {
        var url = $obj.attr("action"),
            formData = $obj.serialize();
        var callBack = function(data) {
                if (data.state === "success") {
                    Wind.Util.resultTip({
                        msg: "编辑成功"
                    });
                    window.location.reload();
                } else {
                    Wind.Util.resultTip({
                        error: true,
                        msg: data.message[0],
                        follow: false
                    });
                }
            }
        showAjaxData(url, formData, null, 'json', callBack);

    },
    //发表评论
    submitComment: function() {
        var _this = this,
            $form = $("#photoCommentForm");
        $btnSubmit.click(function(e) {
            e.preventDefault();
            var $comment = $.trim(_this.commentV.val()),
                url = $form.attr("action"),
                csrf_token = GV.TOKEN,
                id = _this.currentId;

            // if (checkLength(_this.commentV,140,true)) {
            data = {
                content: $comment,
                photoid: id,
                csrf_token: csrf_token
            };
            var sucCallBack = function(data) {
                    if (!data.state && ajaxTempError(data)) {
                        _this.commentV.val('');
                        textareaTips.html('0/140');
                        Wind.Util.resultTip({
                            msg: "评论成功"
                        });
                        $btnSubmit.addClass('disabled').attr('disabled', 'disabled');
                        //写入评论数组
                        _this.picCommentArr[id] = data;
                        _this.comment_content.html(_this.picCommentArr[id]);
                    } else {
                        Wind.Util.resultTip({
                            error: true,
                            msg: data.message[0],
                            follow: false
                        });
                    }
                    //用户名标签化，验证函数是否已存在
                    if ($.isFunction(window.userCard)) {
                        userCard();
                    } else {
                        Wind.js(GV.JS_ROOT + 'pages/common/userCard.js?v=' + GV.JS_VERSION);
                    }
                }

            showAjaxData(url, data, null, 'html', sucCallBack);
            //}
        })
    },
    //加载评论
    //params参数为对象 {photoid:$id,page:1}
    loadComment: function(id,params,loadurl,ispage) {
        var _this = this,sendUrl;
        var sucCallBack = function(data) {
                if (!data.state && ajaxTempError(data)) {
                    _this.comment_content.html(data);
                    //写入评论数组
                    _this.picCommentArr[id] = data;
                } else {
                    Wind.Util.resultTip({
                        error: true,
                        msg: data.message[0],
                        follow: false
                    });
                }
                if ($.isFunction(window.userCard)) {
                    userCard();
                } else {
                    Wind.js(GV.JS_ROOT + 'pages/common/userCard.js?v=' + GV.JS_VERSION);
                }
            }
        if (_this.picCommentArr[id] &&　!ispage) {
            _this.comment_content.html(_this.picCommentArr[id]);
        } else {
        	sendUrl = loadurl?loadurl:url.loadCommentUrl;
            showAjaxData(sendUrl,params,"POST", 'html', sucCallBack);
        }
        //用户名标签化，验证函数是否已存在
        if ($.isFunction(window.userCard)) {
            userCard();
        } else {
            Wind.js(GV.JS_ROOT + 'pages/common/userCard.js?v=' + GV.JS_VERSION);
        }
    },
    //加载图片EXIF信息
    loadExif: function() {
        var _this = this,
            $exif = $("#exif"),
            $loadExifInfo = $("#loadExifInfo"),
            $loadExifList = $loadExifInfo.find("ul");
        $exif.mouseover(function() {
            var currentId = _this.currentId;
            $loadExifInfo.show();
            $loadExifList.html('<div class="pop_loading"></div>');
            var callback = function(data) {
                    if (data.state === "success") {
                        var info = data.data;
                        if (info.length > 0) {
                            var infoArr = ['<li>厂商：' + info[0] + '</li>', '<li>型号：' + info[1] + '</li>', '<li>日期：' + info[2] + '</li>', '<li>大小：' + info[3] + '</li>', '<li>焦距：' + info[4] + '</li>', '<li>光圈：' + info[5] + '</li>', '<li>曝光时间：' + info[6] + '</li>', '<li>感光度：' + info[7] + '</li>', '<li>曝光程序：' + info[8] + '</li>', '<li>测光模式：' + info[9] + '</li>'].join("");
                        } else {
                            var infoArr = ['<li>图片没有EXIF信息</li>'].join("");
                        }
                        //将exif信息写到到数组中，避免重复请求
                        _this.exifInfoArr[currentId] = infoArr;
                        $loadExifList.html(infoArr);
                    } else {
                        $loadExifList.html(data.message[0]);
                    }
                }
            if (_this.exifInfoArr[currentId]) {
                $loadExifList.html(_this.exifInfoArr[currentId]);
            } else {
                showAjaxData(url.getExifUrl, {
                    photoid: currentId
                }, "GET", 'json', callback);
            }
        }).mouseout(function() {
            $loadExifInfo.hide();
        })
    },
    //删除回复
    deleteComment: function(ele, id) {
        var _this = this,
            url = ele.attr('href'),
            currentId = _this.currentId;
        var params = {
            message: '确定要删除这条评论吗？',
            type: 'confirm',
            isMask: false,
            follow: ele,
            onOk: function() {
                var callback = function(data) {
                        if (!data.state && ajaxTempError(data)) {
                            Wind.Util.resultTip({
                                msg: '删除成功'
                            });
                            //写入评论数组
                            _this.picCommentArr[currentId] = data;
                            _this.comment_content.html(_this.picCommentArr[currentId]);
                        }
                        //用户名标签化，验证函数是否已存在
                        if ($.isFunction(window.userCard)) {
                            userCard();
                        } else {
                            Wind.js(GV.JS_ROOT + 'pages/common/userCard.js?v=' + GV.JS_VERSION);
                        }
                    }
                showAjaxData(url, null, "GET", 'html', callback);
            }
        }
        Wind.dialog(params);
    }
}
