/*!
 * PHPWind UI Library 
 * @Copyright 	: Copyright 2011, phpwind.com
 * @Descript	: 相册图片列表
 * @Author		: siweiran@gmail.com
 * @Depend		: core.js、jquery.js(1.7 or later)
 * $Id: dialog.js 8433 2012-04-18 12:23:53Z chris.chencq $			:
 */
(function () {
    var $photoList = $("#photoList");
	if($.browser.msie && $.browser.version == "6.0"){
		$("#photoList  li").hover(function(){
			$(this).find(".operate").show();
		},function(){
			$(this).find(".operate").hide();
		})
	}
    //限制字符 不区分中英文字符数
    function check(obj, num) {
        var $obj = obj,
            max = $obj.attr('maxlength') || num,
            $info = $obj.next(),
            objVal = $obj.val().length;
        if (objVal > 0) {
            $info.html('<b>' + objVal + "</b>/" + max);
        }
        $obj.bind('keyup change', function () {
            var _val = $(this).val(),
                _curL = _val.length;
            if (_curL == 0) {
                $info.html("0/" + max);
            } else if (_curL < max) {
                $info.html(_curL + "/" + max);
            } else {
                $info.html('<b style="color:#f30">' + _curL + "</b>/" + max);
            }
        })
    }
    function showAjaxData(url, data, type, dataType, sucCallBack) {
        $.ajax({
            url: url,
            data: data,
            type: type ? type : "POST",
            dataType: dataType,
            success: function (data) {
                sucCallBack(data);
            },
            error: function () {
                Wind.Util.resultTip({
                    error: true,
                    msg: "请求出错,请重试",
                    follow: false
                });
            }
        })
    }
    //图片列表编辑
    $photoList.find('a.edit').click(function (e) {
        e.preventDefault();
        var $this = $(this),
            url = $this.attr("href");
        var callback = function (data) {
        	if(ajaxTempError(data)){
        		Wind.dialog.html(data,{
        			position	: 'fixed',
					title : '编辑照片',
					isMask		: false,
					isDrag : true,
					callback : function(){
						 var $form = $("#J_edit_photo");
						 	sendEditData($form);
						}
        			})
				}
        	}
        	showAjaxData(url, null, "GET", 'html', callback);
    })

    function sendEditData($obj) {
        var url = $obj.attr("action"),
        	$btnSubmit = $("#btn_edit_photo"),
        	photoName = $obj.find("input[name=name]"),
        	photoDes = $obj.find("textarea[name=descrip]");
        	
	        check(photoName, 20) || check(photoDes, 100);
        var callBack = function (data) {
            if (data.state === "success") {
                Wind.Util.resultTip({
                    msg: "编辑成功"
                });
              window.location.reload();
            } else {
                Wind.Util.resultTip({
                    error: true,
                    msg: data.message[0],
                    follow: false
                });
            }
        }  
        $btnSubmit.on('click',function(e){
        	e.preventDefault();
        	var formData = $obj.serialize();
            if(photoName.val().length==0){
            	$("#errorTitle").show().html("相片名称不能为空");
            }else if(photoDes.val().length>100){
            	$("#errorTitle").show().html("相片描述不能超出100个字");
            }else{
            	showAjaxData(url, formData, null, 'json', callBack);
            }
        })
   }
    //删除图片
    $photoList.find('a.del').click(function (e) {
        e.preventDefault();
        var $this = $(this);
        ajaxConfirm({
            elem: $this,
            href: $this.prop('href'),
            msg: "照片刪除后不可恢复,确定删除吗?",
            callback: function () {
                Wind.Util.resultTip({
                    msg: '删除成功'
                });
                $delId = $this.attr("data-del");
                $("#photo" + $delId).fadeOut();
            }
        });
    })

})()