/*!
 * PHPWind PAGE JS
 * @Copyright Copyright 2011, phpwind.com
 * @Descript: 前台-附件购买记录
 * @Author	: linhao87@gmail.com, TID
 * @Depend	: jquery.js(1.7 or later), global.js
 * $Id$
 */


;(function(){
	
	var read_buy = $('#J_read_buy'),
		buy_count = $('#J_buy_count'),						//购买统计
		post_attach = $('#J_post_attach'),				//附件
		attach_buy = $('#J_attach_buy'),					//附件购买
		buy_pop_tpl = '<div id="J_buy_pop" class="core_pop_wrap J_buyrecords_pop" style="display:none;">\
		<div class="core_pop">\
		<div class="pop_buy_history" style="width:420px">\
			<div class="pop_top J_drag_handle">\
				<a href="#" class="pop_close J_buy_close">关闭</a>\
				<strong>本帖购买记录</strong>\
			</div>\
			<div class="pop_cont">\
				<div class="f14 mb5">您当前积分为<span class="org J_my_credit"></span>，购买附件需花费<span class="org J_price_check"></span>，确定购买？</div>\
				<div class="f14 mb5"></div>\
			</div>\
			<div class="pop_bottom">\
				<button type="submit" class="btn btn_submit J_buy_sub">提交</button>\
				<button type="button" class="btn J_buy_close">取消</button>\
			</div>\
		</div>\
	</div>\
	</div>',
		records_pop_tpl = $('<div id="J_records_pop" class="core_pop_wrap J_buyrecords_pop" style="display:none;">\
	<div class="core_pop">\
		<div class="pop_buy_history">\
			<div class="pop_top J_drag_handle">\
				<a href="#" class="pop_close J_records_close">关闭</a>\
				<strong>本帖购买记录</strong>\
			</div>\
			<div class="pop_cont">\
				<table width="100%">\
					<colgroup>\
						<col width="40" />\
						<col />\
						<col width="60" />\
						<col width="110" />\
					</colgroup>\
					<thead>\
						<tr>\
							<td>序号</td>\
							<td>用户名</td>\
							<td>花费</td>\
							<td>购买时间</td>\
						</tr>\
					</thead>\
					<tbody id="J_records_list"><tr><td colspan="4"><div class="pop_loading"></div></td></tr></tbody>\
				</table>\
			</div>\
			<div class="pop_bottom">\
				<button type="button" class="btn J_records_close">关闭</button>\
			</div>\
		</div>\
	</div>\
		</div>');

	//查看购买记录
	$('#J_read_record').on('click', function(e){
		e.preventDefault();
		var $this = $(this),
			records_pop = $('#J_records_pop');

		if(!parseInt(buy_count.text())) {
			Wind.Util.resultTip({
				error : true,
				elem : $this,
				follow : true,
				msg : '暂没有购买记录'
			});
			return false;
		}

		$('#J_buy_pop').hide();

		if(records_pop.length) {
			buyPopPos($this, records_pop);
		}else{
			records_pop_tpl.appendTo('body');
			var records_pop = $('#J_records_pop');
			buyPopPos($this, records_pop);

			Wind.use('draggable', function(){
				records_pop.draggable( { handle : '.J_drag_handle'} );
			});

			//关闭
			$('.J_records_close').on('click', function(e){
				e.preventDefault();
				$('#J_records_pop').hide();
			});

			$.getJSON(this.href)
			.done(function(data){
				if(data.state == 'success') {
					var _data = data.data;
					if(_data) {
						var record_arr = [];
						for(i=0,len=_data.length; i<len; i++) {
							record_arr.push('<tr><td>'+ (i+1) +'</td><td><a target="_blank" href="'+ GV.U_CENTER + _data[i]['uid'] +'">'+ _data[i]['username'] +'</a></td><td>'+ _data[i]['cost'] + _data[i]['ctype'] +'</td><td>'+ _data[i]['created_time'] +'</td></tr>')
						}
						$('#J_records_list').html(record_arr.join(''));
						buyPopPos($this, records_pop);
					}
				}else if(data.state == 'fail'){
					Wind.Util.resultTip({
						error : true,
						follow : $this,
						msg : data.message[0]
					});
				}
			});
		}

	});

	//购买
	$('a.J_post_buy').on('click', function(e){
		e.preventDefault();
		var $this = $(this),
			id = $this.data('id'),
			role = $this.data('role'),
			price = parseInt($this.data('price')),			//价格
			util = $this.data('util'),						//单位
			url = this.href,								//提交地址
			my_credit = parseInt($this.data('credit'));		//我的积分

		$('#J_records_pop').hide();

		if(!GV.U_ID) {
			return false;
		}

		if(my_credit < price) {
			//积分不足
			Wind.Util.resultTip({
				error : true,
				elem : $this,
				follow : true,
				msg : '购买帖子内容需花费'+ price + util +'。你的积分不足，无法购买！'
			});
			return false;
		}
		//提交购买
		
		var attach_count = $('#J_attach_count_'+ id);
		$('#J_buy_pop').remove();

		$('body').append(buy_pop_tpl);
			var buy_pop = $('#J_buy_pop'),
				buy_sub = buy_pop.find('button.J_buy_sub');

			Wind.use('draggable', function(){
				buy_pop.draggable( { handle : '.J_drag_handle'} );
			});

			//关闭
			$('.J_buy_close').on('click', function(e){
				e.preventDefault();
				$('#J_buy_pop').hide();
			});

			
			buy_sub.on('click', function(e){
				e.preventDefault();

				if(role == 'attach') {
					//下载次数 +1
					attach_count.text(parseInt(attach_count.text())+1);
					//下载地址
					location.href = buy_sub.data('url');
					//解除绑定
					if($this.data('type') !== 2) {
						//非插入帖子
						$this.text('下载');
					}
					$this.off('click');
					//附件解除购买
					post_attach.data('cost', false);
					buy_pop.hide();
					Wind.Util.creditReward();

					//更新积分
					$('a.J_post_buy').data('credit', my_credit-price);
					return false;
				}

				ajaxBtnDisable(buy_sub);
				$.post(buy_sub.data('url'), function(data){
					if(data.state == 'success') {
						Wind.Util.resultTip({
							elem : buy_sub,
							follow : true,
							msg : data.message[0],
							callback : function(){
								if(role == 'post') {
									//显示出售内容
									location.reload();
								}
							}
						});
						buy_pop.remove();
						//read_buy.remove();

						$('#J_records_pop').remove();

						if(buy_count.length) {
							buy_count.text(parseInt(buy_count.text())+1);
						}
						
						//更新积分
						$('a.J_post_buy').data('credit', my_credit-price);
					}else if(data.state == 'fail') {
						Wind.Util.formBtnTips({
							error : true,
							wrap : buy_sub.parent(),
							msg : data.message[0]
						});
					}
					ajaxBtnEnable(buy_sub);
				}, 'json');
			});

		buyPopPos($this, buy_pop);
		fillData(buy_pop, my_credit, price, util, url);
	});

	//单击附件
	post_attach.on('click', function(e){
		e.preventDefault();
		if($(this).data('cost')) {
			attach_buy.click();
		}else{
			location.href = this.href;
		}
	});

	//插入的附件
	$('a.J_post_attachs').each(function(){
		var item = $(this);
		Wind.Util.hoverToggle({
			elem : item,
			list : $('#J_attach_post_info_'+ item.data('id')),
			callback : function(elem, list) {
				list.css({
					left : elem.offset().left,
					top : elem.offset().top + elem.height()
				});
			}
		});
	});
	$('a.J_attach_post_buy').on('click', function(e){
		e.preventDefault();
		$(this).parents('.J_attach_wrap').find('a.J_post_buy').click()
	});
	
	//购买插入附件
	$('#J_attach_post')

	//弹出定位
	function buyPopPos(elem, wrap){
		var wrap_width = wrap.outerWidth(),
			elem_of_left = elem.offset().left,
			win_width = $(window).width(),
			left;

		if(elem_of_left + wrap_width > win_width) {
			left = win_width - wrap_width;
		}else{
			left = elem_of_left;
		}
		wrap.css({
			top : elem.offset().top + elem.height(),
			left : left,
			position : 'absolute',
			zIndex : 1
		}).show();
	}

	//数据填充
	function fillData(pop, credit, price, util, url){
		pop.find('.J_my_credit').text(credit + util);			//我的积分
		pop.find('.J_price_check').text(price + util);			//购买价格
		pop.find('button.J_buy_sub').attr('data-url', url);		//提交地址
	}


})();