/*!
 * PHPWind PAGE JS
 * @Copyright Copyright 2011, phpwind.com
 * @Descript: 前台-可能认识的人
 * @Author	: linhao87@gmail.com, TID
 * @Depend	: jquery.js(1.7 or later), global.js
 * $Id$
 */


;(function(){
	//你可能感兴趣的人
	var friend_maybe = $('#J_friend_maybe'),
		friend_maybe_list = $('#J_friend_maybe_list'),			//列表
		maybe_others = $('#J_friend_maybe_others').text();		//剩余容器 textarea


		//查看共同好友
		friend_maybe_list.on('click', 'a.J_friend_view', function(e){
			e.preventDefault();
			var $this = $(this),
				uid = $(this).data('uid'),
				related = $('#J_friend_related_' + uid);		//关联的共同好友项

			if(!related.is(':visible')) {
				//收起已可见共同好友项
				var all_views = $('div.J_friend_related:visible').prev().find('a.J_friend_view');
				all_views.text(all_views.text().replace('↑','↓'));
				$('div.J_friend_related:visible').slideUp();

				//展示共同好友项
				related.slideDown();
				$this.text($this.text().replace('↓', '↑'));
			}else{
				related.slideUp();
				$this.text($this.text().replace('↑', '↓'));
			}
			
		});

		//加关注
		var lock = false;
		friend_maybe_list.on('click', 'a.J_friend_maybe_follow', function(e){
			e.preventDefault();
			var $this = $(this);

			if(lock) {
				return false;
			}
			lock = true;
			
			$.post(this.href, function(data){
				ajaxMaskRemove();
				if(data.state == 'success') {

					//插入剩余的可能认识的人
					if(maybe_others) {
						friend_maybe_list.append(maybe_others);

						avatarError(friend_maybe_list.children(':hidden').find('img.J_avatar'));
						userCard();

						//防重复
						maybe_others = '';
					}

					$this.hide();
					$this.parents('.J_friend_maybe_items').fadeOut('slow', function(){
						$(this).remove();

						var hide_items = $('div.J_friend_maybe_items:hidden:first');
						if(hide_items.length) {
							//还有未显示的推荐
							hide_items.fadeIn();

							if(!$('.J_friend_related:visible').length) {
								//如果没有共同好友被展开则展开第一项
								$('div.J_friend_maybe_items:first a.J_friend_view').click();
							}
							
						}else{
							//没数据了
							friend_maybe.fadeOut();
						}
					});
					
				}else if(data.state == 'fail') {
					Wind.Util.resultTip({
						error : true,
						elem : $this,
						follow : true,
						msg : data.message[0]
					});
				}

				lock = false;
			}, 'json');
		});

})();