/*!
 * PHPWind PAGE JS
 * @Copyright Copyright 2011, phpwind.com
 * @Descript: 前台-页面设计
 * @Author	: linhao87@gmail.com
 * @Depend	: jquery.js(1.7 or later), core,js
 * $Id: message_index.js 5804 2012-03-12 08:58:35Z hao.lin $
 */
 
;(function(){
	var designUtil = {},
		mod_wrap = $('div.J_mod_wrap'),
		layout_edit = $('#J_layout_edit'),
		mode_edit = $('#J_mode_edit'),
		mode_edit_tit = $('#J_mode_edit_tit'),
		mode_edit_btn = $('#J_mode_edit_btn'),
		mod_tit_edit = $('#J_mod_tit_edit'),
		design_move_temp = $('#J_design_move_temp'),									//移动模板
		design_move_height = design_move_temp.outerHeight(),
		design_move_half_height = design_move_temp.outerHeight()/2,		//
		design_move_half_width = design_move_temp.outerWidth()/2,			//
		move_lock = true,																							//移动锁定
		layout_a = $('#J_layout_sample a'),
		module_a = $('#J_tab_type_ct a'),
		module_url = null,																						//模块请求地址
		mudule_box,
		modlayout = {},
		moduleid = '',
		moduleid_input = $('#J_moduleid'),						//值同moduleid 用于单个页面内的js获取
		uniqueid = $('#J_uniqueid').val(),
		pageid = $('#J_pageid').val(),
		dtype = $('#J_type').val(),
		uri = $('#J_uri').val(),
		title_clone = '',										//标题html_添加
		menu_pop = $('div.J_menu_pop'),						//菜单弹窗
		doc = $(document),
		design_zindex = 100000;											//设计下统一z值

	var layout_edit_pop = $('#J_layout_edit_pop'),											//弹窗
		layout_edit_nav = $('#J_layout_edit_nav'),											//弹窗导航
		layout_edit_contents = $('#J_layout_edit_contents');						//弹窗内容
		design_name = $('#J_design_name'),															//弹窗名
		design_del = $('#J_design_del');																//删除

	var tabnav_data = $('#J_tabnav_data');

	var tabct_data = $('#J_tabct_data'),
		tabct_push = $('#J_tabct_push');			//推送tab content

	var guide_text = '选择一个合适的结构拖至此区域',	//新手引导文案
		guide_cls = 'tempplace_tips';					//新手引导class

/*
 * 结构拖拽
*/
	var layout_temp = {
		'100' : '<div role="structure__ID" data-lcm="100" class="box_wrap design_layout_style J_mod_layout" style="display:none;">\
			<h2 role="titlebar" class="design_layout_hd cc J_layout_hd"><span>标题</span></h2>\
			<div class="design_layout_ct mod_box J_mod_box"></div></div>',
		'1_1' : '<div role="structure__ID" data-lcm="1_1" class="box_wrap design_layout_style J_mod_layout design_layout_1_1" style="display:none;">\
			<h2 role="titlebar" class="design_layout_hd cc J_layout_hd"><span>标题</span></h2>\
			<div class="design_layout_ct"><div class="design_layout_1_1_left mod_box J_mod_box"></div><div class="design_layout_1_1_right mod_box J_mod_box"></div></div></div>',
		'1_2' : '<div role="structure__ID" data-lcm="1_2" class="box_wrap design_layout_style J_mod_layout design_layout_1_2" style="display:none;">\
			<h2 role="titlebar" class="design_layout_hd cc J_layout_hd"><span>标题</span></h2>\
			<div class="design_layout_ct"><div class="design_layout_1_2_left  mod_box J_mod_box"></div><div class="design_layout_1_2_right mod_box J_mod_box"></div></div></div>',
		'2_1' : '<div role="structure__ID" data-lcm="2_1" class="box_wrap design_layout_style J_mod_layout design_layout_2_1" style="display:none;">\
			<h2 role="titlebar" class="design_layout_hd cc J_layout_hd"><span>标题</span></h2>\
			<div class="design_layout_ct"><div class="design_layout_2_1_left mod_box J_mod_box"></div><div class="design_layout_2_1_right mod_box J_mod_box"></div></div></div>',
		'1_3' : '<div role="structure__ID" data-lcm="1_3" class="box_wrap design_layout_style J_mod_layout design_layout_1_3" style="display:none;">\
			<h2 role="titlebar" class="design_layout_hd cc J_layout_hd"><span>标题</span></h2>\
			<div class="design_layout_ct"><div class="design_layout_1_3_left mod_box J_mod_box"></div><div class="design_layout_1_3_right mod_box J_mod_box"></div></div></div>',
		'3_1' : '<div role="structure__ID" data-lcm="3_1" class="box_wrap design_layout_style J_mod_layout design_layout_3_1" style="display:none;">\
			<h2 role="titlebar" class="design_layout_hd cc J_layout_hd"><span>标题</span></h2>\
			<div class="design_layout_ct"><div class="design_layout_3_1_left mod_box J_mod_box"></div><div class="design_layout_3_1_right mod_box J_mod_box"></div></div></div>',
		'1_1_1' : '<div role="structure__ID" data-lcm="1_1_1" class="box_wrap design_layout_style J_mod_layout design_layout_1_1_1" style="display:none;">\
			<h2 role="titlebar" class="design_layout_hd cc J_layout_hd"><span>标题</span></h2>\
			<div class="design_layout_ct"><div class="design_layout_1_1_1_left mod_box J_mod_box"></div><div class="design_layout_1_1_1_cont mod_box J_mod_box"></div><div class="design_layout_1_1_1_right mod_box J_mod_box"></div></div></div>',
		'1_1_1_1' : '<div role="structure__ID" data-lcm="1_1_1_1" class="box_wrap design_layout_style J_mod_layout design_layout_1111" style="display:none;">\
			<h2 role="titlebar" class="design_layout_hd cc J_layout_hd"><span>标题</span></h2>\
			<div class="design_layout_ct"><div class="design_layout_1111_left mod_box J_mod_box"></div><div class="design_layout_1111_left mod_box J_mod_box"></div><div class="design_layout_1111_right mod_box J_mod_box"></div><div class="design_layout_1111_right mod_box J_mod_box"></div></div></div>',
		'tab' : '<div role="structure__ID" data-lcm="tab" class="box_wrap design_layout_style J_mod_layout J_tab_wrap" style="display:none;">\
			<div role="titlebar" class="design_layout_hd cc J_layout_hd J_tabs_nav">\
				<li class="current"><a href="" data-id="tab_1">栏目1</a></li><li><a href="" data-id="tab_2">栏目2</a></li>\
			</div>\
			<div class="J_tabs_ct"><div class="design_layout_ct mod_box J_mod_box J_tabct_tab_1"></div>\
			<div class="design_layout_ct mod_box J_mod_box J_tabct_tab_2" style="display:none;"></div></div></div>'
	},
	insert_holder = $('<div id="J_insert_holder" class="insert_holder"></div>'),
	layout_class_mapping = {
		'100' : 'design_layout_style J_mod_layout',
		'1_1' : 'design_layout_style J_mod_layout design_layout_1_1',
		'1_2' : 'design_layout_style J_mod_layout design_layout_1_2',
		'2_1' : 'design_layout_style J_mod_layout design_layout_2_1',
		'1_3' : 'design_layout_style J_mod_layout design_layout_1_3',
		'3_1' : 'design_layout_style J_mod_layout design_layout_3_1',
		'1_1_1' : 'design_layout_style J_mod_layout design_layout_1_1_1',
		'1_1_1_1' : 'design_layout_style J_mod_layout design_layout_1111',
		'tab' : 'design_layout_style J_mod_layout'
	},
	module_class_mapping = 'mod_boxA mod_boxB mod_boxC mod_boxD mod_boxE';

	//移除头部的消息和发帖下拉
	$('#J_head_msg_pop, #J_head_forum_pop, #J_head_user_menu, #J_head_nav_my_list').remove();

	//离开页面提示
	window.onbeforeunload = function() {
		return '您确定要退出页面设计状态？确定退出后，已修改的数据将不会保存。';
	};

	//已有编辑模块 循环结构数据
	var mod_wrap_len = mod_wrap.length;
	for(i=0;i<mod_wrap_len;i++){
		if(mod_wrap[i].lastChild){
			var layouts = $(mod_wrap[i]).find('.J_mod_layout');
			eachModLayout(layouts.parent());
		}
	}

	//防止链接元素被拖拽
	$('#J_layout_sample a, #J_tab_type_ct a').each(function(){
		this.ondragstart = function (e) {
			return false;
		};
	});

	//去除锚点
	location.hash = '';

	//global.js
	tabsBind(layout_edit_pop);

/*
 * 点击结构项
*/
	layout_a.on('mousedown', function(e){

		//解锁
		move_lock = false;

		//显示移动模板
		design_move_temp.show().css({
			left : e.pageX - 20,
			top : e.pageY - 20
		}).data('name', $(this).data('name'));

		//鼠标拖动
		doc.off('mousemove').on('mousemove', function(e){
			if(!move_lock) {
				var leftx = e.pageX - 10,
						topx = e.pageY - 10;

				//模板定位
				design_move_temp.show().css({
					left : leftx,
					top : topx
				});

				var move_c_left = leftx + design_move_half_width,
						move_c_top = topx + design_move_half_height;

				moveTemp(design_move_temp, move_c_left, move_c_top);

			}
		});

	});


/*
 * 点击模块
*/
	var model;
	module_a.on('mousedown', function(e){
		//判断是否有结构
		if(!$('div.J_mod_layout').length) {
			Wind.Util.resultTip({
				error : true,
				msg : '选择结构后才能设置模块，请先选择结构',
				zindex : design_zindex
			});
			return false;
		}

		module_url = this.href;
		model = this.id;
		//解锁
		move_lock = false;

		//显示移动模板
		design_move_temp.show().css({
			left : e.pageX - 20,
			top : e.pageY - 20
		});

//

		//鼠标拖动
		doc.off('mousemove').on('mousemove', function(e){
			if(!move_lock) {
				var leftx = e.pageX - 10,
						topx = e.pageY - 10;

				//模板定位
				design_move_temp.show().css({
					left : leftx,
					top : topx
				});

				var move_c_left = leftx + design_move_half_width,
						move_c_top = topx + design_move_half_height;

				moveTemp(design_move_temp, move_c_left, move_c_top);

			}
		});

	}).on('click', function(e){
		e.preventDefault();
	});


	//鼠标抬起 取消移动
	doc.on('mouseup', function(e){
		move_lock = true;

		doc.off('mousemove');
		
		var wrap = $('#J_insert_holder').parent(),
				insert_holder_visible = $('#J_insert_holder:visible'),
				layout_move = $('#J_layout_move');												//已有的结构

		if(insert_holder_visible.length) {
			//有占位模板

			if(layout_move.length) {
				//移动已有结构
				layout_move.attr({
					'id' : layout_move.data('randomid'),
					'style' : layout_move.data('orgstyle')		//恢复样式
				});
				layout_move.hide().insertAfter(insert_holder_visible).fadeIn('200');
				insert_holder_visible.remove();
						
				eachModLayout(layout_move.parent());
			}else{
				if(module_url) {
					//请求模块
					mudule_box = insert_holder.parent();

					$.post(MODULE_ADD_TAB, {
						model : model,
						pageid : pageid
					}, function(data){
						if(data.state == 'success') {
							menu_pop.hide();

							design_name.text('模块管理');
							design_del.text('删除该模块').data('role', 'module');

							design_del.hide();
							//global.js
							popPos(layout_edit_pop);

							layout_edit_nav.children().hide();
							var _data = data.data,
								nav_temp = false;
							for(i=0,len=_data.length; i<len; i++) {
								if(_data[i] == 'template') {
									nav_temp = true;
									break;
								}
							}

							getModule(mudule_box, model, nav_temp);
						}else if(data.state == 'fail') {
							Wind.Util.resultTip({
								error : true,
								zindex : design_zindex,
								msg : data.message[0]
							});
						}

						module_url = null;
					}, 'json');

					insert_holder.remove();
					
				}else{
					//插入新结构
					var randomid = randomSix(),
							name = design_move_temp.data('name');
					$(layout_temp[name].replace(/_ID/, randomid)).insertAfter(insert_holder).fadeIn('200').attr('id', randomid);
					insert_holder_visible.remove();
					//wrap.removeClass('tempplace').addClass('tempplacein');
					eachModLayout(wrap);

					if(name == 'tab') {
						var $randomid = $('#'+ randomid);
						tabsBind($randomid);
					}
					
				}
			
			}
			
		}else{
			//恢复原结构位置
			designUtil.layoutMoveReset(layout_move);
		}

		//隐藏拖拽
		design_move_temp.hide();

	});
	
	
	doc.on('keyup', function(e){
		//按esc
		if(e.keyCode === 27) {
			var layout_move = $('#J_layout_move');

			//重置正拖拽结构
			if(layout_move.length) {
				designUtil.layoutMoveReset(layout_move);
			}

			//重置空的拖拽区
			if(!move_lock) {
				design_move_temp.hide();
				insert_holder.remove();
			}
		}

	});

	designUtil = {
		layoutMoveReset : function(layout_move){
			//重置结构
			layout_move.removeAttr('style').attr({
				'id' : layout_move.data('randomid'),
				'style' : layout_move.data('orgstyle')		//恢复样式
			});
		},
		getPopBtn : function(){
			return layout_edit_contents.children(':visible').find('button:submit');
		}
	}

/*
 * 拖拽已添加的结构
*/
	mod_wrap.off('mousedown').on('mousedown', '.J_layout_hd', function(e){
			var wrap = $(this).parent(),
					wrap_left = wrap.offset().left,
					wrap_top = wrap.offset().top,
					org_style = wrap.attr('style');			//原样式

			//点击链接不拖动
			if(e.target.tagName.toLowerCase() == 'a') {
				return false;
			}

			move_lock = false;

			wrap.css({
				width : wrap.width(),
				position : 'absolute',
				zIndex : 1,
				opacity : 0.6,
				left :wrap_left,
				top : wrap_top
			}).data({
				'randomid' : wrap.attr('id'),
				'orgstyle' : org_style ? org_style : ''
			}).attr('id', 'J_layout_move');

			var dis_left = e.pageX - wrap_left,
					dis_top = e.pageY - wrap_top;
//console.log(e.pageY)
			doc.off('mousemove').on('mousemove', function(e){
				if(move_lock) {
					return false;
				}
				window.getSelection ? window.getSelection().removeAllRanges() : document.selection.empty();
				var leftx = e.pageX - 10,
						topx = e.pageY - 10;

				//模板定位
				wrap.css({
					left : e.pageX - dis_left,
					top : e.pageY - dis_top
				});

				var elem_half_left = parseInt(wrap.css('left')) + wrap.outerWidth()/2,		//模板中心点x轴距
						elem_half_top = parseInt(wrap.css('top')) + wrap.outerHeight()/2;			//模板中心点x轴距
				moveTemp(wrap, elem_half_left, elem_half_top);
			});
		});


/*
 * 结构&标题&模块编辑 显示隐藏
*/
	//结构编辑
	mod_wrap.on('mouseenter', 'div.J_mod_layout, .design_layout_style', function(e){
		//e.stopPropagation();
		var $this = $(this),
				tar = $(e.target);

		if(!move_lock) {
			return false;
		}

		//移入模块
		var mod_box = tar.parents('.J_mod_box');
		if(mod_box.length) {
			modEditPos(mod_box);
		}

		//父结构
		var layout_box = tar.parents('.J_mod_layout');
		if(layout_box.length) {
			layoutTitEditPos(layout_edit, layout_box);
		}

		//本结构
		if(tar.is('.J_mod_layout')) {
			layoutTitEditPos(layout_edit, $this);
		}

	}).on('mouseleave', 'div.J_mod_layout, .design_layout_style', function(e){
		e.stopPropagation();
		if(!move_lock) {
			return false;
		}
		var rel_tar = $(e.relatedTarget);
		if(!rel_tar.is('#J_layout_edit')) {
			//移进父结构
			if(rel_tar.is('.J_mod_layout')) {
				layoutTitEditPos(layout_edit, rel_tar);
			}else if(rel_tar.parents('div.J_mod_layout').length) {
				layoutTitEditPos(layout_edit, rel_tar.parents('div.J_mod_layout'));
			}else{
				layout_edit.hide();
			}
		}
		
	});

	layout_edit.on('mouseleave', function(){
		layout_edit.hide();
	});

	//标题编辑
	$('div.J_mod_title').hover(function(e){
		layoutTitEditPos(mod_tit_edit, $(this));
	}, function(e){
		var rel_tar = $(e.relatedTarget);
		if(!rel_tar.is(mod_tit_edit)) {
			mod_tit_edit.hide();
		}
	});

	mod_tit_edit.on('mouseleave', function(){
		mod_tit_edit.hide();
	});

	//结构&标题编辑框 定位显示
	function layoutTitEditPos(elem, tar){
		var lcm = tar.data('lcm');
		if(lcm == 'tab') {
			elem.data('structure', 'tab');
		}else{
			elem.data('structure', '');
		}

		elem.css({
			left : tar.offset().left + tar.outerWidth() - elem.width(),
			top : tar.offset().top
		}).data('id', tar.attr('id')).show();
		
	}

	//模块编辑
	$('body').on('mouseenter', 'div.J_mod_box', function(e){
		e.stopPropagation();

		if (move_lock) {
			modEditPos($(this));
			mode_edit_btn.data({
				'id': $(this).data('id'),
				'model' : $(this).data('model')
			});
		}
	});

	mode_edit.on('mouseleave', function(e){
		mode_edit.hide();
	});

	//模块编辑框 定位显示
	function modEditPos(tar){
		if(!tar.data('id')) {
			return ;
		}
		mode_edit.css({
			width : tar.outerWidth(),
			height : tar.outerHeight(),
			left : tar.offset().left,
			top : tar.offset().top
		}).show();
	}


	
	
	var layouttitle = $('#J_layouttitle'),
			layoutstyle = $('#J_layoutstyle');
	layout_edit_pop.draggable( { handle : '.J_drag_handle'} );

	//点击结构编辑
	var layout_id, btn, structure;
	layout_edit.on('click', function(e){
		e.preventDefault();
		var $this = $(this),
			index = layouttitle.index(),
			content = layout_edit_contents.children(':eq('+ index +')'),
			role = layouttitle.children().data('role'),
			edit_data = {};

			structure = $this.data('structure');

		menu_pop.hide();

		//tab内容 暂不缓存
		layout_edit_nav.find('a').data('load', false);

		layout_id = $this.data('id'),
		design_name.text('结构管理');
		design_del.text('删除该结构').data('role', 'layout').show();
		//btn = $this;
		layout_edit_nav.children().children().data('load', false);

		//global.js
		popPos(layout_edit_pop);

		layouttitle.click().show().children().attr('data-submit', false);	//默认未提交
		layouttitle.siblings().hide();
		layoutstyle.show();
		//layout_edit_nav.children(':eq('+ (index+1) +')').children();
		/*layout_edit_nav.children(':lt('+ index +')').hide();
		layout_edit_nav.children(':gt('+ (index+1) +')').hide();*/

		//if(!$this.data('load')) {
			//还没加载或已提交
		edit_data['name'] = layout_id;
		edit_data['pageid'] = pageid;

		if(structure == 'tab') {
			//tab结构数组
			var tab_arr = [];
			$('#'+ layout_id + ' .J_tabs_nav li').each(function(){
				tab_arr.push($(this).children('a').data('id'));
			})
			edit_data['tab'] = tab_arr;
		}

			$.post(LAYOUT_EDID_TITLE, edit_data, function(data){
				if(ajaxTempError(data)) {
					content.html(data);

					//jquery.scrollFixed
					content.find('.J_scroll_fixed').scrollFixed();

					$this.attr('data-load', true);	//
					//$this.data('submit', true);
					//btn.data('datatitle', data);	//存入html

					editFn(content, role);
					commonFn();

					title_clone = content.find('div.J_mod_title_cont').clone().html();		//添加新标题的html复制
				}
			});
		/*}else{
			//已请求过
			layout_edit_contents.find('form').resetForm();
		}*/
	});

	//点击模块编辑
	mode_edit_btn.on('click', function(e){
		e.preventDefault();
		var $this = $(this);
				//index = 3,
				//content = layout_edit_contents.children(':eq('+ index +')'),
				//role = current_nav.children().data('role');

		menu_pop.hide();

		//tab内容 暂不缓存
		layout_edit_nav.find('a').data('load', false);
		//layout_id = $this.parents('.J_mod_layout').attr('id'),
		design_name.text('模块管理');
		moduleid = $this.data('id');
		moduleid_input.val(moduleid);
		model = $this.data('model');
		mudule_box = $('#J_mod_' + moduleid);
		design_del.text('删除该模块').data('role', 'module');
		//btn = $this;
		//layout_edit_nav.children().children().data('load', false);

		//判断tab显示
		//global.js
		ajaxMaskShow(design_zindex);
		$.post(MODULE_EDIT_JUDGE, {
			moduleid : moduleid,
			pageid:pageid
		}, function(data){
			if(data.state == 'success') {
				

				layout_edit_nav.children().hide();
				//显示tab项
				var tab_arr = data.data;
				if(tab_arr.length) {
					for(i=0,len=tab_arr.length; i<len; i++) {
						$('#J_tabnav_' + tab_arr[i]).show();

						//是否显示 删除模块
						if(tab_arr[i] == 'delete') {
							design_del.show();
						}else{
							design_del.hide();
						}
					};
				}

				//global.js
				popPos(layout_edit_pop);

				var current_nav = layout_edit_nav.children(':visible:first');
				current_nav.click();
				var current_content = layout_edit_contents.children(':visible:first');

				//获取第一个tab内容
				$.post(current_nav.children().attr('href'), {
					moduleid : moduleid,
					pageid:pageid
				}, function(data){
					if(ajaxTempError(data)) {
						ajaxMaskRemove();

						current_content.html(data);
						current_nav.children().data('load', true);
						
						//jquery.scrollFixed
						current_content.find('.J_scroll_fixed').scrollFixed();

						//editFn(content, role);
						commonFn();
					}
				});

			}else{
				//global.js
				ajaxMaskRemove();
				Wind.Util.resultTip({
					error : true,
					msg : data.message[0]
				});
			}
		}, 'json');
		
	});

	//标题编辑
	mod_tit_edit.on('click', function(e){
		e.preventDefault();
		var id = $(this).data('id');
		ajaxMaskShow(design_zindex);
		$.post(this.href, {name : id}, function(data){
			ajaxMaskRemove();
			if(ajaxTempError(data)) {
				var moduletitle = $('#J_moduletitle'),
						current_content = layout_edit_contents.children(':eq('+ moduletitle.index() +')');
				design_name.text('标题编辑');
				design_del.hide();
				moduletitle.show().addClass('current').siblings().hide();
				current_content.html(data).show().siblings().hide();

				popPos(layout_edit_pop);

				$('#J_design_tit_form').ajaxForm({
					dataType : 'json',
					beforeSubmit : function(){
						ajaxMaskShow(design_zindex);
					},
					success : function(data){
						ajaxMaskRemove();
						if(data.state == 'success') {
							layout_edit_pop.hide();
							$('#' + id).html(data.data);
						}else{
							Wind.Util.resultTip({
								error : true,
								msg : data.message[0],
								zindex : design_zindex
							});
						}
					}
				});
			}
		}, 'html');
	});


	//点击弹窗tab
	layout_edit_nav.find('a').on('click', function(){
		var $this = $(this),
				role = $this.data('role'),
				type = $this.data('type'),
				index = $this.parent().index(),
				current_content = layout_edit_contents.children(':eq('+ index +')');		//当前内容区

		if(!$this.data('load')) {
			//还没加载
			//current_content.html('<div class="pop_loading"></div>');

			if(role == 'layoutstyle') {
				//结构样式
				$.post(LAYOUT_EDID_STYLE, {name : layout_id}, function(data){
					if(ajaxTempError(data)) {
						current_content.html(data)/*.find('form').ajaxForm({
							dataType : 'json',
							success : function(data){

							}
						})*/;

						//jquery.scrollFixed
						current_content.find('.J_scroll_fixed').scrollFixed();

						$this.data('load', true);
						editFn(current_content, role, '');
						commonFn();
					}
				});
			}else if(role == 'module') {
				//模块tab
				$.post(this.href, {moduleid : moduleid}, function(data){
					if(!ajaxTempError(data, undefined, undefined, design_zindex)) {
						popHide(true);
						return false;
					}

						current_content.html(data)/*.find('form').ajaxForm({
							dataType : 'json',
							success : function(data){

							}
						})*/;

						if(current_content.find('#J_design_temp_tpl').length) {
							Wind.use('rangeInsert');
						}

						//jquery.scrollFixed
						current_content.find('.J_scroll_fixed').scrollFixed();

						//模块模板 global.js
						buttonStatus($('#J_design_temp_name'), $('#J_design_temp_sub'));

						$this.data('load', true);
						commonFn();

						if(type == 'title') {
							title_clone = current_content.find('div.J_mod_title_cont').clone().html();		//添加新标题的html复制
						}

				});
			}
		}

		//layout_edit_contents.children(':eq('+ $this.parent().index() +')').children()
	});

	//关闭编辑
	$('#J_layout_edit_close').on('click', function(e){
		e.preventDefault();
		popHide();

		//先清空为loading效果
		layout_edit_contents.children().html('<div class="pop_loading"></div>');
	});

	//删除结构&模块
	design_del.on('click', function(e){
		e.preventDefault();
		var role = $(this).data('role');
		if(role == 'layout') {
			//删除结构
			var layout = $('#'+ layout_id);

			if(layout.find('.J_mod_box').children().length || layout.find('.J_mod_layout').length) {
				alert('请先清空该结构下的模块或子结构');
				return false;
			}

			layout.fadeOut(200, function(){
				$(this).remove();
			});

			popHide(true);
		}else{
			//删除模块
			if(confirm('您确定要删除本模块吗？删除后将不可恢复！')) {
				//global.js
				ajaxMaskShow(design_zindex);

				$.post(MODULE_BOX_DEL, {moduleid: moduleid}, function(data){
					//global.js
					ajaxMaskRemove();

					if(data.state == 'success') {
						//移除class
						mudule_box.removeClass(module_class_mapping);

          				//移除内容
						mudule_box.removeAttr('id data-id').removeData('id').empty();

					}else{
						//global.js
						Wind.Util.resultTip({
							error : true,
							msg : data.message[0]
						});
					}
					popHide(true);
				}, 'json');


			}
		}
		
	});

	//分别设置
	layout_edit_contents.on('click', 'input.J_set_part', function(){
		var $this = $(this),
				last = $this.parents('dd').children(':last'),
				prev_last = last.prev();
		if($this.prop('checked')) {
			last.show();
			prev_last.hide();
		}else{
			last.hide();
			prev_last.show();
		}
	});


	//弹窗内方法
	function editFn(content, role){
		//form添加标识
		content.children('form').attr('data-role', role);

		//提交
		$('form.J_design_layout_form').ajaxForm({
			dataType : 'json',
			data : {
				structure : structure ? structure : ''
			},
			beforeSubmit : function(){
				//global.js
				ajaxBtnDisable(designUtil.getPopBtn());
			},
			success : function(data, statusText, xhr, $form){
				if(data.state == 'success') {
					var btn = designUtil.getPopBtn();
					//global.js
					ajaxBtnEnable(btn);

					popHide();
					Wind.Util.resultTip({
						msg : '操作成功',
						zIndex : design_zindex
					});

					//提交后不tab内容重载
					layout_edit_nav.find('a').data('load', false);
					layout_edit_contents.children(':not(:visible)').html('<div class="pop_loading"></div>');
					
					var layout = $('#'+ layout_id),																		//编辑的结构
							//vis_content = layout_edit_contents.children(':visible'),			//当前编辑内容
							role = $form.data('role');																		//编辑的区域角色

					if(role == 'layouttitle') {
						//写入标题
						var layout_hd = layout.children('.design_layout_hd, J_layout_hd');
						/*data['data'] = '<li class="current"><a data-id="tab_2" href="">栏目3</a></li>\
<li class=""><a data-id="tab_4" href="">栏目4</a></li>\
<li class=""><a data-id="tab_5" href="">栏目5</a></li>';*/
						layout_hd.html(data['data']['tab']);
						layout_hd.attr('style', data['data']['background']);

						if(structure == 'tab') {
							var tab_ct_child = layout.find('.J_tabs_ct').children();
							tab_ct_child.hide();

							//匹配tab
							layoutTabMatch(layout);

						}
						//btn.attr('data-titleload', false);
						//重新存入html
						//btn.data('datatitle', vis_content.html());
					}else if(role == 'layoutstyle') {
						//写入样式
						var prev_style = layout.prev('style'),
								layout_style = '<style type="text/css" class="_tmp">#'+ data.data.styleDomId[0] +'{'+ data.data.styleDomId[1] +'}#'+ data.data.styleDomId[0] +' a{'+ data.data.styleDomIdLink[1] +'}</style>';
						if(prev_style.length) {
							//已有style标签
							prev_style.replaceWith(layout_style);
						}else{
							layout.before(layout_style);
						}

						if(data.data.styleDomClass) {
							//写入class
							layout.attr('class', layout_class_mapping[layout.data('lcm')]+' '+data.data.styleDomClass);
						}
						
					}
					
				}else if(data.state == 'fail') {
					Wind.Util.formBtnTips({
						error : true,
						msg : data.message[0],
						wrap : btn.parent()
					});
				}
				
			}
		});

	}


	//tab结构标题内容匹配
	function layoutTabMatch(layout, retry) {
		var hd = layout.children('.design_layout_hd, J_layout_hd'),
				ct = layout.find('.J_tabs_ct'),
				ct_child = layout.find('.J_tabs_ct').children();

		hd.find('a').each(function() {
								var tab_id = $(this).data('id'),
										tab_index = $(this).parents('li').index(),
										ct_child_item = ct_child.filter(':eq('+ tab_index +')');

								
								if(ct_child_item.length) {
									//存在索引项
									
									if(ct_child_item.data('id') !== tab_id) {
										//不匹配 删除，重新匹配
										ct_child_item.remove();
										layoutTabMatch(layout, true);
									}
								}else{
									//不存在索引项，添加
									layout.find('.J_tabs_ct').append('<div style="display:none;" class="design_layout_ct mod_box J_mod_box" data-id="'+ tab_id +'"></div>');
								}

								//新加的tab
								/*if(!tab_ct_child.filter('J_tabct_' + tab_id).length) {
									layout.find('.J_tabs_ct').append('<div style="display:none;" class="design_layout_ct mod_box J_mod_box" data-id="'+ tab_id +'"></div>');
								}

								if(tab_ct.data('id') !== tab_id) {
									tab_ct.remove();
								}*/
							});

							//循环结束 删除多余项
							var hd_len = hd.children().length;
							if(ct.children().length > hd_len) {
								ct.children(':gt('+ (hd_len-1) +')').remove();
							}

		if(!retry) {
			hd.removeData('plugin_tabs');
			tabsBind(layout);
		}
		
	}


/*
 * 弹窗内公共方法&组件
*/
	function commonFn(){
		//global.js
		colorPickerBind($('span.J_color_pick'), design_zindex);

		$('input.J_design_date').each(function(){
			datePickerBind({
				elem : $(this),
				time : true,
				zindex : design_zindex
			});
		});

		//字体配置
		if($('.J_design_font_config').length) {
			
			$('.J_design_font_config').each(function() {
				var elem = $(this).find('.J_design_color_pick');
				var panel = elem.parent('.J_design_font_config');
				elem.colorPicker({
					zIndex : design_zindex,
					default_color : $(this).find('.J_bg').css('background-color'),
					callback:function(color) {
						elem.find('.J_bg').css('background-color',color);
						panel.find('.J_case').css('color',color);
						panel.find('.J_hidden_color').val(color);
					},
					default_color : ''
				});
			});

			//加粗、斜体、下划线的处理
			$('.J_bold,.J_italic,.J_underline').on('click',function() {
				var panel = $(this).parents('.J_design_font_config');
				var c = $(this).data('class');
				if( $(this).prop('checked') ) {
					panel.find('.J_case').addClass(c);
				}else {
					panel.find('.J_case').removeClass(c);
				}
			});
		}

		//全选
		var design_check_all = $('input.J_design_check_all');
		if(design_check_all.length) {
			var check_wrap = design_check_all.parents('table'),
					checks = check_wrap.find('input.J_design_check');
			//点击全选
			design_check_all.on('change', function(){
				if(this.checked) {
					checks.prop('checked', true);
				}else{
					checks.prop('checked', false);
				}
			});

			//点击单项
			checks.on('change', function(){
				if(this.checked) {
					if(checks.filter(':checked').length == checks.length) {
						design_check_all.prop('checked', true);
					}
				}else{
					design_check_all.prop('checked', false);
				}
			});
		}

		//地区组件
		if($('a.J_region_change').length) {
			Wind.js(GV.JS_ROOT +'pages/common/region.js?v='+ GV.JS_VERSION, function(){
				$('a.J_region_change').off('click').on('click', function (e) {
					e.preventDefault();
					var $this = $(this),
						wrap = $this.parents('.J_region_set'),
						current_province = wrap.find('.J_province'),
						current_city = wrap.find('.J_city'),
						current_district = wrap.find('.J_district');

					regionInit(current_province.data('id'), current_city.data('id'), current_district.data('id'), $this.data('rank'), wrap, 'region');

					$('#J_region_pop').css('zIndex', design_zindex);
				});

				//取消
				$('a.J_region_cancl').on('click', function(e){
					e.preventDefault();
					var wrap = $(this).parents('.J_region_set');
					wrap.find('.J_province, .J_city, .J_district').data('id', '').text('');
					wrap.find('input.J_areaid').val('');
					$(this).hide();
				});
			});
		}

		//图片预览
		var input_prev = layout_edit_pop.find('input.J_upload_preview');
		if(input_prev.length) {
			Wind.use('uploadPreview',function() {
				input_prev.uploadPreview();
			});
		}

		//更新
		$('#J_module_update').on('click', function(e){
			e.preventDefault();
			var $this = $(this);
			ajaxBtnDisable($this);
			$.post($this.data('url'), {
				moduleid : moduleid
			}, function(data){
				ajaxBtnEnable($this);
				if(data.state == 'success') {
					ajaxMaskShow(design_zindex);
					updatePopList();
				}else if(data.state == 'fail') {
					Wind.Util.resultTip({
						error : true,
						follow : $this,
						zindex : design_zindex,
						msg : data.message[0]
					});
				}
			}, 'json');
		});

	}

	
	//移动模板结构
	function moveTemp(move_elem, left, top){

		//获取移动中心点元素(有闪烁手势问题)
		move_elem.hide();
		var elem_point = document.elementFromPoint(left, top - $(document).scrollTop());
		move_elem.show();

		var $elem_point = $(elem_point),
				wrap_parent = $elem_point.parents('.J_mod_wrap');

		if($elem_point.hasClass('J_mod_wrap')) {
			/*//去除新手引导
			if($elem_point.hasClass(guide_cls)) {
				$elem_point.removeClass(guide_cls).html('');
			}*/

			//位置判断 非移动模块
			if(!module_url) {
				insertJudge($elem_point, top);
			}

		}else if(wrap_parent.length){
			//设计区的J_mod_box内
			if($elem_point.hasClass('J_mod_box')) {
				if(module_url){
					//移动模板且为空
					if(!$elem_point.children().length) {
						insertJudge($elem_point, top);
					}
					
				}else{
					var parents_mod_layout_len = $elem_point.parentsUntil('div.J_mod_wrap').filter('.J_mod_layout').length,	//已有的J_mod_layout层数
							move_mod_layout_len = move_elem.find('.J_mod_layout').length;																				//移动模板里的J_mod_layout层数
					if(parents_mod_layout_len < 2 && move_mod_layout_len < 1 && !$elem_point.children('div').length){
						//设计区小于2层且没有模块数据

						//位置判断
						insertJudge($elem_point, top);

						//重新计算区域结构数据
						//eachModLayout($elem_point.parents('div.J_mod_wrap'));
					}
				}

				

			}

		}else{
			var _mod_wrap = insert_holder.parents('.J_mod_wrap');	//被移出的自定义区域

			//设计区外
			insert_holder.remove();

			/*if(!_mod_wrap.children().length) {
				//添加新手引导
				_mod_wrap.addClass(guide_cls).html(guide_text);
			}*/
		}
	}

	//位置判断
	function insertJudge(elem, top){
		//设计区为空
		if(!elem.find('#J_insert_holder').length) {
			elem.append(insert_holder);
		}

		//设计区有子结构
		if(elem.find('.J_mod_layout').length) {
			var layout_arr = elem.data('data'),								//当前区域结构数据
					layout_arr_len = layout_arr.length,
					insert_wrap = elem;

			for(i=0; i<layout_arr_len; i++) {

				if(top > layout_arr[i][0] && top < layout_arr[i][1]) {
					//进入可添加区内

					if(i===0) {
						//顶部
						insert_holder.prependTo(elem);
					}else{
						insert_holder.insertAfter(elem.children('.J_mod_layout:eq('+ (i-1) +')'));
					}

					break;
				}
			}	
		}

		//重新计算区域结构数据
		eachModLayout(elem);
	}

	//获取模块
	function getModule(mudule_box, model, nav_temp){
		//index = 7,																															//当前tab项索引值
		var current_nav = $('#J_moduleproperty_add'),							//当前tab项
			current_content = layout_edit_contents.children(':eq('+ current_nav.index() +')');			//当前内容项

		current_nav.show().click();

		$.post(module_url, {
			pageid :pageid,
			model : model,
			struct : mudule_box.parents('.J_mod_layout').attr('id')
		}, function(data){
			if(!ajaxTempError(data)) {
				return false;
			}

			current_content.html(data);
			if(nav_temp) {
				$('#J_property_add').text('下一步');
			}
			
				//jquery.scrollFixed
				current_content.find('.J_scroll_fixed').scrollFixed();
				commonFn();

				var btn = designUtil.getPopBtn();
				//提交
				$('form.J_design_module_form').ajaxForm({
					dataType : 'json',
					beforeSubmit : function(){
						ajaxBtnDisable(btn);
					},
					success : function(data, statusText, xhr, $form){
						if(data.state == 'success') {
							moduleid = data.data;
							moduleid_input.val(moduleid);

							//写入模块html
							$.post(MODULE_BOX_UPDATE, {moduleid : moduleid}, function(data){
								ajaxBtnEnable(btn);
								if(!ajaxTempError(data)) {
									return false;
								}

								mudule_box.html(data).attr({
									'id' : 'J_mod_'+ moduleid,
									'data-id' : moduleid,
									'data-model' : model
								});

								if(nav_temp) {
									//触发模板tab
									var tabnav_template = $('#J_tabnav_template');
									tabnav_template.show().click().siblings().hide();
									tabnav_template.children('a').click();
								}else{
									popHide(true);
									Wind.Util.resultTip({
										msg : '操作成功',
										zIndex : design_zindex
									});
								}
								
							});
						}else if(data.state == 'fail'){
							ajaxBtnEnable(btn);
							Wind.Util.formBtnTips({
								error : true,
								msg : data.message[0],
								wrap : btn.parent()
							});
						}
					}
				});
			
		});
	}

	//更新弹窗列表内容
	function updatePopList(btn, updatemod, hidepop){
		if(btn) {
			ajaxBtnDisable(btn);
		}
		

		$.post(layout_edit_nav.children('.current').children().attr('href'), {
			moduleid : moduleid,
			pageid:pageid
		}, function(data){
			//global.js
			ajaxMaskRemove();

			if(btn) {
				ajaxBtnEnable(btn);
			}

			if(ajaxTempError(data)) {
				//重新列表
				var current_content = layout_edit_contents.children(':visible');
				current_content.html(data);

				if(btn) {
					Wind.Util.formBtnTips({
						wrap : btn.parent(),
						msg : '操作成功'
					});
				}

				current_content.find('.J_scroll_fixed').scrollFixed();
				commonFn();

				//是否更新模块
				if(updatemod && mudule_box.children(':not(.J_mod_layout)').length) {
					updateModuleList(moduleid, mudule_box, hidepop);
				}
			}
		});
	}

	//更新模块列表内容
	function updateModuleList(moduleid, mudule_box, hidepop){
		//有列表内容
		var list = mudule_box.find('.J_module_con_list'),
				clone = mudule_box.clone();
		mudule_box.html('<div class="pop_loading"></div>');
		$.post(MODULE_BOX_UPDATE, {moduleid : moduleid}, function(data){
			//global.js
			var btn = designUtil.getPopBtn();
			ajaxBtnEnable(btn);

			if(!ajaxTempError(data)) {
				//出错
				mudule_box.html(clone);
				Wind.Util.formBtnTips({
					error : true,
					wrap : btn.parent(),
					msg : data.message[0]
				});
				return;
			}

			//返回列表
			$('#J_module_data_back').click();

			//成功
			if(hidepop) {
				popHide(true);
				Wind.Util.resultTip({
					msg : '操作成功',
					zindex : design_zindex
				});
			}

			mudule_box.html(data);
			//头像
			var avatars = mudule_box.find('img.J_avatar');
			if(avatars.length) {
				avatarError(avatars);
			}

		});
	}


	//循环结构坐标数据
	function eachModLayout(wrap){
		var arr = [],
				childs = wrap.children('.J_mod_layout').filter(':not(#J_layout_move)');

		childs.filter(':not(#J_layout_move)').each(function(i, o){
			var scroll_top = $(document).scrollTop(),
					win_top = $(this).offset().top,
					height = $(this).outerHeight(),
					mb = parseInt($(this).css('marginBottom').replace('px', '')),
					height_bot = win_top + height,
					height_mb = win_top + height + mb;
					//console.log(win_top);
			if(i <= 0){
				//第一个
				arr.push([0, win_top]);
				arr.push([height_bot, height_mb]);
			}else if(i > 0 && i === (childs.length-1)){
				//最后一个
				arr.push([height_bot, 9999]);
			}else{
				arr.push([height_bot, height_mb]);
			}
			
		});

		wrap.data('data', arr);
		//console.log(wrap.data());
		//modlayout[wrap.data('id')] = arr;
		//console.log(modbox);
	}

/*
 * 生成6位随机字母
*/
	function randomSix(){
		var cha = '';
		for(i=1;i<=6;i++){
			cha += String.fromCharCode(Math.floor( Math.random() * 26) + "a".charCodeAt(0));
		}
		return cha;
	}


/*
 * 模块管理
*/
	
	layout_edit_contents.on('click', 'a.J_data_edit', function(e){
		//显示内容编辑
		e.preventDefault();
		var id = $(this).data('id'),
				//current_edit = $('#J_module_data_'+ id),					//当前编辑内容
				module_data_list = $('#J_module_data_list'),			//显示内容列表
				module_data_edit = $('#J_module_data_edit');			//显示内容编辑区

		module_data_list.hide();
		module_data_edit.show();
		$.post(this.href, function(data){
			//global.js
			if(ajaxTempError(data)) {
				module_data_edit.html(data);
				
				commonFn();
			}
		});

	}).on('click', 'button.J_mod_title_add', function(e){
		//添加新标题
		e.preventDefault();
		var wrap = $(this).parent().next();		//默认项
		$('<div style="padding:5px;" class="fr"><a style="margin:5px;" class="fr J_mod_title_del" href="">删除此标题</a></div><div class="J_mod_title_cont">'+title_clone +'</div>').insertAfter(wrap).find('input, .J_color_pick >em').val('').removeAttr('style');
	}).on('click', 'a.J_mod_title_del', function(e){
		//删除标题
		e.preventDefault();
		var del_wrap = $(this).parent();
		del_wrap.next().remove();del_wrap.remove();
	}).on('click', '.J_pages_wrap a', function(e){
		//推送翻页
		e.preventDefault();

		//翻页前内容
		var clone = tabct_push.clone();

		tabct_push.html('<div class="pop_loading"></div>');

		$.post(this.href)
		.done(function(data){
			if (ajaxTempError(data, function(){
				tabct_push.html(clone.html());
			})) {
				tabct_push.html(data);
				commonFn();
			}
		});
	}).on('click', 'a.J_data_push', function(e) {
		//推送
		e.preventDefault();
		var role = $(this).data('role');
		//global.js
		ajaxMaskShow(design_zindex);

		$.post(this.href, function(data) {
			if (data.state == 'success') {
				//更新弹窗列表
				updatePopList(null, false);

				if(role == 'pass') {
					//通过
					tabnav_data.children().data('load', false);
					tabct_data.html('<div class="pop_loading"></div>');
				}
				
			} else if (data.state == 'fail') {
				//global.js
				ajaxMaskRemove();
				Wind.Util.resultTip({
					error: true,
					msg: data.message[0],
					zindex : design_zindex
				});
			}
		}, 'json');
	}).on('click', 'a.J_design_data_ajax', function(e){
		//公共ajax更新
		e.preventDefault();
		var noupdate = $(this).data('noupdate');		//是否更新模块列表

		//global.js
		ajaxMaskShow(design_zindex);

		$.post(this.href, function(data){
			if(data.state == 'success') {
				//更新弹窗列表
				updatePopList(null, noupdate ? false : true, false);
			}else if(data.state == 'fail'){
				//global.js
				ajaxMaskRemove();
				Wind.Util.resultTip({
					error : true,
					msg : data.message[0],
					zindex : design_zindex
				});
			}
		}, 'json');
	}).on('click', '#J_design_temp_sub', function(e){
		//模块模板保存
		e.preventDefault();
		var $this = $(this),
			temp_name = $('#J_design_temp_name');

		//global.js
		ajaxMaskShow(design_zindex);

		$.post($this.data('action'), {
			tpl : $('textarea[name=tpl]').val(),
			tplname : $('#J_design_temp_name').val(),
			moduleid : moduleid
		}, function(data){
			//global.js
			ajaxMaskRemove();

			if(data.state == 'success') {
				temp_name.val('');
				$this.prop('disabled', true).addClass('disabled');
				//global.js
				Wind.Util.resultTip({
					msg : '保存成功',
					follow : $this,
					zindex : design_zindex
				});
			}else if(data.state == 'fail'){
				//global.js
				Wind.Util.resultTip({
					error : true,
					msg : data.message[0],
					follow : $this,
					zindex : design_zindex
				});
			}
		}, 'json');
	}).on('click', 'div.J_sign_items', function(e){
		//点击模板模块属性 codemirror冲突
		//$('#J_design_temp_tpl').rangeInsert(this.innerHTML);
	}).on('change', '#J_select_model_type', function(e){
		//模块属性 数据模型
		var select_model = $('#J_select_model'),
				data = DESIGN_MODELS[this.value],
				arr = [];
		if(data) {
			for (i = 0, len = data.length; i<len; i++) {
				arr.push('<option value="'+ data[i].model +'">'+ data[i].name +'</option>')
			}
			select_model.html(arr.join('')).show();

			if (select_model.val()) {
				updateProperty(select_model.val());
			}
 		}else{
			select_model.hide().html('');
		}
	}).on('change', '#J_select_model', function(e){
		//更新数据模块
		updateProperty(this.value);
	});

	//重新加载数据模块
	function updateProperty(model){
		ajaxMaskShow(design_zindex);
		$.post(layout_edit_nav.find('li.current > a').attr('href'), {
			moduleid : moduleid,
			model : model
		}, function(data){
			ajaxMaskRemove();
			if (ajaxTempError(data)) {
				layout_edit_contents.children(':visible').html(data);
				commonFn();
			}
		}, 'html');
	}

	//返回内容列表
	layout_edit_contents.on('click', '#J_module_data_back', function(e){
		e.preventDefault();
		$('#J_module_data_list').show();
		$('#J_module_data_edit').hide().html('<div class="pop_loading"></div>');
	});

	//模块编辑提交
	layout_edit_contents.on('click', 'button.J_module_sub', function(e){
		e.preventDefault();
		var $this = $(this),
				form = $this.parents('form'),
				role = $this.data('role'),
				action = $this.data('action'),
				update = $this.data('update');			//更新对象

		form.ajaxSubmit({
			url : action ? action : form.attr('action'),
			dataType : 'json',
			beforeSubmit : function(){
				ajaxBtnDisable($this);
			},
			success : function(data, statusText, xhr, $form){
				if(data.state == 'success') {
					//提交后不tab内容重载
					layout_edit_nav.find('a').data('load', false);
					layout_edit_contents.children(':not(:visible)').html('<div class="pop_loading"></div>');

					if(update == 'mod'){
						//更新模块列表
						updateModuleList(moduleid, mudule_box, true);

					}else if(update == 'title'){
						//编辑标题
						ajaxBtnEnable($this);
						var modtit = mudule_box.children('h2');
						if(modtit.length) {
							modtit.replaceWith(data.data);
						}else{
							mudule_box.prepend(data.data);
						}

						popHide(true);
						Wind.Util.resultTip({
							msg : data.message[0]
						});
					}else if(update == 'style'){
						//编辑样式
						ajaxBtnEnable($this);

						//移除老的style
						mudule_box.find('style').remove();

						//写入style 样式
						mudule_box.prepend('<style type="text/css" class="_tmp">#'+ data.data.styleDomId[0] +'{'+ data.data.styleDomId[1] +'}#'+ data.data.styleDomId[0] +' a{'+ data.data.styleDomIdLink[1] +'}</style>');

						//更新class
						if(data.data.styleDomClass) {
							mudule_box.removeClass(module_class_mapping).addClass(data.data.styleDomClass)
							//mudule_box.attr('class', 'box J_mod_box '+ data.data.styleDomClass);
						}

						popHide(true);
						Wind.Util.resultTip({
							msg : data.message[0]
						});
					}else{
						if(update == 'pop') {
							//更新弹窗列表
							updatePopList($this, false);
						}else if(update == 'all') {
							//更新弹窗&模块列表
							updatePopList($this, true, false);
						}
					}
				}else if(data.state == 'fail'){
					//global.js
					ajaxBtnEnable($this);
					Wind.Util.formBtnTips({
						error : true,
						wrap : $this.parent(),
						msg : data.message[0]
					});
				}
			}
		});
	});

/*
 * 隐藏弹窗并恢复内容为loading
*/
	function popHide(loading){
		layout_edit_pop.hide();
		if(loading) {
			layout_edit_contents.children().html('<div class="pop_loading"></div>');
		}
	}

/*
 * 右上角菜单
*/
	//global.js
	Wind.Util.hoverToggle({
		elem : $('#J_design_top_arrow'),		//hover元素
		list : $('#J_design_top_list')
	});


/*
 * 保存
*/
	var savedata = {}, dialog_html = '';
	savedata['pageid'] = pageid;
	savedata['uri'] = uri;
	savedata['uniqueid'] = uniqueid;
	savedata['compile'] = document.getElementById('J_compile').value;

	//点击保存
	$('#J_design_submit').on('click', function(){
		var $this = $(this);

		//获取提交内容
		var ii = 0;
		for(i=0;i<mod_wrap.length;i++){
			var clone = $(mod_wrap[i]).clone(),
					box = clone.find('div.J_mod_box');
			clone.find('div.J_mod_layout').removeAttr('style');			//外框的style不提交
			clone.find('style').remove();														//拿掉style标签

			//替换模块内容
			for(k=0;k<box.length;k++) {
				var _id = $(box[k]).data('id');
				if(_id) {
					if($.browser.msie) {
						var el_module = document.createElement('design');
						el_module.id = 'D_mod_'+ _id;
						el_module.setAttribute('role', 'module');
						$(box[k]).html(el_module);
					}else{
						$(box[k]).html('<design id="D_mod_'+ _id +'" role="module"></design>');
					}
				}
			}

			var html = clone[0].innerHTML;//console.log(html);
			savedata['segment['+ mod_wrap[i].id +']'] = html;
			if(html) {
				ii++;
			}
		}

		if(dtype == 'unique') {
			dialog_html = '<div class="pop_cont">是否应用于其他同类页面？</div>\
				<div class="pop_bottom">\
					<button class="btn btn_submit mr10 J_design_check" data-value="nounique" type="button">是</button>\
					<button class="btn J_design_check" data-value="isunique" type="button">否</button>\
				</div>';
		}/*else if(dtype == 'read'){
			dialog_html = '<div class="pop_cont">请先选择应用于以下哪一项</div>\
				<div class="pop_bottom">\
					<button class="btn btn_submit J_design_check" data-value="" type="button">所有阅读页</button>\
					<button class="btn btn_submit J_design_check" data-value="forum" type="button">当前页所属版块</button>\
					<button class="btn btn_submit J_design_check" data-value="read" type="button">当前页</button>\
				</div>';
		}*/else{
			dialog_html = '';
		}


		if(dialog_html){
			Wind.dialog.html(dialog_html, {
				isMask	: true,
				zIndex : design_zindex,
				callback : function(){
					$('button.J_design_check').on('click', function(e){
						e.preventDefault();
						savedata.type = $(this).data('value');
						Wind.dialog.closeAll();
						save($this, savedata);
					});
				}
			});
		}else{
			//delete savedata.uniqueid;
			savedata.type = dtype;
			save($this, savedata);
		}

	});

	//保存方法
	function save(elem, savedata){
		ajaxMaskShow(design_zindex);
		$.ajax({
			url : elem.data('action'),
			type : 'post',
			dataType : 'json',
			data : savedata,
			success : function(data){
				//global.js
				ajaxMaskRemove();

				if(data.state == 'success') {
					if(data.data) {
						window.onbeforeunload = null;
						location.href = data.data;
					}
				}else{
					//global.js
					Wind.Util.resultTip({
						error : true,
						msg : data.message[0]
					});
				}
			}
		});
	}


/*
 * 退出
*/
	$('#J_design_quit').on('click', function(e){
		e.preventDefault();
		if(confirm('您确定要退出页面设计状态？确定退出后，已修改的数据将不会保存。')) {
			$.post(this.href, {pageid: pageid, uri : uri}, function(data){
				if(data.state == 'fail') {
					Wind.Util.resultTip({
						error : true,
						msg : data.message[0]
					});
					return;
				}
				window.onbeforeunload = null;
				location.href = data.data;
			}, 'json');
		}
 	});

/*
 * 退出 模板权限
*/
	$('#J_design_quit_direct').on('click', function(e){
		e.preventDefault();
		$.post(this.href, {pageid: pageid, uri : uri}, function(data){
			window.onbeforeunload = null;
			location.href = data.data;
		}, 'json');
	});

/*
	
 * 菜单公共方法
*/
	//关闭
	$('a.J_pop_close').on('click', function(e){
		e.preventDefault();
		menu_pop.hide();
	});
	//拖拽
	menu_pop.draggable( { handle : '.J_drag_handle'} );


/*
 * 恢复备份
*/
	$('#J_design_restore').on('click', function(e){
		e.preventDefault();
		if(confirm('您确定要恢复为上一个版本的备份结果吗？')) {
			restoreLoop(this.href, 1);
		}
	});

	//循环请求备份信息
	function restoreLoop(url, step){
		$.post(url, {pageid: pageid, step : step}, function(data){
			if(data.state == 'success') {
				var status = parseInt(data.data[0]);
				if(status < 7) {
					/*var text;
					switch(status){
						case 1 : text = '正在恢复模块';break;
						case 2 : text = '正在更新数据';break;
						case 3 : text = '正在恢复结构';break;
						case 4 : text = '正在恢复模版';break;
						case 5 : text = '正在生成页面';break;
						case 6 : text = '';break;
					}*/

					//global.js
					Wind.Util.resultTip({
						msg : data.data[1]
					});

					restoreLoop(url, step+1);
				}else{
					Wind.Util.resultTip({
						msg : '恢复成功！',
						callback : function(){
							window.onbeforeunload = null;
							//global.js
							location.reload();
						}
					});
				}
			}else if(data.state == 'fail'){
				Wind.Util.resultTip({
					error : true,
					msg : data.message[0]
				});
			}
		}, 'json');
	}


/*
 * 导出
*/
	$('#J_design_export').on('click', function(e){
		e.preventDefault();
		window.open(this.href +'&pageid='+ pageid);
	});


/*
 * 导入
*/
	var design_import_pop = $('#J_design_import_pop');
	$('#J_design_import').on('click', function(e){
		e.preventDefault();
		popPos(design_import_pop);
	});

	//导入提交
	$('#J_design_import_form').ajaxForm({
		dataType : 'json',
		beforeSubmit : function (arr, $form, options) {
			//global.js
			ajaxBtnDisable($form.find('button:submit'));
		},
		data : {
			pageid : pageid
		},
		success : function (data, statusText, xhr, $form) {
			//global.js
			var btn = $form.find('button:submit')
			ajaxBtnEnable(btn);

			if(data.state == 'success') {
				Wind.Util.resultTip({
					elem : btn,
					follow : true,
					msg : '导入成功',
					zindex : design_zindex,
					callback : function(){
						window.onbeforeunload = null;
						//global.js
						reloadPage(window);
					}
				});
			}else if(data.state == 'fail'){
				//global.js
				Wind.Util.resultTip({
					elem : btn,
					follow : true,
					error : true,
					msg : data.message[0],
					zindex : design_zindex
				});
			}
		}
	});


/*
 * 更新
*/
	$('#J_design_cache').on('click', function(e){
		e.preventDefault();
		$.post(this.href, {pageid : pageid}, function(data){
			if(data.state == 'success') {
				Wind.Util.resultTip({
					msg : '更新成功',
					callback : function(){
						window.onbeforeunload = null;
						//global.js
						reloadPage(window);
					}
				});
			}else if(data.state == 'fail'){
				//global.js
				Wind.Util.resultTip({
					error : true,
					msg : data.message[0]
				});
			}
		}, 'json');
	});


/*
 * 清空
*/
	$('#J_design_clear').on('click', function(e){
		e.preventDefault();
		if(confirm('您确定要清空页面上的所有模块？清空后将不可恢复！')) {
			$.post(this.href, {pageid : pageid, design : 1}, function(data){
				if(data.state == 'success') {
					mod_wrap.html('');
					location.reload();
				}else if(data.state == 'fail') {
					Wind.Util.resultTip({
						error : true,
						msg : data.message[0]
					});
				}
			}, 'json');
		}
	});

/*
 * 编辑模式锁定轮循请求
*/
	designLockLoop();
	function designLockLoop(){
		$.post(DESIGN_LOCK, {pageid: pageid}, function(data){
			if(data.state == 'success') {
				setTimeout(function(){
					designLockLoop();
				}, 60000);
			}
		}, 'json');
	}

/*
 * 关闭小贴士
*/
	var mini_tips = $('#J_mini_tips'),
		tip_cookie = Wind.Util.getCookie('designMiniTips');
	if(tip_cookie !== 'closed') {
		//cookie不存在则显示
		mini_tips.show();
	}

	$('#J_mini_tips_close').on('click', function(e){
		e.preventDefault();
		mini_tips.hide();
		//存入cookie
		Wind.Util.setCookie('designMiniTips','closed','365',document.domain);
	});


})();