/*
 * PHPWind WindEditor Plugin
 * @Copyright 	: Copyright 2011, phpwind.com
 * @Descript	: 编辑器出售插件
 * @Author		: chaoren1641@gmail.com
 * @Depend		: jquery.js(1.7 or later)
 * $Id: windeditor.js 4472 2012-02-19 10:41:01Z chris.chencq $			:
 */
;(function ( $, window, undefined ) {
	if(!window.EDIT_CONFIG) {
		$.error('EDIT_CONFIG没有定义，附件上传需要提供配置对象');
		return;
	}
	var WindEditor = window.WindEditor;
	var credit = window.EDIT_CONFIG.sell.credit;
	var creditSelect = '';
	for(i in credit) {
		creditSelect += '<option value="'+ i +'">'+ credit[i] +'</option>';
	}
	var maxSell = EDIT_CONFIG.sell.price || 0;
	var maxIncome = EDIT_CONFIG.sell.income || 0;
	var pluginName = 'insertSell',
		dialog = $('<div class="edit_menu" style="display:none;">\
					<div class="edit_menu_hide">\
						<div class="edit_menu_top"><a href="" class="edit_menu_close">关闭</a><strong>插入出售内容</strong></div>\
						<div class="edit_menu_cont">\
							<ul>\
								<li>允许设置最高售价'+ maxSell +'，限制最高收入'+ maxIncome +'</li>\
								<li>售价：<input name="price" type="number" size="2" id="J_sell_price" class="input length_1 mr5 J_price" max="'+ maxSell +'" min="0">\
								<select class="mr5 J_unit">'+ creditSelect +'</select>\
								<span id="B_sell_bm"></span></li>\
							</ul>\
							<textarea></textarea>\
						</div>\
						<div class="edit_menu_bot">\
							<button type="button" class="edit_menu_btn">确定</button><button type="button" class="edit_btn_cancel">取消</button>\
						</div>\
					</div>\
				</div>'),
		editAction = false;//是否编辑状态
		editNode = null;

	WindEditor.plugin(pluginName,function() {
		var _self = this;
		var editorDoc = _self.editorDoc = _self.iframe[0].contentWindow.document,
		editorToolbar = _self.toolbar,
		//toolbar中的icon容器
		icon_ul = editorToolbar.find('ul');

		//自定义插入位置,插到insertBlockquote后面
		var plugin_icon = $('<div class="wind_icon" data-control="'+ pluginName +'" unselectable="on"><span unselectable="on" class="'+ pluginName +'" title="插入出售内容"></span></div>').insertAfter( icon_ul.find('span.insertBlockquote').parent() );
		var editContent =  function(node){
			editAction = true;
			editNode = node;
			var cnode = node.clone(),
				price = node.data("price"),
				unit = node.data("unit");
			cnode.find("h6, .J_sell_delete, .J_sell_edit").remove();
			var text = cnode.text();
			if(!$.contains(document.body,dialog[0]) ) {
				dialog.appendTo( document.body );
			}
			var textarea = dialog.find('textarea');
			dialog.find(".J_price").val(price);
			dialog.find(".J_unit").find("option[value="+unit+"]").attr("selected", "selected");
			textarea.val(text).show();
			_self.showDialog(dialog);
		};
		plugin_icon.on('click',function() {
			if($(this).hasClass('disabled')) {
				return;
			}

			//如果有选取内容，则不弹窗
			var node	= _self.getRangeNode('div.content_sell'),
				html = _self.getRangeHTML();
			if(node && node.length) {
				//编辑功能
				editContent(node);
			}else {
				if(!$.contains(document.body,dialog[0]) ) {
					dialog.appendTo( document.body );
				}
				var textarea = dialog.find('textarea');
				if(html) {
					//如果有选中内容，则不显示弹窗中的textarea
					textarea.val(html).hide();
				}else{
					textarea.val('').show();
				}
				_self.showDialog(dialog);
			}
		});

		//弹窗的关闭事件
		dialog.find('a.edit_menu_close,button.edit_btn_cancel').on('click',function(e) {
			e.preventDefault();
			_self.hideDialog();
			editAction = false;
		});

		//点击插入
		var head = editorDoc.head || editorDoc.getElementsByTagName( "head" )[0] || editorDoc.documentElement;
		var style = "";
		$(head).append(style);

		dialog.find('.edit_menu_btn').on('click',function(e) {
			e.preventDefault();
			var price = $('#J_sell_price').val();
			if(isNaN(price) || parseInt(price) < 0) {
				alert('请输入正确的数字');
				$('#J_sell_price').focus();
				return;
			}
			if(parseInt(price) > maxSell) {
				alert('最高售价为'+ maxSell + ',不能大于' + maxSell + '哦！');
				$('#J_sell_price').focus();
				return;
			}
			var textarea = dialog.find('textarea');
			var price = dialog.find('input.J_price').val();
			var unit = dialog.find('.J_unit option:selected').val();
			//var text = _self.getRangeText();
			if(textarea.is(':visible') && textarea.val() === '') {
				alert('请输入要出售的帖子内容');return;
			}

			var val = '<div class="content_sell" data-price="'+ price +'" data-unit="'+ unit +'"><a class="icon_delete J_sell_delete" href="#">删除</a><a class="icon_edit J_sell_edit" href="#">编辑</a><h6>本帖出售的内容</h6>'+ textarea.val() +'</div>';
			textarea.val('');
			if(editAction === true){
				editNode.replaceWith(val);
				_self.hideDialog();
				editAction = false;
				editNode = null;
			}else{
				_self.insertHTML(val).hideDialog();
			}
		});

		function wysiwyg() {
			var reg = /\[sell=(\d+)\,(\w+)\s*\]([\s\S]*?)\[\/sell\]/ig;
				html = $(editorDoc.body).html();
			html = html.replace(reg,function(all, $1, $2,$3) {
				return '<div data-price="'+ $1 +'" data-unit="'+ $2 +'" class="content_sell"><a class="icon_delete J_sell_delete" href="#">删除</a><a class="icon_edit J_sell_edit" href="#">编辑</a><h6>本帖出售的内容</h6>'+ $3 +'</div>';
			});
			$(editorDoc.body).html(html);
		}

		//加载插件时把ubb转换成可见即所得
		$(_self).on('ready',function() {
			wysiwyg();
		});

		//切换成可见即所得模式时变成html
		$(_self).on('afterSetContent',function(event,html) {
			wysiwyg();
		});

		$(_self).on('beforeGetContent',function() {
			$(editorDoc.body).find('div.content_sell').each(function() {
				$(this).find('h6, .J_sell_edit, .J_sell_delete').remove();
				var price = $(this).data('price');
				var unit = $(this).data('unit');
				$(this).replaceWith('[sell='+ price +','+ unit +']'+ this.innerHTML +'[/sell]');
			});
		});

		//控件栏按钮的控制
    	$(_self.editorDoc.body).on('mousedown',function(e) {
    		if( $(e.target).closest('div.content_sell').length ) {
    			plugin_icon.removeClass('disabled').addClass('activate');
    		}else {
    			_self.enableToolbar();
    			plugin_icon.removeClass('activate');
    		}
    	});
    	//插入出售帖的编辑和删除功能
    	$(_self.editorDoc.body).on('mouseenter.' + pluginName, '.content_sell', function(){
    		$(this).addClass("content_sell_cur");
    	});
    	$(_self.editorDoc.body).on('mouseleave.' + pluginName, '.content_sell', function(){
    		$(this).removeClass("content_sell_cur");
    	});
    	$(_self.editorDoc.body).on('mousedown', '.J_sell_edit', function(e){
    		e.preventDefault();
    		var target = $(e.target);
    		var node = target.closest('.content_sell');
    		editContent(node);
    	});
    	$(_self.editorDoc.body).on('mousedown', '.J_sell_delete', function(e){
    		e.preventDefault();
    		var target = $(e.target);
    		var wrap = target.closest('.content_sell');
    		Wind.dialog.confirm("确定删除该出售内容？", function(){
    			wrap.remove();
    		})
    	});
	});


})( jQuery, window);