/*
* PHPWind WindEditor Plugin
* @Copyright 	: Copyright 2011, phpwind.com
* @Descript	: 编辑器工具栏模式切换
* @Author		: chaoren1641@gmail.com
* $Id: windeditor.js 4472 2012-02-19 10:41:01Z chris.chencq $			:
*/
;(function ( $, window, undefined ) {

	var WindEditor = window.WindEditor;
	var pluginName = 'simpleToolbar';

	WindEditor.plugin(pluginName,function() {
		var config = 'fontName fontSize bold italic underline strikeThrough foreColor backColor justifyLeft justifyCenter justifyRight insertLink'.split(' ');
		var _self = this;
		var editorDoc = _self.editorDoc = _self.iframe[0].contentWindow.document,
			editorToolbar = _self.toolbar,
			//toolbar中的icon容器
			icon_ul = editorToolbar.find('ul.wind_editor_icons'),
			big_icon_box = icon_ul.find('li.wind_icon_big');
		
		var button = $('<span class="wind_toolbar_switch" data-type="advanced">简单</span>').insertBefore(editorToolbar.find('span.wind_codeMode'));
		var clear_button = editorToolbar.find('div.wind_clear');
		var controls = icon_ul.find('div.wind_icon');
		
		//缓存需要隐藏的按钮
		var simpleControls = [];
		button.on('click',function() {
			var type = $(this).data('type');
			if(type === 'advanced') {
				if(simpleControls.length) {
					for(var i = 0;i < simpleControls.length;i++) {
						simpleControls[i].hide();
					}
				}else {
					controls.each(function() {
						var icon = this;
						var control = $(this).data('control');
						if($.inArray(control,config) < 0) {
							simpleControls.push($(icon));
							$(icon).hide();
						}
					});
				}
				clear_button.hide();//换行元素
				big_icon_box.removeClass('wind_icon_big');
				this.innerHTML = '高级';
				$(this).data('type','simple');
			}else {
				for(var i = 0;i < simpleControls.length;i++) {
						simpleControls[i].show();
				}
				clear_button.show();
				big_icon_box.addClass('wind_icon_big');
				this.innerHTML = '简单';
				$(this).data('type','advanced');
			}
		});
		button.trigger('click');
	});
})(jQuery, window);
