﻿package com.phpwind.util
{
    import com.adobe.images.JPGEncoder;
    import com.phpwind.rainbow.util.UploadPostHelper;
    
    import flash.display.BitmapData;
    import flash.events.ErrorEvent;
    import flash.events.Event;
    import flash.events.IOErrorEvent;
    import flash.net.URLLoader;
    import flash.net.URLLoaderDataFormat;
    import flash.net.URLRequest;
    import flash.net.URLRequestMethod;
    import flash.net.URLVariables;
    
    /**
     * Uploads the file data to the server though the HTTP protocol.
     *
     * @author: xuanyin.zy
     * @since: Jun 24, 2011
     */
    public class FileUploadModel extends Model
    {
        public static const JPG_ENCODE_QUALITY:int = 90;
        
        /**
         * When setting this property true, "_actionName", "_doMethodName"
         * and "_userId" will not taken the value providen by the user. It's useful when
         * debugging flash.
         */
        private var _useLocalVar:Boolean = false;
        
        private var _actionName:String = "user/headsetAction";
        
        private var _doMethodName:String = "event_submit_do_change_avatar_though_flash";
        
        private var _requestURL:String = "http://10.13.34.20/microshop/json/changeLogo.htm";
		
		private var _new:String = ""; //定义
        
        /**
        * taobao test user: tbtest101
        */
        private var _userId:int = 15703140;
        
        /**
        * Of course this token can't pass the check.
        */
        private var _tbToken:String = "aaaaaaaaa";
        
        private var _urlLoader:URLLoader = new URLLoader();
        
        public function FileUploadModel(actionName_:String, doMethodName_:String, userId_:int, tbToken_:String, requestURL_:String, new_:String)
        {
            super();
            if (!_useLocalVar) 
            {
                _actionName = actionName_;
                _doMethodName = doMethodName_;
                _userId = userId_;
                _requestURL = requestURL_;
                _tbToken = tbToken_;
				_new = new_; //LocalImageUploader.as 73行需增加对应
            }
        }
        
        public function uploadImage(bitmapData_:BitmapData):void
        {
            var jpgeEncoder_:JPGEncoder = new JPGEncoder(JPG_ENCODE_QUALITY);
            
            // add addition variables
            var queryStr_:String = "_tb_token_=" + _tbToken +"&action=" + _actionName 
                + "&" + _doMethodName + "=anything&userId=" + _userId +"&new=" + _new;
            var urlVariables_:URLVariables = new URLVariables(queryStr_);
            
            var urlRequest_:URLRequest = new URLRequest(_requestURL);
            urlRequest_.method = URLRequestMethod.POST;
            urlRequest_.data = urlVariables_;
            
            urlRequest_.contentType = "multipart/form-data; boundary=" + UploadPostHelper.getBoundary();
            urlRequest_.data = UploadPostHelper.getPostData("image.jpg", jpgeEncoder_.encode(bitmapData_), urlVariables_);
            
            _urlLoader.dataFormat = URLLoaderDataFormat.BINARY;
            
            _urlLoader.addEventListener(Event.COMPLETE, onUploadComplete);
            _urlLoader.addEventListener(IOErrorEvent.IO_ERROR, onIOError);
            _urlLoader.load(urlRequest_);
        }
        
        protected function onIOError(event_:IOErrorEvent):void
        {
            dispatchEvent(new ErrorEvent(ErrorEvent.ERROR, false, false, "图片保存失败12，网络连接错误！"));
        }
        
        protected function onUploadComplete(event_:Event):void
        {
            dispatchEvent(new Event(Event.COMPLETE));
        }
        
        public function get urlLoaderData():String
        {
            return String(_urlLoader.data);
        }
    }
}