/*
 * Decompiled with CFR 0.152.
 */
package smoothbedrock;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.event.FMLServerStartingEvent;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.registry.GameRegistry;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.Configuration;
import smoothbedrock.SBRetroCommand;
import smoothbedrock.common.SBPacketHandler;
import smoothbedrock.configs.GalactiCraftConfig;
import smoothbedrock.configs.MineDonaldsConfig;
import smoothbedrock.configs.SBConfig;
import smoothbedrock.configs.TwilightForestConfig;
import smoothbedrock.worldgeneration.SBWorldGeneration;

@Mod(modid="SmoothBedrock", version="1.0.10.75", name="Smooth Bedrock", dependencies="required-after:Forge@[9.11.1.965,)")
@NetworkMod(serverSideRequired=true, clientSideRequired=false, packetHandler=SBPacketHandler.class, channels={"SmoothBedrock"})
public class SBCore {
    public static final String ModId = "SmoothBedrock";
    public static final String ModName = "Smooth Bedrock";
    @Mod.Instance(value="SmoothBedrock")
    private static SBCore _instance;

    public static SBCore getInstance() {
        return _instance;
    }

    @Mod.EventHandler
    public void onPreInitializationEvent(FMLPreInitializationEvent e) {
        _instance = this;
        SBConfig.Log = e.getModLog();
        TwilightForestConfig.read(e.getModConfigurationDirectory());
        GalactiCraftConfig.read(e.getModConfigurationDirectory());
        MineDonaldsConfig.read(e.getModConfigurationDirectory());
        Configuration configFile = new Configuration(e.getSuggestedConfigurationFile());
        SBConfig.readConfig(configFile);
        if (configFile.hasChanged()) {
            configFile.save();
        }
    }

    @Mod.EventHandler
    public void onInitializationEvent(FMLInitializationEvent e) {
        if (SBConfig.isActive) {
            GameRegistry.registerWorldGenerator((IWorldGenerator)new SBWorldGeneration());
        }
    }

    @Mod.EventHandler
    public void onServerStartingEvent(FMLServerStartingEvent event) {
        if (SBConfig.isActive) {
            event.registerServerCommand((ICommand)new SBRetroCommand());
        }
    }
}

