/*
 * Decompiled with CFR 0.152.
 */
package smoothbedrock;

import cpw.mods.fml.common.network.PacketDispatcher;
import cpw.mods.fml.common.network.Player;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.command.CommandBase;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.packet.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatMessageComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import smoothbedrock.common.SBPacketCoordinates;
import smoothbedrock.configs.SBConfig;

public class SBRetroCommand
extends CommandBase {
    private final List commands = new ArrayList();

    public SBRetroCommand() {
        this.commands.add("smooth");
    }

    public int compareTo(Object arg0) {
        return 0;
    }

    public String func_71517_b() {
        return "smooth";
    }

    public String func_71518_a(ICommandSender icommandsender) {
        return String.format("/%s help|<radiusChunks>", this.func_71517_b());
    }

    public List func_71514_a() {
        return this.commands;
    }

    public void func_71515_b(ICommandSender icommandsender, String[] astring) {
        if (!(icommandsender instanceof EntityPlayer)) {
            return;
        }
        int radius = 4;
        int count = 81;
        ChatMessageComponent cmc = new ChatMessageComponent();
        if (astring.length == 1) {
            if (astring[0].equalsIgnoreCase("help")) {
                cmc.func_111079_a(String.format("[SmoothBedrock] Use '/%s %d' to cleanup the bedrock - 81 chunks.", this.func_71517_b(), radius));
                icommandsender.func_70006_a(cmc);
                return;
            }
        } else {
            cmc.func_111079_a(this.func_71518_a(icommandsender));
            icommandsender.func_70006_a(cmc);
            return;
        }
        radius = Integer.parseInt(astring[0]);
        EntityPlayer player = (EntityPlayer)icommandsender;
        int minX = player.field_70176_ah - radius;
        int maxX = player.field_70176_ah + radius;
        int minZ = player.field_70164_aj - radius;
        int maxZ = player.field_70164_aj + radius;
        count = (maxX - minX + 1) * (maxZ - minZ + 1);
        cmc.func_111079_a(String.format("[SmoothBedrock] Starting smoothing process - %d Chunks", count));
        icommandsender.func_70006_a(cmc);
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                this.generate(x, z, icommandsender.func_130014_f_().field_73011_w.field_76574_g, (Player)icommandsender);
            }
        }
        cmc = new ChatMessageComponent();
        cmc.func_111079_a(String.format("[SmoothBedrock] Finished smoothing process - %d Chunks", count));
        icommandsender.func_70006_a(cmc);
    }

    public boolean func_71519_b(ICommandSender icommandsender) {
        return super.func_71519_b(icommandsender) && !icommandsender.func_70005_c_().equalsIgnoreCase("rcon") && !icommandsender.func_70005_c_().equalsIgnoreCase("server");
    }

    public List func_71516_a(ICommandSender icommandsender, String[] astring) {
        return null;
    }

    public boolean func_82358_a(String[] astring, int i) {
        return false;
    }

    private void generate(int chunkX, int chunkZ, int dimension, Player player) {
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dimension);
        if (world.field_72995_K || !SBConfig.isActive || world.field_73011_w.field_76577_b == WorldType.field_77138_c || !SBConfig.isValidDimension((World)world)) {
            return;
        }
        boolean isNether = world.field_73011_w.field_76574_g == -1;
        int posX = 0;
        int posZ = 0;
        int defaultBlockId = SBConfig.getDefaultBlockID((World)world, chunkX, chunkZ);
        int defaultBlockMeta = SBConfig.getDefaultBlockMetadata((World)world, chunkX, chunkZ);
        if (!SBConfig.isValidDimension((World)world)) {
            return;
        }
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int posY;
                posX = chunkX * 16 + x;
                posZ = chunkZ * 16 + z;
                if (isNether) {
                    for (posY = 128; posY > 121; --posY) {
                        if (!this.isBedrock((World)world, posX, posY, posZ)) continue;
                        this.setBlock((World)world, posX, posY, posZ, defaultBlockId, defaultBlockMeta, player);
                    }
                }
                for (posY = 5; posY > 0; --posY) {
                    if (!this.isBedrock((World)world, posX, posY, posZ)) continue;
                    this.setBlock((World)world, posX, posY, posZ, defaultBlockId, defaultBlockMeta, player);
                }
            }
        }
    }

    private void setBlock(World world, int posX, int posY, int posZ, int blockId, int blockMeta, Player player) {
        world.func_72832_d(posX, posY, posZ, blockId, blockMeta, 3);
        PacketDispatcher.sendPacketToPlayer((Packet)new SBPacketCoordinates(blockId, blockMeta, posX, posY, posZ).getPacket(), (Player)player);
    }

    private boolean isBedrock(World world, int x, int y, int z) {
        return world.func_72798_a(x, y, z) == Block.field_71986_z.field_71990_ca;
    }
}

