/*
 * Decompiled with CFR 0.152.
 */
package smoothbedrock.common;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import smoothbedrock.common.SBPacket;

public class SBPacketCoordinates
extends SBPacket {
    private int id;
    public int posX;
    public int posY;
    public int posZ;
    public int blockId;
    public int blockMeta;

    public SBPacketCoordinates() {
    }

    public SBPacketCoordinates(int blockId, int blockMeta, int x, int y, int z) {
        this.id = 0;
        this.blockId = blockId;
        this.posX = x;
        this.posY = y;
        this.posZ = z;
        this.blockMeta = blockMeta;
    }

    @Override
    public void writeData(DataOutputStream data) throws IOException {
        data.writeInt(this.posX);
        data.writeInt(this.posY);
        data.writeInt(this.posZ);
        data.writeInt(this.blockId);
        data.writeInt(this.blockMeta);
    }

    @Override
    public void readData(DataInputStream data) throws IOException {
        this.posX = data.readInt();
        this.posY = data.readInt();
        this.posZ = data.readInt();
        this.blockId = data.readInt();
        this.blockMeta = data.readInt();
    }

    @Override
    public int getID() {
        return this.id;
    }

    public boolean targetExists(World world) {
        return world.func_72899_e(this.posX, this.posY, this.posZ);
    }

    public Block getBlock(World world) {
        return Block.field_71973_m[world.func_72798_a(this.posX, this.posY, this.posZ)];
    }
}

