/*
 * Decompiled with CFR 0.152.
 */
package smoothbedrock.configs;

import java.util.Hashtable;
import java.util.logging.Logger;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.Configuration;
import smoothbedrock.configs.GalactiCraftConfig;
import smoothbedrock.configs.MineDonaldsConfig;
import smoothbedrock.configs.TwilightForestConfig;

public class SBConfig {
    public static boolean isActive;
    public static boolean spawnDiamonds;
    public static boolean spawnRedstone;
    public static boolean spawnLapis;
    public static boolean usedForNether;
    public static boolean usedForTwilighForest;
    public static boolean usedForGalacticraft;
    public static boolean usedForMineDonalds;
    private static Hashtable<Integer, Boolean> _dimensions;
    private static Hashtable<Integer, Integer> _dimensionDefaultBlock;
    private static Hashtable<Integer, Integer> _dimensionDefaultBlockMeta;
    public static Logger Log;

    public static void readConfig(Configuration config) {
        isActive = config.get("WorldGeneration", "isActive", true, "true, smooths out those annoying bumps of bedrock").getBoolean(true);
        usedForNether = config.get("WorldGeneration", "usedForNether", true, "true, applies in the generation of the nether").getBoolean(true);
        usedForTwilighForest = config.get("WorldGeneration", "usedForTwilighForest", true, "true, applies in the generation of twilight forest").getBoolean(true);
        usedForGalacticraft = config.get("WorldGeneration", "usedForGalacticraft", true, "true, applies in the generation of Galacticcraft Dimensions").getBoolean(true);
        usedForMineDonalds = config.get("WorldGeneration", "usedForMineDonalds", true, "true, applies in the generation of MineDonalds Dimension").getBoolean(true);
        spawnDiamonds = config.get("WorldGeneration", "spawnDiamonds", true, "true, if diamonds (very low chance) should be generated as bedrock alternative.").getBoolean(true);
        spawnRedstone = config.get("WorldGeneration", "spawnRedstone", true, "true, if redstone (low chance) should be generated as bedrock alternative.").getBoolean(true);
        spawnLapis = config.get("WorldGeneration", "spawnLapis", true, "true, if lapis (low chance) should be generated as bedrock alternative.").getBoolean(true);
        SBConfig.registerDimensions();
    }

    private static void registerDimensions() {
        _dimensions.put(-1, usedForNether);
        _dimensionDefaultBlock.put(-1, Block.field_72012_bb.field_71990_ca);
        _dimensionDefaultBlockMeta.put(-1, 0);
        _dimensions.put(0, true);
        _dimensionDefaultBlock.put(0, Block.field_71981_t.field_71990_ca);
        _dimensionDefaultBlockMeta.put(0, 0);
        _dimensions.put(1, false);
        _dimensionDefaultBlock.put(1, 0);
        _dimensionDefaultBlockMeta.put(1, 0);
        if (TwilightForestConfig.dimensionId != -255) {
            _dimensions.put(TwilightForestConfig.dimensionId, usedForTwilighForest);
        }
        if (GalactiCraftConfig.marsDimensionId != -255) {
            _dimensions.put(GalactiCraftConfig.marsDimensionId, usedForGalacticraft);
        }
        if (GalactiCraftConfig.moonDimensionId != -255) {
            _dimensions.put(GalactiCraftConfig.moonDimensionId, usedForGalacticraft);
        }
        if (MineDonaldsConfig.dimensionId != -255) {
            _dimensions.put(MineDonaldsConfig.dimensionId, usedForMineDonalds);
        }
    }

    public static boolean isValidDimension(World world) {
        if (!_dimensions.containsKey(world.field_73011_w.field_76574_g)) {
            _dimensions.put(world.field_73011_w.field_76574_g, false);
        }
        return _dimensions.get(world.field_73011_w.field_76574_g);
    }

    public static int getDefaultBlockID(World world, int chunkX, int chunkZ) {
        if (!_dimensionDefaultBlock.containsKey(world.field_73011_w.field_76574_g)) {
            int posX = 0;
            int posZ = 0;
            Object namelist = null;
            for (int x = 0; x < 16; ++x) {
                for (int z = 0; z < 16; ++z) {
                    posX = chunkX * 16 + x;
                    posZ = chunkZ * 16 + z;
                    for (int posY = 5; posY > 0; --posY) {
                        try {
                            ItemStack is = new ItemStack(Block.field_71973_m[world.func_72798_a(posX, posY, posZ)], 1, world.func_72805_g(posX, posY, posZ));
                            if (!SBConfig.isSearchedBlock(is.func_82833_r())) continue;
                            return SBConfig.setDimensionValues(world, posX, posZ, posY);
                        }
                        catch (Exception e) {
                            continue;
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                    }
                }
            }
            _dimensions.put(world.field_73011_w.field_76574_g, false);
            _dimensionDefaultBlock.put(world.field_73011_w.field_76574_g, 0);
            _dimensionDefaultBlockMeta.put(world.field_73011_w.field_76574_g, 0);
        }
        return _dimensionDefaultBlock.get(world.field_73011_w.field_76574_g);
    }

    private static boolean isSearchedBlock(String name) {
        return name.contains("Stone");
    }

    private static int setDimensionValues(World world, int posX, int posZ, int posY) {
        _dimensionDefaultBlock.put(world.field_73011_w.field_76574_g, world.func_72798_a(posX, posY, posZ));
        _dimensionDefaultBlockMeta.put(world.field_73011_w.field_76574_g, world.func_72805_g(posX, posY, posZ));
        return _dimensionDefaultBlock.get(world.field_73011_w.field_76574_g);
    }

    public static int getDefaultBlockMetadata(World world, int chunkX, int chunkZ) {
        if (!_dimensionDefaultBlockMeta.containsKey(world.field_73011_w.field_76574_g)) {
            SBConfig.getDefaultBlockID(world, chunkX, chunkZ);
        }
        return _dimensionDefaultBlockMeta.get(world.field_73011_w.field_76574_g);
    }

    static {
        _dimensions = new Hashtable();
        _dimensionDefaultBlock = new Hashtable();
        _dimensionDefaultBlockMeta = new Hashtable();
    }
}

