/*
 * Decompiled with CFR 0.152.
 */
package smoothbedrock.worldgeneration;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import smoothbedrock.configs.SBConfig;

public class SBWorldGeneration
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        if (!SBConfig.isActive || world.field_73011_w.field_76577_b == WorldType.field_77138_c || !SBConfig.isValidDimension(world)) {
            return;
        }
        boolean isNether = world.field_73011_w.field_76574_g == -1;
        int defaultBlockId = SBConfig.getDefaultBlockID(world, chunkX, chunkZ);
        int defaultBlockMeta = SBConfig.getDefaultBlockMetadata(world, chunkX, chunkZ);
        if (!SBConfig.isValidDimension(world)) {
            return;
        }
        boolean useCustomSpawn = defaultBlockId == Block.field_71981_t.field_71990_ca && (SBConfig.spawnDiamonds || SBConfig.spawnRedstone || SBConfig.spawnLapis);
        int blockId = defaultBlockId;
        int blockMeta = defaultBlockMeta;
        int posX = 0;
        int posZ = 0;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int posY;
                posX = chunkX * 16 + x;
                posZ = chunkZ * 16 + z;
                if (isNether) {
                    for (posY = 127; posY > 121; --posY) {
                        if (!this.isBedrock(world, posX, posY, posZ)) continue;
                        world.func_72832_d(posX, posY, posZ, defaultBlockId, defaultBlockMeta, 0);
                    }
                }
                for (posY = 5; posY > 0; --posY) {
                    if (!this.isBedrock(world, posX, posY, posZ)) continue;
                    if (useCustomSpawn) {
                        double rand = random.nextDouble();
                        blockMeta = 0;
                        if (SBConfig.spawnDiamonds && rand < 1.0E-5) {
                            blockId = Block.field_72073_aw.field_71990_ca;
                        } else if (SBConfig.spawnRedstone && rand < 2.0E-4) {
                            blockId = Block.field_72047_aN.field_71990_ca;
                        } else if (SBConfig.spawnLapis && rand < 5.0E-4) {
                            blockId = Block.field_71947_N.field_71990_ca;
                        } else {
                            blockId = defaultBlockId;
                            blockMeta = defaultBlockMeta;
                        }
                    } else {
                        blockId = defaultBlockId;
                        blockMeta = defaultBlockMeta;
                    }
                    if (world.func_72832_d(posX, posY, posZ, blockId, blockMeta, 0)) continue;
                    world.func_72832_d(posX, posY, posZ, defaultBlockId, defaultBlockMeta, 0);
                }
            }
        }
    }

    private boolean isBedrock(World world, int x, int y, int z) {
        return world.func_72798_a(x, y, z) == Block.field_71986_z.field_71990_ca;
    }
}

