from pxz import *

def getBakeMaps(mapsToBake):
	diffuse, normal, materialID, partID = mapsToBake
	maps = []
	if diffuse:
		maps.append(algo.MapType.Diffuse)
	
	if normal:
		maps.append(algo.MapType.Normal)
	
	if materialID:
		maps.append(algo.MapType.MaterialId)
	
	if partID:
		maps.append(algo.MapType.PartId)
	
	return maps

def bake(lowPoly, highPolys, mapsToBake, mapSize, mapPadding):
	maps = getBakeMaps(mapsToBake)
	if len(maps) > 0:
		images = algo.bakeMaps([lowPoly], highPolys, maps, 0, mapSize, mapPadding)
		if len(images) != len(maps):
			return False
		
		diffuseMapIndex = -1
		normalMapIndex = -1
		for ind in range(0, len(maps)):
			map = maps[ind]
			if map == algo.MapType.Diffuse:
				diffuseMapIndex = ind
			elif map == algo.MapType.Normal:
				normalMapIndex = ind
		
		mat = material.createMaterial("Baked", "PBR")
		
		if diffuseMapIndex >= 0:
			core.setProperty(mat, "albedo", "TEXTURE([[1,1],[0,0],"+str(images[diffuseMapIndex])+", 0])")
		
		if normalMapIndex >= 0:
			normalTangent = algo.convertNormalMap([lowPoly], images[normalMapIndex], 0, True, False, True, False, False, mapSize, mapPadding)
			core.setProperty(mat, "normal", "TEXTURE([[1,1],[0,0],"+str(normalTangent)+", 0])")
			# for security:
			algo.orientNormalMap(normalTangent)
								
		core.setProperty(lowPoly[-1], "Material", str(mat))
	return True