import math
import bakeCommon

def generateProxyMesh( gridResolution, generateTextureMaps, keepOriginalMesh ):
  bakeType, bakeOption = generateTextureMaps
  images = []
  #Gets selection
  highPolys = scene.getSelectionedOccurrences()
  #if empty set as root
  if highPolys == []:
    highPolys = [[scene.getRoot()]]
    
  if scene.getPolygonCount(highPolys) == 0:
    raise Exception('This scenario works for meshes only (requires the selected parts to be tessellated first).')
  
  highPoly = []
  
  for hp in highPolys:
    partPaths = scene.getPartPaths(hp)
    for partPath in partPaths:
      occ = scene.getOccurrenceFromScenePath(partPath)
      if scene.getOccurrencesVisibility(occ):
        highPoly.append(partPath)
  
  aabb = scene.getAABB(highPoly)
  lenX = aabb[1][0] - aabb[0][0]
  lenY = aabb[1][1] - aabb[0][1]
  lenZ = aabb[1][2] - aabb[0][2]
  voxelSize = max(lenX, lenY, lenZ) / gridResolution
  
  lowPoly = algo.proxyMesh(highPoly, voxelSize, True, True)
  algo.decimate([lowPoly], 1,0.5,-1, -1)
  
  if bakeType != "No":
    mapResolution, padding, mapsToBake = bakeOption
    MAP_SIZE=mapResolution
    MAP_SIZE_REPACK=mapResolution
    MAP_PADDING=padding
    MAP_PADDING_REPACK=padding * 2
    
    algo.createNormals([lowPoly], 180)
    
    algo.mapUvOnAABB([lowPoly], False, 100.000000, 0, True)
    algo.repackUV([lowPoly], 0, True, MAP_SIZE_REPACK, MAP_PADDING_REPACK, True)
    
    algo.createTangents([lowPoly])
    
    bakeCommon.bake(lowPoly, highPoly, mapsToBake, MAP_SIZE, MAP_PADDING)
  
  if not keepOriginalMesh:
    scene.deleteOccurrences(highPoly)

