﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;

public class FSVTOLrotator : PartModule
{
    [KSPField(guiActive = true, guiName = "Max angle", isPersistant = true)]
    public float deployedAngle = 90f;
    [KSPField(isPersistant = true)]
    public float maxDownAngle = 0f;
    [KSPField(isPersistant = true)]
    public Vector3 availableAngles1 = new Vector3(45, 90, 130);
    [KSPField(isPersistant = true)]
    public Vector3 availableAngles2 = new Vector3(180, 0, 0);
    [KSPField(isPersistant = true)]
    public float stepAngle = 10f;
    [KSPField]
    public string targetPartObject = "mount";
    
    public float currentAngle = 0f;

    [KSPField(guiActive = true, isPersistant = true, guiName = "Current Angle")]
    public float targetAngle = 0f;

    [KSPField]
    private int selectedListAngle = 0;
    private float animationIncrement = 1f;
    //private bool firstActivation = true;
    private List<float> availableAnglesList = new List<float>
    {
    };
    Transform partTransform = new GameObject().transform;

    FSGUIPopup popup;
    PopupElement elementInfoText;
    PopupElement elementTestAngle;
    PopupElement elementStepSize;
    PopupElement elementMaxDownAngle;
    PopupElement elementDebug;
    PopupElement elementDebug2;
    List<PopupElement> elementPresets = new List<PopupElement>();
    

    [KSPField(guiActive = true, guiName = "VTOL rotation inverted", isPersistant = true)]
    public bool invertRotation;
    [KSPField(guiActive = false, isPersistant = true)]
    public bool invertSet;
    public bool invertInHangar = false;

    [KSPEvent(name = "invertVTOLrotation", active = true, guiActive = true, guiName = "invert VTOL rotation", guiActiveUnfocused = true, externalToEVAOnly = true, unfocusedRange = 4f)]
    public void toggleInvertRotation()
    {
        invertRotation = !invertRotation;
        Debug.Log("dot: " + Vector3.Dot(partTransform.position.normalized, vessel.ReferenceTransform.right));
    }

    [KSPEvent(name = "toggleVTOL", active = true, guiActive = true, guiName = "toggle VTOL")]
    public void toggleVTOL()
    {
        toggleAngle();
    }

    [KSPEvent(name = "cycleAnglesEvent", active = true, guiActive = true, guiName = "Cycle max angle")]
    public void cycleAnglesEvent()
    {
        cycleAngles();
    }

    [KSPAction("Cycle max Angles")]
    public void cycleAnglesAction(KSPActionParam param)
    {
        cycleAngles();
    }

    [KSPAction("toggle VTOL")]
    public void toggleVTOLAction(KSPActionParam param)
    {
        toggleAngle();
    }

    [KSPAction("raise engine")]
    public void raiseVTOLAction(KSPActionParam param)
    {
        if (!invertRotation)
        {
            targetAngle += stepAngle;
            if (targetAngle > deployedAngle) targetAngle = deployedAngle;
        }
        else
        {
            targetAngle -= stepAngle;
            if (targetAngle < -deployedAngle) targetAngle = -deployedAngle;
        }
    }

    [KSPAction("lower engine")]
    public void lowerVTOLAction(KSPActionParam param)
    {
        if (!invertRotation)
        {
            targetAngle -= stepAngle;
            if (targetAngle < maxDownAngle) targetAngle = maxDownAngle;
        }
        else
        {
            targetAngle += stepAngle;
            if (targetAngle > -maxDownAngle) targetAngle = -maxDownAngle;
        }
    }

    private void toggleAngle()
    {
        if (!invertRotation)
        {
            if (targetAngle > 0) targetAngle = 0;
            else
                if (targetAngle <= deployedAngle) targetAngle = deployedAngle;
        }
        else
        {
            if (targetAngle < 0) targetAngle = 0;
            else
                if (targetAngle >= -deployedAngle) targetAngle = -deployedAngle;
        }
    }

    private void cycleAngles()
    {
        selectedListAngle ++;
        if (selectedListAngle > availableAnglesList.Count-1) selectedListAngle = 0;
        if (availableAnglesList.Count > 0)
            deployedAngle = availableAnglesList[selectedListAngle];
    }

    public void buildAngleList()
    {
        availableAnglesList.Clear();
        if (availableAngles1.x != 0) availableAnglesList.Add(availableAngles1.x);
        if (availableAngles1.y != 0) availableAnglesList.Add(availableAngles1.y);
        if (availableAngles1.z != 0) availableAnglesList.Add(availableAngles1.z);
        if (availableAngles2.x != 0) availableAnglesList.Add(availableAngles2.x);
        if (availableAngles2.y != 0) availableAnglesList.Add(availableAngles2.y);
        if (availableAngles2.z != 0) availableAnglesList.Add(availableAngles2.z); 
    }

    public override void OnStart(PartModule.StartState state)
    {
        base.OnStart(state);
        //if (firstActivation)
        //{
            partTransform = part.FindModelTransform(targetPartObject);
            //defaultRotation.rotation = partTransform.transform.localRotation;
            //deployedRotation.rotation = defaultRotation.rotation;
            //deployedRotation.Rotate(new Vector3(-deployedAngle, 0, 0));
            //firstActivation = false;
            buildAngleList();
        //}

        //Action editor GUI

        elementInfoText = new PopupElement("Presets set to 0 are excluded.");
        popup = new FSGUIPopup(part, "FSVTOLrotator", 0, FSGUIwindowID.VTOLrotator, new Rect(550f, 200f, 225f, 150f), "VTOL presets", elementInfoText);
        popup.elementList.Add(new PopupElement("Settings are per engine!"));

        elementTestAngle = new PopupElement(new PopupButton("Use Preset " + selectedListAngle, 100f, testUseAngle));
        popup.elementList.Add(elementTestAngle);
        elementTestAngle.buttons.Add(new PopupButton("Next", 40f, testNextAngle));
        elementTestAngle.buttons.Add(new PopupButton("Reset", 50f, testReset));

        elementStepSize = new PopupElement("Step size", stepAngle.ToString());
        elementStepSize.titleSize = 135f;
        elementStepSize.inputSize = 55f;
        popup.elementList.Add(elementStepSize);

        elementMaxDownAngle = new PopupElement("Max negative rot.,", maxDownAngle.ToString());
        elementMaxDownAngle.titleSize = 135f;
        elementMaxDownAngle.inputSize = 55f;
        popup.elementList.Add(elementMaxDownAngle);

        for (int i = 0; i <= 5; i++) // ------------- hard coded ---------------------------
        {
            elementPresets.Add(new PopupElement());
            float presetAngle = 0f;
            if (i < availableAnglesList.Count)
            {
                presetAngle = availableAnglesList[i];
            }
            elementPresets[i] = new PopupElement("Preset " + i, presetAngle.ToString());
            elementPresets[i].titleSize = 135f;
            elementPresets[i].inputSize = 55f;
            popup.elementList.Add(elementPresets[i]);
        }        

        //elementDebug = new PopupElement("Debug");
        //popup.elementList.Add(elementDebug);
        //elementDebug2 = new PopupElement("Debug Vectors");
        //popup.elementList.Add(elementDebug2);
    }

    public void testNextAngle()
    {
        buildAngleList();
        selectedListAngle++;
        if (selectedListAngle > availableAnglesList.Count - 1)
        {
            selectedListAngle = 0;
        }
    }

    public void testUseAngle()
    {
        buildAngleList();
        targetAngle = availableAnglesList[selectedListAngle];
        float dot = Vector3.Dot(partTransform.position.normalized, Vector3.right);
        if (dot < 0) // check for orientation of the part, relative to world directions, since there is no vessel transfrom to compare to
        {
            targetAngle *= -1;
            Debug.Log("Invert True, dot: " + dot);
        }
        else
        {            
            Debug.Log("Invert False, dot: " + dot);
        }

        partTransform.transform.localEulerAngles = new Vector3(-targetAngle, 0f, 0f);
    }

    public void testReset()
    {
        targetAngle = 0f;
        selectedListAngle = 0;
        partTransform.transform.localEulerAngles = new Vector3(targetAngle, 0f, 0f);
    }

    public override void OnUpdate()
    {
        base.OnUpdate();
        if (!HighLogic.LoadedSceneIsFlight || !vessel.isActiveVessel) return;

        if (!invertSet) //run only the first time the craft is loaded
        {
            if (Vector3.Dot(partTransform.position.normalized, vessel.ReferenceTransform.right) < 0) // below 0 means the engine is on the left side of the craft
            {
                invertRotation = true;
                Debug.Log("Inverting left side VTOL rotation");
            }
        }
        invertSet = true;

        //if (invertRotation) invertModifier = -1;
        //else invertModifier = 1;

        float angleChange = targetAngle - currentAngle;

        if (angleChange > animationIncrement)
        {
            angleChange = animationIncrement;
        }
        else if (angleChange < -animationIncrement)
        {
            angleChange = -animationIncrement;
        }

        currentAngle += angleChange;

        partTransform.transform.Rotate(-angleChange, 0, 0);        
    }

    public void OnGUI()
    {
        if (HighLogic.LoadedSceneIsEditor)
        {
            //elementCurrentAngle.inputText = "Current rot.: " + currentAngle;
            popup.popup();
            stepAngle = float.Parse(elementStepSize.inputText);
            maxDownAngle = float.Parse(elementMaxDownAngle.inputText);

            // fill the kspfield preset values from the popup
            if (elementPresets.Count > 0)
                availableAngles1.x = float.Parse(elementPresets[0].inputText);
            if (elementPresets.Count > 1)
                availableAngles1.y = float.Parse(elementPresets[1].inputText);
            if (elementPresets.Count > 2)
                availableAngles1.z = float.Parse(elementPresets[2].inputText);
            if (elementPresets.Count > 3)
                availableAngles2.x = float.Parse(elementPresets[3].inputText);
            if (elementPresets.Count > 4)
                availableAngles2.y = float.Parse(elementPresets[4].inputText);
            if (elementPresets.Count > 5)
                availableAngles2.z = float.Parse(elementPresets[5].inputText);
        }

        elementTestAngle.buttons[0].buttonText = "Use Preset " + selectedListAngle;

        //Debug elements
        //elementDebug.titleText = "selected: " + selectedListAngle;
        //elementDebug2.titleText = "2: " + availableAngles2;
    }
}
