﻿using UnityEngine;
using System.Collections;

/// <summary>
/// For monitor buttons.
/// Assign this to a collider with isTrigger.
/// Activates the buttonClick function on the part's first available FSmonitorInterface.
/// Multiple buttons are told apart for the receiving function by the buttonNumber
/// </summary>
public class FSbuttonHandler : InternalModule
{
    /// <summary>
    /// A part with an assigned FSmonitorInterface module
    /// </summary>
    public GameObject target;
    /// <summary>
    /// an identifying number to tell multiple buttons apart, if several are assigned to the target module.
    /// </summary>
    public int buttonNumber = 1;    

    public void OnMouseDown()
    {        
        target.GetComponent<FSmonitorInterface>().buttonClick(buttonNumber);
    }
}
