﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;


    public class FSdebugMessages
    {
        public bool debugMode = true;
        //public string debugMessageOutput = "both";
        public enum OutputMode
        {
            screen,
            log,
            both,
            none,
        }
        OutputMode outputMode = OutputMode.log;
        public float postToScreenDuration = 5f;

        public FSdebugMessages()
        {
        }

        public FSdebugMessages(bool _debugMode, OutputMode _outputMode, float _postToScreenDuration)
        {
            debugMode = _debugMode;
            outputMode = _outputMode;
            postToScreenDuration = _postToScreenDuration;
        }

        public void debugMessage(string input)
        {
            if (debugMode)
            {
                switch (outputMode)
                {
                    case OutputMode.both:
                        debugMessage(input, true, postToScreenDuration);
                        break;
                    case OutputMode.log:
                        debugMessage(input, true, 0f);
                        break;
                    case OutputMode.screen:
                        debugMessage(input, false, postToScreenDuration);
                        break;
                }
            }
        }

        public void debugMessage(string input, bool postToLog, float postToScreenDuration)
        {
            if (debugMode)
            {
                PostMessage(input, postToLog, postToScreenDuration);
            }
        }

        public static void PostMessage(string input, bool postToLog, float postToScreenDuration) // Posts uninstantiated, so it doesn't care about debugMode.
        {
            if (postToLog)
            {
                Debug.Log(input);
            }
            if (postToScreenDuration > 0f && HighLogic.LoadedSceneIsFlight) // will only work in the flight scene, gives an error in other places.
            {
                ScreenMessages.PostScreenMessage(new ScreenMessage(input, 1f, ScreenMessageStyle.UPPER_RIGHT));
            }
        }
    }
