﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;


public class FSmoveCraftAtLaunch : PartModule
{
    [KSPField(isPersistant=true)]
    public bool moveAtLaunch = true; // for overriding with SPH option menu

    [KSPField]
    public float addLongitude = 0.4f;

    [KSPField]
    public float altitude = 5.0f;

    [KSPField(isPersistant=true)]
    public bool hasLaunched = false;

    //[KSPAction("Test")]
    //public void testAction(KSPActionParam param)
    //{
    //    Debug.Log("testing");
    //    moveCraft();
    //}

    private float timer = 3f;
    public bool doQuickLoad = false;
    private bool isFixed = false;
    public FSGUIPopup popup;

    public override void OnStart(PartModule.StartState state)
    {        
        if (HighLogic.LoadedSceneIsFlight && moveAtLaunch)
        {
            Debug.Log("FSmoveCraftAtLaunch: moving craft");
            if (!hasLaunched)
            {
                moveCraft();                
                timer = 3f;
            }
        }
        popup = new FSGUIPopup(part, "FSmoveCraftAtLaunch", 0, FSGUIwindowID.moveCraftAtLaunch, new Rect(600f, 300f, 200f, 60f), "Move to the water at launch?", new PopupElement(new PopupButton("Yes", "No", 0f, toggleMoveAtLaunch)));
        popup.elementList[0].buttons[0].toggle(moveAtLaunch);
        base.OnStart(state);

    }

    public void moveCraft()
    {
        vessel.longitude += addLongitude;
        vessel.altitude = altitude;
    }

    public void fixCraftLock()
    {
        base.vessel.situation = Vessel.Situations.SPLASHED;
        vessel.state = Vessel.State.ACTIVE;
        base.vessel.Landed = false;
        base.vessel.Splashed = true;
        base.vessel.GoOnRails();
        base.vessel.rigidbody.WakeUp();
        base.vessel.ResumeStaging();
        vessel.landedAt = "";
        //FlightGlobals.ForceSetActiveVessel(vessel);
        InputLockManager.ClearControlLocks();
        /*
        FlightInputHandler.ResumeVesselCtrlState(vessel);
        FlightDriver.SetPause(false);        
        foreach (Part p in vessel.parts)
        {
            Debug.Log("FSmoveCraftAtLaunch: inactive part " + p.name + ", started: " + p.started);
            p.started = true;
            p.force_activate();
            p.frozen = false;
            p.packed = false;
        }*/
        ScreenMessages.PostScreenMessage(new ScreenMessage("Press F5 to Quicksave, then F9 to Quickload to get full control", 10f, ScreenMessageStyle.UPPER_CENTER));
    }

    public void toggleMoveAtLaunch()
    {
        moveAtLaunch = !moveAtLaunch;        
        popup.elementList[0].buttons[0].toggle(moveAtLaunch);        
    }

    public void Update() //TODO, check if this is the active vessel
    {
        if (!HighLogic.LoadedSceneIsFlight || !vessel.isActiveVessel) return;
        if (!moveAtLaunch) return;
        if (!hasLaunched)
        {
            if (timer <= 0 && !isFixed)
            {
                fixCraftLock();
                isFixed = true;
                hasLaunched = true;
            }
            else if (timer > 0 && !isFixed)
            {
                timer -= Time.deltaTime;
            }
        }
    }

    public void OnGUI()
    {
            popup.popup();
    }
}
