﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using UnityEngine;

//namespace Firespitter


   public class FSpartTurner : PartModule
    {
        [KSPField]
        public string targetPartObject = "turnEmpty";
        [KSPField]
        public float rotationDirectionX = 0f;
        [KSPField]
        public float rotationDirectionY = 0f;
        [KSPField]
        public float rotationDirectionZ = 1f;
        [KSPField]
        public float defaultRotationX = 0f;
        [KSPField]
        public float defaultRotationY = 0f;
        [KSPField]
        public float defaultRotationZ = 0f;
        [KSPField(guiActive = true, guiName = "Steering Multiplier", isPersistant = true)]
        public float steerMultiplier = 10f;

        [KSPField(guiActive=true, guiName="Steering", isPersistant=true)]
        public bool steeringEnabled = false;
        [KSPField(guiActive=true, guiName="use QE, not AD", isPersistant=true)]
        public bool altInputModeEnabled = false;
        [KSPField(guiActive = true, guiName = "Reversed input", isPersistant = true)]
        public bool reversedInput = false;
        [KSPField(guiActive = true, guiName = "Ignore Trim", isPersistant = true)]
        public bool ignoreTrim = true;

        //[KSPField]
        //string wheelColliderName = "wheelCollider";

        //WheelCollider wheelCollider;
        //Transform wheelColliderTransform;

        //TEST ------------------------
        [KSPField(guiActive = true, guiName = "drag")]
        public float currentDrag;

        private Vector3 currentTrim = new Vector3(0,0,0);
        private Vector3 currentRotation = new Vector3(0, 0, 0);
        private Vector3 steeringInput;
        private Transform partTransform;

        [KSPAction("Toggle Steering")]
        public void toggleSteeringAction(KSPActionParam param)
        {
            toggleSteering();
        }

        [KSPAction("Invert Steering")]
        public void toggleInvertAction(KSPActionParam param)
        {
            reversedInput = !reversedInput;
        }

        [KSPEvent(name = "toggleSteering", active = true, guiActive = true, guiName = "Toggle Steering")]
        public void toggleSteering()
        {
            steeringEnabled = !steeringEnabled;
        }

        [KSPEvent(name = "toggleAltInputMode", active = true, guiActive = true, guiName = "QE or AD to steer")]
        public void toggleAltInputMode()
        {
            altInputModeEnabled = !altInputModeEnabled;
        }

        [KSPEvent(name = "toggleIgnoreTrim", active = true, guiActive = true, guiName = "Toggle Ignore trim")]
        public void toggleIgnoreTrim()
        {
            ignoreTrim = !ignoreTrim;
        }

        [KSPEvent(name = "toggleReverseInput", active = true, guiActive = true, guiName = "Reverse input")]
        public void toggleReverseInput()
        {
            reversedInput = !reversedInput;
        }

        [KSPEvent(name = "increaseSteering", active = true, guiActive = true, guiName = "Increase Steering")]
        public void increaseSteering()
        {
            steerMultiplier += 1f;
            if (steerMultiplier > 90f) steerMultiplier = 90f;
        }

        [KSPEvent(name = "decreaseSteering", active = true, guiActive = true, guiName = "Decrease Steering")]
        public void decreaseSteering()
        {
            steerMultiplier -= 1;
            if (steerMultiplier < 1f) steerMultiplier = 1f;
        }

        public void steerPart(float direction)
        {
            currentRotation.x = steerMultiplier * rotationDirectionX * direction;
            currentRotation.y = steerMultiplier * rotationDirectionY * direction;
            currentRotation.z = steerMultiplier * rotationDirectionZ * direction;
        }
                
        private void setPartRotation()
        {
            //Transform partTransform = part.FindModelTransform(targetPartObject);
            if (partTransform != null)
                partTransform.localRotation = Quaternion.Euler(currentRotation);
        }

        public override void OnStart(PartModule.StartState state)
        {
            base.OnStart(state);
            partTransform = part.FindModelTransform(targetPartObject);
            /*if (wheelColliderName != string.Empty)
            {
                wheelColliderTransform = part.FindModelTransform(wheelColliderName);
                if (wheelColliderTransform != null)
                {
                    wheelCollider = wheelColliderTransform.gameObject.GetComponent<WheelCollider>();
                    if (wheelCollider != null)
                    {
                        if (!wheelCollider.enabled)
                        {
                            wheelCollider.enabled = true;
                            Debug.Log("FS: enabled wheelCollider");
                        }
                    }
                }
            }*/
        }

        /*void FixeUpdate()
        {
            if (wheelCollider != null)
            {
                if (!wheelCollider.enabled)
                {
                    wheelCollider.enabled = true;
                    Debug.Log("FS: enabled wheelCollider");
                }
            }
        }*/

        public override void OnUpdate()
        {
            if (!HighLogic.LoadedSceneIsFlight || !vessel.isActiveVessel) return;
            FlightCtrlState ctrl = vessel.ctrlState;

            int reverseModifier = 1;

            if (altInputModeEnabled) {
                steeringInput.x = ctrl.roll;
                if (ignoreTrim) steeringInput.x -= ctrl.rollTrim;
            } else {
                steeringInput.x = ctrl.yaw;
                if (ignoreTrim) steeringInput.x -= ctrl.yawTrim;
            }

            if (reversedInput)
            {
                reverseModifier = -1;
            }

            if (steeringEnabled)
            {
                steerPart(steeringInput.x * reverseModifier);
            }
            else steerPart(0);


            setPartRotation();
        }
    }

