﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using UnityEngine;

public class FSpropellerAtmosphericNerf : PartModule
{
    [KSPField]
    public int useHover = 0;
    [KSPField]
    public float thrustModifier = 1.1f;
    [KSPField]
    public float hoverThrottle = 0.5f;
    [KSPField]
    public float cargoThrottle = 1.5f;
    //[KSPField(guiActive = false, guiName = "modeModifier")]
    public float engineModeModifier = 1f; // allows for hover, normal and cargo throttle presets in copterThrottle.cs.

    private ModuleEngines engine = new ModuleEngines();
    private float fullThrottle;

    [KSPAction("Hover Throttle")]
    public void hoverThrottleAction(KSPActionParam param)
    {
        engineModeModifier = hoverThrottle;
    }
    [KSPAction("Normal Throttle")]
    public void normalThrottleAction(KSPActionParam param)
    {
        engineModeModifier = 1;
    }
    [KSPAction("Cargo Throttle")]
    public void cargoThrottleAction(KSPActionParam param)
    {
        engineModeModifier = cargoThrottle;
    }

    public override void OnStart(PartModule.StartState state)
    {            
        base.OnStart(state);
        engine = part.Modules.OfType<ModuleEngines>().FirstOrDefault();
        fullThrottle = engine.maxThrust;
    }

    public override void OnUpdate() {
        if (!HighLogic.LoadedSceneIsFlight || !vessel.isActiveVessel) return;
        float atmosphericModifier = ((float)part.staticPressureAtm * thrustModifier);
        if (atmosphericModifier > 1f && thrustModifier > 1f) atmosphericModifier = 1f; // not setting modifier to 1 at thrustModifier 1 or lower allows for engine that are better than normal in atmospeheres above 1
        float newThrust = fullThrottle * atmosphericModifier * engineModeModifier;
        if (newThrust <= 0) newThrust = 0.001f;
        engine.maxThrust = newThrust;
        
    }
}
