/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import processing.app.Language;
import processing.app.Messages;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.Preferences;
import processing.app.SketchCode;
import processing.app.Util;
import processing.app.ui.Editor;
import processing.app.ui.Recent;
import processing.app.ui.Toolkit;
import processing.core.PApplet;

public class Sketch {
    private Editor editor;
    private Mode mode;
    private File primaryFile;
    private String name;
    private boolean modified;
    private File folder;
    private File dataFolder;
    private File codeFolder;
    private SketchCode current;
    private int currentIndex;
    private int codeCount;
    private SketchCode[] code;
    private boolean untitled;
    private boolean disappearedWarning;
    boolean renamingCode;
    AtomicBoolean saving = new AtomicBoolean();

    public Sketch(String path, Mode mode) {
        this.editor = null;
        this.mode = mode;
        this.load(path);
    }

    public Sketch(String path, Editor editor) throws IOException {
        this.editor = editor;
        this.mode = editor.getMode();
        this.load(path);
    }

    protected void load(String path) {
        this.primaryFile = new File(path);
        String mainFilename = this.primaryFile.getName();
        int suffixLength = this.mode.getDefaultExtension().length() + 1;
        this.name = mainFilename.substring(0, mainFilename.length() - suffixLength);
        this.folder = new File(new File(path).getParent());
        this.disappearedWarning = false;
        this.load();
    }

    protected void load() {
        this.codeFolder = new File(this.folder, "code");
        this.dataFolder = new File(this.folder, "data");
        ArrayList<String> filenames = new ArrayList<String>();
        ArrayList<String> extensions = new ArrayList<String>();
        this.getSketchCodeFiles(filenames, extensions);
        this.codeCount = filenames.size();
        this.code = new SketchCode[this.codeCount];
        int i = 0;
        while (i < this.codeCount) {
            String filename = (String)filenames.get(i);
            String extension = (String)extensions.get(i);
            this.code[i] = new SketchCode(new File(this.folder, filename), extension);
            ++i;
        }
        i = 1;
        while (i < this.codeCount) {
            if (this.code[i].getFile().equals(this.primaryFile)) {
                SketchCode temp = this.code[0];
                this.code[0] = this.code[i];
                this.code[i] = temp;
                break;
            }
            ++i;
        }
        this.sortCode();
        if (this.editor != null) {
            this.setCurrentCode(0);
        }
    }

    public void getSketchCodeFiles(List<String> outFilenames, List<String> outExtensions) {
        String[] list;
        String[] stringArray = list = this.folder.list();
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String filename = stringArray[n2];
            if (!filename.startsWith(".") && !new File(this.folder, filename).isDirectory()) {
                String base = filename;
                String[] stringArray2 = this.mode.getExtensions();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String extension = stringArray2[n4];
                    if (base.toLowerCase().endsWith("." + extension) && Sketch.isSanitaryName(base = base.substring(0, base.length() - (extension.length() + 1)))) {
                        if (outFilenames != null) {
                            outFilenames.add(filename);
                        }
                        if (outExtensions != null) {
                            outExtensions.add(extension);
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public void reload() {
        this.current = null;
        this.load();
    }

    public void loadNewTab(String filename, String ext, boolean newAddition) {
        if (newAddition) {
            this.insertCode(new SketchCode(new File(this.folder, filename), ext));
        } else {
            this.replaceCode(new SketchCode(new File(this.folder, filename), ext));
        }
        this.sortCode();
    }

    protected void replaceCode(SketchCode newCode) {
        int i = 0;
        while (i < this.codeCount) {
            if (this.code[i].getFileName().equals(newCode.getFileName())) {
                this.code[i] = newCode;
                break;
            }
            ++i;
        }
    }

    protected void insertCode(SketchCode newCode) {
        this.ensureExistence();
        this.code = (SketchCode[])PApplet.append((Object)this.code, (Object)newCode);
        ++this.codeCount;
    }

    protected void sortCode() {
        int i = 1;
        while (i < this.codeCount) {
            int who = i;
            int j = i + 1;
            while (j < this.codeCount) {
                if (this.code[j].getFileName().compareTo(this.code[who].getFileName()) < 0) {
                    who = j;
                }
                ++j;
            }
            if (who != i) {
                SketchCode temp = this.code[who];
                this.code[who] = this.code[i];
                this.code[i] = temp;
                if (this.currentIndex == i) {
                    this.currentIndex = who;
                } else if (this.currentIndex == who) {
                    this.currentIndex = i;
                }
            }
            ++i;
        }
    }

    public void handleNewCode() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Messages.showMessage(Language.text("new.messages.is_read_only"), Language.text("new.messages.is_read_only.description"));
            return;
        }
        this.renamingCode = false;
        this.promptForTabName(String.valueOf(Language.text("editor.tab.rename.description")) + ":", "");
    }

    public void handleRenameCode() {
        this.ensureExistence();
        if (this.currentIndex == 0 && this.isUntitled()) {
            Messages.showMessage(Language.text("rename.messages.is_untitled"), Language.text("rename.messages.is_untitled.description"));
            return;
        }
        if (this.isModified()) {
            Messages.showMessage(Language.text("menu.file.save"), Language.text("rename.messages.is_modified"));
            return;
        }
        if (this.isReadOnly()) {
            Messages.showMessage(Language.text("rename.messages.is_read_only"), Language.text("rename.messages.is_read_only.description"));
            return;
        }
        this.renamingCode = true;
        String prompt = this.currentIndex == 0 ? Language.text("editor.sketch.rename.description") : Language.text("editor.tab.rename.description");
        String oldName = this.current.isExtension(this.mode.getDefaultExtension()) ? this.current.getPrettyName() : this.current.getFileName();
        this.promptForTabName(String.valueOf(prompt) + ":", oldName);
    }

    protected void promptForTabName(String prompt, String oldName) {
        final JTextField field = new JTextField(oldName);
        field.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent event) {
                char ch = event.getKeyChar();
                if (!(ch == '_' || ch == '.' || 'A' <= ch && ch <= 'Z' || 'a' <= ch && ch <= 'z')) {
                    if (ch == ' ') {
                        String t = field.getText();
                        int start = field.getSelectionStart();
                        int end2 = field.getSelectionEnd();
                        field.setText(String.valueOf(t.substring(0, start)) + "_" + t.substring(end2));
                        field.setCaretPosition(start + 1);
                        event.consume();
                    } else if (ch >= '0' && ch <= '9') {
                        if (field.getCaretPosition() == 0 || field.getSelectionStart() == 0) {
                            event.consume();
                        }
                    } else if (ch == '\n') {
                        Container parent = field.getParent();
                        while (!(parent instanceof JOptionPane)) {
                            parent = parent.getParent();
                        }
                        JOptionPane pane = (JOptionPane)parent;
                        JPanel pnlBottom = (JPanel)pane.getComponent(pane.getComponentCount() - 1);
                        int i = 0;
                        while (i < pnlBottom.getComponents().length) {
                            ActionListener[] actionListeners;
                            JButton okButton;
                            Component component = pnlBottom.getComponents()[i];
                            if (component instanceof JButton && (okButton = (JButton)component).getText().equalsIgnoreCase("OK") && (actionListeners = okButton.getActionListeners()).length > 0) {
                                actionListeners[0].actionPerformed(null);
                                event.consume();
                            }
                            ++i;
                        }
                    } else {
                        event.consume();
                    }
                }
            }
        });
        int userReply = JOptionPane.showOptionDialog(this.editor, new Object[]{prompt, field}, Language.text("editor.tab.new"), 2, -1, null, new Object[]{Language.getPrompt("ok"), Language.getPrompt("cancel")}, field);
        if (userReply == 0) {
            this.nameCode(field.getText());
        }
    }

    protected void nameCode(String newName) {
        String sanitaryName;
        if ((newName = newName.trim()).length() == 0) {
            return;
        }
        this.ensureExistence();
        if (newName.indexOf(46) == -1) {
            newName = String.valueOf(newName) + "." + (this.renamingCode ? this.mode.getDefaultExtension() : this.mode.getModuleExtension());
        }
        if (this.renamingCode && newName.equalsIgnoreCase(this.current.getFileName())) {
            return;
        }
        if (newName.startsWith(".")) {
            Messages.showWarning(Language.text("name.messages.problem_renaming"), Language.text("name.messages.starts_with_dot.description"));
            return;
        }
        int dot = newName.lastIndexOf(46);
        String newExtension = newName.substring(dot + 1).toLowerCase();
        if (!this.mode.validExtension(newExtension)) {
            Messages.showWarning(Language.text("name.messages.problem_renaming"), Language.interpolate("name.messages.invalid_extension.description", newExtension));
            return;
        }
        if (!this.mode.isDefaultExtension(newExtension) && this.renamingCode && this.current == this.code[0]) {
            Messages.showWarning(Language.text("name.messages.problem_renaming"), Language.interpolate("name.messages.main_java_extension.description", newExtension));
            return;
        }
        String shortName = newName.substring(0, dot);
        if (!shortName.equals(sanitaryName = Sketch.sanitizeName(shortName))) {
            newName = String.valueOf(sanitaryName) + "." + newExtension;
        }
        if (!this.renamingCode || !sanitaryName.equals(this.current.getPrettyName())) {
            SketchCode[] sketchCodeArray = this.code;
            int n = this.code.length;
            int n2 = 0;
            while (n2 < n) {
                SketchCode c = sketchCodeArray[n2];
                if (c != this.current && sanitaryName.equalsIgnoreCase(c.getPrettyName())) {
                    Messages.showMessage(Language.text("name.messages.new_sketch_exists"), Language.interpolate("name.messages.new_sketch_exists.description", c.getFileName(), this.folder.getAbsolutePath()));
                    return;
                }
                ++n2;
            }
        }
        File newFile = new File(this.folder, newName);
        if (this.renamingCode) {
            if (this.currentIndex == 0) {
                String folderName = newName.substring(0, newName.indexOf(46));
                File newFolder = new File(this.folder.getParentFile(), folderName);
                if (newFolder.exists()) {
                    Messages.showWarning(Language.text("name.messages.new_folder_exists"), Language.interpolate("name.messages.new_folder_exists.description", newName));
                    return;
                }
                boolean success = this.folder.renameTo(newFolder);
                if (!success) {
                    Messages.showWarning(Language.text("name.messages.error"), Language.text("name.messages.no_rename_folder.description"));
                    return;
                }
                this.current.setFolder(newFolder);
                newFile = new File(newFolder, newName);
                if (!this.current.renameTo(newFile, newExtension)) {
                    Messages.showWarning(Language.text("name.messages.error"), Language.interpolate("name.messages.no_rename_file.description", this.current.getFileName(), newFile.getName()));
                    return;
                }
                int i = 1;
                while (i < this.codeCount) {
                    this.code[i].setFolder(newFolder);
                    ++i;
                }
                this.updateInternal(sanitaryName, newFolder, this.renamingCode);
            } else if (!this.current.renameTo(newFile, newExtension)) {
                Messages.showWarning(Language.text("name.messages.error"), Language.interpolate("name.messages.no_rename_file.description", this.current.getFileName(), newFile.getName()));
                return;
            }
        } else {
            try {
                if (!newFile.createNewFile()) {
                    throw new IOException("createNewFile() returned false");
                }
            }
            catch (IOException e) {
                Messages.showWarning(Language.text("name.messages.error"), Language.interpolate("name.messages.no_create_file.description", newFile, this.folder.getAbsolutePath()), e);
                return;
            }
            SketchCode newCode = new SketchCode(newFile, newExtension);
            this.insertCode(newCode);
        }
        this.sortCode();
        this.setCurrentCode(newName);
        this.editor.rebuildHeader();
    }

    public void handleDeleteCode() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Messages.showMessage(Language.text("delete.messages.is_read_only"), Language.text("delete.messages.is_read_only.description"));
            return;
        }
        if (this.currentIndex == 0 && this.isUntitled()) {
            Messages.showMessage(Language.text("delete.messages.cannot_delete"), Language.text("delete.messages.cannot_delete.description"));
            return;
        }
        Object[] options = new Object[]{Language.text("prompt.ok"), Language.text("prompt.cancel")};
        String prompt = this.currentIndex == 0 ? Language.text("warn.delete.sketch") : Language.interpolate("warn.delete.file", this.current.getPrettyName());
        int result = JOptionPane.showOptionDialog(this.editor, prompt, Language.text("warn.delete"), 0, 3, null, options, options[0]);
        if (result == 0) {
            if (this.currentIndex == 0) {
                Util.removeDir(this.folder);
                this.editor.getBase().rebuildSketchbookMenus();
                this.editor.getBase().handleClose(this.editor, false);
            } else {
                if (!this.current.deleteFile()) {
                    Messages.showMessage(Language.text("delete.messages.cannot_delete.file"), String.valueOf(Language.text("delete.messages.cannot_delete.file.description")) + " \"" + this.current.getFileName() + "\".");
                    return;
                }
                this.removeCode(this.current);
                this.editor.rebuildHeader();
                this.setCurrentCode(0);
            }
        }
    }

    public void removeCode(SketchCode which) {
        int i = 0;
        while (i < this.codeCount) {
            if (this.code[i] == which) {
                int j = i;
                while (j < this.codeCount - 1) {
                    this.code[j] = this.code[j + 1];
                    ++j;
                }
                --this.codeCount;
                this.code = (SketchCode[])PApplet.shorten((Object)this.code);
                return;
            }
            ++i;
        }
        System.err.println("removeCode: internal error.. could not find code");
    }

    public void handlePrevCode() {
        int prev = this.currentIndex - 1;
        if (prev < 0) {
            prev = this.codeCount - 1;
        }
        this.setCurrentCode(prev);
    }

    public void handleNextCode() {
        this.setCurrentCode((this.currentIndex + 1) % this.codeCount);
    }

    public void setModified(boolean state) {
        if (this.current.isModified() != state) {
            this.current.setModified(state);
            this.calcModified();
        }
    }

    protected void calcModified() {
        this.modified = false;
        int i = 0;
        while (i < this.codeCount) {
            if (this.code[i].isModified()) {
                this.modified = true;
                break;
            }
            ++i;
        }
        this.editor.repaintHeader();
        if (Platform.isMacOS()) {
            Boolean modifiedParam = this.modified ? Boolean.TRUE : Boolean.FALSE;
            this.editor.getRootPane().putClientProperty("Window.documentModified", modifiedParam);
        }
    }

    public boolean isModified() {
        return this.modified;
    }

    public void updateSketchCodes() {
        this.current.setProgram(this.editor.getText());
    }

    public boolean save() throws IOException {
        this.ensureExistence();
        this.updateSketchCodes();
        if (this.isReadOnly()) {
            Messages.showMessage(Language.text("save_file.messages.is_read_only"), Language.text("save_file.messages.is_read_only.description"));
            if (!this.saveAs()) {
                return false;
            }
        }
        SketchCode[] sketchCodeArray = this.code;
        int n = this.code.length;
        int n2 = 0;
        while (n2 < n) {
            SketchCode sc = sketchCodeArray[n2];
            if (sc.isModified()) {
                sc.save();
            }
            ++n2;
        }
        this.calcModified();
        return true;
    }

    public boolean saveAs() throws IOException {
        String newParentDir = null;
        String newName = null;
        String oldName = this.folder.getName();
        String PROMPT = Language.text("save");
        if (Preferences.getBoolean("chooser.files.native")) {
            FileDialog fd = new FileDialog((Frame)this.editor, PROMPT, 1);
            if (this.isReadOnly() || this.isUntitled()) {
                fd.setDirectory(Preferences.getSketchbookPath());
            } else {
                fd.setDirectory(this.folder.getParent());
            }
            String oldFolderName = this.folder.getName();
            fd.setFile(oldFolderName);
            fd.setVisible(true);
            newParentDir = fd.getDirectory();
            newName = fd.getFile();
        } else {
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle(PROMPT);
            if (this.isReadOnly() || this.isUntitled()) {
                fc.setCurrentDirectory(new File(Preferences.getSketchbookPath()));
            } else {
                fc.setCurrentDirectory(this.folder.getParentFile());
            }
            int result = fc.showSaveDialog(this.editor);
            if (result == 0) {
                File selection = fc.getSelectedFile();
                newParentDir = selection.getParent();
                newName = selection.getName();
            }
        }
        if (newName == null) {
            return false;
        }
        String sanitaryName = Sketch.checkName(newName);
        File newFolder = new File(newParentDir, sanitaryName);
        if (!sanitaryName.equals(newName) && newFolder.exists()) {
            Messages.showMessage(Language.text("save_file.messages.sketch_exists"), Language.interpolate("save_file.messages.sketch_exists.description", sanitaryName));
            return false;
        }
        newName = sanitaryName;
        int i = 1;
        while (i < this.codeCount) {
            if (newName.equalsIgnoreCase(this.code[i].getPrettyName())) {
                Messages.showMessage(Language.text("save_file.messages.tab_exists"), Language.interpolate("save_file.messages.tab_exists.description", newName));
                return false;
            }
            ++i;
        }
        if (newFolder.equals(this.folder)) {
            return this.save();
        }
        try {
            String newPath = String.valueOf(newFolder.getCanonicalPath()) + File.separator;
            String oldPath = String.valueOf(this.folder.getCanonicalPath()) + File.separator;
            if (newPath.indexOf(oldPath) == 0) {
                Messages.showWarning(Language.text("save_file.messages.recursive_save"), Language.text("save_file.messages.recursive_save.description"));
                return false;
            }
        }
        catch (IOException iOException) {}
        if (newFolder.exists()) {
            Util.removeDir(newFolder);
        }
        newFolder.mkdirs();
        this.updateSketchCodes();
        File[] copyItems = this.folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                int n;
                int n2;
                String[] stringArray;
                String name = file.getName();
                if (name.equals(".") || name.equals("..")) {
                    return false;
                }
                String[] ignorable = Sketch.this.mode.getIgnorable();
                if (ignorable != null) {
                    stringArray = ignorable;
                    n2 = ignorable.length;
                    n = 0;
                    while (n < n2) {
                        String ignore = stringArray[n];
                        if (name.equals(ignore)) {
                            return false;
                        }
                        ++n;
                    }
                }
                stringArray = Sketch.this.mode.getExtensions();
                n2 = stringArray.length;
                n = 0;
                while (n < n2) {
                    String ext = stringArray[n];
                    if (name.endsWith(ext)) {
                        return false;
                    }
                    ++n;
                }
                return !name.startsWith("screen-");
            }
        });
        this.startSaveAsThread(oldName, newName, newFolder, copyItems);
        int i2 = 1;
        while (i2 < this.codeCount) {
            File newFile = new File(newFolder, this.code[i2].getFileName());
            this.code[i2].saveAs(newFile);
            ++i2;
        }
        File newFile = new File(newFolder, String.valueOf(newName) + "." + this.mode.getDefaultExtension());
        this.code[0].saveAs(newFile);
        this.updateInternal(newName, newFolder, false);
        this.setUntitled(false);
        Recent.append(this.editor);
        return true;
    }

    public boolean isSaving() {
        return this.saving.get();
    }

    void startSaveAsThread(String oldName, final String newName, final File newFolder, final File[] copyItems) {
        this.saving.set(true);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                final JFrame frame = new JFrame("Saving \u201c" + newName + "\u201c...");
                frame.setDefaultCloseOperation(1);
                Box box = Box.createVerticalBox();
                box.setBorder(new EmptyBorder(16, 16, 16, 16));
                if (Platform.isMacOS()) {
                    frame.setBackground(Color.WHITE);
                }
                JLabel label = new JLabel("Saving additional files from the sketch folder...");
                box.add(label);
                box.add(Box.createVerticalStrut(8));
                final JProgressBar progressBar = new JProgressBar(0, 100);
                progressBar.setValue(0);
                progressBar.setStringPainted(true);
                box.add(progressBar);
                frame.getContentPane().add(box);
                frame.pack();
                frame.setLocationRelativeTo(Sketch.this.editor);
                Toolkit.setIcon(frame);
                frame.setVisible(true);
                new SwingWorker<Void, Void>(){

                    @Override
                    protected Void doInBackground() throws Exception {
                        this.addPropertyChangeListener(new PropertyChangeListener(){

                            @Override
                            public void propertyChange(PropertyChangeEvent evt) {
                                if ("progress".equals(evt.getPropertyName())) {
                                    progressBar.setValue((Integer)evt.getNewValue());
                                }
                            }
                        });
                        long totalSize = 0L;
                        File[] fileArray = copyItems;
                        int n = copyItems.length;
                        int n2 = 0;
                        while (n2 < n) {
                            File copyable = fileArray[n2];
                            totalSize += Util.calcSize(copyable);
                            ++n2;
                        }
                        long progress = 0L;
                        this.setProgress(0);
                        File[] fileArray2 = copyItems;
                        int n3 = copyItems.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            File copyable = fileArray2[n4];
                            if (copyable.isDirectory()) {
                                this.copyDir(copyable, new File(newFolder, copyable.getName()), progress, totalSize);
                                progress += Util.calcSize(copyable);
                            } else {
                                this.copyFile(copyable, new File(newFolder, copyable.getName()), progress, totalSize);
                                if (Util.calcSize(copyable) < 524288L) {
                                    this.setProgress((int)((progress += Util.calcSize(copyable)) * 100L / totalSize));
                                }
                            }
                            ++n4;
                        }
                        (this).Sketch.this.saving.set(false);
                        return null;
                    }

                    void copyFile(File sourceFile, File targetFile, long progress, long totalSize) throws IOException {
                        int bytesRead;
                        BufferedInputStream from = new BufferedInputStream(new FileInputStream(sourceFile));
                        BufferedOutputStream to = new BufferedOutputStream(new FileOutputStream(targetFile));
                        byte[] buffer = new byte[16384];
                        int progRead = 0;
                        while ((bytesRead = from.read(buffer)) != -1) {
                            to.write(buffer, 0, bytesRead);
                            if ((progRead += bytesRead) < 524288) continue;
                            this.setProgress((int)(100L * (progress += (long)progRead) / totalSize));
                            progRead = 0;
                        }
                        this.setProgress((int)(100L * progress / totalSize));
                        from.close();
                        from = null;
                        to.flush();
                        to.close();
                        to = null;
                        targetFile.setLastModified(sourceFile.lastModified());
                        targetFile.setExecutable(sourceFile.canExecute());
                    }

                    long copyDir(File sourceDir, File targetDir, long progress, long totalSize) throws IOException {
                        String[] files;
                        if (sourceDir.equals(targetDir)) {
                            throw new IllegalArgumentException("source and target directories are identical");
                        }
                        targetDir.mkdirs();
                        String[] stringArray = files = sourceDir.list();
                        int n = files.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String filename = stringArray[n2];
                            if (filename.charAt(0) != '.') {
                                File source = new File(sourceDir, filename);
                                File target = new File(targetDir, filename);
                                if (source.isDirectory()) {
                                    progress = this.copyDir(source, target, progress, totalSize);
                                    this.setProgress((int)(100L * progress / totalSize));
                                    target.setLastModified(source.lastModified());
                                } else {
                                    this.copyFile(source, target, progress, totalSize);
                                    this.setProgress((int)(100L * (progress += source.length()) / totalSize));
                                }
                            }
                            ++n2;
                        }
                        return progress;
                    }

                    @Override
                    public void done() {
                        frame.dispose();
                        Sketch.this.editor.statusNotice(Language.text("editor.status.saving.done"));
                    }
                }.execute();
            }
        });
    }

    protected void updateInternal(String sketchName, File sketchFolder, boolean renaming) {
        String oldPath = this.getMainFilePath();
        this.primaryFile = this.code[0].getFile();
        this.name = sketchName;
        this.folder = sketchFolder;
        this.disappearedWarning = false;
        this.codeFolder = new File(this.folder, "code");
        this.dataFolder = new File(this.folder, "data");
        this.calcModified();
        this.editor.updateTitle();
        this.editor.getBase().rebuildSketchbookMenus();
        if (renaming) {
            Recent.rename(this.editor, oldPath);
        }
    }

    public void handleAddFile() {
        this.ensureExistence();
        if (this.isReadOnly()) {
            Messages.showMessage(Language.text("add_file.messages.is_read_only"), Language.text("add_file.messages.is_read_only.description"));
            return;
        }
        String prompt = Language.text("file");
        FileDialog fd = new FileDialog((Frame)this.editor, prompt, 0);
        fd.setVisible(true);
        String directory = fd.getDirectory();
        String filename = fd.getFile();
        if (filename == null) {
            return;
        }
        File sourceFile = new File(directory, filename);
        boolean result = this.addFile(sourceFile);
    }

    public boolean addFile(File sourceFile) {
        boolean muchSuccess;
        String filename = sourceFile.getName();
        File destFile = null;
        String codeExtension = null;
        boolean replacement = false;
        boolean isCode = false;
        if (filename.toLowerCase().endsWith(".class") || filename.toLowerCase().endsWith(".jar") || filename.toLowerCase().endsWith(".dll") || filename.toLowerCase().endsWith(".dylib") || filename.toLowerCase().endsWith(".jnilib") || filename.toLowerCase().endsWith(".so")) {
            this.prepareCodeFolder();
            destFile = new File(this.codeFolder, filename);
            isCode = true;
        } else {
            String[] stringArray = this.mode.getExtensions();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String extension = stringArray[n2];
                String lower = filename.toLowerCase();
                if (lower.endsWith("." + extension)) {
                    destFile = new File(this.folder, filename);
                    codeExtension = extension;
                }
                ++n2;
            }
            if (codeExtension == null) {
                this.prepareDataFolder();
                destFile = new File(this.dataFolder, filename);
            }
        }
        if (destFile.exists()) {
            Object[] options = new Object[]{Language.text("prompt.ok"), Language.text("prompt.cancel")};
            String prompt = Language.interpolate("add_file.messages.confirm_replace", filename);
            int result = JOptionPane.showOptionDialog(this.editor, prompt, "Replace", 0, 3, null, options, options[0]);
            if (result == 0) {
                replacement = true;
            } else {
                return false;
            }
        }
        if (replacement && !(muchSuccess = destFile.delete())) {
            Messages.showWarning(Language.text("add_file.messages.error_adding"), Language.interpolate("add_file.messages.cannot_delete.description", filename));
            return false;
        }
        if (codeExtension == null && sourceFile.equals(destFile)) {
            Messages.showWarning(Language.text("add_file.messages.same_file"), Language.text("add_file.messages.same_file.description"));
            return false;
        }
        if (!sourceFile.equals(destFile)) {
            try {
                Util.copyFile(sourceFile, destFile);
            }
            catch (IOException e) {
                Messages.showWarning(Language.text("add_file.messages.error_adding"), Language.interpolate("add_file.messages.cannot_add.description", filename), e);
                return false;
            }
        }
        if (isCode) {
            this.editor.codeFolderChanged();
        }
        if (codeExtension != null) {
            SketchCode newCode = new SketchCode(destFile, codeExtension);
            if (replacement) {
                this.replaceCode(newCode);
            } else {
                this.insertCode(newCode);
                this.sortCode();
            }
            this.setCurrentCode(filename);
            this.editor.repaintHeader();
            if (this.isUntitled()) {
                this.current.setModified(true);
            }
        } else if (this.isUntitled()) {
            this.code[0].setModified(true);
        }
        return true;
    }

    public void setCurrentCode(int which) {
        if (which < 0 || which >= this.codeCount || this.currentIndex == which && this.current == this.code[this.currentIndex]) {
            return;
        }
        if (this.current != null) {
            this.current.setState(this.editor.getText(), this.editor.getSelectionStart(), this.editor.getSelectionStop(), this.editor.getScrollPosition());
        }
        this.current = this.code[which];
        this.currentIndex = which;
        this.current.visited = System.currentTimeMillis();
        this.editor.setCode(this.current);
        this.editor.repaintHeader();
    }

    public void setCurrentCode(String findName) {
        int i = 0;
        while (i < this.codeCount) {
            if (findName.equals(this.code[i].getFileName()) || findName.equals(this.code[i].getPrettyName())) {
                this.setCurrentCode(i);
                return;
            }
            ++i;
        }
    }

    public File makeTempFolder() {
        try {
            return Util.createTempFolder(this.name, "temp", null);
        }
        catch (IOException e) {
            Messages.showWarning(Language.text("temp_dir.messages.bad_build_folder"), Language.text("temp_dir.messages.bad_build_folder.description"), e);
            return null;
        }
    }

    public void ensureExistence() {
        if (!this.folder.exists() && !this.disappearedWarning) {
            this.disappearedWarning = true;
            Messages.showWarning(Language.text("ensure_exist.messages.missing_sketch"), Language.text("ensure_exist.messages.missing_sketch.description"));
            try {
                this.folder.mkdirs();
                this.modified = true;
                int i = 0;
                while (i < this.codeCount) {
                    this.code[i].save();
                    ++i;
                }
                this.calcModified();
            }
            catch (Exception e) {
                Messages.showWarning(Language.text("ensure_exist.messages.unrecoverable"), Language.text("ensure_exist.messages.unrecoverable.description"), e);
            }
        }
    }

    public boolean isReadOnly() {
        String apath = this.folder.getAbsolutePath();
        List<Mode> modes = this.editor.getBase().getModeList();
        for (Mode mode : modes) {
            if (!apath.startsWith(mode.getExamplesFolder().getAbsolutePath()) && !apath.startsWith(mode.getLibrariesFolder().getAbsolutePath())) continue;
            return true;
        }
        int i = 0;
        while (i < this.codeCount) {
            if (this.code[i].isModified() && this.code[i].fileReadOnly() && this.code[i].fileExists()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public File getMainFile() {
        return this.primaryFile;
    }

    public String getMainFilePath() {
        return this.primaryFile.getAbsolutePath();
    }

    public File getFolder() {
        return this.folder;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    public boolean hasDataFolder() {
        return this.dataFolder.exists();
    }

    public File prepareDataFolder() {
        if (!this.dataFolder.exists()) {
            this.dataFolder.mkdirs();
        }
        return this.dataFolder;
    }

    public File getCodeFolder() {
        return this.codeFolder;
    }

    public boolean hasCodeFolder() {
        return this.codeFolder != null && this.codeFolder.exists();
    }

    public File prepareCodeFolder() {
        if (!this.codeFolder.exists()) {
            this.codeFolder.mkdirs();
        }
        return this.codeFolder;
    }

    public SketchCode[] getCode() {
        return this.code;
    }

    public int getCodeCount() {
        return this.codeCount;
    }

    public SketchCode getCode(int index) {
        return this.code[index];
    }

    public int getCodeIndex(SketchCode who) {
        int i = 0;
        while (i < this.codeCount) {
            if (who == this.code[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public SketchCode getCurrentCode() {
        return this.current;
    }

    public int getCurrentCodeIndex() {
        return this.currentIndex;
    }

    public String getMainProgram() {
        return this.getCode(0).getProgram();
    }

    public void setUntitled(boolean untitled) {
        this.untitled = untitled;
        this.editor.updateTitle();
    }

    public boolean isUntitled() {
        return this.untitled;
    }

    public static String checkName(String origName) {
        String newName = Sketch.sanitizeName(origName);
        if (!newName.equals(origName)) {
            String msg = Language.text("check_name.messages.is_name_modified");
            System.out.println(msg);
        }
        return newName;
    }

    public static boolean isSanitaryName(String name) {
        int dot = name.lastIndexOf(46);
        if (dot >= 0) {
            name = name.substring(0, dot);
        }
        return Sketch.sanitizeName(name).equals(name);
    }

    static final boolean asciiLetter(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z';
    }

    public static String sanitizeName(String origName) {
        char[] orig = origName.toCharArray();
        StringBuilder sb = new StringBuilder();
        if (!Sketch.asciiLetter(orig[0])) {
            sb.append("sketch_");
        }
        char[] cArray = orig;
        int n = orig.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Sketch.asciiLetter(c) || c >= '0' && c <= '9') {
                sb.append(c);
            } else {
                sb.append('_');
            }
            ++n2;
        }
        if (sb.length() > 63) {
            sb.setLength(63);
        }
        int underscore = 0;
        while (underscore < sb.length() && sb.charAt(underscore) == '_') {
            ++underscore;
        }
        if (underscore == sb.length()) {
            return "bad_sketch_name_please_fix";
        }
        if (underscore != 0) {
            return sb.substring(underscore);
        }
        return sb.toString();
    }

    public Mode getMode() {
        return this.mode;
    }
}

