/*
 * Decompiled with CFR 0.152.
 */
package processing.app.contrib;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import processing.app.Base;
import processing.app.Mode;
import processing.app.ui.Toolkit;

public class ManagerTabs
extends Box {
    static final int HIGH = Toolkit.zoom(34);
    static final int BORDER = Toolkit.zoom(8);
    static final int CURVE_RADIUS = Toolkit.zoom(6);
    static final int TAB_TOP = Toolkit.zoom(0);
    static final int TAB_BOTTOM = HIGH - Toolkit.zoom(2);
    static final int TAB_BETWEEN = Toolkit.zoom(2);
    static final int MARGIN = Toolkit.zoom(14);
    static final int ICON_WIDTH = Toolkit.zoom(16);
    static final int ICON_HEIGHT = Toolkit.zoom(16);
    static final int ICON_TOP = Toolkit.zoom(7);
    static final int ICON_MARGIN = Toolkit.zoom(7);
    static final int UNSELECTED = 0;
    static final int SELECTED = 1;
    Color[] textColor = new Color[2];
    Color[] tabColor = new Color[2];
    List<Tab> tabList = new ArrayList<Tab>();
    Mode mode;
    Font font;
    int fontAscent;
    Image offscreen;
    int sizeW;
    int sizeH;
    int imageW;
    int imageH;
    Image gradient;
    JPanel cardPanel;
    CardLayout cardLayout;
    Controller controller;
    Component currentPanel;

    public ManagerTabs(Base base) {
        super(1);
        this.mode = base.getDefaultMode();
        this.textColor[1] = this.mode.getColor("manager.tab.text.selected.color");
        this.textColor[0] = this.mode.getColor("manager.tab.text.unselected.color");
        this.font = this.mode.getFont("manager.tab.text.font");
        this.tabColor[1] = this.mode.getColor("manager.tab.selected.color");
        this.tabColor[0] = this.mode.getColor("manager.tab.unselected.color");
        this.gradient = this.mode.makeGradient("manager.tab", Toolkit.zoom(400), HIGH);
        this.setBorder(new EmptyBorder(BORDER, BORDER, BORDER, BORDER));
        this.controller = new Controller();
        this.add(this.controller);
        this.cardLayout = new CardLayout();
        this.cardPanel = new JPanel(this.cardLayout);
        this.add(this.cardPanel);
    }

    public void addPanel(Component comp, String name) {
        this.addPanel(comp, name, null);
    }

    public void addPanel(Component comp, String name, String icon) {
        if (this.tabList.isEmpty()) {
            this.currentPanel = comp;
        }
        this.tabList.add(new Tab(comp, name, icon));
        this.cardPanel.add(name, comp);
    }

    public void setPanel(Component comp) {
        for (Tab tab : this.tabList) {
            if (tab.comp != comp) continue;
            this.currentPanel = comp;
            this.cardLayout.show(this.cardPanel, tab.name);
            this.repaint();
        }
    }

    public Component getPanel() {
        return this.currentPanel;
    }

    public void setNotification(Component comp, boolean note) {
        for (Tab tab : this.tabList) {
            if (tab.comp != comp) continue;
            tab.notification = note;
            this.repaint();
        }
    }

    class Controller
    extends JComponent {
        Controller() {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    int x = e.getX();
                    for (Tab tab : ((Controller)Controller.this).ManagerTabs.this.tabList) {
                        if (!tab.contains(x)) continue;
                        ManagerTabs.this.setPanel(tab.comp);
                        Controller.this.repaint();
                    }
                }
            });
        }

        @Override
        public void paintComponent(Graphics screen) {
            if (screen == null) {
                return;
            }
            Dimension size = this.getSize();
            if (size.width != ManagerTabs.this.sizeW || size.height != ManagerTabs.this.sizeH) {
                if (size.width > ManagerTabs.this.imageW || size.height > ManagerTabs.this.imageH) {
                    ManagerTabs.this.offscreen = null;
                } else {
                    ManagerTabs.this.sizeW = size.width;
                    ManagerTabs.this.sizeH = size.height;
                }
            }
            if (ManagerTabs.this.offscreen == null) {
                ManagerTabs.this.sizeW = size.width;
                ManagerTabs.this.sizeH = size.height;
                ManagerTabs.this.imageW = ManagerTabs.this.sizeW;
                ManagerTabs.this.imageH = ManagerTabs.this.sizeH;
                ManagerTabs.this.offscreen = Toolkit.offscreenGraphics(this, ManagerTabs.this.imageW, ManagerTabs.this.imageH);
            }
            Graphics g = ManagerTabs.this.offscreen.getGraphics();
            g.setFont(ManagerTabs.this.font);
            if (ManagerTabs.this.fontAscent == 0) {
                ManagerTabs.this.fontAscent = (int)Toolkit.getAscent(g);
            }
            Graphics2D g2 = Toolkit.prepareGraphics(g);
            g.drawImage(ManagerTabs.this.gradient, 0, 0, ManagerTabs.this.imageW, ManagerTabs.this.imageH, this);
            g.setColor(ManagerTabs.this.tabColor[1]);
            g.fillRect(0, TAB_BOTTOM, ManagerTabs.this.imageW, Toolkit.zoom(2));
            for (Tab tab : ManagerTabs.this.tabList) {
                tab.textWidth = (int)ManagerTabs.this.font.getStringBounds(tab.name, g2.getFontRenderContext()).getWidth();
            }
            this.placeTabs(0);
            this.drawTabs(g2);
            screen.drawImage(ManagerTabs.this.offscreen, 0, 0, ManagerTabs.this.imageW, ManagerTabs.this.imageH, null);
        }

        private void placeTabs(int left) {
            int x = left;
            for (Tab tab : ManagerTabs.this.tabList) {
                tab.left = x;
                x += MARGIN;
                if (tab.hasIcon()) {
                    x += ICON_WIDTH + MARGIN;
                }
                tab.right = x += tab.textWidth + MARGIN;
                x += TAB_BETWEEN;
            }
            Tab lastTab = ManagerTabs.this.tabList.get(ManagerTabs.this.tabList.size() - 1);
            int offset = this.getWidth() - lastTab.right;
            lastTab.left += offset;
            lastTab.right += offset;
        }

        private void drawTabs(Graphics2D g) {
            for (Tab tab : ManagerTabs.this.tabList) {
                tab.draw(g);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(300, HIGH);
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(super.getMaximumSize().width, HIGH);
        }
    }

    class Tab {
        String name;
        Component comp;
        boolean notification;
        Image enabledIcon;
        Image selectedIcon;
        int left;
        int right;
        int textWidth;

        Tab(Component comp, String name, String icon) {
            this.comp = comp;
            this.name = name;
            if (icon != null) {
                this.enabledIcon = ManagerTabs.this.mode.loadImageX(String.valueOf(icon) + "-enabled");
                this.selectedIcon = ManagerTabs.this.mode.loadImageX(String.valueOf(icon) + "-selected");
                if (this.selectedIcon == null) {
                    this.selectedIcon = this.enabledIcon;
                }
            }
        }

        boolean contains(int x) {
            return x >= this.left && x <= this.right;
        }

        boolean isCurrent() {
            return this.comp.isVisible();
        }

        boolean hasLeftNotch() {
            return ManagerTabs.this.tabList.get(0) == this || ManagerTabs.this.tabList.get(ManagerTabs.this.tabList.size() - 1) == this;
        }

        boolean hasRightNotch() {
            return ManagerTabs.this.tabList.get(ManagerTabs.this.tabList.size() - 1) == this || ManagerTabs.this.tabList.get(ManagerTabs.this.tabList.size() - 2) == this;
        }

        int getTextLeft() {
            int links = this.left;
            if (this.enabledIcon != null) {
                links += ICON_WIDTH + ICON_MARGIN;
            }
            return links + (this.right - links - this.textWidth) / 2;
        }

        boolean hasIcon() {
            return this.enabledIcon != null;
        }

        void draw(Graphics g) {
            int state = this.isCurrent() ? 1 : 0;
            g.setColor(ManagerTabs.this.tabColor[state]);
            Graphics2D g2 = (Graphics2D)g;
            g2.fill(Toolkit.createRoundRect(this.left, TAB_TOP, this.right, TAB_BOTTOM, this.hasLeftNotch() ? CURVE_RADIUS : 0, this.hasRightNotch() ? CURVE_RADIUS : 0, 0.0f, 0.0f));
            if (this.hasIcon()) {
                Image icon = this.isCurrent() || this.notification ? this.selectedIcon : this.enabledIcon;
                g.drawImage(icon, this.left + MARGIN, ICON_TOP, ICON_WIDTH, ICON_HEIGHT, null);
            }
            int textLeft = this.getTextLeft();
            if (this.notification && state == 0) {
                g.setColor(ManagerTabs.this.textColor[1]);
            } else {
                g.setColor(ManagerTabs.this.textColor[state]);
            }
            int tabHeight = TAB_BOTTOM - TAB_TOP;
            int baseline = TAB_TOP + (tabHeight + ManagerTabs.this.fontAscent) / 2;
            g.drawString(this.name, textLeft, baseline);
        }
    }
}

