/*
 * Decompiled with CFR 0.152.
 */
package processing.app.platform;

import com.apple.eio.FileManager;
import java.awt.Desktop;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import processing.app.Base;
import processing.app.Messages;
import processing.app.platform.DefaultPlatform;
import processing.app.platform.ThinkDifferent;

public class MacPlatform
extends DefaultPlatform {
    static final int kDocumentsFolderType = 1685021555;
    static final int kDomainLibraryFolderType = 1684826466;
    static final short kUserDomain = -32763;

    @Override
    public void saveLanguage(String language) {
        String[] cmdarray = new String[]{"defaults", "write", String.valueOf(System.getProperty("user.home")) + "/Library/Preferences/org.processing.app", "AppleLanguages", "-array", language};
        try {
            Runtime.getRuntime().exec(cmdarray);
        }
        catch (IOException e) {
            Messages.log("Error saving platform language: " + e.getMessage());
        }
    }

    @Override
    public void initBase(Base base) {
        super.initBase(base);
        System.setProperty("apple.laf.useScreenMenuBar", "true");
        ThinkDifferent.init(base);
    }

    @Override
    public File getSettingsFolder() throws Exception {
        return new File(this.getLibraryFolder(), "Processing");
    }

    @Override
    public File getDefaultSketchbookFolder() throws Exception {
        return new File(this.getDocumentsFolder(), "Processing");
    }

    @Override
    public void openURL(String url) throws Exception {
        try {
            Desktop.getDesktop().browse(new URI(url));
        }
        catch (IOException e) {
            if (e.getMessage().contains("Error code: -600")) {
                throw new RuntimeException("Could not open the sketch, please restart your browser or computer");
            }
            throw e;
        }
    }

    protected String getLibraryFolder() throws FileNotFoundException {
        return FileManager.findFolder((short)-32763, (int)1684826466);
    }

    protected String getDocumentsFolder() throws FileNotFoundException {
        return FileManager.findFolder((short)-32763, (int)1685021555);
    }
}

