/*
 * Decompiled with CFR 0.152.
 */
package processing.app.ui;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import processing.app.Base;
import processing.app.Language;
import processing.app.Mode;
import processing.app.Platform;
import processing.app.SketchReference;
import processing.app.ui.Toolkit;
import processing.app.ui.ZoomTreeCellRenderer;

public class SketchbookFrame
extends JFrame {
    protected Base base;
    protected Mode mode;

    public SketchbookFrame(final Base base, Mode mode) {
        super(Language.text("sketchbook"));
        this.base = base;
        this.mode = mode;
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SketchbookFrame.this.setVisible(false);
            }
        };
        Toolkit.registerWindowCloseKeys(this.getRootPane(), listener);
        Toolkit.setIcon(this);
        final JTree tree = new JTree(mode.buildSketchbookTree());
        tree.getSelectionModel().setSelectionMode(1);
        tree.setShowsRootHandles(true);
        tree.expandRow(0);
        tree.setRootVisible(false);
        tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                    int selRow = tree.getRowForLocation(e.getX(), e.getY());
                    if (node != null && node.isLeaf() && selRow != -1) {
                        SketchReference sketch = (SketchReference)node.getUserObject();
                        base.handleOpen(sketch.getPath());
                    }
                }
            }
        });
        tree.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27) {
                    SketchbookFrame.this.setVisible(false);
                }
            }

            @Override
            public void keyTyped(KeyEvent e) {
                DefaultMutableTreeNode node;
                if (e.getKeyChar() == '\n' && (node = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent()) != null && node.isLeaf()) {
                    SketchReference sketch = (SketchReference)node.getUserObject();
                    base.handleOpen(sketch.getPath());
                }
            }
        });
        int border = Toolkit.zoom(5);
        tree.setBorder(new EmptyBorder(border, border, border, border));
        if (Platform.isMacOS()) {
            tree.setToggleClickCount(2);
        } else {
            tree.setToggleClickCount(1);
        }
        tree.setCellRenderer(new ZoomTreeCellRenderer(mode));
        TreeModel treeModel = tree.getModel();
        if (treeModel.getChildCount(treeModel.getRoot()) != 0) {
            JScrollPane treePane = new JScrollPane(tree);
            treePane.setPreferredSize(Toolkit.zoom(250, 450));
            treePane.setBorder(new EmptyBorder(0, 0, 0, 0));
            this.getContentPane().add(treePane);
        } else {
            JPanel emptyPanel = new JPanel();
            emptyPanel.setBackground(Color.WHITE);
            emptyPanel.setPreferredSize(Toolkit.zoom(250, 450));
            JLabel emptyLabel = new JLabel("Empty Sketchbook");
            emptyLabel.setForeground(Color.GRAY);
            emptyPanel.add(emptyLabel);
            this.setContentPane(emptyPanel);
        }
        this.pack();
    }

    public void setVisible() {
        EventQueue.invokeLater(new Runnable(){

            /*
             * Unable to fully structure code
             */
            @Override
            public void run() {
                roughWidth = SketchbookFrame.this.getWidth() + 20;
                p = null;
                editor = SketchbookFrame.this.base.getActiveEditor();
                if (editor == null) ** GOTO lbl-1000
                p = editor.getLocation();
                if (p.x < roughWidth) lbl-1000:
                // 2 sources

                {
                    SketchbookFrame.this.setLocationRelativeTo(null);
                } else {
                    SketchbookFrame.this.setLocation(p.x - roughWidth, p.y);
                }
                SketchbookFrame.this.setVisible(true);
            }
        });
    }
}

