/*
 * Decompiled with CFR 0.152.
 */
package processing.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.Socket;
import processing.core.PApplet;

public class Client
implements Runnable {
    protected static final int MAX_BUFFER_SIZE = 0x8000000;
    PApplet parent;
    Method clientEventMethod;
    Method disconnectEventMethod;
    volatile Thread thread;
    Socket socket;
    int port;
    String host;
    public InputStream input;
    public OutputStream output;
    final Object bufferLock = new Object[0];
    byte[] buffer = new byte[32768];
    int bufferIndex;
    int bufferLast;
    boolean disposeRegistered = false;

    public Client(PApplet pApplet, String string, int n) {
        this.parent = pApplet;
        this.host = string;
        this.port = n;
        try {
            this.socket = new Socket(this.host, this.port);
            this.input = this.socket.getInputStream();
            this.output = this.socket.getOutputStream();
            this.thread = new Thread(this);
            this.thread.start();
            pApplet.registerMethod("dispose", (Object)this);
            this.disposeRegistered = true;
            try {
                this.clientEventMethod = pApplet.getClass().getMethod("clientEvent", Client.class);
            }
            catch (Exception exception) {}
            try {
                this.disconnectEventMethod = pApplet.getClass().getMethod("disconnectEvent", Client.class);
            }
            catch (Exception exception) {}
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            this.dispose();
        }
    }

    public Client(PApplet pApplet, Socket socket) throws IOException {
        this.parent = pApplet;
        this.socket = socket;
        this.input = socket.getInputStream();
        this.output = socket.getOutputStream();
        this.thread = new Thread(this);
        this.thread.start();
        try {
            this.clientEventMethod = pApplet.getClass().getMethod("clientEvent", Client.class);
        }
        catch (Exception exception) {}
        try {
            this.disconnectEventMethod = pApplet.getClass().getMethod("disconnectEvent", Client.class);
        }
        catch (Exception exception) {}
    }

    public void stop() {
        if (this.disconnectEventMethod != null && this.thread != null) {
            try {
                this.disconnectEventMethod.invoke((Object)this.parent, this);
            }
            catch (Exception exception) {
                Throwable throwable = exception;
                if (exception instanceof InvocationTargetException && exception.getCause() != null) {
                    throwable = exception.getCause();
                }
                throwable.printStackTrace();
                this.disconnectEventMethod = null;
            }
        }
        if (this.disposeRegistered) {
            this.parent.unregisterMethod("dispose", (Object)this);
            this.disposeRegistered = false;
        }
        this.dispose();
    }

    public void dispose() {
        this.thread = null;
        try {
            if (this.input != null) {
                this.input.close();
                this.input = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (this.output != null) {
                this.output.close();
                this.output = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            if (this.socket != null) {
                this.socket.close();
                this.socket = null;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean active() {
        return this.thread != null;
    }

    public String ip() {
        if (this.socket != null) {
            return this.socket.getInetAddress().getHostAddress();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int available() {
        Object object = this.bufferLock;
        synchronized (object) {
            return this.bufferLast - this.bufferIndex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.bufferLock;
        synchronized (object) {
            this.bufferLast = 0;
            this.bufferIndex = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() {
        Object object = this.bufferLock;
        synchronized (object) {
            block5: {
                if (this.bufferIndex != this.bufferLast) break block5;
                return -1;
            }
            int n = this.buffer[this.bufferIndex++] & 0xFF;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char readChar() {
        Object object = this.bufferLock;
        synchronized (object) {
            block4: {
                if (this.bufferIndex != this.bufferLast) break block4;
                return '\uffff';
            }
            return (char)this.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes() {
        Object object = this.bufferLock;
        synchronized (object) {
            block4: {
                if (this.bufferIndex != this.bufferLast) break block4;
                return null;
            }
            int n = this.bufferLast - this.bufferIndex;
            byte[] byArray = new byte[n];
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n);
            this.bufferIndex = 0;
            this.bufferLast = 0;
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytes(int n) {
        Object object = this.bufferLock;
        synchronized (object) {
            block6: {
                if (this.bufferIndex != this.bufferLast) break block6;
                return null;
            }
            int n2 = this.bufferLast - this.bufferIndex;
            if (n2 > n) {
                n2 = n;
            }
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n2);
            this.bufferIndex += n2;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytes(byte[] byArray) {
        Object object = this.bufferLock;
        synchronized (object) {
            block6: {
                if (this.bufferIndex != this.bufferLast) break block6;
                return 0;
            }
            int n = this.bufferLast - this.bufferIndex;
            if (n > byArray.length) {
                n = byArray.length;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n);
            this.bufferIndex += n;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readBytesUntil(int n) {
        byte by = (byte)n;
        Object object = this.bufferLock;
        synchronized (object) {
            int n2;
            int n3;
            block9: {
                block8: {
                    if (this.bufferIndex != this.bufferLast) break block8;
                    return null;
                }
                n3 = -1;
                n2 = this.bufferIndex;
                while (n2 < this.bufferLast) {
                    if (this.buffer[n2] == by) {
                        n3 = n2;
                        break;
                    }
                    ++n2;
                }
                if (n3 != -1) break block9;
                return null;
            }
            n2 = n3 - this.bufferIndex + 1;
            byte[] byArray = new byte[n2];
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n2);
            this.bufferIndex += n2;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            return byArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readBytesUntil(int n, byte[] byArray) {
        byte by = (byte)n;
        Object object = this.bufferLock;
        synchronized (object) {
            int n2;
            block11: {
                int n3;
                block10: {
                    block9: {
                        if (this.bufferIndex != this.bufferLast) break block9;
                        return 0;
                    }
                    n3 = -1;
                    n2 = this.bufferIndex;
                    while (n2 < this.bufferLast) {
                        if (this.buffer[n2] == by) {
                            n3 = n2;
                            break;
                        }
                        ++n2;
                    }
                    if (n3 != -1) break block10;
                    return 0;
                }
                n2 = n3 - this.bufferIndex + 1;
                if (n2 <= byArray.length) break block11;
                System.err.println("readBytesUntil() byte buffer is too small for the " + n2 + " bytes up to and including char " + n);
                return -1;
            }
            System.arraycopy(this.buffer, this.bufferIndex, byArray, 0, n2);
            this.bufferIndex += n2;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            return n2;
        }
    }

    public String readString() {
        byte[] byArray = this.readBytes();
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    public String readStringUntil(int n) {
        byte[] byArray = this.readBytesUntil(n);
        if (byArray == null) {
            return null;
        }
        return new String(byArray);
    }

    public void write(int n) {
        try {
            this.output.write(n & 0xFF);
            this.output.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.stop();
        }
    }

    public void write(byte[] byArray) {
        try {
            this.output.write(byArray);
            this.output.flush();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.stop();
        }
    }

    public void write(String string) {
        this.write(string.getBytes());
    }
}

