/*
 * Decompiled with CFR 0.152.
 */
package processing.mode.java.pdex;

import com.google.classpath.ClassPath;
import com.google.classpath.ClassPathFactory;
import com.google.classpath.RegExpResourceFilter;
import com.google.classpath.ResourceFilter;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.jdt.core.compiler.IProblem;
import processing.app.Language;
import processing.mode.java.JavaEditor;
import processing.mode.java.JavaMode;
import processing.mode.java.pdex.JavaProblem;
import processing.mode.java.pdex.PreprocessedSketch;
import processing.mode.java.pdex.PreprocessingService;
import processing.mode.java.pdex.SourceUtils;

class ErrorChecker {
    private static final long DELAY_BEFORE_UPDATE = 650L;
    private ScheduledExecutorService scheduler;
    private volatile ScheduledFuture<?> scheduledUiUpdate = null;
    private volatile long nextUiUpdate = 0L;
    private volatile boolean enabled = true;
    private final Consumer<PreprocessedSketch> errorHandlerListener = this::handleSketchProblems;
    private JavaEditor editor;
    private PreprocessingService pps;
    private static final Pattern CURLY_QUOTE_REGEX = Pattern.compile("([\u201c\u201d\u2018\u2019])", 256);

    public ErrorChecker(JavaEditor editor, PreprocessingService pps) {
        this.editor = editor;
        this.pps = pps;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.enabled = JavaMode.errorCheckEnabled;
        if (this.enabled) {
            pps.registerListener(this.errorHandlerListener);
        }
    }

    public void notifySketchChanged() {
        this.nextUiUpdate = System.currentTimeMillis() + 650L;
    }

    public void preferencesChanged() {
        if (this.enabled != JavaMode.errorCheckEnabled) {
            this.enabled = JavaMode.errorCheckEnabled;
            if (this.enabled) {
                this.pps.registerListener(this.errorHandlerListener);
            } else {
                this.pps.unregisterListener(this.errorHandlerListener);
                this.editor.setProblemList(Collections.emptyList());
                this.nextUiUpdate = 0L;
            }
        }
    }

    public void dispose() {
        if (this.scheduler != null) {
            this.scheduler.shutdownNow();
        }
    }

    private void handleSketchProblems(PreprocessedSketch ps) {
        HashMap suggCache = JavaMode.importSuggestEnabled ? new HashMap() : Collections.emptyMap();
        ArrayList<JavaProblem> problems = new ArrayList<JavaProblem>();
        IProblem[] iproblems = ps.compilationUnit.getProblems();
        List<JavaProblem> curlyQuoteProblems = ErrorChecker.checkForCurlyQuotes(ps);
        problems.addAll(curlyQuoteProblems);
        if (problems.isEmpty()) {
            List<JavaProblem> missingBraceProblems = ErrorChecker.checkForMissingBraces(ps);
            problems.addAll(missingBraceProblems);
        }
        if (problems.isEmpty()) {
            AtomicReference<Object> searchClassPath = new AtomicReference<Object>(null);
            List cuProblems = Arrays.stream(iproblems).filter(iproblem -> !iproblem.isWarning() || JavaMode.warningsEnabled).filter(iproblem -> !iproblem.getMessage().contains("Syntax error, insert \":: IdentifierOrNew\"")).map(iproblem -> {
                JavaProblem p = ErrorChecker.convertIProblem(iproblem, ps);
                if (p != null && JavaMode.importSuggestEnabled && ErrorChecker.isUndefinedTypeProblem(iproblem)) {
                    ClassPath cp = (ClassPath)searchClassPath.updateAndGet(prev -> prev != null ? prev : new ClassPathFactory().createFromPaths(preprocessedSketch.searchClassPathArray));
                    String[] s = suggCache.computeIfAbsent(iproblem.getArguments()[0], name -> ErrorChecker.getImportSuggestions(cp, name));
                    p.setImportSuggestions(s);
                }
                return p;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            problems.addAll(cuProblems);
        }
        if (this.scheduledUiUpdate != null) {
            this.scheduledUiUpdate.cancel(true);
        }
        long delay = this.nextUiUpdate - System.currentTimeMillis();
        Runnable uiUpdater = () -> {
            if (this.nextUiUpdate > 0L && System.currentTimeMillis() >= this.nextUiUpdate) {
                EventQueue.invokeLater(() -> this.editor.setProblemList(problems));
            }
        };
        this.scheduledUiUpdate = this.scheduler.schedule(uiUpdater, delay, TimeUnit.MILLISECONDS);
    }

    private static JavaProblem convertIProblem(IProblem iproblem, PreprocessedSketch ps) {
        PreprocessedSketch.SketchInterval in = ps.mapJavaToSketch(iproblem);
        if (in != PreprocessedSketch.SketchInterval.BEFORE_START) {
            String badCode = ps.getPdeCode(in);
            int line = ps.tabOffsetToTabLine(in.tabIndex, in.startTabOffset);
            JavaProblem p = JavaProblem.fromIProblem(iproblem, in.tabIndex, line, badCode);
            p.setPDEOffsets(in.startTabOffset, in.stopTabOffset);
            return p;
        }
        return null;
    }

    private static boolean isUndefinedTypeProblem(IProblem iproblem) {
        int id = iproblem.getID();
        return id == 0x1000002 || id == 0x22000032 || id == 33554515;
    }

    private static boolean isMissingBraceProblem(IProblem iproblem) {
        if (iproblem.getID() == 0x600000F0) {
            char brace = iproblem.getArguments()[0].charAt(0);
            return brace == '{' || brace == '}';
        }
        if (iproblem.getID() == 1610612967) {
            char brace = iproblem.getArguments()[1].charAt(0);
            return brace == '{' || brace == '}';
        }
        return false;
    }

    private static List<JavaProblem> checkForCurlyQuotes(PreprocessedSketch ps) {
        IProblem[] iproblems;
        ArrayList<JavaProblem> problems = new ArrayList<JavaProblem>(0);
        Matcher matcher = CURLY_QUOTE_REGEX.matcher(ps.scrubbedPdeCode);
        while (matcher.find()) {
            int pdeOffset = matcher.start();
            String q = matcher.group();
            int tabIndex = ps.pdeOffsetToTabIndex(pdeOffset);
            int tabOffset = ps.pdeOffsetToTabOffset(tabIndex, pdeOffset);
            int tabLine = ps.tabOffsetToTabLine(tabIndex, tabOffset);
            String message = Language.interpolate((String)"editor.status.bad_curly_quote", (Object[])new Object[]{q});
            JavaProblem problem = new JavaProblem(message, 1, tabIndex, tabLine);
            problem.setPDEOffsets(tabOffset, tabOffset + 1);
            problems.add(problem);
        }
        ArrayList<JavaProblem> problems2 = new ArrayList<JavaProblem>(0);
        IProblem[] iProblemArray = iproblems = ps.compilationUnit.getProblems();
        int n = iproblems.length;
        int n2 = 0;
        while (n2 < n) {
            IProblem iproblem = iProblemArray[n2];
            switch (iproblem.getID()) {
                case 1610612968: 
                case 1610612969: 
                case 1610612971: 
                case 1610612973: 
                case 1610612995: {
                    PreprocessedSketch.SketchInterval in = ps.mapJavaToSketch(iproblem);
                    if (in == PreprocessedSketch.SketchInterval.BEFORE_START) break;
                    String badCode = ps.getPdeCode(in);
                    matcher.reset(badCode);
                    while (matcher.find()) {
                        int offset = matcher.start();
                        String q = matcher.group();
                        int tabStart = in.startTabOffset + offset;
                        int tabStop = tabStart + 1;
                        if (!problems.stream().noneMatch(p -> p.getStartOffset() == tabStart)) continue;
                        int line = ps.tabOffsetToTabLine(in.tabIndex, tabStart);
                        String message = iproblem.getID() == 1610612995 ? Language.interpolate((String)"editor.status.unterm_string_curly", (Object[])new Object[]{q}) : Language.interpolate((String)"editor.status.bad_curly_quote", (Object[])new Object[]{q});
                        JavaProblem p2 = new JavaProblem(message, 1, in.tabIndex, line);
                        p2.setPDEOffsets(tabStart, tabStop);
                        problems2.add(p2);
                    }
                    break;
                }
            }
            ++n2;
        }
        problems.addAll(problems2);
        return problems;
    }

    private static List<JavaProblem> checkForMissingBraces(PreprocessedSketch ps) {
        JavaProblem p2;
        ArrayList<JavaProblem> problems = new ArrayList<JavaProblem>(0);
        int tabIndex = 0;
        while (tabIndex < ps.tabStartOffsets.length) {
            int tabStartOffset = ps.tabStartOffsets[tabIndex];
            int tabEndOffset = tabIndex < ps.tabStartOffsets.length - 1 ? ps.tabStartOffsets[tabIndex + 1] : ps.scrubbedPdeCode.length();
            int[] braceResult = SourceUtils.checkForMissingBraces(ps.scrubbedPdeCode, tabStartOffset, tabEndOffset);
            if (braceResult[0] != 0) {
                JavaProblem problem = new JavaProblem(braceResult[0] < 0 ? Language.interpolate((String)"editor.status.missing.left_curly_bracket", (Object[])new Object[0]) : Language.interpolate((String)"editor.status.missing.right_curly_bracket", (Object[])new Object[0]), 1, tabIndex, braceResult[1]);
                problem.setPDEOffsets(braceResult[3], braceResult[3] + 1);
                problems.add(problem);
            }
            ++tabIndex;
        }
        if (problems.isEmpty()) {
            return problems;
        }
        int problemTabIndex = ((JavaProblem)problems.get(0)).getTabIndex();
        IProblem missingBraceProblem = Arrays.stream(ps.compilationUnit.getProblems()).filter(ErrorChecker::isMissingBraceProblem).filter(p -> p.getSourceEnd() + 1 < preprocessedSketch.javaCode.length()).filter(p -> problemTabIndex == preprocessedSketch.mapJavaToSketch((IProblem)p).tabIndex).findFirst().orElse(null);
        if (missingBraceProblem != null && (p2 = ErrorChecker.convertIProblem(missingBraceProblem, ps)) != null) {
            problems.clear();
            problems.add(p2);
        }
        return problems;
    }

    public static String[] getImportSuggestions(ClassPath cp, String className) {
        className = className.replace("[", "\\[").replace("]", "\\]");
        RegExpResourceFilter regf = new RegExpResourceFilter(Pattern.compile(".*"), Pattern.compile("(.*\\$)?" + className + "\\.class", 2));
        String[] resources = cp.findResources("", (ResourceFilter)regf);
        return (String[])Arrays.stream(resources).map(res -> res.substring(0, res.length() - 6)).map(res -> res.replace('/', '.')).map(res -> res.replace('$', '.')).sorted((o1, o2) -> {
            boolean o2StartsWithJava;
            boolean o1StartsWithJava = o1.startsWith("java");
            if (o1StartsWithJava != (o2StartsWithJava = o2.startsWith("java"))) {
                if (o1StartsWithJava) {
                    return -1;
                }
                return 1;
            }
            return o1.compareTo((String)o2);
        }).toArray(String[]::new);
    }
}

