<?php
!defined('P_W') && exit('Forbidden');

define('FORUM_INVALID_PARAMS', 401);
define('FORUM_FAVOR_MAX', 402);
define('FORUM_FAVOR_ALREADY', 403);
define('FORUM_NOT_EXISTS', 404);
define('THREAD_TOPPED_NOT_EXISTS', 405);
define('THREAD_INVALID_PARAMS', 406);

class ForumApi extends BaseApi {
	var $methodsType = array('getthreads' => 'GET', 'getsubforums' => 'GET', 'getlist' => 'GET', 'add' => 'POST', 'addtype' => 'POST', 'unfavor' => 'GET');
	
	/**
	 * ȡµͨб
	 * @param int $fid ID
	 * @param int $offset ȡбʼλ
	 * @param int $limit ȡб
	 * @param bool $getTopicType ǷȡϢ
	 * return array
	 */
	function getthreads($fid, $offset = 0, $limit = 20, $getTopicType, $getForum = false) {
		global $db_postmin, $db_postmax;
		$user = new apiUserInfo(array('visit', 'post'));
		$user->initRight();
		L::loadClass('forum', 'forum', false);
		$pwforum = new PwForum($fid);
		if (!$pwforum->isForum(true)) {
			return $this->errMessage(THREAD_INVALID_PARAMS, '鲻');
		}
		$pwforum->forumcheck($user->info, $user->groupid);
		$pwforum->creditcheck($user->info, $user->groupid);
		
		$total = $this->db->get_value("SELECT topic FROM pw_forumdata WHERE fid=" . S::sqlEscape($fid));
		$threads = array();
		$query = $this->db->query("SELECT tid,subject,authorid,author,postdate,lastpost,lastposter,hits,replies,ifupload FROM pw_threads WHERE fid=" . S::sqlEscape($fid) . " AND ifcheck='1' AND topped='0' ORDER BY lastpost DESC " . S::sqlLimit($offset, $limit));
		while ($rt = $this->db->fetch_array($query)) {
			$threads[] = $rt;
		}
		$array = array('threads' => $threads, 'count' => $total);
		$array['hasSubForum'] = $pwforum->foruminfo['childid'] ? 1 : 0;
		$array['hasTopThreads'] = $this->_getTopThreadIds($fid) ? 1 : 0;
		if ($getForum == true) {
			if (trim($user->info['shortcut'], ',')) {
				$shortcuts = explode(',', $user->info['shortcut']);
			}
			$forumInfo = array('name' => strip_tags($pwforum->name), 'isFavored' => (in_array($pwforum->fid, $shortcuts) ? 1 : 0), 'postRight' => $user->allowcheck($pwforum->foruminfo['allowpost'], $pwforum->foruminfo['fid'], 'post') && $user->getRight('allowpost'));
			$array['forum'] = $forumInfo;
		}
		if ($this->_isNotFalse($getTopicType) && is_array($pwforum->foruminfo['topictype']) && !empty($pwforum->foruminfo['topictype'])) {
			$topictype = $this->_bulidTopicType($pwforum->foruminfo['topictype'], $user->_gp_gptype);
			$topictype && $array['topictype'] = $topictype;
		}
		$array['minLenth'] = $pwforum->foruminfo['forumset']['contentminlen'] ? $pwforum->foruminfo['forumset']['contentminlen'] : $db_postmin;
		$array['maxLenth'] = $db_postmax;
		return $array;
	}
	
	/**
	 * ȡضӰ
	 * @param int $fid fid
	 * return array
	 */
	function getsubforums($fid) {
		$user = new apiUserInfo(array('visit', 'post'));
		$array = $shortcuts = array();
		if (trim($user->info['shortcut'], ',')) {
			$shortcuts = explode(',', $user->info['shortcut']);
		}
		$query = $this->db->query("SELECT fid,name,allowvisit,allowpost FROM pw_forums WHERE fup=" . S::sqlEscape($fid) . " ORDER BY vieworder");
		while ($rt = $this->db->fetch_array($query)) {
			if (!$user->allowcheck($rt['allowvisit'], $rt['fid'], 'visit'))
				continue;
			$array[] = array('fid' => $rt['fid'], 'name' => strip_tags($rt['name']), 'isFavored' => (in_array($rt['fid'], $shortcuts) ? 1 : 0), 'postRight' => $user->allowcheck($rt['allowpost'], $rt['fid'], 'post') && $user->getRight('allowpost'));
		}
		return $array;
	}
	
	/**
	 * 
	 * ȡöб
	 * @param int $fid
	 */
	function gettopthreads($fid) {
		if (intval($fid) < 1)
			return $this->errMessage(FORUM_INVALID_PARAMS, 'fid');
		$toptids = $this->_getTopThreadIds($fid);
		if (!$toptids)
			return array();
		$threads = array();
		if ($toptids) {
			$query = $this->db->query("SELECT tid,subject,authorid,author,postdate,lastpost,hits,replies FROM pw_threads WHERE tid IN($toptids) ORDER BY topped DESC,lastpost DESC");
			while ($rt = $this->db->fetch_array($query)) {
				$threads[] = $rt;
			}
		}
		return $threads;
	}
	
	/**
	 * 
	 * ȡָϢ
	 * @param int $fid
	 */
	function gettopictype($fid) {
		$user = new apiUserInfo();
		$user->initRight();
		L::loadClass('forum', 'forum', false);
		$pwforum = new PwForum($fid);
		if (empty($pwforum->foruminfo['topictype']))
			return array();
		$array = $this->_bulidTopicType($pwforum->foruminfo['topictype'], $user->_gp_gptype);
		return $array;
	}
	
	/**
	 * 
	 * ȡеöID
	 * @param int $fid
	 */
	
	function _getTopThreadIds($fid) {
		if ($fid < 0)
			return false;
		$topthreads = $this->db->get_value("SELECT topthreads FROM pw_forumdata WHERE fid=" . S::sqlEscape($fid));
		$topids = $topthreads ? trim($topthreads, ',') : false;
		return $topids;
	}
	
	/**
	 * ȡб
	 * @return array
	 */
	function getforums() {
		$user = new apiUserInfo(array('visit', 'post'));
		$cates = $forums = $favorite = $shortcuts = array();
		if (trim($user->info['shortcut'], ',')) {
			$shortcuts = explode(',', $user->info['shortcut']);
		}
		$query = $this->db->query("SELECT f.fid,f.name,f.fup,f.type,f.allowvisit,f.allowpost,f.ifsub,fd.tpost,fd.lastpost,fe.forumset FROM pw_forums f LEFT JOIN pw_forumdata fd ON f.fid=fd.fid LEFT JOIN pw_forumsextra fe ON f.fid=fe.fid WHERE f.ifcms!=2 AND f.cms!='1' ORDER BY f.vieworder");
		while ($rt = $this->db->fetch_array($query)) {
			$rt['name'] = strip_tags($rt['name']);
			if ($rt['type'] == 'category') {
				$cates[$rt['fid']] = array('fid' => $rt['fid'], 'name' => $rt['name']);
				continue;
			} elseif ($rt['type'] == 'forum') {
				if (!$user->allowcheck($rt['allowvisit'], $rt['fid'], 'visit')) {
					continue;
				}
				$forumset = unserialize($rt['forumset']);
				$threadMinLength = $forumset['contentminlen'];
				$contentmin = empty($threadMinLength) ? $GLOBALS['db_postmin'] : $threadMinLength;
				list(, $lastposter, $lastpost) = explode("\t", $rt['lastpost']);
				$forums[$rt['fup']][] = array('fid' => $rt['fid'], 'name' => $rt['name'], 'isFavored' => (in_array($rt['fid'], $shortcuts) ? 1 : 0), 'postRight' => $user->allowcheck($rt['allowpost'], $rt['fid'], 'post') && $user->getRight('allowpost'), 'tpost' => $rt['tpost'], 
					'lastpost' => $lastpost, 'lastposter' => $lastposter, 'contentmin' => $contentmin);
			}
			if (in_array($rt['fid'], $shortcuts)) {
				if ($rt['type'] == 'forum') {
					$forumset = unserialize($rt['forumset']);
					$threadMinLength = $forumset['contentminlen'];
					$contentmin = empty($threadMinLength) ? $GLOBALS['db_postmin'] : $threadMinLength;
				} else {
					$contentmin = $GLOBALS['db_postmin'];
				}
				$favorite[] = array('fid' => $rt['fid'], 'name' => $rt['name'], 'postRight' => $user->allowcheck($rt['allowpost'], $rt['fid'], 'post') && $user->getRight('allowpost'), 'tpost' => $rt['tpost'], 'lastpost' => $lastpost, 'contentmin' => $contentmin);
			}
		}
		foreach ($forums as $key => $value) {
			$cates[$key]['child'] = $value;
		}
		foreach ($cates as $key => $value) {
			$_cates[] = $value;
		}
		$hotforums = array();
		if (empty($favorite)) {
			$hotforums = $this->_hotforum($user);
		}
		return array('forums' => $_cates, 'favorite' => $favorite, 'hotforums' => $hotforums, 'titlemax' => $GLOBALS['db_titlemax'], 'contentmin' => $GLOBALS['db_postmin']);
	}
	/**
	 * Ű
	 *
	 * @param unknown_type $num
	 * @return unknown
	 */
	function _hotforum(&$user, $num = 6) {
		$cates = $forums = $shortcuts = array();
		$num = intval($num);
		$num = ($num < 1) ? 1 : $num;
		$query = $this->db->query("SELECT f.fid,f.name,f.fup,f.type,f.allowvisit,f.allowpost,f.ifsub,fd.tpost,fd.lastpost,fe.forumset FROM pw_forums f LEFT JOIN pw_forumdata fd ON f.fid=fd.fid LEFT JOIN pw_forumsextra fe ON f.fid=fe.fid WHERE f.ifcms!=2 AND f.cms!='1' ORDER BY fd.tpost DESC LIMIT " . $num);
		while ($rt = $this->db->fetch_array($query)) {
			$rt['name'] = strip_tags($rt['name']);
			if ($rt['type'] == 'category') {
				$cates[$rt['fid']] = array('fid' => $rt['fid'], 'name' => $rt['name']);
				continue;
			} elseif ($rt['type'] == 'forum') {
				if (!$user->allowcheck($rt['allowvisit'], $rt['fid'], 'visit')) {
					continue;
				}
				$forumset = unserialize($rt['forumset']);
				$threadMinLength = $forumset['contentminlen'];
				$contentmin = empty($threadMinLength) ? $GLOBALS['db_postmin'] : $threadMinLength;
				list(, $lastposter, $lastpost) = explode("\t", $rt['lastpost']);
				$forums[$rt['fup']][] = array('fid' => $rt['fid'], 'name' => $rt['name'], 'isFavored' => (in_array($rt['fid'], $shortcuts) ? 1 : 0), 'postRight' => $user->allowcheck($rt['allowpost'], $rt['fid'], 'post') && $user->getRight('allowpost'), 'tpost' => $rt['tpost'], 
					'lastpost' => $lastpost, 'lastposter' => $lastposter, 'contentmin' => $contentmin);
			}
		}
		foreach ($forums as $key => $value) {
			$cates[$key]['child'] = $value;
		}
		foreach ($cates as $key => $value) {
			$_cates[] = $value;
		}
		return $_cates;
	}
	
	/**
	 * ɾղ
	 * @param int $fid fid
	 * return bool
	 */
	function deletecollection($fid) {
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
		$cates = $forums = $favorite = $shortcuts = array();
		if (trim($user->info['shortcut'], ',')) {
			$shortcut = explode(',', $user->info['shortcut']);
			$shortcut = array_diff($shortcut, array($fid, ''));
			$shortcut = ',' . implode(',', $shortcut) . ",\t" . $user->info['appshortcut'];
			$userService = L::loadClass('UserService', 'user');
			$userService->update($user->uid, array('shortcut' => $shortcut));
		}
		return true;
	}
	
	/**
	 * ȡղ
	 * @param int $fid	//id
	 * @return boolean
	 */
	function unfavor($fid) {
		return $this->deletecollection($fid);
	}
	
	/**
	 * ղ
	 * @param int $fid fid
	 * return bool
	 */
	function favor($fid) {
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
		$myshortcut = explode(',', $user->info['shortcut']);
		foreach ($myshortcut as $key => $value) {
			if (!$value || !is_numeric($value)) {
				unset($myshortcut[$key]);
			}
		}
		$myshortcut = array_unique($myshortcut);
		if (count($myshortcut) >= 6) {
			return $this->errMessage(FORUM_FAVOR_MAX, 'ղزܳ6');
		}
		if (in_array($fid, $myshortcut)) {
			return $this->errMessage(FORUM_FAVOR_ALREADY, 'ðѾղ');
		}
		$myshortcut[] = $fid;
		$shortcut = ',' . implode(',', $myshortcut) . ',';
		$shortcut .= "\t" . $user->info['appshortcut'];
		$userService = L::loadClass('UserService', 'user');
		$userService->update($user->uid, array('shortcut' => $shortcut));
		return true;
	}
	
	/**
	 * жǷΪfalse
	 * @param bool $value true|false
	 * return bool
	 */
	function _isNotFalse($value) {
		return $value && strtolower($value) != 'false';
	}
	
	/**
	 * 
	 * @param array $topictype δ
	 * @param array $gp_gptype û飨ϵͳ顢Ա飩
	 * return array $array
	 */
	function _bulidTopicType($topictype, $gp_gptype) {
		$array = array();
		foreach ($topictype as $key => $value) {
			if ($value['ifsys'] && $gp_gptype != 'system') {
				unset($topictype[$key]);
				continue;
			}
			$value['name'] = strip_tags($value['name']);
			$filter = array('id' => $value['id'], 'name' => $value['name'], 'upid' => $value['upid']);
			$array[] = $filter;
		}
		return $array;
	}
}