<?php
!defined('P_W') && exit('Forbidden');
define('MESSAGE_INVALID_PARAMS', 601);
define('MESSAGE_UID_ERROR', 602);
define('MESSAGE_SEND_FAIL', 603);

class MessageApi extends BaseApi {
	var $methodsType = array('get' => 'GET', 'getmessages' => 'GET', 'inbox' => 'GET', 'outbox' => 'GET', 'getunread' => 'GET', 'delete' => 'POST', 'send' => 'POST', 'reply' => 'POST', 'getreply' => 'GET', 'messagelist' => 'GET',
			/*  */
			'unreadcount' => 'GET');

	/**
	 * ȡȡϢ
	 * @param int $mid ϢID
	 * @param int $uid ûID ѡڸûϢעΪѶ
	 * @return array
	 */
	function get($mid, $uid = 0) {
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
		if (intval($mid) < 1) {
			return $this->errMessage(MESSAGE_INVALID_PARAMS, 'mid');
		}
		$messageService = $this->_getMessageService();
		$result = $messageService->getMessage($mid);
		if ($result && $uid)
			$messageService->readMessages($uid, $mid);
		$messageInfo = $this->_messageMapper($result);
		return array('messageinfo' => $messageInfo);
	}

	/**
	 * ȡûվ
	 * @param int $uid ûID
	 * @param int $offset ҳ
	 * @param int $limit 
	 * @return array
	 */
	function getmessages($uid, $offset = 1, $limit = 20) {
		if ($errormsg = $this->_checkUser($uid)) {
			list($errCode,$errMessage) = explode($errormsg);
			return $this->errMessage($errCode, $errMessage);
		}
		$messageService = $this->_getMessageService();
		$result = $messageService->getAllMessages($uid, $offset, $limit);
		$messages = array();
		foreach ($result as $value) {
			list($value['face']) = showfacedesign($value['icon'], 1, 's');
			$messages[] = $this->_messageMapper($value);
		}
		$count = $messageService->countAllMessage($uid);
	
		return array('count' => $count, 'messages' => $messages);
	}
	/**
	 * б
	 *
	 * @param int $uid ûid
	 * @param int $mid ϴεĶid
	 * @param string $go  up|down
	 * @param int $limit 
	 * @return array
	 */
	function getmessageslist($uid, $mid, $go = 'up', $limit = 20) {
		if ($errormsg = $this->_checkUser($uid)) {
			list($errCode,$errMessage) = explode($errormsg);
			return $this->errMessage($errCode, $errMessage);
		}
		$messageService = $this->_getMessageService();
		$count = $messageService->countAllMessage($uid);
		if (!$count) return array('count' => $count, 'messages' => array());
		$result = $messageService->getAllMessages($uid, $offset, $limit);
		$messages = array();
		foreach ($result as $value) {
			$messages[] = $this->_messageMapper($value);
		}
		return array('count' => $count, 'messages' => $messages);
	}

	/**
	 * ȡûյĶϢ
	 * @param Integer $uid ûID
	 * @param Integer $offset
	 * @param Integer $limit 
	 * @return array
	 */
	function inbox($uid, $offset = 1, $limit = 20) {
		if ($errormsg = $this->_checkUser($uid)) {
			list($errCode,$errMessage) = explode($errormsg);
			return $this->errMessage($errCode, $errMessage);
		}
		$messageService = $this->_getMessageService();
		$result = $messageService->getMessagesByOther($uid, 100, $offset, $limit);
		$messages = array();
		foreach ($result as $value) {
			$messages[] = $this->_messageMapper($value);
		}
		$count = $messageService->countMessagesByOther($uid, 100);
		$unread = $messageService->countMessagesNotRead($uid);
		return array('count' => $count, 'unread' => $unread, 'messages' => $messages);
	}

	/**
	 * ȡû͵ĶϢ
	 * @param int $uid
	 * @param int $offset
	 * @param int $limit
	 * @return array 
	 */
	function outbox($uid, $offset = 1, $limit = 20) {
		if ($errormsg = $this->_checkUser($uid)) {
			list($errCode,$errMessage) = explode($errormsg);
			return $this->errMessage($errCode, $errMessage);
		}
		$messageService = $this->_getMessageService();
		$result = $messageService->getMessagesBySelf($uid, 100, $offset, $limit);
		$messages = array();
		foreach ($result as $value) {
			$messagesFilter = $this->_messageMapper($value);
			foreach ($value['extra'] as $v) {
				$userService = $this->_getUserService();
				$uid = $userService->getUserIdByUserName($v);
				$messagesFilter['revicers'][] = array('uid' => $uid, 'username' => $v);
			}
			$messages[] = $messagesFilter;
		}
		$count = $messageService->countMessagesBySelf($uid, 100);
		return array('count' => $count, 'messages' => $messages);
	}

	/**
	 * ȡĩϢб
	 * @param int $uid
	 * @param int $offset
	 * @param int $limit
	 * @return array
	 */
	function getunread($uid, $offset = 1, $limit = 20) {
		if ($errormsg = $this->_checkUser($uid)) {
			list($errCode,$errMessage) = explode($errormsg);
			return $this->errMessage($errCode, $errMessage);
		}
		$messageService = $this->_getMessageService();
		$result = $messageService->getAllNotRead($uid, $offset, $limit);
		$messages = array();
		foreach ($result as $value) {
			$messages[] = $this->_messageMapper($value);
		}
		$count = $messageService->countMessagesNotRead($uid);
		return array('count' => $count, 'messages' => $messages);
	}

	/**
	 * ƳϢ
	 * @param int $uid ûID
	 * @param int $mid ϢID
	 * @return int|array
	 */
	function delete($uid, $mid) {
		if ($errormsg = $this->_checkUser($uid)) {
			list($errCode,$errMessage) = explode($errormsg);
			return $this->errMessage($errCode, $errMessage);
		}
		if (intval($mid) < 1) {
			return $this->errMessage(MESSAGE_INVALID_PARAMS, 'mid');
		}
		$messageService = $this->_getMessageService();
		return (bool) $messageService->deleteMessage($uid, $mid) ? false : true;
	}

	/**
	 * ֪ͨ
	 * @param int|array $recevieName ûID
	 * @param string $type 'notice' | 'message'
	 * @param string $subject Ϣ
	 * @param string $content Ϣ
	 * @return int
	 */
	function send($recevieName, $type = 'message', $subject, $content) {
		if (empty($recevieName) || empty($subject) || empty($content)) {
			return $this->errMessage(MESSAGE_INVALID_PARAMS, 'recevieName or subject or content');
		}
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
		$user->initRight();
		$GLOBALS['winduid'] = $user->uid;
		$GLOBALS['windid'] = $user->username;
		$GLOBALS['groupid'] = $user->groupid;
		$GLOBALS['winddb'] = $user->info;
		$GLOBALS['_G'] = $user->_G;
		$recevieName = is_array($recevieName) ? $recevieName : array($recevieName);
		//$recevieId = is_numeric($recevieId) ? array($recevieId) : explode(',',$recevieId);
		$messageInfo = array('create_uid' => $user->uid, 'create_username' => $user->username, 'title' => $subject, 'content' => $content);
		$messageService = $this->_getMessageService();
		if ($type == 'notice') {
			$mid = M::sendNotice($recevieName, $messageInfo);
		} elseif ($type == 'message') {
			$mid = M::sendMessage($user->uid, $recevieName, $messageInfo);
		}
		if ($mid > 0) {
			return array('mid' => $mid);
		} else {
			return $this->errMessage(MESSAGE_SEND_FAIL, 'ʧܣ');
		}
	}

	/**
	 * ظ
	 * @param int $mid ϢID
	 * @param int $rid ϢϵID
	 * @param string $subject Ϣ
	 * @param string $content Ϣ
	 * @return int ͳɹĻظid
	 */
	function reply($mid, $rid, $subject, $content) {
		if (intval($mid) < 1 || empty($subject) || empty($content)) {
			return $this->errMessage(MESSAGE_INVALID_PARAMS, 'mid or subject or content');
		}
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
		$userService = $this->_getUserService();
		$messageInfo = array('create_uid' => $user->uid, 'create_username' => $userService->getUserNameByUserId($user->uid), 'title' => $subject, 'content' => $content);
		$messageService = $this->_getMessageService();
		//$messageInfo = $messageService->getMessage($mid);//return array($messageInfo);
		$replyId = $messageService->sendReply($user->uid, $rid, $mid, $messageInfo);
		return array('replyid' => $replyId);
	}

	/**
	 * ȡϢظ
	 * @param Integer $mid ϢID
	 * @param Integer $rid ϢϵID
	 * @return Array
	 */
	function getreply($mid, $rid) {
		if (intval($mid) < 1 || intval($rid) < 1) {
			return $this->errMessage(MESSAGE_INVALID_PARAMS, 'mid or rid');
		}
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
		$messageServer = $this->_getMessageService();
		$relation = $messageServer->getRelation($user->uid, $rid);
		$message  = $messageServer->getMessage($mid);
		list($message['content'],$message['tid'],$message['pid'],$message['page']) = $this->_buildMessageContent($message['content']);
		if($relation['relation'] == 2){
			$expand = (isset($message['expand'])) ? unserialize($message['expand']) : array();
			$message = $messageServer->getMessage($expand['parentid']);
			$mid = $message['mid'];
		}
		$replyInfo = $messageServer->getReplies($user->uid, $mid, $rid);
		$messages = array();
		$unset = array('title','status','modifiedtime');
		foreach ($replyInfo as $k => $value) {
			if ($k == 0) {
				$message['content'] && $value['content'] = $message['content'].'<br />';
				if ($message['tid']) $value['content'] .= '<topic type="1" id="'.$message['tid'].'">鿴</topic>  ';
				if ($message['pid']) $value['content'] .= '<topic type="1" id="'.$message['tid'].','.$message['pid'].','.$message['page'].'">鿴ظ</topic>';
			}
			foreach ($unset as $key) {
				unset($value[$key]);
			}
			$value['mid'] = $mid;
			$value['face'] = str_replace('/middle/','/small/',$value['face']);
			$messages[] = $this->_messageMapper($value);
		}
		return array('messagereply' => $messages);
	}

	/**
	 * ȡб
	 * @param Integer $rid
	 * @param String $go
	 * @param Integer $limit
	 */
	function messagelist($rid = 0, $go = 'up', $limit = 20) {
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
		$sql = "SELECT * FROM pw_ms_relations force index(categoryidx) WHERE uid=" . S::sqlEscape($user->uid) . " AND categoryid=1 ";
		if (!empty($rid)) {
			$sql .= $go == 'up' ? "AND rid >" . S::sqlEscape($rid) . " ORDER BY rid ASC " : "AND rid <" . S::sqlEscape($rid) . " ORDER BY rid DESC ";
			$sql .= S::sqlLimit(0, $limit);
		} else {
			$sql .= ' ORDER BY rid DESC ' . S::sqlLimit(0, $limit);
		}
		$query = $this->db->query($sql);
		$relations = array();
		while ($rt = $this->db->fetch_array($query)) {
			$relations[] = $rt;
		}
		$messageIds = $tmpRelations = array();
		foreach ($relations as $r) {
			($r['mid']) ? $messageIds[] = $r['mid'] : 0;
			$tmpRelations[$r['rid']] = $r;
		}
		if (!$messageIds)
			return array('messages' => array());
		$messageIds = is_array($messageIds) ? S::sqlImplode($messageIds) : $messageIds;
		$query = $this->db->query("SELECT * FROM pw_ms_messages WHERE mid in (" . $messageIds . ")");
		while ($rt = $this->db->fetch_array($query)) {
			$messages[] = $rt;
		}
		$tmpUid = $tmpMessages = $result = array();
		foreach ($messages as $m) {
			$tmpMessages[$m['mid']] = $m;
			$tmpUid[] = $m['create_uid'];
			if ($m['create_uid'] == $user->uid) {
				$query = $this->db->query("SELECT uid FROM pw_ms_relations WHERE mid=" . S::sqlEscape($m['mid']));
				while ($rt = $this->db->fetch_array($query)) {
					$rt['uid'] != $user->uid && $_uids[] = $rt['uid'];
				}
				$userInfo = $this->_getUserInfoByUids($_uids);
				if (!is_array($userInfo))
					continue;
				foreach ($userInfo as $item) {
					$userName[$m['mid']][] = $item['username'];
				}
			}
		}
		$userIcon = $this->_getUserIconByUids($tmpUid);
		!empty($rid) && $go == 'up' && krsort($tmpRelations);
		foreach ($tmpRelations as $rid => $r) {
			$r['face'] = $userIcon[$tmpMessages[$r['mid']]['create_uid']];
			if (isset($tmpMessages[$r['mid']])) {
				$messages = $this->_messageMapper($r + $tmpMessages[$r['mid']]);
				$messages['receive'] = isset($userName[$r['mid']]) ? $userName[$r['mid']] : array();
				$result[] = $messages;
			}
		}
		return array('messages' => $result);
	}

	/**
	 * ûϢվţ@ңûص۵δ
	 * @param int $uid
	 * @return array
	 */
	function condition($lastmid = 0) {
		$user = new apiUserInfo();
		if (!$user->uid)
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		$messageService = $this->_getMessageService();
		$_result[] = $messageService->countMessagesNotRead($user->uid);
		$_result[] = $user->info['newreferto'];
		$_result[] = $user->info['newcomment'];
		require_once (R_P . 'mclientapi/api/weibo.class.php');
		$weiboObj = new WeiboApi();
		$newweibo = $weiboObj->getNewAttentionWeiboCount($lastmid);
		$_result[] = $newweibo;
		$_result[] = $user->info['newfans'];
		return $_result;
	}

	function _messageMapper($data) {
		$data['content'] = $this->_mShowFace($data['content']);
		$return = array('mid' => $data['mid'], 'senderid' => $data['create_uid'], 'sender' => $data['create_username'],'createdtime' => $data['created_time'],'modifiedtime' => $data['modified_time'],'content' => $data['content']);
		isset($data['title']) && $return['title'] = $data['title'];
		isset($data['extra']) && is_array($data['extra']) && $return['receiver'] = $data['extra'][0];
		isset($data['rid']) && $return['rid'] = $data['rid'];
		isset($data['status']) && $return['status'] = $data['status'];
		isset($data['face']) && $return['face'] = $data['face'];
		isset($data['tid']) && $return['tid'] = $data['tid'];
		isset($data['pid']) && $return['pid'] = $data['pid'];
		isset($data['page']) && $return['page'] = $data['page'];
		return $return;
	}
	
	function _mShowFace($content) {
		$content = preg_replace("/<img src\=\"[^>]+\/post\/smile\/([^>]+)\" \/>/eis","UnMShowFace('\\1')",$content);
		$content = mShowface($content);
		return $content;
	}

	function _buildMessageContent($content) {
		if(strpos($content,'鿴') !== false && strpos($content,'鿴ظ') !== false) {
			preg_match("/\[url\=http:(.*)job\.php\?action\=topost&tid\=(\d*)&pid\=(\d*)\]鿴ظ\[\/url\]/i", $content, $matches);
			$content = preg_replace("/\[url\=http:(.*)job\.php\?action\=topost&tid\=(\d*)&pid\=(\d*)\]鿴ظ\[\/url\]/i",'',$content);
			$content = preg_replace("/\[url\=http:(.*)read\.php\?tid\=(\d*)\]鿴\[\/url\]/i",'',$content);
			$page = $this->_getPageByTidAndPid($matches[2],$matches[3]);
			return array($content,$matches[2],$matches[3],$page);
		} else {
			return array();
		}
	}

	function _getPageByTidAndPid($tid,$pid) {
		if (empty($tid) || empty($pid)) return 1;
		$pw_posts = GetPtable('N', $tid);
		$postdb = $this->db->get_one("SELECT postdate FROM $pw_posts WHERE pid=" . S::sqlEscape($pid));
		if (empty($postdb)) return 1;
		$postsnum = $this->db->get_value("SELECT COUNT(*) FROM $pw_posts WHERE tid=" . S::sqlEscape($tid) . " AND postdate<= ".S::sqlEscape($postdb['postdate']));
		$page = ceil(($postsnum + 1) / 20);
		return $page;
	}

	/**
	 * ȡûͷ
	 * @param Array|Int $uids
	 */
	function _getUserIconByUids($uids) {
		if (empty($uids))
			return null;
		!is_array($uids) && $uids = array($uids);
		require_once (R_P . 'require/showimg.php');
		//$userService = L::loadClass('UserService', 'user');
		$userInfo = $this->_getUserInfoByUids($uids);
		if (!is_array($userInfo))
			return null;
		$return = array();
		foreach ($userInfo as $key => $item) {
			$_icon = showfacedesign($item['icon'], 1, 's');
			$return[$key] = $_icon['0'];
		}
		return $return;
	}

	function _getUserInfoByUids($uids) {
		//$userService = L::loadClass('UserService', 'user');
		$userService = $this->_getUserService();
		return $userService->getByUserIds($uids);
	}

	/**
	 * @return PW_UserService
	 */
	function _getUserService() {
		return L::loadClass('UserService', 'user');
	}

	/**
	 * @return PW_Message
	 */
	function _getMessageService() {
		return L::loadClass("message", 'message');
	}

	/**
	 * ûĺϷ
	 * @param $uid ûID
	 * @return string
	 */
	function _checkUser($uid) {
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return array(USER_NOT_LOGIN, 'ûδ¼');
		}
		if (intval($uid) < 1) {
			return array(MESSAGE_INVALID_PARAMS, 'uid');
		}
		if ($uid != $user->uid) {
			return array(MESSAGE_UID_ERROR, 'ִûǵǰ¼û');
		}
		return array();
	}
}