<?php
!defined('P_W') && exit('Forbidden');
class SearchApi extends BaseApi {
	var $methodsType = array('search' => 'GET');
	/**
	 * ̳ӿ
	 *
	 * @param unknown_type $keyword 
	 * @param unknown_type $type 
	 * @param unknown_type $threadrange   1⣨Ĭϣ2+ 3
	 * @param unknown_type $page ҳ
	 * @param unknown_type $num 
	 */
	function search($keyword = "", $type = 'thread', $threadrange = 1, $fid = 0, $page = 1, $perpage = 20) {
		$searchPassType = array('thread', 'diary', 'user', 'forum', 'group');
		if ($type && !in_array($type, array_merge(array('special'), (array) $searchPassType))) {
			showMsg("Ǹ,Ͳ");
		}
		$searcherService = L::loadclass('searcher', 'search'); /* @var $searcherService PW_Searcher */
		list($page, $isSphinx, $threadrange, $diaryrange) = $this->_initCondition($page, $threadrange, $diaryrange);
		list($perpage, $searchURL) = array($perpage, '');
		
		if ($type && $keyword) {
			if (!$isSphinx && 2 == $step) {
				if (!$searcherService->checkUserLevel()) {
					Showmsg('search_limit');
				}
				if (!$searcherService->checkWaitSegment()) {
					Showmsg('search_wait');
				}
			}
			$keyword = strip_tags($keyword);
			@include_once (D_P . 'data/bbscache/search_config.php');
			$starttime = FALSE;
			$endtime = FALSE;
			$fid = $fid ? $fid : '';
			switch ($type) {
				case "thread" :
					$allowSearch = ($_G['allowsearch'] > 0 && $_G['allowsearch'] == 3) ? array(2, 3) : array(2); /* search range */
					$threadrange = (in_array($threadrange, $allowSearch)) ? $threadrange : 1;
					$ptable = min(intval($ptable), count($db_plist));
					$ttable = min(intval($ttable), count($db_tlist));
					$expand = array("ttable" => $ttable, "ptable" => $ptable);
					$threadrange = ($keyword) ? $threadrange : 1;
					list($total, $threads) = $searcherService->searchThreads($keyword, $threadrange, $username, $starttime, $endtime, $fid, $page, $perpage, $expand);
					break;
				case "forum" :
					list($total, $forums) = $searcherService->searchForums($keyword, $page, $perpage);
					$forums = $total ? $_searchHelper->buildForums($forums) : array();
					$pager = ($total) ? numofpage($total, $page, ceil($total / $perpage), $searchURL . "searcher.php?keyword=" . urlencode($keyword) . "&type=$type&", null, '', true) : '';
					break;
				case "user" :
					list($total, $users) = $searcherService->searchUsers($keyword, $page, $perpage);
					$pager = ($total) ? numofpage($total, $page, ceil($total / $perpage), $searchURL . "searcher.php?keyword=" . urlencode($keyword) . "&type=$type&", null, '', true) : '';
					break;
				case "diary" :
					$adverts = $_searchHelper->getSearchAdvert($keyword);
					$posttime && list($diarystarttime, $diaryendtime) = $_searchHelper->getStartAndEndTimeByUrl($posttime);
					list($total, $diarys) = $searcherService->searchDiarys($keyword, $diaryrange, $diaryusername, $diarystarttime, $diaryendtime, $page, $perpage);
					$pager = ($total) ? numofpage($total, $page, ceil($total / $perpage), $searchURL . "searcher.php?keyword=" . urlencode($keyword) . "&type=$type&diaryrange=$diaryrange&diaryusername=" . urlencode($diaryusername) . "&diarystarttime=$diarystarttime&diaryendtime=$diaryendtime&", null, '', true) : '';
					break;
				case "group" :
					list($total, $groups) = $searcherService->searchGroups($keyword, $page, $perpage);
					$pager = ($total) ? numofpage($total, $page, ceil($total / $perpage), $searchURL . "searcher.php?keyword=" . urlencode($keyword) . "&type=$type&", null, '', true) : '';
					break;
				default :
					$adverts = $_searchHelper->getSearchAdvert($keyword);
					$_extendSearcher = L::loadClass('extendsearcher', 'search');
					$_searcherService = $_extendSearcher->extendSearcher($type);
					$conditions = array('keywords' => $keyword, 'username' => $username, 'starttime' => $starttime, 'endtime' => $endtime, 'authorid' => $authorid);
					list($total, $lists) = $_searcherService->search($conditions, $page, $perpage);
					$pager = ($total) ? numofpage($total, $page, ceil($total / $perpage), $searchURL . "searcher.php?type=$type&keyword=$keyword&", null, '', true) : '';
					break;
			}
		} else {
			showMsg("");
		}
		$threads = $this->_dispachThreads($threads);
		$threads = $threads ? $threads : array();
		$return = array('total' => $total, 'threads' => $threads);
		return $return;
	
	}
	/**
	 * ȴ
	 *
	 * @return unknown
	 */
	function hotwords() {
		global $db_hotwords;
		$hotwords = ($db_hotwords) ? explode(",", $db_hotwords) : array();
		return $hotwords;
	}
	function _dispachThreads($threads) {
		if (!empty($threads)) {
			$posts = array();
			foreach ($threads as $thread) {
				$thread['tid'] = $thread['tid'];
				$thread['subject'] = ($thread['subject']);
				$thread['content'] = strip_tags($thread['content']);
				$thread['forumname'] = $thread['name'];
				$thread['postdate'] = strtotime($thread['postdate']);
				unset($thread['name'], $thread['imgTotal'], $thread['firstImgName'], $thread['firstImgId'], $thread['firstImgUrl'], $thread['content']);
				$posts[] = $thread;
			}
			$threads = $posts;
		
		}
		return $threads;
	}
	function _initCondition($page, $threadrange, $diaryrange) {
		global $db_sphinx;
		$isSphinx = ($db_sphinx['isopen'] > 0) ? true : false; /* is mysql or sphinx */
		$threadrange = ($threadrange > 1) ? $threadrange : 1;
		$diaryrange = ($diaryrange > 1) ? $diaryrange : 1;
		$page = ($page > 1) ? $page : 1;
		return array($page, $isSphinx, $threadrange, $diaryrange);
	}
}