<?php
!defined('P_W') && exit('Forbidden');
define('SIGN_USER_NOT_LOGIN', 901);
define('SIGN_STATUS', 902);
define('SIGN_CREDIT', 903);
class SignApi extends BaseApi {
	var $methodsType = array('sign' => 'GET');
	var $table = 'pw_phone_sign';
	/**
	 * ǩ
	 *
	 */
	function sign() {
		global $winduid, $windid;
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(SIGN_USER_NOT_LOGIN, 'ûδ¼');
		}
		$winduid = $user->uid;
		$windid = $user->username;
		$sign = $this->_signCheckModel($winduid);
		if ($sign == TRUE) { //˵Ѿǩ
			return $this->errMessage(SIGN_STATUS, 'Ѿǩ');
		} else {
			include_once (D_P . 'data/bbscache/sign_config.php');
			$creditpoint = isset($creditpoint) ? $creditpoint : 0;
			$credittype = isset($credittype) ? $credittype : 'money';
			$creditnames = pwCreditNames();
			$creditname = $creditnames[$credittype];
			require_once (D_P . 'require/credit.php');
			if ($creditpoint) {
				$setCredit = $credit->set($winduid, $credittype, $creditpoint);
			} else {
				$setCredit = TRUE;
			}
			if ($setCredit == TRUE) { //˵ӷֳɹ
				$sign = $this->_signModel($winduid, $windid);
				if ($sign == TRUE) {
					$sign = 1;
					return array('sign' => $sign);
				} else { //ǩûгɹ
					$creditpoint = -$creditpoint;
					$credit->set($winduid, $credittype, $creditpoint);
					$sign = 0;
					return array('sign' => $sign);
				}
			} else {
				return $this->errMessage(SIGN_CREDIT, 'ӻַ');
			}
		}
	
	}
	/**
	 * ֤ǷѾǩ
	 *
	 * @return unknown
	 */
	function signCheck() {
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(SIGN_USER_NOT_LOGIN, 'ûδ¼');
		}
		$winduid = $user->uid;
		$sign = $this->_signCheckModel($winduid);
		include_once (D_P . 'data/bbscache/sign_config.php');
		$creditpoint = isset($creditpoint) ? $creditpoint : 5;
		$credittype = isset($credittype) ? $credittype : 'money';
		$creditnames = pwCreditNames();
		$creditname = $creditnames[$credittype];
		$sign = $sign ? 1 : 0;
		$return = array('sign' => $sign, 'point' => $creditpoint, 'creditname' => $creditname);
		return $return;
	
	}
	/**
	 * Ƿǩݿ
	 *
	 * @param unknown_type $uid
	 * @return unknown
	 */
	function _signCheckModel($uid) {
		$createDate = $this->db->get_value("SELECT createdate FROM " . $this->table . " WHERE uid=" . pwEscape($uid));
		$createDate = $createDate ? $createDate : 0;
		if ((date('d', $this->timestamp) != date('d', $createDate))) { //˵ûǩ
			$sign = FALSE;
		
		} else { //Ѿǩ
			$sign = TRUE;
		}
		return $sign;
	}
	/**
	 * ǩ¼ 
	 *
	 * @param int $uid
	 * @param string $username
	 * @return unknown
	 */
	function _signModel($uid, $username) {
		$sql = 'REPLACE INTO ' . $this->table;
		$sql .= ' SET uid=' . pwEscape($uid) . ',username=' . pwEscape($username) . ',createdate=' . pwEscape($this->timestamp);
		$this->db->update($sql);
		return TRUE;
	}
}