<?php
!defined('P_W') && exit('Forbidden');
define('SITE_INVALID_PARAMS',001);

class SiteApi extends BaseApi{
	var $methodsType = array(
		'get'    => 'GET',
		'bbsinfo'=> 'GET',
		'mobileversion'=> 'GET'
	);
	
    /**
     * ȡվϢ
     * @return array
     */
    function get() {
		$queryMap = array(
			'db_bbsifopen' => 'ifopen',
			'db_bbsname'   => 'sitename',
			'db_bbsurl'    => 'siteurl',
			'db_charset'   => 'charset'
		);
    	$query = $this->db->query("SELECT * FROM pw_config");
    	$data = array();
    	while($rt = $this->db->fetch_array($query)) {
			if (array_key_exists($rt['db_name'], $queryMap)){
				$a = $rt['db_name'];
				$data[$queryMap[$a]] = ($rt['vtype'] == 'array') ? unserialize($rt['db_value']) : $rt['db_value'];
			}
        }
        return $data;
    }
    
    /**
     * ȡվͳϢ
     * @return array
     */
    function bbsinfo() {
    	global $db_online,$timestamp;
    	$query = $this->db->query("SELECT fd.tpost,fd.topic,fd.article,fd.subtopic FROM pw_forums f LEFT JOIN pw_forumdata fd USING(fid) WHERE f.ifsub='0' AND f.ifcms!=2 AND f.cms!='1' ORDER BY f.vieworder");
		while ($forums = $this->db->fetch_array($query)) {
			$forums['topics'] = $forums['topic'] + $forums['subtopic'];
			$article += $forums['article'];
			$topics += $forums['topics'];
			$tposts += $forums['tpost'];
		}
    	$data = $this->db->get_one("SELECT * FROM pw_bbsinfo WHERE id=1");
    	
    	$info = array();
    	$info['newmember'] = $data['newmember'];
    	$info['totalmember'] = $data['totalmember'];
    	$info['highonlinenum'] = $data['higholnum'];
    	$info['yestodayposts'] = $data['yposts'];
    	$info['highpostday'] = $data['hposts'];
    	$info['topicsnum'] = $data['o_post'] + $topics;
    	$info['treadsnum'] = $data['o_post'] + $article;
    	$info['todaynum'] = $data['o_tpost'] + $tposts;
	    if (empty($db_online)) {
			include_once (D_P . 'data/bbscache/olcache.php');
		} else {
			$userinbbs = $guestinbbs = 0;
			if (count($online_info =  explode("\t", GetCookie('online_info'))) == 3 && $timestamp - $online_info[0] < 60){
				list(, $userinbbs, $guestinbbs) = $online_info;
			}else {
				$onlineService = L::loadClass('OnlineService', 'user');
				$userinbbs = $onlineService->countOnlineUser();
				$guestinbbs = $onlineService->countOnlineGuest();
				Cookie('online_info', $timestamp . "\t" . $userinbbs . "\t" . $guestinbbs);
			}
		}
		$info['usertotal'] = $userinbbs + $guestinbbs;
    	return $info;
    }


	/**
     * ȡֻͻϢ
     * @return array
     */
	function mobileversion($version, $sign) {
		global $db_charset;
		if ($version <= 0) return $this->errMessage(SITE_INVALID_PARAMS, "ͻ˰汾Сڻ0ܻȡϢ");
		$day = get_date($GLOBALS['timestamp'], 'Y-m-d');
		$currentMonth = get_date($GLOBALS['timestamp'],'Y-m');
		$nextMonth = get_date($GLOBALS['timestamp']+3600*24*31,'Y-m');
		require_once (R_P . 'mclientapi/library/statistics.class.php');
		$stasticsService = new PW_EStatistics();
		if (!$this->db->get_one("SELECT identifier FROM pw_statistics_uniqueidentifier WHERE identifier=" . S::sqlEscape($sign) . ' AND updatetime>' . S::sqlEscape($currentMonth). " AND updatetime<" . S::sqlEscape($nextMonth))) {
			$stasticsService->addMonth('visitor');
		}
		if (!$this->db->get_one("SELECT identifier FROM pw_statistics_uniqueidentifier WHERE identifier=" . S::sqlEscape($sign) . ' AND updatetime=' . S::sqlEscape($day))) {
			$this->db->update("REPLACE INTO pw_statistics_uniqueidentifier SET " . S::sqlSingle(array('identifier' => $sign, 'updatetime' => $day)));
			$stasticsService->add('visitor');
		}
		$stasticsService->addMonth('sumvisitor');
	
		$doc = new DOMDocument("1.0","UTF-8");
		$doc->load(R_P.'mclientapi/update.xml');
		$root = $doc->documentElement;
		$elm = $root->getElementsByTagName('version');
		foreach ($elm as $node) {
			$v = $node->nodeValue;
		}
		$elm = $root->getElementsByTagName('desc');
		foreach ($elm as $node) {
			$desc = pwConvert($node->nodeValue,$db_charset,'UTF-8');
		}
		list($downloadurl) = geturl($this->openApi->config('apkname'),'show');
		$ifupdate = $this->_compareVersion($version,$v) ? 1 : 0;
		if ($ifupdate == 1) {
			return array(
				'ifupdate' => $ifupdate,
				'desc' => $desc,
				'downloadurl' => $downloadurl,
				'name' => $this->openApi->config('name')
			);
		} else {
			return array(
				'ifupdate' => $ifupdate
			);
		}
	}

	function _compareVersion($version1,$version2) {
		$version1 = explode('.',$version1);
		$version2 = explode('.',$version2);
		$count1 = count($version1);
		$count2 = count($version2);
		$maxcount = $count1 > $count2 ? $count1 : $count2;
		for ($i = 0; $i<$maxcount; $i++) {
			if ($version1[$i]<$version2[$i]) {
				return true;
			} elseif ($version1[$i]==$version2[$i]) {
				continue;
			} else {
				return false;
			}
		}
	}

	/**
     * ͳ
     * @return array
     */
	function getDownloadStatistics($wifinum,$gprsnum,$wififlow,$gprsflow) {
		require_once (R_P . 'mclientapi/library/statistics.class.php');
		$stasticsService = new PW_EStatistics();
		$stasticsService->addByNettypeMonth('downnum',STATISTICS_NETTYPE_WIFI,$wifinum);
		$stasticsService->addByNettypeMonth('downnum',STATISTICS_NETTYPE_GPRS,$gprsnum);
		$stasticsService->addByNettypeMonth('downflow',STATISTICS_NETTYPE_WIFI,$wififlow);
		$stasticsService->addByNettypeMonth('downflow',STATISTICS_NETTYPE_GPRS,$gprsflow);
		return true;
	}
}