<?php
!defined('P_W') && exit('Forbidden');
define('THREAD_INVALID_PARAMS', 301);
define('THREAD_USER_NOT_RIGHT', 302);
define('THREAD_FORUM_NOT_EXIST', 303);
define('THREAD_USER_NOT_EXIST', 304);
define('THREAD_ID_NOT_ILLEGAL', 305);
define('THREAD_EDIT_TIME_LIMIT', 306);
define('THREAD_USER_NOT_HTML_RIGHT', 307);
define('THREAD_SYSTEM_ERROR', 308);
define('THREAD_FAVOR_MAX', 309);
define('THREAD_FAVOR_ALREADY', 310);
define('THREAD_USER_NOT_EXIST', 311);
define('THREAD_NOT_EXIST', 312);
define('THREAD_LOCKED', 313);
define('POST_GP_LIMIT',314);
define('THREAD_ALLOW_READ',315);

class ThreadApi extends BaseApi {
	var $methodsType = array('get' => 'GET', 'getdigestthreads' => 'GET', 'getlatestthreads' => 'GET', 'getimgthreads' => 'GET', 'post' => 'POST', 'delete' => 'POST', 'update' => 'POST', 'getcomments' => 'GET', 'reply' => 'POST', 'gethotreply' => 'GET', 'gethotthreads' => 'GET', 'unfavor' => 'GET', 
		'getcommentdetail' => 'GET', 'getlatestthreadsBytid' => 'GET');

	/**
	 * û
	 * @param int $uid
	 * @param int $offset
	 * @param int $limit
	 */
	function getuserthreads($uid, $offset = 0, $limit = 20) {
		if (intval($uid) <= 0)
			return $this->errMessage(THREAD_INVALID_PARAMS, 'uid');
		$userService = L::loadClass('UserService', 'user');
		$username = $userService->getUserNameByUserId($uid);
		if (!$username)
			return $this->errMessage(THREAD_USER_NOT_EXIST, 'û');
		$_result['threads'] = array();
		$count = $this->db->get_value("SELECT count(*) as count FROM pw_threads WHERE authorid= " . pwEscape($uid) . " AND fid != 0");
		$_result['count'] = $count;
		$sql = "SELECT t.*,f.name FROM pw_threads t LEFT JOIN pw_forums f ON t.fid=f.fid WHERE t.authorid=" . pwEscape($uid) . " AND t.fid != 0 ORDER BY t.lastpost DESC " . S::sqlLimit($offset, $limit);
		$query = $this->db->query($sql);
		while ($rt = $this->db->fetch_array($query)) {
			$rt['name'] = strip_tags($rt['name']);
			$_result['threads'][] = array('tid' => $rt['tid'], 'subject' => $rt['subject'], 'postdate' => $rt['postdate'], 'lastpost' => $rt['lastpost'], 'forumname' => $rt['name'], 'hits' => $rt['hits'], 'replies' => $rt['replies']);
		}
		return $_result;
	}
	/**
	 * ûлظ
	 *
	 * @param int $uid
	 * @param int $offset
	 * @param int $limit
	 * @return array
	 */
	function getusercomments($uid, $offset = 0, $limit = 20) {
		if (intval($uid) <= 0)
			return $this->errMessage(THREAD_INVALID_PARAMS, 'uid');
		$userService = L::loadClass('UserService', 'user');
		if (!$userService->getUserNameByUserId($uid))
			return $this->errMessage(THREAD_USER_NOT_EXIST, 'û');
		$fidoff = array();
		$user = new apiUserInfo();
		if ($uid != $user->uid) {
			$query = $this->db->query("SELECT fid FROM pw_forums WHERE type<>'category' AND (password!='' OR forumsell!='' OR allowvisit!='' AND allowvisit NOT LIKE '%,$user->groupid,%')");
			while ($rt = $this->db->fetch_array($query)) {
				$fidoff[] = $rt['fid'];
			}
		}
		$sqloff = !empty($fidoff) ? ' AND p.fid NOT IN(' . pwImplode($fidoff) . ')' : '';
		!isset($ptable) && $ptable = $GLOBALS['db_ptable'];
		$pw_posts = GetPtable($ptable);
		/*require_once(R_P . 'require/bbscode.php');*/
		$_comments = array();
		$count = $this->db->get_value("SELECT COUNT(*) AS count FROM $pw_posts p WHERE p.authorid=" . S::sqlEscape($uid) . " $sqloff");
		$_result['count'] = $count;
		$sql = "SELECT p.pid,p.tid,p.fid,p.postdate,f.name,t.hits,t.replies,t.subject FROM " . $pw_posts . " p LEFT JOIN pw_forums f ON p.fid=f.fid LEFT JOIN pw_threads t ON p.tid=t.tid WHERE p.authorid=" . pwEscape($uid) . $sqloff . ' ORDER BY p.postdate DESC ' . S::sqlLimit($offset, $limit);
		$query = $this->db->query($sql);
		while ($rt = $this->db->fetch_array($query)) {
			$rt['name'] = strip_tags($rt['name']);
			$_comments[$rt['pid']] = array('pid' => $rt['pid'], 'tid' => $rt['tid'], 'fid' => $rt['fid'], 'subject' => $rt['subject'], 'postdate' => $rt['postdate'], 'hits' => $rt['hits'], 'replies' => $rt['replies'], 'forumname' => $rt['name']);
		}
		$_result['comments'] = array();
		foreach ($_comments as $value) {
			$_result['comments'][] = $value;
		}
		return $_result;
	}

	/**
	 * ϸϢ()
	 *
	 * @param int $tid
	 * @param bool $isDetailed
	 * @return array
	 */
	function get($tid, $isDetailed = true) {
		global $attachpath, $db_windpost, $foruminfo, $fid, $forumset, $pwforum;
		if (intval($tid) <= 0) {
			return $this->errMessage(THREAD_INVALID_PARAMS, 'tid');
		}
		$GLOBALS['tid'] = $tid;
		$threadData = $this->_getThread($tid, $isDetailed);
		if (empty($threadData))
			return array();
		if (!$isDetailed) {
			return $threadData;
		}
		$fid = $threadData['fid'];
		$user = new apiUserInfo();
		$user->initRight();
		$this->_getReadRight($user);
		$GLOBALS['tpc_buy'] = $threadData['buy'];
		$GLOBALS['tpc_author'] = $threadData['author'];
		L::loadClass('forum', 'forum', false);
		$pwforum = new PwForum($fid);
		$foruminfo = $pwforum->foruminfo;
		$forumset = $pwforum->forumset;
		if ($GLOBALS['wind_version'] == '8.0') {
			$this->_isMyFavoredForEarly($tid, $threadData);
		} else {
			$this->_isMyFavoredForAfter($tid, $threadData);
		}
		$udb = $this->_getUDb($threadData);
		$bandb = $pwforum->forumBan($udb);
		isset($bandb[$threadData['uid']]) && $threadData['groupid'] = 6;
		$threadData['content'] = $this->_parsePostContent($threadData);
		include_once R_P . 'require/showimg.php';
		list($_icon) = showfacedesign($threadData['icon'], '1', 's');
		$threadData['icon'] = $_icon;
		return $threadData;
	}

	function _getUDb($data) {
		if ($data['uid']) {
			return array('groupid' => $data['groupid'], 'userstatus' => $data['userstatus'], 'uid' => $data['uid']);
		}
	}
	/**
	 * Ȩ
	 *
	 * @param unknown_type $user
	 */
	function _getReadRight($user) {
		global $isGM, $isBM, $admincheck, $pwPostHide, $pwSellHide, $pwEncodeHide, $manager, $groupid, $windid;
		$pwSystem = array();
		if ($user->groupid != 'guest') {
			$isGM = S::inArray($windid, $manager);
			if (!$isGM) {
				$pwSystem = pwRights();
				$pwPostHide = $pwSystem['posthide'];
				$pwSellHide = $pwSystem['sellhide'];
				$pwEncodeHide = $pwSystem['encodehide'];
			} else {
				$pwPostHide = $pwSellHide = $pwEncodeHide = 1;
			}
		}
	}

	/**
	 * @param tid
	 * @param threadData
	 */
	private function _isMyFavoredForEarly($tid, &$threadData) {
		$user = new apiUserInfo();
		if ($user->isLogin()) {
			$favored = $this->db->get_value("SELECT tids FROM pw_favors WHERE uid=" . pwEscape($user->uid));
			$threadData['isFavored'] = strpos(',' . $favored . ',', ',' . $tid . ',') === false ? 0 : 1;
		}
	}

	/**
	 * @param tid
	 * @param threadData
	 */
	private function _isMyFavoredForAfter($tid, &$threadData) {
		$user = new apiUserInfo();
		if ($user->isLogin()) {
			$collectionService = L::loadClass('Collection', 'collection');
			$favor = $collectionService->getByTypeAndTypeid($user->uid, 'postfavor', $tid);
			$threadData['isFavored'] = $favor ? 1 : 0;
		}
	}

	/**
	 *
	 * б
	 * @param int $offset
	 * @param int $limit
	 */
	function getdigestthreads($offset = 1, $limit = 20) {
		$offset = ($offset - 1) * $limit;
		$query = $this->db->query("SELECT t.* FROM pw_threads t WHERE t.ifcheck = 1 AND t.digest in (1,2,3) ORDER BY t.postdate DESC " . S::sqlLimit($offset, $limit));
		L::loadClass("forum", 'forum', false);
		$forumService = new PwForum(1);
		while ($threadData = $this->db->fetch_array($query)) {
			$forumName = $forumService->get($threadData['fid']);
			$threads[] = array('tid' => $threadData['tid'], 'fid' => $threadData['fid'], 'name' => $forumName, 'icon' => $threadData['icon'], 'author' => $threadData['author'], 'authorid' => $threadData['authorid'], 'subject' => $threadData['subject'], 'type' => $threadData['type'], 
				'postdate' => $threadData['postdate'], 'lastreplytime' => $threadData['lastpost'], 'lastreplyauthor' => $threadData['lastposter'], 'hitcount' => $threadData['hits'], 'replycount' => $threadData['replies'], 'bookmarkcount' => $threadData['favors'], 
				'modelid' => $threadData['modelid'], 'sharecount' => $threadData['shares'], 'topped' => $threadData['topped'], 'topforum' => $threadData['topreplays'], 'locked' => $threadData['locked'], 'digest' => $threadData['digest'], 'special' => $threadData['special'], 
				'hasupload' => $threadData['ifupload'], 'state' => $threadData['state']);
		}
		$count = $this->db->get_value("SELECT count(*) FROM pw_threads t WHERE t.ifcheck = 1 AND t.digest IN (1,2,3)");
		return array('count' => $count, 'threads' => $threads);
	}

	/**
	 * ͼƬID
	 * @param $offset
	 * @param $limit
	 * @return Array
	 */
	function getimgthreads($offset = 1, $limit = 20) {
		global $attachpath;
		$offset = ($offset - 1) * $limit;
		$query = $this->db->query("SELECT tid,attachurl FROM pw_attachs WHERE `pid`=0 AND `type`='img' GROUP BY tid ORDER BY uploadtime DESC " . S::sqlLimit($offset, $limit));
		while ($rt = $this->db->fetch_array($query)) {
			$data[] = array('tid' => $rt['tid'], 'imgurl' => $attachpath . '/' . $rt['attachurl']);
		}
		$count = $this->db->get_value("SELECT count(distinct tid) FROM pw_attachs WHERE `pid`=0 AND `type`='img'");
		return array('count' => $count, 'imgthreadids' => $data);
	}
	/**
	 * ͼƬ
	 *
	 * @param unknown_type $tid
	 * @param unknown_type $uid
	 * @param unknown_type $offset
	 * @param unknown_type $limit
	 */
	function getthreadimg($tid, $uid = 0, $offset = 0, $limit = 20) {
		global $attachpath;
		$tid = intval($tid);
		$uid = intval($uid);
		$sqlAdd = $uid ? " AND `uid`=$uid" : '';
		$offset = intval($offset);
		$offset = $offset < 0 ? 0 : $offset;
		$offset = ($offset - 1) * $limit;
		$query = $this->db->query("SELECT tid,attachurl FROM pw_attachs WHERE `tid`=" . $tid . $sqlAdd . " AND `type`='img' ORDER BY uploadtime ASC " . S::sqlLimit($offset, $limit));
		while ($rt = $this->db->fetch_array($query)) {
			$data[] = array('tid' => $rt['tid'], 'imgurl' => $attachpath . '/' . $rt['attachurl']);
		}
		$count = $this->db->get_value("SELECT count(tid) FROM pw_attachs WHERE `tid`=$tid $sqlAdd AND `type`='img'");
		return array('count' => $count, 'imgthreadids' => $data);
	}
	/**
	 * 
	 * @param int $fid ID
	 * @param string $title ӱ
	 * @param string $content 
	 * @param string $tags ӱǩ
	 * @param int $convert Ƿwindcodeת
	 * @param int $usesign Ƿʹûǩ
	 * @param int $usehtml
	 * @param int $topped Ƿö
	 * @param int $digest 
	 * @param string $p_type
	 * @param string $p_sub_type
	 * @return array
	 */
	function post($fid, $title, $content, $tags = '', $convert = 1, $usesign = 1, $usehtml = 0, $topped = 0, $digest = 0, $p_type = '', $p_sub_type = '') {
		global $winddb, $winduid, $windid, $groupid, $_G, $timestamp, $pwforum, $pwpost, $uploadcredit, $uploadmoney, $db_uploadfiletype;
		//$this->addLog($content, 'thread.post');
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
		if ($user->groupid == 6 || getstatus($user->info['userstatus'], PW_USERSTATUS_BANUSER)) {
			return $this->errMessage(THREAD_USER_NOT_RIGHT, 'ûȨ޴');
		}
		$user->initRight();
		$winduid = $user->uid;
		$groupid = $user->groupid;
		$windid = $user->username;
		$winddb = $user->info;
		$_G = $user->_G;
		//$this->_setAdditionalContent($content, 'post');
		if ($_G['postlimit'] && $winddb['todaypost'] >= $_G['postlimit']) {
			return $this->errMessage(POST_GP_LIMIT, 'ûȨޣûÿܷ ' . $_G['postlimit'] . ' ƪ');
		}
		L::loadClass('forum', 'forum', false);
		$pwforum = new PwForum($fid);
		if (!$pwforum->isForum()) {
			return $this->errMessage(THREAD_FORUM_NOT_EXIST, '鲻');
		}
		list($uploadcredit, $uploadmoney, , ) = explode("\t", $pwforum->forumset['uploadset']);
		L::loadClass('post', 'forum', false);
		require_once (R_P . 'mclientapi/library/bbscode.php');
		$pwpost = new PwPost($pwforum);
		$pwpost->errMode = true;
		$pwpost->forumcheck();
		$pwpost->postcheck();
		L::loadClass('topicpost', 'forum', false);
		$topicpost = new topicPost($pwpost);
		$topicpost->check();
		$postdata = new topicPostData($pwpost);
		$postdata->setWtype($p_type, $p_sub_type, $pwforum->foruminfo['t_type'], $pwforum->foruminfo['topictype']);
		$postdata->setTitle($title);
		$postdata->setContent($content);
		$postdata->setConvert($convert, 1);
		$postdata->setTags($tags);
		$postdata->setDigest($digest);
		$postdata->setTopped($topped);
		$postdata->setIfsign($usesign, $usehtml);
		if (method_exists($postdata, 'setPostFromMob')) {
			$postdata->setPostFromMob();
		}
		if ($pwpost->errMsg && $msg = reset($pwpost->errMsg)) {
			return $this->errMessage(THREAD_SYSTEM_ERROR, "system error [$msg]");
		}
		//L::loadClass('attupload', 'upload', false);
		require_once (R_P . 'mclientapi/library/attupload.class.php');
		if (PwUpload::getUploadNum()) {
			$_G['uploadtype'] && $db_uploadfiletype = $_G['uploadtype'];
			$db_uploadfiletype = !empty($db_uploadfiletype) ? (is_array($db_uploadfiletype) ? $db_uploadfiletype : unserialize($db_uploadfiletype)) : array();
			$postdata->att = new AttUpload($user->uid);
			$return = $postdata->att->check();
			if ($return) {
				$msginfo = getLangInfo('msg', $return);
				return $this->errMessage(THREAD_USER_NOT_RIGHT, $msginfo);
			}
			/* 汾ݴ */
			if ($GLOBALS['wind_version'] && $GLOBALS['wind_version'] < '8.5') {
				$postdata->att->transfer();
				PwUpload::upload($postdata->att);
			}
		}
		//$this->addLog($postdata->data['content'], 'thread.post');
		$topicpost->execute($postdata);
		$tid = $topicpost->getNewId();
		require_once (R_P . 'mclientapi/library/statistics.class.php');
		$stasticsService = new PW_EStatistics();
		$stasticsService->add('post');
		if ($postdata->getIfcheck() != 1)
			return 0;
		return $tid;
	}

	/**
	 *
	 * ظ
	 * @param int $tid
	 * @param string $subject
	 * @param string $content
	 * @return int
	 */
	function reply($tid, $title, $content, $pid = '0') {
		global $winddb, $winduid, $windid, $groupid, $fid, $timestamp, $pwforum, $pwpost, $_G, $db_uploadfiletype, $uploadcredit, $uploadmoney, $manager, $isBM;
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
		if ($user->groupid == 6 || getstatus($user->info['userstatus'], PW_USERSTATUS_BANUSER)) {
			return $this->errMessage(THREAD_USER_NOT_RIGHT, 'ûȨ޴');
		}
		$user->initRight();
		$winduid = $user->uid;
		$groupid = $user->groupid;
		$windid = $user->username;
		$winddb = $user->info;
		$_G = $user->_G;
		if ($_G['postlimit'] && $winddb['todaypost'] >= $_G['postlimit']) {
			return $this->errMessage(POST_GP_LIMIT, 'ûȨޣûÿܷ ' . $_G['postlimit'] . ' ƪ');
		}
		$tpcarray = $this->db->get_one("SELECT t.tid,t.fid,t.locked,t.ifcheck,t.author,t.authorid,t.postdate,t.lastpost,t.ifmail,t.special,t.subject,t.type,t.ifshield,t.anonymous,t.ptable,t.replies,t.tpcstatus FROM pw_threads t WHERE t.tid=" . pwEscape($tid));
		L::loadClass('forum', 'forum', false);
		$pwforum = new PwForum($tpcarray['fid']);
		if (!$pwforum->isForum()) {
			return $this->errMessage(THREAD_FORUM_NOT_EXIST, '鲻');
		}
		//
		$fid = $tpcarray['fid'];
		$isBM = $pwforum->isBM($windid);
		$isGM = S::inArray($windid, $manager);
		if (!$isGM && $tpcarray['locked'] % 3 != 0 && !pwRights($isBM, 'replylock')) {
			return $this->errMessage(THREAD_LOCKED, 'ӱܻظ');
		}
		//end 
		L::loadClass('post', 'forum', false);
		require_once (R_P . 'mclientapi/library/bbscode.php');
		$pwpost = new PwPost($pwforum);
		$pwpost->errMode = true;
		$pwpost->forumcheck();
		$pwpost->postcheck();
		L::loadClass('replypost', 'forum', false);
		$replypost = new replyPost($pwpost);
		$replypost->setTpc($tpcarray);
		$replypost->check();
		$pw_posts = GetPtable($replypost->tpcArr['ptable']);
		if ($pid) {
			$_floor = $this->db->get_value("SELECT COUNT(*) FROM " . $pw_posts . " WHERE tid=" . pwEscape($tid) . " AND pid <= " . pwEscape($pid) . " AND ifcheck='1'");
			$_reply = $this->db->get_one("SELECT * FROM " . $pw_posts . " WHERE tid=" . pwEscape($tid) . " AND pid=" . pwEscape($pid) . " AND ifcheck='1'");
			if ($_reply) {
				$tempcontent = '';
				$tempcontent .= "[quote]" . $_floor . "¥" . $_reply['author'] . "" . get_date($_reply['postdate']) . "";
				$tempcontent .= $_reply['subject'] ? " " . $_reply['subject'] . " \r\n\r\n" : ":\r\n\r\n";
				$_reply['content'] = str_replace(array('[quote]', '[/quote]'), '', $_reply['content']);
				$tempcontent .= strlen($_reply['content']) > 200 ? substrs($_reply['content'], 200) : $_reply['content'];
				$tempcontent .= "[/quote]";
				$content = $tempcontent . $content;
			}
		}
		/* ֻͻ */
		//$this->_setAdditionalContent($content, 'reply');
		$postdata = new replyPostData($pwpost);
		$postdata->setTitle($title);
		$postdata->setContent($content);
		if (method_exists($postdata, 'setPostFromMob')) {
			$postdata->setPostFromMob();
		}
		$postdata->conentCheck();
		if ($pwpost->errMsg && $msg = reset($pwpost->errMsg)) {
			return $this->errMessage(THREAD_SYSTEM_ERROR, "system error [$msg]");
		}
		/* ش */
		require_once (R_P . 'mclientapi/library/attupload.class.php');
		if (PwUpload::getUploadNum()) {
			$_G['uploadtype'] && $db_uploadfiletype = $_G['uploadtype'];
			$db_uploadfiletype = !empty($db_uploadfiletype) ? (is_array($db_uploadfiletype) ? $db_uploadfiletype : unserialize($db_uploadfiletype)) : array();
			$postdata->att = new AttUpload($user->uid);
			$return = $postdata->att->check();
			if ($return) {
				$msginfo = getLangInfo('msg', $return);
				return $this->errMessage(THREAD_USER_NOT_RIGHT, $msginfo);
			}
			/* 汾ݴ */
			if ($GLOBALS['wind_version'] && $GLOBALS['wind_version'] < '8.5') {
				$postdata->att->transfer();
				PwUpload::upload($postdata->att);
			}
		}
		$replypost->execute($postdata);
		$pid = $replypost->getNewId();
		/* ¥ */
		$count = $this->db->get_value("SELECT COUNT(*) FROM " . $pw_posts . " WHERE tid=" . pwEscape($tid) . " AND ifcheck='1'");
		require_once (R_P . 'mclientapi/library/statistics.class.php');
		$stasticsService = new PW_EStatistics();
		$stasticsService->add('reply');
		require_once (R_P . 'require/showimg.php');
		list($icon) = showfacedesign($user->info['icon'], '1', 's');
		if ($postdata->getIfcheck() != 1)
			return array('pid' => 0);
		return $this->_getOneCommentDetail($tid, $pid);
	}

	private function _getOneCommentDetail($tid, $pid) {
		$post_table = $this->_getPtable($tid);
		$reply = $this->db->get_one("SELECT p.tid,p.pid,p.author,p.authorid,p.postdate,p.subject,p.content,p.ifshield,p.buy,m.uid,m.icon,m.groupid,m.userstatus FROM " . $post_table . " p LEFT JOIN pw_members m ON p.authorid=m.uid  WHERE ifcheck=1 AND pid=" . pwEscape($pid));
		$query = $this->db->query('SELECT * FROM pw_attachs WHERE pid=' . pwEscape($pid));
		while ($rt = $this->db->fetch_array($query)) {
			$attachs[] = $rt;
		}
		$GLOBALS['tpc_buy'] = $reply['buy'];
		$GLOBALS['tpc_author'] = $reply['author'];
		$GLOBALS['tpc_pid'] = $reply['pid'];
		require_once R_P . 'require/showimg.php';
		$reply['content'] = $this->_parsePostContent($reply);
		$_floor = $this->db->get_value("SELECT COUNT(*) FROM " . $post_table . " WHERE tid=" . pwEscape($tid) . " AND pid <= " . pwEscape($reply['pid']) . " AND ifcheck='1'");
		list($_icon) = showfacedesign($reply['icon'], '1', 's');
		$reply['icon'] = $_icon;
		$reply['floor'] = $_floor;
		$reply['content'] .= $this->_parseAttachList($attachs, $reply['content']);
		return $reply;
	}

	/**
	 * ȡûĳһ۵(ҳ)
	 * @param int $tid
	 * @param int $uid
	 * @return array
	 */
	function getcommentdetail($tid, $uid) {
		if (intval($tid) < 1 || intval($uid) < 1)
			return $this->errMessage(THREAD_INVALID_PARAMS, 'tid or uid');

		$readdb = $pids = array();
		$topic = $this->get($tid);
		$readdb['tpc'] = $topic;
		$pids['tpc'] = 0;
		$post_table = $this->_getPtable($tid);
		$query = $this->db->query("SELECT p.tid,p.pid,p.author,p.authorid,p.postdate,p.subject,p.content,p.ifshield,m.uid,m.icon,m.groupid,m.userstatus FROM " . $post_table . " p LEFT JOIN pw_members m ON p.authorid=m.uid  WHERE ifcheck=1 AND tid=" . pwEscape($tid) . " AND authorid=" . pwEscape($uid));
		while ($rt = $this->db->fetch_array($query)) {
			$pids[] = $rt['pid'];
			$readdb[$rt['pid']] = $rt;
		}
		$query = $this->db->query('SELECT * FROM pw_attachs WHERE tid=' . pwEscape($tid) . " AND pid IN (" . pwImplode($pids) . ")");
		while ($rt = $this->db->fetch_array($query)) {
			$key = $rt['tid'] && empty($rt['pid']) ? 'tpc' : $rt['pid'];
			$attachs[$key][] = $rt;
		}
		require_once R_P . 'require/showimg.php';
		foreach ($readdb as $key => $value) {
			$value['content'] = $this->_parsePostContent($value);
			$_floor = $this->db->get_value("SELECT COUNT(*) FROM " . $post_table . " WHERE tid=" . pwEscape($tid) . " AND pid <= " . pwEscape($value['pid']) . " AND ifcheck='1'");
			list($_icon) = showfacedesign($value['icon'], '1', 's');
			$value['icon'] = $_icon;
			$value['floor'] = $_floor;
			$value['content'] .= $this->_parseAttachList($attachs[$key], $value['content']);
			if ($key == 'tpc') {
				$topic['content'] = $value['content'];
			} else {
				$_result[] = $value;
			}
		}
		$topic = $this->_cleanThreadinfo($topic);
		return array('topic' => $topic, 'posts' => $_result);
	}

	/**
	 *  tidȡظ
	 *
	 * @param Integer $tid
	 * @param Integer $offset
	 * @param Integer $limit
	 * @param unknown_type $threaddetail //Ƿ
	 * @param unknown_type $order //ʽ
	 * @return Array
	 */
	function getcomments($tid, $offset = 0, $limit = 20, $threaddetail = 0, $order = 0) {
		global $db_postmin, $db_postmax, $foruminfo, $fid, $pwforum;
		if (intval($tid) < 1) {
			return $this->errMessage(THREAD_INVALID_PARAMS, 'tid');
		}
		if (!$treadInfo = $this->get($tid, $threaddetail)) {
			return $this->errMessage(THREAD_NOT_EXIST, 'ӲڻѾɾ');
		}
		$user = new apiUserInfo(array('reply'));
		$user->initRight();
		$this->_getReadRight($user);
		L::loadClass('forum', 'forum', false);
		$pwforum = new PwForum($treadInfo['fid']);
		if (!$pwforum->isForum(true)) {
			return $this->errMessage(THREAD_FORUM_NOT_EXIST, '鲻');
		}
		$fid = $pwforum->fid;
		$foruminfo = $pwforum->foruminfo;
		$pwforum->forumcheck($user->info, $user->groupid);
		$pwforum->creditcheck($user->info, $user->groupid);
		if (!$user->allowcheck($pwforum->foruminfo['allowread']) && !$pwforum->isBM($user->username)) {
			return $this->errMessage(THREAD_ALLOW_READ, 'Ȩ޲鿴Ϣ');
		}
		if ($treadInfo['ifcheck'] == 0 && $user->username != $treadInfo['author'] && !$user->getSystemRight('viewcheck')) {
			return $this->errMessage(THREAD_READ_CHECK, 'û֤ͨ');
		}
		if ($treadInfo['locked'] % 3 == 2 && !$user->getSystemRight('viewclose')) {
			return $this->errMessage(THREAD_READ_LOCKED, 'ӱ');
		}
		$return = $_pids = array();
		if ($threaddetail) {
			$return['threadinfo'] = $treadInfo;
			$return['allowreply'] = ($read['locked'] % 3 == 0) && $user->allowcheck($pwforum->foruminfo['allowrp'], $treadInfo['fid'], 'reply');
			require_once (R_P . 'mclientapi/library/statistics.class.php');
			$stasticsService = new PW_EStatistics();
			$stasticsService->add('hits');
			$treadInfo['aid'] && $_pids['tpc'] = 0;
		}
		$pw_posts = $this->_getPtable($tid);
		$return['count'] = $this->db->get_value("SELECT count(*) FROM $pw_posts WHERE tid=" . S::sqlEscape($tid) . " AND ifcheck='1'");
		$return['comments'] = array();
		$comments = $this->_getreplys($tid, $offset, $limit, $order);
		foreach ($comments as $key => $value) {
			$value['aid'] && $_pids[$value['pid']] = $value['pid'];
		}
		if ($_pids) {
			$_attachList = array();
			$query = $this->db->query('SELECT * FROM pw_attachs WHERE tid=' . pwEscape($tid) . " AND pid IN (" . pwImplode($_pids) . ")");
			while ($rt = $this->db->fetch_array($query)) {
				$_attachList[$rt['pid']][] = $rt;
			}
		}
		$this->_parseAttachList($_attachList[0], $return['threadinfo']['content']);
		$return['comments'] = array();
		foreach ($comments as $key => $value) {
			$this->_parseAttachList($_attachList[$value['pid']], $value['content']);
			$return['comments'][] = $value;
		}
		$return['threadinfo'] = $this->_cleanThreadinfo($return['threadinfo']);
		$return['minLenth'] = $pwforum->foruminfo['forumset']['contentminlen'] ? $pwforum->foruminfo['forumset']['contentminlen'] : $db_postmin;
		$return['maxLenth'] = $db_postmax;
		return $return;
	}
	/**
	 * ӵĳûظ(ҳ)
	 *
	 * @author ensoon
	 * 
	 * @param Integer $tid
	 * @param int $uid
	 * @param Integer $offset
	 * @param Integer $limit
	 * @param bool $threaddetail
	 * @return Array
	 */
	function getuserreply($tid, $uid = 0, $offset = 0, $limit = 20, $threaddetail = 0) {
		global $db_postmin, $db_postmax, $foruminfo, $fid, $pwforum;
		$uid = intval($uid);
		$tid = intval($tid);
		if ($tid < 1) {
			return $this->errMessage(THREAD_INVALID_PARAMS, 'tid');
		}
		if ($uid < 1) {
			return $this->errMessage(THREAD_INVALID_PARAMS, 'uid');
		}
		if (!$treadInfo = $this->get($tid, $threaddetail)) {
			return $this->errMessage(THREAD_NOT_EXIST, 'ӲڻѾɾ');
		}
		$user = new apiUserInfo(array('reply'));
		$user->initRight();
		$this->_getReadRight($user);
		L::loadClass('forum', 'forum', false);
		$pwforum = new PwForum($treadInfo['fid']);
		if (!$pwforum->isForum(true)) {
			return $this->errMessage(THREAD_FORUM_NOT_EXIST, '鲻');
		}
		$fid = $pwforum->fid;
		$foruminfo = $pwforum->foruminfo;
		$pwforum->forumcheck($user->info, $user->groupid);
		$pwforum->creditcheck($user->info, $user->groupid);
		if (!$user->allowcheck($pwforum->foruminfo['allowread']) && !$pwforum->isBM($user->username)) {
			return $this->errMessage(THREAD_ALLOW_READ, 'Ȩ޲鿴Ϣ');
		}
		if ($treadInfo['ifcheck'] == 0 && $user->username != $treadInfo['author'] && !$user->getSystemRight('viewcheck')) {
			return $this->errMessage(THREAD_READ_CHECK, 'û֤ͨ');
		}
		if ($treadInfo['locked'] % 3 == 2 && !$user->getSystemRight('viewclose')) {
			return $this->errMessage(THREAD_READ_LOCKED, 'ӱ');
		}
		$return = $_pids = array();
		if ($threaddetail) {
			$return['threadinfo'] = $treadInfo;
			$return['allowreply'] = ($read['locked'] % 3 == 0) && $user->allowcheck($pwforum->foruminfo['allowrp'], $treadInfo['fid'], 'reply');
			require_once (R_P . 'mclientapi/library/statistics.class.php');
			$stasticsService = new PW_EStatistics();
			$stasticsService->add('hits');
			$treadInfo['aid'] && $_pids['tpc'] = 0;
		}
		$pw_posts = $this->_getPtable($tid);
		$return['count'] = $this->db->get_value("SELECT count(*) FROM $pw_posts WHERE tid=" . S::sqlEscape($tid) . " AND authorid=" . pwEscape($uid) . " AND ifcheck='1'");
		$return['comments'] = array();
		$comments = $this->_getuserreplys($tid, $uid, $offset, $limit);
		foreach ($comments as $key => $value) {
			$value['aid'] && $_pids[$value['pid']] = $value['pid'];
		}
		if ($_pids) {
			$_attachList = array();
			$query = $this->db->query('SELECT * FROM pw_attachs WHERE tid=' . pwEscape($tid) . " AND pid IN (" . pwImplode($_pids) . ")");
			while ($rt = $this->db->fetch_array($query)) {
				$_attachList[$rt['pid']][] = $rt;
			}
		}
		$this->_parseAttachList($_attachList[0], $return['threadinfo']['content']);
		$return['comments'] = array();
		foreach ($comments as $key => $value) {
			$this->_parseAttachList($_attachList[$value['pid']], $value['content']);
			$return['comments'][] = $value;
		}
		$return['threadinfo'] = $this->_cleanThreadinfo($return['threadinfo']);
		$return['minLenth'] = $pwforum->foruminfo['forumset']['contentminlen'] ? $pwforum->foruminfo['forumset']['contentminlen'] : $db_postmin;
		$return['maxLenth'] = $db_postmax;
		return $return;
	}

	/**
	 *
	 * 
	 * @param int $tid
	 * @param int $pid
	 * @return boolean
	 */

	function buyTopic($tid, $pid) {
		global $db_sellset, $onlineip, $timestamp, $windid, $foruminfo, $forumset;
		$user = new apiUserInfo();
		$windid = $user->username;
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
		require_once (R_P . 'require/credit.php');
		$tpcs = array();
		if ($pid == 'tpc' || empty($pid)) {
			$table = GetTtable($tid);
			$tpcs = $this->db->get_one("SELECT t.fid,t.author,t.authorid,t.subject,tm.userip,tm.content,tm.buy FROM pw_threads t LEFT JOIN $table tm ON tm.tid=t.tid WHERE t.tid=" . S::sqlEscape($tid));
			$where = '';
		} elseif (is_numeric($pid)) {
			$table = GetPtable('N', $tid);
			$tpcs = $this->db->get_one("SELECT fid,author,authorid,subject,userip,content,buy FROM $table WHERE pid=" . S::sqlEscape($pid) . ' AND tid=' . S::sqlEscape($tid));
			$where = ' AND pid=' . S::sqlEscape($pid);
		}
		if (!$tpcs)
			return $this->errMessage(THREAD_NOT_EXIST, 'Ӳ');
		if ($user->uid == $tpcs['authorid']) {
			return $this->errMessage(SYSTEM_ERROR, 'ԼӲҪ');
		}

		L::loadClass('forum', 'forum', false);
		$pwforum = new PwForum($tpcs['fid']);
		$foruminfo = $pwforum->foruminfo;
		$forumset = $pwforum->forumset;

		$tpcsBuyDate = $tpcs['buy'] ? unserialize($tpcs['buy']) : array();
		if ($tpcsBuyDate && array_key_exists($winduid, $tpcsBuyDate) !== false) {
			return $this->errMessage(SYSTEM_ERROR, 'Ѿ.벻Ҫظ!');
		}
		$count = count($tpcsBuyDate);
		!$tpcs['subject'] && $tpcs['subject'] = preg_replace('/\[.*?\]/i', '', substrs($tpcs['content'], 25));
		$tpcs['content'] = substr($tpcs['content'], strpos($tpcs['content'], '[sell=') + 6);
		$cost = substr($tpcs['content'], 0, strpos($tpcs['content'], ']'));
		list($creditvalue, $credittype) = explode(',', $cost);
		$creditvalue = (int) $creditvalue;
		if ($creditvalue < 0) {
			$creditvalue = 0;
		} elseif ($db_sellset['price'] && $creditvalue > $db_sellset['price']) {
			$creditvalue = $db_sellset['price'];
		}
		!isset($credit->cType[$credittype]) && $credittype = 'money';
		$userCredit = $credit->get($user->uid, $credittype);
		$creditname = $credit->cType[$credittype];
		if ($userCredit < $creditvalue) {
			return $this->errMessage(SYSTEM_ERROR, " {$creditname}  {$creditvalue}޷!");
		}
		$credit->addLog('topic_buy', array($credittype => -$creditvalue), array('uid' => $user->uid, 'username' => $user->username, 'ip' => $onlineip, 'tid' => $tid, 'subject' => $tpcs['subject']));
		$credit->set($user->uid, $credittype, -$creditvalue, false);
		$income = $creditvalue * $count;
		if (!$db_sellset['income'] || $income < $db_sellset['income']) {
			$credit->addLog('topic_sell', array($credittype => $creditvalue), array('uid' => $tpcs['authorid'], 'username' => $tpcs['author'], 'ip' => $tpcs['userip'], 'tid' => $tid, 'subject' => $tpcs['subject'], 'buyer' => $user->username));
			$credit->set($tpcs['authorid'], $credittype, $creditvalue, false);
		}
		$credit->runsql();

		$tpcsBuy = array();
		$tpcsBuy[$user->uid] = array('uid' => $user->uid, 'username' => $user->username, 'ip' => $tpcs['userip'], 'tid' => $tid, 'subject' => $tpcs['subject'], 'credittype' => $credittype, 'creditvalue' => $creditvalue, 'author' => $tpcs['author'], 'authorid' => $tpcs['authorid'], 
			'createdtime' => $timestamp);

		$tpcs['buy'] = $tpcsBuyDate ? serialize($tpcsBuy + $tpcsBuyDate) : serialize($tpcsBuy);

		$this->db->update("UPDATE $table SET buy=" . S::sqlEscape($tpcs['buy'], false) . " WHERE tid=" . S::sqlEscape($tid) . $where);
		Perf::gatherInfo('changeThreadWithThreadIds', array('tid' => $tid));
		if ($pid == 'tpc' || empty($pid)) {
			return $this->get($tid);
		} else {
			return $this->_getOneCommentDetail($tid, $pid);
		}
	}

	function _cleanThreadinfo($threadinfo) {
		$unset = array('titlefont', 'toolinfo', 'toolfield', 'ifupload', 'activeid', 'ifmail', 'ifmark', 'ifreward', 'ifshield', 'ifsale', 'anonymous', 'dig', 'fight', 'ptable', 'ifmagic', 'ifhide', 'inspect', 'digests', 'xigests', 'xig', 'tpcstatus', 'modelid', 'shares', 'topreplays', 'aid', 
			'userip', 'ifsign', 'buy', 'ipfrom', 'alterinfo', 'remindinfo', 'tags', 'ifconvert', 'ifwordsfb', 'form', 'c_from', 'magic', 'overprint');
		foreach ($unset as $key => $value) {
			unset($threadinfo[$value]);
		}
		return $threadinfo;
	}

	function _parsePostContent($data) {
		list($content, $tpc_shield) = $this->_shieldContent($data['content'], $data['ifshield'], $data['groupid']);
		if ($tpc_shield)
			return $content;
		$content = stripcslashes($content);
		if (strpos($content, "[quote]") !== false && strpos($content, "[/quote]") !== false) {
			$content = preg_replace_callback('/\[quote\](.*?)\[\/quote\]/is', array($this, '_parseQuote'), $content);
		}
		if (strpos($content, "[img]") !== false && strpos($content, "[/img]") !== false) {
			$content = preg_replace_callback('/\[img\](https?)?(' . $GLOBALS['db_attachname'] . '\/)?([^\[]+?)\[\/img\]/is', array($this, '_parseImg'), $content);
		}

		strpos($content, '[s:') !== false && $content = mShowface($content);
		$content = preg_replace(array("/\n/is", "/\r\n/is"), "<br />", $content);
		require_once (R_P . 'mclientapi/library/bbscode.php');
		$content = convert($content, $GLOBALS['db_windpost']);
		return $content;
	}

	function _shieldContent($content, $ifshield, $groupid) {
		global $db_shield;

		if ($ifshield || $groupid == 6 && $db_shield) {
			if ($ifshield == 2) {
				$content = '<blockquote>ѱɾ!<\blockquote>';
			} else {
				$content = $read['ifshield'] ? '<blockquote>ѱԱ!<\blockquote>' : '<blockquote>û,Զ!<\blockquote>';
			}
			$tpc_shield = 1;
		}
		return array($content, $tpc_shield);
	}
	/**
	 * ͼƬ
	 *
	 * @param unknown_type $merged
	 * @return unknown
	 */
	function _parseImg($merged) {
		$return = '<img';
		if ($merged[1]) { //ͼƬ
			$return .= " src='$merged[1]$merged[3]' thumb='' where='-1'";
		} else {
			list($attachurl, $attachThumbUrl) = $this->_getThumbAttach($merged[3]);
			list($db_thumbw, $db_thumbh) = explode("\t", $GLOBALS['db_athumbsize']);
			$return .= " src='$attachurl' thumb='$attachThumbUrl' width='$db_thumbw' height='$db_thumbh'";
		}
		return $return . ' />';
	}

	function _parseQuote($merged) {
		$return = '';
		if (is_array($merged) && $merged[0])
			$return = preg_replace('/\[url=([^\[\s]+?)(\,(1)\/?)?\](.+?)\[\/url\]/is', '', $merged[0]);
		return $return;
	}

	function _parseAttachList($attachList, &$content) {
		if (empty($attachList))
			return '';
		$_src = $_thumb = '';
		list($db_thumbw, $db_thumbh) = explode("\t", $GLOBALS['db_athumbsize']);
		foreach ($attachList as $value) {
			if ($value['type'] != 'img') {
				$content = str_replace('[attachment=' . $value['aid'] . ']', '', $content);
				continue;
			}
			list($attachurl, $attachThumbUrl) = $this->_getThumbAttach($value['attachurl'], $value['ifthumb']);

			if (strpos($content, '[attachment=' . $value['aid'] . ']') !== false) {
				$content = str_replace('[attachment=' . $value['aid'] . ']', '<img src="' . $attachurl . '" thumb="' . $attachThumbUrl . '" width="' . $db_thumbw . '" height="' . $db_thumbh . '" />', $content);
				continue;
			}
			$attachurl && $_src .= $attachurl . ',';
			$attachThumbUrl && $_thumb .= $attachThumbUrl . ',';
		}
		if ($_src || $_thumb)
			$_return = '<attachs ';
		$_src && $_return .= " src='" . trim($_src, ',') . "'";
		$_thumb && $_return .= " thumb='" . trim($_thumb, ',') . "' width='$db_thumbw' height='$db_thumbh'";
		$_return && $_return .= " />";
		$content .= $_return;
	}

	function _parseAttachContent(&$content, $attach) {
		$str_match = '[attachment=' . $attach['aid'] . ']';
		list($db_thumbw, $db_thumbh) = explode("\t", $GLOBALS['db_athumbsize']);
		if ($attach['type'] != 'img') {
			$content = str_replace($str_match, '', $content);
		} else {
			list($attachurl, $attachThumbUrl) = $this->_getThumbAttach($attach['attachurl'], $attach['ifthumb']);
			if (strpos($content, $str_match) !== false) {
				$content = str_replace($str_match, '<img src="' . $attachurl . '" thumb="' . $attachThumbUrl . '" width="' . $db_thumbw . '" height="' . $db_thumbh . '" />', $content);
			}
			/*else {
				$content .= '<img src="' . $attachurl . '" />';
			}*/
		}
	}

	function _getThumbAttach($attachurl, $ifthumb = false) {
		global $wind_version, $attachpath, $attachdir, $db_ftpweb;
		$a_url = geturl($attachurl, 'show', $ifthumb);
		if ($wind_version >= 8.0) {
			$thumburl = $this->_getMiniUrl($attachurl, $ifthumb, $a_url[1]);
		} else {
			$thumburl = $a_url[0];
		}
		if ($a_url[1] == 'Local') {
			$sourceurl = $attachpath . '/' . $attachurl;
		} elseif ($a_url[1] == 'Ftp') {
			$sourceurl = $db_ftpweb . '/' . $attachurl;
		}
		return array($sourceurl, $thumburl);
	}

	function _getMiniUrl($path, $ifthumb, $where) {
		$dir = '';
		($ifthumb & 1) && $dir = 'thumb/';
		($ifthumb & 2) && $dir = 'thumb/mini/';
		if ($where == 'Local')
			return $GLOBALS['attachpath'] . '/' . $dir . $path;
		if ($where == 'Ftp')
			return $GLOBALS['db_ftpweb'] . '/' . $dir . $path;
		if (!is_array($GLOBALS['attach_url']))
			return $GLOBALS['attach_url'] . '/' . $dir . $path;
		return $GLOBALS['attach_url'][0] . '/' . $dir . $path;
	}

	function _getreplys($tid, $offset, $limit, $order = 0) {
		global $db_windpost, $pwforum;
		require_once (R_P . 'require/showimg.php');
		$pw_posts = $this->_getPtable($tid);
		$array = array();
		$order = intval($order);
		$order = $order ? "DESC" : "ASC";
		$query = $this->db->query("SELECT p.*,m.uid,m.icon,m.groupid,m.userstatus FROM $pw_posts p LEFT JOIN pw_members m ON p.authorid=m.uid WHERE p.tid=" . S::sqlEscape($tid) . " AND p.ifcheck='1' ORDER BY p.postdate $order " . S::sqlLimit($offset, $limit));
		while ($rt = $this->db->fetch_array($query)) {
			list($_icon) = showfacedesign($rt['icon'], '1', 's');
			$udb[$rt['uid']] = array('uid' => $rt['uid'], 'userstatus' => $rt['userstatus'], 'groupid' => $rt['groupid']);
			$array[$rt['pid']] = array('pid' => $rt['pid'], 'tid' => $rt['tid'], 'aid' => $rt['aid'], 'author' => $rt['author'], 'authorid' => $rt['authorid'], 'icon' => $_icon, 'postdate' => $rt['postdate'], 'subject' => $rt['subject'], 'content' => $rt['content'], 'buy' => $rt['buy']);
		}
		$bandb = $pwforum->forumBan($udb);
		foreach ($array as $key => $value) {
			$GLOBALS['tpc_buy'] = $value['buy'];
			$GLOBALS['tpc_author'] = $value['author'];
			$GLOBALS['tpc_pid'] = $value['pid'];
			isset($bandb[$value['authorid']]) && $value['groupid'] = 6;
			$array[$key]['content'] = $this->_parsePostContent($value);
		}
		return $array;
	}
	function _getuserreplys($tid, $uid, $offset, $limit) {
		global $db_windpost, $pwforum;
		require_once (R_P . 'require/showimg.php');
		$pw_posts = $this->_getPtable($tid);
		$array = array();
		$query = $this->db->query("SELECT p.*,m.uid,m.icon,m.groupid,m.userstatus FROM $pw_posts p LEFT JOIN pw_members m ON p.authorid=m.uid WHERE p.tid=" . S::sqlEscape($tid) . " AND p.authorid=" . S::sqlEscape($uid) . " AND p.ifcheck='1' ORDER BY p.postdate ASC " . S::sqlLimit($offset, $limit));
		while ($rt = $this->db->fetch_array($query)) {
			list($_icon) = showfacedesign($rt['icon'], '1', 's');
			$udb[$rt['uid']] = array('uid' => $rt['uid'], 'userstatus' => $rt['userstatus'], 'groupid' => $rt['groupid']);
			$array[$rt['pid']] = array('pid' => $rt['pid'], 'tid' => $rt['tid'], 'aid' => $rt['aid'], 'author' => $rt['author'], 'authorid' => $rt['authorid'], 'icon' => $_icon, 'postdate' => $rt['postdate'], 'subject' => $rt['subject'], 'content' => $rt['content'], 'buy' => $rt['buy']);
		}
		$bandb = $pwforum->forumBan($udb);
		foreach ($array as $key => $value) {
			$GLOBALS['tpc_buy'] = $value['buy'];
			$GLOBALS['tpc_author'] = $value['author'];
			$GLOBALS['tpc_pid'] = $value['pid'];
			isset($bandb[$value['authorid']]) && $value['groupid'] = 6;
			$array[$key]['content'] = $this->_parsePostContent($value);
		}
		return $array;
	}

	/**
	 * Żظ
	 * @param Integer $num 
	 * @return Array
	 */
	function gethotreply($num = 20) {
		$data = array();
		$data = $this->_getElementService()->replySort(0, $num);
		$reply = array();
		foreach ($data as $item) {
			$reply[] = array('tid' => $item['addition']['tid'], 'fid' => $item['addition']['fid'], 'author' => $item['addition']['author'], 'authorid' => $item['addition']['authorid'], 'subject' => $item['addition']['subject'], 'hitcount' => $item['addition']['hits'], 
				'replycount' => $item['addition']['replies'], 'postdate' => $item['addition']['postdate'], 'forumname' => $item['forumname']);
		}
		return array('hotreply' => $reply);
	}

	/**
	 * ȡ
	 * @param Integer $offset
	 * @param Integer $limit
	 * @return Array
	 */
	function gethotthreads($offset = 0, $limit = 30) {
		$efone_rankifopen = L::config('efone_rankifopen', 'efone_config');
		$pushdataService = L::loadClass('pushdataservice', 'area');
		$invokeservice = L::loadClass('invokeservice', 'area');
		$invokePice = $invokeservice->getInvokePieceByInvokeName('pwefone_1');
		$sql = "SELECT t.tid,t.fid,t.ifupload,t.subject,t.author,t.authorid,t.hits,t.replies,t.postdate,t.lastpost,t.lastposter,f.name as forumname FROM pw_threads t LEFT JOIN pw_forums f ON t.fid=f.fid WHERE t.ifcheck=1 AND t.fid != 0";
		$_result = array();
		if (!empty($invokePice)) {
			$invoke = array_pop($invokePice);
			$invokeId = $invoke['id'];
			$searchArray = array('invokepiece' => $invokeId);
			$pushdatas = $pushdataService->searchPushDatas($searchArray, 0, $limit);
			$tids = $subject = array();
			foreach ($pushdatas as $key => $data) {
				$tids[] = $data['data']['tid'];
				$_result[$data['data']['tid']] = $data['data'];
			}
		}
		if (($_count = ($limit - count($tids))) > 0 && $efone_rankifopen) {
			$dataSourceService = L::loadClass('datasourceservice', 'area');
			$tempdata = $dataSourceService->getSourceData($invoke);
			$tempdata = $this->_bulidSourceData($tempdata);
			foreach ($tempdata as $key => $value) {
				$tids[] = $key;
			}
		}
		$_return = array();
		if ($tids) {
			$query = $this->db->query($sql . " AND tid IN (" . pwImplode($tids) . ")");
			while ($rt = $this->db->fetch_array($query)) {
				$tid = $rt['tid'];
				$rt['subject'] = $_result[$tid] ? $_result[$tid]['subject'] : $rt['subject'];
				$rt['forumname'] = strip_tags($rt['forumname']);
				$_tempreturn[$rt['tid']] = $rt;
			}
		}
		foreach ($tids as $key => $value) {
			$_return[] = $_tempreturn[$value];
		}
		if (empty($_return))
			return array();
		return $_return;
	}

	function _bulidSourceData($sourceData) {
		foreach ($sourceData as $key => $value) {
			$tid = $value['addition']['tid'];
			$_return[$tid] = array('tid' => $value['addition']['tid'], 'fid' => $value['addition']['fid'], 'subject' => $value['addition']['subject'], 'author' => $value['addition']['author'], 'authorid' => $value['addition']['authorid'], 'hits' => $value['addition']['hits'], 
				'replies' => $value['addition']['replies'], 'postdate' => $value['addition']['postdate'], 'lastpost' => $value['addition']['lastpost'], 'name' => $value['forumname']);
		}
		return $_return;
	}

	/**
	 * ȡ
	 * @param Integer $offset
	 * @param Integer $limit
	 * @return Array
	 */
	function getlatestthreads($offset = 0, $limit = 20) {
		$array = array();
		$efone_newsubject = L::config('efone_newsubject', 'efone_config');
		$sqladd = ($efone_newsubject && !in_array('0', $efone_newsubject)) ? 't.fid IN (' . S::sqlImplode($efone_newsubject) . ')' : 't.fid>0';
		$forceIndex = $GLOBALS['wind_version'] == '8.0' ? 'postdate' : 'idx_postdate';
		$query = $this->db->query("SELECT t.tid,t.fid,t.subject,t.author,t.authorid,t.hits,t.replies,t.postdate,t.lastpost,t.lastposter,f.name as forumname FROM pw_threads t FORCE INDEX(" . $forceIndex . ") LEFT JOIN pw_forums f ON t.fid=f.fid WHERE t.ifcheck=1 AND $sqladd ORDER BY postdate DESC " .
			S::sqlLimit($offset, $limit));
		while ($rt = $this->db->fetch_array($query)) {
			$rt['forumname'] = strip_tags($rt['forumname']);
			$array[] = $rt;
		}
		return $array;
	}
	/**
	 * ȡ
	 * @param Integer $offset
	 * @param Integer $limit
	 * @return Array
	 */
	function getlatestthreadsBytid($tid = 0, $limit = 20) {
		$tid = intval($tid);
		$limit = intval($limit);
		$sqladdTid = '';
		if ($tid > 0) {
			$sqladdTid = ' AND t.tid<' . $tid;
		}
		$array = array();
		$efone_newsubject = L::config('efone_newsubject', 'efone_config');
		$sqladd = ($efone_newsubject && !in_array('0', $efone_newsubject)) ? 't.fid IN (' . S::sqlImplode($efone_newsubject) . ')' : 't.fid>0';
		$forceIndex = $GLOBALS['wind_version'] == '8.0' ? 'postdate' : 'idx_postdate';
		$query = $this->db->query("SELECT t.tid,t.fid,t.ifupload,t.subject,t.author,t.authorid,t.hits,t.replies,t.postdate,t.lastpost,t.lastposter,f.name as forumname FROM pw_threads t FORCE INDEX(" . $forceIndex . ") LEFT JOIN pw_forums f ON t.fid=f.fid WHERE t.ifcheck=1 AND $sqladd $sqladdTid ORDER BY postdate DESC LIMIT " .
			$limit);
		while ($rt = $this->db->fetch_array($query)) {
			$rt['forumname'] = strip_tags($rt['forumname']);
			$array[] = $rt;
		}
		return $array;
	}

	/**
	 * ȡûղص
	 * @param int $uid ûuid
	 * @param int $offset бʼλ
	 * @param int $limit ȡб
	 * return array
	 */
	function getcollection($offset = 0, $limit = 20) {
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
		if ($GLOBALS['wind_version'] == '8.0') {
			return $this->_getCollectionForEarly($user->uid, $offset, $limit);
		} else {
			return $this->_getCollectionForAfter($user->uid, $offset, $limit);
		}
	}

	function _getCollectionForEarly($uid, $offset = 0, $limit = 20) {
		$array = array();
		$count = 0;
		if ($list = $this->_getCollectionIdsForEarly($uid)) {
			$tids = $this->_arrayFormat($list);
			$count = count($tids);
			$query = $this->db->query("SELECT tid,subject,authorid,author,postdate,lastpost,hits,replies
				FROM pw_threads WHERE tid IN(" . S::sqlImplode($tids) . ')' . ' ORDER BY postdate desc ' . S::sqlLimit($offset, $limit));
			while ($rt = $this->db->fetch_array($query)) {
				$array[] = $rt;
			}
		}
		return array('favors' => $array, 'count' => $count);
	}

	function _getCollectionForAfter($uid, $offset = 0, $limit = 20) {
		$array = array();
		$count = 0;
		$collectionService = L::loadClass('Collection', 'collection');
		$count = $collectionService->countByUidAndType($uid, 'postfavor');
		$page = $offset / $limit + 1;
		$page = (int) $page;
		$array = $collectionService->findByUidAndTypeInPage($uid, 'postfavor', $page, $limit, $ftype);
		$array = $this->_bulidCollectionForAfter($array);
		return array('favors' => $array, 'count' => $count);
	}

	function _bulidCollectionForAfter($favors) {
		$return = $tids = $collecttimes = array();
		foreach ($favors as $key => $value) {
			$tids[] = $value['typeid'];
			$collecttimes[$value['typeid']] = $value['postdate'];
		}
		$threadsDB = L::loadDB('threads', 'forum');
		$result = $threadsDB->getsBythreadIds($tids);
		foreach ($result as $key => $value) {
			$temparray['tid'] = $value['tid'];
			$temparray['subject'] = $value['subject'];
			$temparray['authorid'] = $value['authorid'];
			$temparray['author'] = $value['author'];
			$temparray['postdate'] = $value['postdate'];
			$temparray['lastpost'] = $value['lastpost'];
			$temparray['hits'] = $value['hits'];
			$temparray['replies'] = $value['replies'];
			$temparray['collecttime'] = $collecttimes[$value['tid']];
			$return[] = $temparray;
		}
		return $return;
	}

	/**
	 * ɾղ
	 * @param int $tid tid
	 * reutn bool
	 */
	function _deleteCollectionForEarly($tid, $uid) {
		$list = $this->_getCollectionIdsForEarly($uid);
		if ($list) {
			foreach ($list as $key => $value) {
				if (in_array($tid, $value)) {
					unset($list[$key][$tid]);
				}
			}
			$newtids = $this->_makefavor($list);
			$this->db->update("UPDATE pw_favors SET tids=" . S::sqlEscape($newtids) . ' WHERE uid=' . S::sqlEscape($uid));
		}
		return true;
	}

	/**
	 * ɾղ
	 * @param int $tid tid
	 * reutn bool
	 */
	function _deleteCollectionForAfter($tid, $uid) {
		$collectionService = L::loadClass('Collection', 'collection');
		$favor = $collectionService->getByTypeAndTypeid($uid, 'postfavor', $tid);
		if (empty($favor))
			return 'thread_not_exist';
		if ($favor['uid'] != $uid)
			return 'thread_user_not_right';
		$collectionService->delete($favor['id']);
		return true;
	}

	/**
	 * ȡղ
	 * @param int $tid
	 * @return boolean
	 */
	function unfavor($tid) {
		if (intval($tid) < 1) {
			return $this->errMessage(THREAD_INVALID_PARAMS, 'tid');
		}
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
		if ($GLOBALS['wind_version'] == '8.0') {
			$return = $this->_deleteCollectionForEarly($tid, $user->uid);
		} else {
			$return = $this->_deleteCollectionForAfter($tid, $user->uid);
		}
		if ($return === 'thread_not_exist') {
			return $this->errMessage(THREAD_NOT_EXIST, "ղز");
		} elseif ($return === 'thread_user_not_right') {
			return $this->errMessage(THREAD_USER_NOT_RIGHT, "ɾ˵ղ");
		} else {
			return $return;
		}
	}

	/**
	 * ղ
	 * @param int $tid tid
	 * reutn bool
	 */
	function favor($tid) {
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
		if ($GLOBALS['wind_version'] == '8.0') {
			$return = $this->_favorForEarly($tid, $user);
		} else {
			$return = $this->_favorForAfter($tid, $user, $user->username);
		}
		if ($return === 'thread_favor_already') {
			return $this->errMessage(THREAD_FAVOR_ALREADY, 'ѱղ');
		} elseif ($return === 'thread_favor_max') {
			return $this->errMessage(THREAD_FAVOR_MAX, 'ղѴֵ');
		} elseif ($return === 'thread_not_exists') {
			return $this->errMessage(THREAD_NOT_EXIST, 'Ӳ');
		}
		return $return;
	}

	function getSmile($type = 'thread') {
		global $imgpath;
		if ($type == 'thread') {
			include_once (D_P . 'data/bbscache/cache_post.php');
			$firstSmiles = array_values(array_slice($faces, 0, 1));
			foreach ($firstSmiles[0]['child'] as $value) {
				$defaultFaces[] = array('face' => '[s:' . $value . ']', 'path' => "$imgpath/post/smile/{$face[$value][0]}");
			}
		} elseif ($type == 'weibo') {
			include_once (D_P . 'data/bbscache/writesmiles.php');
			foreach ($data as $value) {
				$defaultFaces[] = array('face' => '[s:' . $value['name'] . ']', 'path' => "$imgpath/post/smile/write/{$value[path]}");
			}
		}
		return $defaultFaces;
	}

	function _favorForEarly($tid, $user) {
		$flag = 0;
		$list = $this->_getCollectionIdsForEarly($user->uid);
		if ($list === false) {
			$list = array();
			$flag = 1;
		}
		$tids = $this->_arrayFormat($list);
		if (in_array($tid, $tids)) {
			return 'thread_favor_already';
		}
		if (count($tids) >= $user->getRight('maxfavor')) {
			return 'thread_favor_already';
		}
		$list[0][] = $tid;
		$newtids = $this->_makefavor($list);
		if ($flag) {
			$this->db->update("INSERT INTO pw_favors SET tids=" . S::sqlEscape($newtids) . ',uid=' . S::sqlEscape($user->uid));
		} else {
			$this->db->update("UPDATE pw_favors SET tids=" . S::sqlEscape($newtids) . ' WHERE uid=' . S::sqlEscape($user->uid));
		}
		return true;
	}

	function _favorForAfter($tid, $user, $username) {
		global $timestamp;
		$collectionService = L::loadClass('Collection', 'collection');
		$favor = $collectionService->getByTypeAndTypeid($user->uid, 'postfavor', $tid);
		if ($favor)
			return 'thread_favor_already';
		if ($collectionService->countByUidAndType($user->uid, 'postfavor') >= $user->getRight('maxfavor')) {
			return 'thread_favor_max';
		}
		$content = $this->_bulidFavorContent($tid, $user->uid, $username);
		if ($content == 'thread_not_exists')
			return $content;

		$collectionDate = array('type' => 'postfavor', 'typeid' => $tid, 'uid' => $user->uid, 'username' => $username, 'content' => serialize($content), 'postdate' => $timestamp);
		$collectionService->insert($collectionDate);
		return true;
	}

	function _bulidFavorContent($tid, $uid, $username) {
		global $db_bbsurl;
		$threadsService = L::loadClass('Threads', 'forum');
		$favor = $threadsService->getByTid($tid);
		if (empty($favor))
			return 'thread_not_exists';
		$collection['uid'] = $favor['authorid'];
		$collection['lastpost'] = $favor['lastpost'];
		$collection['link'] = $db_bbsurl . '/read.php?tid=' . $tid;
		$collection['postfavor']['subject'] = $favor['subject'];
		$collection['username'] = $favor['author'];
		return $collection;
	}

	function _getThread($tid, $isDetailed = false) {
		if ($isDetailed) {
			$pw_tmsgs = GetTtable($tid);
			return $this->db->get_one("SELECT t.*,m.uid,m.icon,m.groupid,m.userstatus,tm.* FROM pw_threads t LEFT JOIN pw_members m ON t.authorid=m.uid LEFT JOIN $pw_tmsgs tm ON t.tid=tm.tid WHERE t.tid=" . S::sqlEscape($tid) . " AND t.ifcheck = 1 AND t.fid != 0");
		} else {
			return $this->db->get_one("SELECT * FROM pw_threads WHERE tid=" . S::sqlEscape($tid) . " AND ifcheck = 1 AND fid != 0");
		}
	}

	/**
	 * ֻ/ظ׷
	 * @param string $content
	 * @param string $type
	 */
	function _setAdditionalContent(&$content, $type = 'post') {
		$name = $this->openApi->config('name');
		$url = $this->openApi->config('downloadurl');
		$name = $name ? $name : ($url ? $url : '');
		if (!$name)
			return;
		$_content .= "\n\n";
		$_content .= $url ? "[url=" . $url . ",1]" . $name . "[/url]" : $name;
		$content = str_replace($_content, '', $content);
		$content .= $_content;
	}

	/**
	 * ȡֱ
	 *
	 * @global array $db_plist
	 * @param int $tid id
	 * @return string
	 */
	function _getPtable($tid) {
		if ($GLOBALS['db_plist'] && is_array($plistdb = $GLOBALS['db_plist'])) {
			$postTableId = $this->db->get_value('SELECT ptable FROM pw_threads WHERE tid=' . S::sqlEscape($tid, false));
			if ((int) $postTableId > 0 && array_key_exists($postTableId, $plistdb)) {
				return 'pw_posts' . $postTableId;
			}
		}
		return 'pw_posts';
	}

	/**
	 * @return PW_UserService
	 */
	function _getUserService() {
		return L::loadClass('UserService', 'user');
	}

	/**
	 * @return PW_ElementService
	 */
	function _getElementService() {
		return L::loadClass('element');
	}

	function _getCollectionIdsForEarly($uid) {
		$rt = $this->db->get_one("SELECT tids FROM pw_favors WHERE uid=" . S::sqlEscape($uid));
		if (!$rt) {
			return false;
		}
		if (!$rt['tids']) {
			return array();
		}
		$list = array();
		$tids = explode('|', $rt['tids']);
		foreach ($tids as $key => $t) {
			if (!$t)
				continue;
			$v = explode(',', $t);
			foreach ($v as $k => $v1) {
				if ($v1)
					$list[$key][$v1] = $v1;
			}
		}
		return $list;
	}

	function _arrayFormat($array) {
		$tmp = array();
		foreach ($array as $value) {
			$tmp = array_merge($tmp, $value);
		}
		return $tmp;
	}

	function _makefavor($tiddb) {
		$newtids = $ex = '';
		$k = 0;
		ksort($tiddb);
		foreach ($tiddb as $key => $val) {
			$new_tids = '';
			rsort($val);
			if ($key != $k) {
				$s = $key - $k;
				for ($i = 0; $i < $s; $i++) {
					$newtids .= '|';
				}
			}
			foreach ($val as $k => $v) {
				is_numeric($v) && $new_tids .= $new_tids ? ',' . $v : $v;
			}
			$newtids .= $ex . $new_tids;
			$k = $key + 1;
			$ex = '|';
		}
		return $newtids;
	}
}
