<?php
!defined('P_W') && exit('Forbidden');
define('USER_INVALID_PARAMS', 201);
define('USER_INVALID_USERNAME', 202);
define('USER_UPDATE_ERROR', 203);
define('USER_DELETE_ERROR', 204);
define('USER_NOT_EXISTS', 205);
define('USER_PWD_ERROR', 206);

class UserApi extends BaseApi {
	var $methodsType = array(
		'get' => 'GET', 
		'getbyname' => 'GET', 
		'checkauth' => 'GET',
		'checkbyname' => 'GET',
		'uploadicon' => 'POST'
	);


	/**
	 * ȡûϢ
	 * @param int $uid ûID
	 * @param int $weibo Ƿȡû΢Ϣ
	 * @return array
	 */
	function get($uid, $weibo = 0) {
		if (intval($uid) < 1) return $this->errMessage(USER_INVALID_PARAMS, 'uid');
		$userService = L::loadClass('UserService', 'user');
		$userInfo = $userService->get($uid, true, true, true);
		if (empty($userInfo)) return array();
		$userInfo = $this->_buildUserInfo($userInfo);
		$weibo !=0 && $userInfo['weibo'] = $this->_getWeiboInfo($uid,$userInfo['fans'],$userInfo['follows']);
		$userInfo = $this->_filterField($userInfo);
		return $userInfo;
	}


	/**
	 * ͨûȡûϢ
	 * @param string $username û
	 * @param int $weibo Ƿȡû΢Ϣ
	 * @return array
	 */
	function getbyname($username, $weibo = 0) {
		$username = trim($username);
		if (empty($username)) return array();
		$userService = L::loadClass('UserService', 'user');
		$userInfo = $userService->getByUserName($username, true, true, true);
		if (empty($userInfo)) return $this->errMessage(USER_NOT_EXISTS, 'û');
		$userInfo = $this->_buildUserInfo($userInfo);
		$weibo !=0 && $userInfo['weibo'] = $this->_getWeiboInfo($userInfo['uid'],$userInfo['fans'],$userInfo['follows']);
		$userInfo = $this->_filterField($userInfo);
		return $userInfo;
	}


	/**
	 * ûϢϷ
	 * @param string $userCode ûϢ
	 * @return int
	 */
	function checkauth($username, $password) {
		if (empty($username) || empty($password)) return $this->errMessage(USER_INVALID_PARAMS, 'username or password');
		$userService = $this->_getUserService();
		$userInfo = $userService->getByUserName($username,true,true);
		if (empty($userInfo)) return $this->errMessage(USER_NOT_EXISTS, 'û');
		if ($userInfo['password'] == $password) {
			Cookie("winduser", StrCode($userInfo['uid'] . "\t" . PwdCode($password)));
			$userInfo = $this->_buildUserInfo($userInfo);
			return $this->_filterField($userInfo);
		}
		return $this->errMessage(USER_PWD_ERROR, 'û');
	}


	/**
	 * ͨû֤ûǷ
	 * @param string $username û
	 * @param boolean $info ǷȡûϢ
	 * @return boolean|array ûϢ򲼶ֵ
	 */
	function checkbyname($username, $info = false) {
		$username = trim($username);
		if (empty($username)) return false;
		$userService = L::loadClass('UserService', 'user');
		$userInfo = $userService->getByUserName($username,true,true);
		if (empty($userInfo)) return false;
		$userInfo = $this->_buildUserInfo($userInfo);
		$userInfo = $this->_filterField($userInfo);
		return $info ? $userInfo : true;
	}


	/**
	 * ϴûͷ
	 * @return string $iconurl
	 */
	function uploadicon() {
		global $atc_attachment_name,$db_ifftp;
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
		$ext = strtolower(substr(strrchr($_FILES['icon']['name'], '.'), 1));
		L::loadClass('faceupload', 'upload', false);
		$face = new FaceUpload($user->uid);
		$icondb = PwUpload::upload($face);

		require_once (R_P . 'require/showimg.php');
		
		$udir = str_pad(substr($user->uid, -2), 2, '0', STR_PAD_LEFT);

		if (!in_array(strtolower($ext), array(
			'gif',
			'jpg',
			'jpeg',
			'png',
			'bmp'
		))) {
			return $this->errMessage(USER_UPLOAD_CONTENT_ERROR, 'ʹ');
		}
		
		$filename = "{$user->uid}.$ext";
		$sourceFilename = "{$user->uid}_tmp.$ext";
		$sourceDir = "upload/$udir/";
		$middleDir = "upload/middle/$udir/";
		$smallDir = "upload/small/$udir/";
		$img_w = $img_h = 0;
		$sourceFile = PwUpload::savePath($db_ifftp, $sourceFilename, $sourceDir);
		$middleFile = PwUpload::savePath($db_ifftp, $filename, $middleDir);
		PwUpload::createFolder(dirname($middleFile));
		PwUpload::movefile($sourceFile,$middleFile);
		require_once (R_P . 'require/imgfunc.php');

		if (!$img_size = GetImgSize($middleFile)) {
			P_unlink($middleFile);
			return $this->errMessage(USER_UPLOAD_CONTENT_ERROR, 'ݴ');
		}

		list($img_w, $img_h) = getimagesize($middleFile);
		$smallFile = PwUpload::savePath($db_ifftp, $filename, $smallDir);
		$s_ifthumb = 0;
		PwUpload::createFolder(dirname($smallFile));
		if ($ext == 'gif') {
			L::loadClass('gifdecoder', 'utility', false);
			L::loadClass('gif', 'utility', false);
			$gifDecoder = new GIFDecoder($data);
			$frames = $gifDecoder->GIFGetFrames();
			if (!empty($frames)) {
				foreach ($frames as $key => $value) {
					$frames[$key] = makeAvatarGifThumb($value, $img_w, $img_h, 48, 48);
				}
				$anime = new GIFEncoder($frames, $gifDecoder->GIFGetDelays(), $gifDecoder->GIFGetLoop(), $gifDecoder->GIFGetDisposal(), $gifDecoder->GIFGetTransparentR(), $gifDecoder->GIFGetTransparentG(), $gifDecoder->GIFGetTransparentB(), 'bin');
				$newGifData = $anime->getAnimation();
				PwUpload::createFolder(dirname($smallFile));
				writeover($smallFile, $newGifData);
				$s_ifthumb = 1;
			}
		} elseif (MakeThumb($middleFile, $smallFile, 48, 48)) {
			$s_ifthumb = 1;
		}

		if ($db_ifftp) {
			PwUpload::movetoftp($middleFile, $middleDir . $filename);
			$s_ifthumb && PwUpload::movetoftp($smallFile, $smallDir . $filename);
		}
		
		$user_a = explode('|', $winddb['icon']);
		$user_a[2] = $img_w;
		$user_a[3] = $img_h;
		$usericon = setIcon("$udir/{$user->uid}.$ext", 3, $user_a);
		
		$userService = L::loadClass('UserService', 'user'); /* @var $userService PW_UserService */
		$userService->update($user->uid, array('icon'=>$usericon));
		list($iconurl) = showfacedesign($usericon, 1, 's');
		return array('iconurl' => $iconurl);
	}

	
	/**
	 * ûϢ
	 * @param array $userInfo
	 * @return array
	 */
	function _buildUserInfo($userInfo) {
		$uid = $userInfo['uid'];
		$iconInfo = $this->_getUserIcon($userInfo);
		$userInfo['icon'] = $iconInfo[0];
		$userInfo['ltitle'] = $this->_getUserLevel($userInfo);
		$userInfo['isfollowed'] = $this->_getIsFollowed($uid);
		$subjectNum = $this->_getSubjectNum($uid);
		$userInfo['replycount'] = $userInfo['postnum'] - $subjectNum;
		$userInfo['favorcount'] = $this->_getFavorCount($uid,'postfavor');
		return $userInfo;
	}


	/**
	 * ûֶ
	 * @param array $data
	 * @return array
	 */
	function _filterField($data) {
		$filedMap = array(
			'uid' => $data['uid'], 
			'username' => $data['username'], 
			'gender' => $data['gender'], 
			'icon' => $data['icon'],
			'birthday' => $data['bday'], 
			'honor' => $data['honor'], 
			'postnum' => $data['postnum'],
			'ltitle' => $data['ltitle'],
			'isfollowed' => $data['isfollowed'],
			'replycount' => $data['replycount'],
			'favorcount' => $data['favorcount']
		);
		if ($data['weibo']) $filedMap['weibo'] = $data['weibo'];
		return $filedMap;
	}


	/**
	 * ȡûͷַ
	 * @param array $userInfo
	 * @return array
	 */
	function _getUserIcon($userInfo) {
		require_once (R_P . 'require/showimg.php');
		$iconInfo = showfacedesign($userInfo['icon'], 1, 's');
		return $iconInfo;
	}
	

	/**
	 * ȡûȼ
	 * @param array $userInfo
	 * @return array
	 */
	function _getUserLevel($userInfo) {
		include_once D_P . 'data/bbscache/level.php';
		$groupid = $userInfo['groupid'] == '-1' ?  $userInfo['memberid'] : $userInfo['groupid'];
		$_ltitle = $ltitle ? $ltitle[$groupid] : '';
		return $_ltitle;
	}
	

	/**
	 * ȡû΢
	 * @param array $uid
	 * @param array $fans
	 * @param array $follows
	 * @return array
	 */
	function _getWeiboInfo($uid,$fans,$follows) {
		$userWeiboInfo['followedweibo'] = $this->_getWeiboService()->getUserAttentionWeibosNotMeCount($uid);
		$userWeiboInfo['userweibo'] = $this->_getWeiboService()->getUserWeibosCount($uid);
		$userWeiboInfo['referweibo'] = $this->_getWeiboService()->getRefersToMeCount($uid);
		$userWeiboInfo['fans'] = $fans;
		$userWeiboInfo['follows'] = $follows;
		return $userWeiboInfo;
	}


	/**
	 * ȡûע״̬
	 * @param array $uid
	 * @return array
	 */
	function _getIsFollowed($uid) {
		$user = new apiUserInfo();
		$isfollowed = 0;
		if ($user->uid && $user->uid !== $uid) {
			$attentionService = $this->_getAttentionService();
			$isfollowed = $attentionService->isFollow($user->uid, $uid);
		}
		return $isfollowed;
	}


	/**
	 * @return PW_UserService
	 */
	function _getUserService() {
		return L::loadClass('UserService', 'user');
	}


	/**
	 * @return PW_Weibo
	 */
	function _getWeiboService() {
		return L::loadClass('weibo', 'sns');
	}


	/**
	 * @return PW_Attention
	 */
	function _getAttentionService() {
		return L::loadClass('Attention', 'friend');
	}


	/**
	 * ȡû
	 * @param int $uid ûID
	 * @return int $count ָû
	 */
	function _getSubjectNum($uid) {
		$count = $this->db->get_value("SELECT COUNT(*) FROM pw_threads WHERE authorid=".S::sqlEscape($uid));
		return $count;
	}


	/**
	 * ȡûղ
	 * @param int $uid ûID
	 * @param string $type ղص
	 * @return int ղ
	 */
	function _getFavorCount($uid,$type) {
		if ($GLOBALS['wind_version'] == '8.0') {
			$tids = $this->db->get_value("SELECT tids FROM pw_favors WHERE uid=".S::sqlEscape($uid));
			$tiddb = $this->_getFavor($tids);
			$count = count($tiddb);
		} else {
			$collectionObj = L::loadClass('Collection','collection');
			$count = $collectionObj->countByUidAndType($uid,$type);
		}
		return $count;
	}


	/**
	 * ûղΪ
	 * @param string $tids ղIDַ
	 * @return array $tiddb ղID
	 */
	function _getFavor($tids) {
		$tids = explode('|', $tids);
		$tiddb = array();
		foreach ($tids as $key => $t) {
			if ($t) {
				$v = explode(',', $t);
				foreach ($v as $k => $v1) {
					$tiddb[] = $v1;
				}
			}
		}
		return $tiddb;
	}
}