<?php
!defined('P_W') && exit('Forbidden');
define('WEIBO_INVALID_PARAMS', 801);
define('WEIBO_DELETE_ERROR', 802);
define('WEIBO_USER_HAS_EXIST', 803);
define('WEIBO_USER_ALREADY_FLOLLOW', 804);
define('WEIBO_USER_IN_PRIVACY', 805);
define('WEIBO_USER_NOT_FLOLLOW', 806);
define('WEIBO_COMMENT_SEND_FAIL', 807);
define('WEIBO_FOLLOW_UID_ERROR', 808);
define('WEIBO_UPLOAD_ERROR', 809);
define('WEIBO_NOT_EXISTS', 810);

class WeiboApi extends BaseApi {
	var $weiboService;
	var $methodsType = array(
		'send' => 'POST', 
		'getfollowedweibos' => 'GET', 
		'getfollowedweiboslist' => 'GET', 
		'getuserweibos' => 'GET', 
		'getuserweiboslist' => 'GET', 
		'getreferweibos' => 'GET', 
		'getreferweiboslist' => 'GET', 
		'delete' => 'POST',
		'get' => 'GET', 
		'getallweibos' => 'GET', 
		'getallweiboslist' => 'GET', 
		'getfollows' => 'GET', 
		'getfans' => 'GET', 
		'follow' => 'POST', 
		'unfollow' => 'POST', 
		'comment' => 'POST', 
		'transmit' => 'POST',
		'getHotTransmit' => 'GET',
		'getHotComment' => 'GET',
		'getHotTopics' => 'GET',
		'getWeiboByTopicName' => 'GET',
		'getWeibos'	=> 'GET',
		'delWeiboById' => 'GET',
		'delWeiboComment' => 'GET'
	);

	function init() {
		parent::init();
		$this->weiboService = $this->_getWeiboService();
	}

	function delWeiboById ($mid) {
		if (!empty($mid) && intval($mid) < 0) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'mid');
		}
		$user = new apiUserInfo();
		if (!$user->uid) return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		$weiboService = L::loadClass('weibo','sns');
		$weibo = $weiboService->getWeibosByMid($mid);
		if ($user->uid != $weibo['uid']) return $this->errMessage(WEIBO_DEL_RIGHT_ERROR, 'ɾ˵΢');
		$weiboService->deleteWeibos($mid);
		return true;
	}

	function delWeiboComment ($mid,$cid) {
		if (!empty($mid) && intval($mid) < 0 || !empty($cid) && intval($cid) < 0) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'invalid params');
		}
		$user = new apiUserInfo();
		if (!$user->uid) return $this->errMessage(USER_NOT_LOGIN, 'user not login');
		$commentDao = L::loadDB('weibo_comment','sns');
		$comment = $commentDao->get($cid);
		if ($user->uid != $comment['uid']) return $this->errMessage(WEIBO_DEL_RIGHT_ERROR, 'can not del other\'s comment');
		$commentService = L::loadClass("comment","sns");
		if($commentService->deleteComment($cid)){
			$weiboService = L::loadClass('weibo','sns');
			$weiboService->updateCountNum(array('replies' => -1), $mid,'plus');
		}
		return true;
	}

	/**
	 * ΢΢
	 * @param string $topicName ΢
	 * @param int $weiboId бһ΢ID
	 * @return array
	 */
	function getWeiboByTopicName($topicName,$mid = 0,$limit = 20) {
		if ((!empty($mid) && intval($mid) < 0) || intval($limit) < 1) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'mid or limit');
		}
		$sqlAdd = '';
		/*ݹؼ*/
		$count = $this->db->get_value("SELECT * FROM pw_weibo_content WHERE content LIKE ".S::sqlEscape('%'.$topicName.'%'));
		if (!$count) return array(
			'count' => 0, 
			'weibos' => array());
		$topicName && $sqlAdd .= ' AND content like '.S::sqlEscape('%'.$topicName.'%');
		$mid && $sqlAdd .= ' AND mid<'.S::sqlEscape($mid);
		$sql = 'SELECT * FROM pw_weibo_content WHERE 1 '.$sqlAdd ." ORDER BY mid DESC ".S::sqlLimit(0, $limit);
		return $this->_buildWeiboList($sql, $mid, 'down', $count);
	}
	/**
	 * ΢
	 * @param int $weiboId бһ΢ID
	 * @return array
	 */
	function getWeibos($weiboId,$limit = 20) {
		if ((!empty($mid) && intval($mid) < 0) || intval($limit) < 1) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'mid or limit');
		}
		$count = $this->weiboService->getWeibosCount();
		if (!$count) return array(
			'count' => 0, 
			'weibos' => array());
		$sqlAdd = '';
		$weiboId && $sqlAdd = 'WHERE mid<'.$weiboId;
		$sql = 'SELECT * FROM pw_weibo_content '.$sqlAdd.' ORDER BY mid DESC '.S::sqlLimit(0, $limit);
		return $this->_buildWeiboList($sql, $weiboId, 'down', $count);
	}

	/**
	 * ȡ1ڵת
	 * @param int $weiboId ͻʾһ΢ID
	 * @return array
	 */
	function getHotTransmit($weiboId,$limit = 20) {
		$rt = $this->db->get_one("SELECT * FROM pw_cache WHERE name='weiboHotTransmit_200'");
		$lastData = @unserialize($rt['cache']);
		$weiboHotTransmit = array();
		if ($lastData && ($rt['time'] > $this->timestamp - 86400)) {
			$weiboHotTransmit = (array)$lastData;
		} else {
			$time = $this->timestamp - 86400;
			$contentDao = L::loadDB('weibo_content','sns');
			$objectId = $contentDao -> getHotTransmit(200,$time);
			if(!$objectId) return array(
			'count' => 0, 
			'weibos' => array());
			$contentData = $contentDao -> getWeibosByMid($objectId);
			if(!$contentData) return array(
			'count' => 0, 
			'weibos' => array());
			foreach($objectId as $key => $v){
				if(!$contentData[$v]){
					unset($key);
					continue; 
				}
				$data[$v] = $contentData[$v];
			}
			$weiboHotTransmit = $this->weiboService->buildData($data);
			$this->db->update("REPLACE INTO pw_cache SET " . S::sqlSingle(array(
				'name'	=> 'weiboHotTransmit_200',
				'cache'	=> serialize($weiboHotTransmit),
				'time'	=> $this->timestamp
			)));
		}
		$weiboHotTransmitSlice = $this->_getWeiboSliceByKey($weiboHotTransmit,$weiboId,$limit);
		$count = count($weiboHotTransmitSlice);
		return $this->_buildWeibos($weiboHotTransmitSlice,$count);
	}
	/**
	 * ȡ1ڵ
	 * @param int $weiboId ͻʾһ΢ID
	 * @return array
	 */
	function getHotComment($weiboId,$limit = 20) {
		$rt = $this->db->get_one("SELECT * FROM pw_cache WHERE name='weiboHotComment_200'");
		$lastData = @unserialize($rt['cache']);
		$weiboHotComment = array();
		if ($lastData && ($rt['time'] > $this->timestamp - 86400)) {
			$weiboHotComment = (array)$lastData;
		} else {
			$time = $this->timestamp - 86400;
			$contentDao = L::loadClass('comment','sns');
			$objectId = $contentDao->getHotComment(200,$time);
			if(!$objectId) return array(
			'count' => 0, 
			'weibos' => array());
			$contentDao = L::loadDB('weibo_content','sns');
			$contentData = $contentDao -> getWeibosByMid($objectId);
			if(!$contentData) return array(
			'count' => 0, 
			'weibos' => array());
			foreach($objectId as $key => $v){
				if(!$contentData[$v]){
					unset($key);
					continue; 
				}
				$data[$v] = $contentData[$v];
			}
			$weiboHotComment = $this->weiboService->buildData($data);
			$this->db->update("REPLACE INTO pw_cache SET " . S::sqlSingle(array(
				'name'	=> 'weiboHotComment_200',
				'cache'	=> serialize($weiboHotComment),
				'time'	=> $this->timestamp
			)));
		}
		$weiboHotCommentSlice = $this->_getWeiboSliceByKey($weiboHotComment,$weiboId,$limit);
		$count = count($weiboHotCommentSlice);
		return $this->_buildWeibos($weiboHotCommentSlice,$count);
	}
	/**
	 * ȡ1Ż
	 * @param int $topicId ͻʾһID
	 * @return array 
	 */
	function getHotTopics($topicId,$limit = 20) {
		$rt = $this->db->get_one("SELECT * FROM pw_cache WHERE name='weiboHotTopics_200'");
		$lastData = @unserialize($rt['cache']);
		$weiboHotTopics = array();
		if ($lastData && ($rt['time'] > $this->timestamp - 86400)) {
			$weiboHotTopics = (array)$lastData;
		} else {
			$topicObject = L::loadClass('topic','sns');
			$weiboHotTopics = $topicObject->getHotTopics(100,7);
			$this->db->update("REPLACE INTO pw_cache SET " . S::sqlSingle(array(
				'name'	=> 'weiboHotTopics_200',
				'cache'	=> serialize($weiboHotTopics),
				'time'	=> $this->timestamp
			)));
		}
		return $this->_getWeiboSliceByKey($weiboHotTopics,$topicId,$limit);
	}

	function _getWeiboSliceByKey($weibos,$wkey,$limit = 20) {
		if(empty($key)) return array_slice($weibos,0,$limit);
		$i = 0;
		foreach ($weibos as $key=> $value) {
			$i++;
			if ($key == $wkey) {
				$weiboHotTransmitSlice = array_slice($weibos,$i,$limit);
				break;
			}
		}
		return $weiboHotTransmitSlice;
	}


	/*
     * 
     * @param int $uid
     * @param string $content
	 * @param string $type
	 * @param int $typeid
	 * @param array $extra
     * @return array
     */
	function send($uid, $content, $type = 'weibo', $typeid = 0, $extra = array()) {
		if (intval($uid) <= 0 || '' == trim($content)) return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid or content');
		$user = new apiUserInfo();
		if (!$user->uid) return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		$type != 'sendweibo' && $type = 'weibo';
		require_once D_P . 'data/bbscache/o_config.php';
		if ($o_weibourl && $o_weibourl != 1) preg_match('/http:\/\//i', $content) && $this->errMessage(0, getLangInfo('msg', 'weibo_link_close'));
		if (($return = $this->weiboService->sendCheck($content, $user->groupid)) !== true) $this->errMessage(0, $return);
		/* ¶ͼƬش  */
		require_once R_P . 'require/app_core.php';
		if (!$GLOBALS['db_phopen']) $this->errMessage(0, 'Ӧñر');
		if ($o_weibophoto != 1) $this->errMessage(0, '΢ͼƬܱر');
		$aid = $this->db->get_value("SELECT aid FROM pw_cnalbum WHERE atype='0' AND ownerid=" . pwEscape($user->uid) . " AND isdefault=1 " . pwLimit(1));
		if (!$aid) $this->errMessage(0, '᲻');
		$rt = $this->db->get_one("SELECT aname,photonum,ownerid,private,lastphoto FROM pw_cnalbum WHERE atype='0' AND aid=" . pwEscape($aid));
		if (empty($rt)) {
			$this->errMessage(0, getLangInfo('msg', 'undefined_action'));
		} elseif ($user->uid != $rt['ownerid']) {
			$this->errMessage(0, getLangInfo('msg', 'colony_phototype'));
		}
		//L::loadClass('photoupload', 'upload', false);
		require_once(R_P . 'mclientapi/library/photoupload.class.php');
		if (PwUpload::getUploadNum()) {
			$imgs = new PhotoUpload($aid);
			$uploadReturn = PwUpload::upload($imgs);
			if ($uploadReturn != 'success') return $this->errMessage(809,$uploadReturn);
			$photos = $imgs->getAttachs();
		}
		if ($photos && is_array($photos)) {
			$this->db->update("UPDATE pw_cnalbum SET photonum=photonum+" . pwEscape(count($photos), false) . ",lasttime=" . pwEscape($GLOBALS['timestamp'], false) . ',lastpid=' . pwEscape(implode(',', $imgs->getNewID())) . (!$rt['lastphoto'] ? ',lastphoto=' . pwEscape($imgs->getLastPhoto()) : '') . " WHERE aid=" . pwEscape($aid));
			$extra['photos'] = $photos;
		}
		$weiboId = $this->weiboService->send($uid, $content, $type, $typeid, $extra);
		return array(
			'weiboid' => $weiboId);
	}

	function transmit($mid, $uid, $content, $ifcomment = false) {
		if (intval($uid) <= 0 || intval($mid) <= 0) return $this->errMessage(WEIBO_INVALID_PARAMS, 'mid');
		$user = new apiUserInfo();
		if (!$user->uid || $user->uid !== $uid) return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid');
		if (!$weibo = $this->weiboService->getWeibosByMid($mid)) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, '΢');
		}
		$transmits = array();
		$type = $this->weiboService->getType($weibo['type']);
		if ($type == 'transmit' && $weibo['objectid']) {
			$transmits = $this->weiboService->getWeibosByMid($weibo['objectid']);
		}
		$attentionService = L::loadClass('Attention', 'friend');
		$blackList = $attentionService->getBlackListToMe($uid, array(
			$weibo['uid']));
		$tmid = $transmits ? $weibo['objectid'] : $mid;
		if (($return = $this->weiboService->sendCheck($content, $user->groupid, true)) !== true) {
			return $this->errMessage(0, $return);
		}
		require_once(R_P.'require/app_core.php');
		if ($this->weiboService->send($uid, $content, 'transmit', $tmid)) {
			$this->weiboService->updateCountNum(array(
				'transmit' => 1), $tmid);
			if ($transmits) {
				$this->weiboService->updateCountNum(array(
					'transmit' => 1), $mid);
			}
			if ($ifcomment) {
				$commentService = L::loadClass("comment", "sns");
				if ($commentService->comment($uid, $tmid, $content)) {
					$this->weiboService->updateCountNum(array(
						'replies' => 1), $tmid);
				}
			}
		} else {
			return $this->errMessage(0, 'תɹ');
		}
		return true;
	}

	/**
	 * ûע΢Ϣ
	 * @param unknown_type $uid
	 * @param unknown_type $offset
	 * @param unknown_type $limit
	 */
	function getUserAttentionWeibos($uid, $offset = 1, $limit = 20) {
		if (intval($uid) <= 0) return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid');
		$filter = array(
			'source' => array(
				'article' => 1, 
				'diary' => 1, 
				'photos' => 1, 
				'group' => 1), 
			'contenttype' => array(
				'string' => 1, 
				'img' => 1), 
			'relation' => array(
				'self' => 1, 
				'attention' => 1,
				'friend' => 1
			));
		$count = $this->weiboService->getUserAttentionWeibosCount($uid, $filter);
		if (!$count) return array(
			'count' => 0, 
			'weibos' => array());
		$weiboList = $this->weiboService->getUserAttentionWeibos($uid, $filter, $offset, $limit);
		return $this->_buildWeibos($weiboList, $count);
	}

	function _buildWeibos($weiboList, $count) {
		$weibos = array();
		foreach ($weiboList as $value) {
			if($value['extra']['fname']) $value['extra']['fname'] = strip_tags($value['extra']['fname']);
			$this->_attachList($value);
			$value['sourceType'] = $this->weiboService->getType($value['type']);
			$value['sourceTypeDesc'] = $this->weiboService->getTypeDescript($value['type']);
			$weibos[] = $value;
		}
		return array(
			'count' => $count, 
			'weibos' => $weibos);
	}

	/**
	 * ûע΢Ϣ
	 * @param unknown_type $uid
	 * @param unknown_type $offset
	 * @param unknown_type $limit
	 */
	function getUserAttentionWeiboslist($uid, $mid = 0, $go = 'up', $limit = 20) {
		if (intval($uid) <= 0) return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid');
		$filter = array(
			'source' => array(
				'article' => 1, 
				'diary' => 1, 
				'photos' => 1, 
				'group' => 1), 
			'contenttype' => array(
				'string' => 1, 
				'img' => 1), 
			'relation' => array(
				'self' => 1, 
				'attention' => 1,
				'friend' => 1
			));
		$count = $this->weiboService->getUserAttentionWeibosCount($uid, $filter);
		if (!$count) return array(
			'count' => 0, 
			'weibos' => array());
		if (($sqlArr = $this->weiboService->_filterSql($uid, $filter)) === false) {
			return $this->errMessage(0, '$this->weiboService->_filterSql() failed.');
		}
		$sqlAdd = '';
		foreach ($sqlArr as $key => $value) {
			switch ($key) {
				case 'uidIn':
				case 'uidsIn':
					$sqlAdd .= " AND a.authorid" . $this->_sqlIn($value);
					break;
				case 'uidsNotIn':
					if ($value) $sqlAdd .= " AND a.authorid NOT IN (" . pwImplode($value) . ')';
					break;
				case 'uidNotIn':
					$sqlAdd .= " AND a.authorid!=" . pwEscape($value);
					break;
				case 'source':
					$sqlAdd .= " AND a.type" . $this->_sqlIn($value);
					break;
				case 'contenttype':
					$sqlAdd .= " AND b.contenttype=" . pwEscape($value);
					break;
			}
		}
		$sql = 'SELECT * FROM pw_weibo_relations a LEFT JOIN pw_weibo_content b ON a.mid=b.mid WHERE a.uid=' . S::sqlEscape($uid) . $sqlAdd;
		if (!empty($mid)) {
			$sql .= ($go == 'up') ? ' AND a.mid > ' . S::sqlEscape($mid) . ' ORDER BY a.mid ASC ' : ' AND a.mid < ' . S::sqlEscape($mid) . ' ORDER BY a.mid DESC ';
			$sql .= S::sqlLimit(0, $limit);
		} else {
			$sql .= ' ORDER BY a.mid DESC ' . S::sqlLimit(0, $limit);
		}
		return $this->_buildWeiboList($sql, $mid, $go, $count);
	}

	/*
     * ȡûעµµ
     * @param int $lastmid
     * @return array
     */
	function getNewAttentionWeiboCount($lastmid = 0) {
		!$lastmid && $lastmid = 0;
		$user = new apiUserInfo();
		if (!$user->uid) return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		$filter = array(
			'source' => array(
				'article' => 1, 
				'diary' => 1, 
				'photos' => 1, 
				'group' => 1), 
			'contenttype' => array(
				'string' => 1, 
				'img' => 1), 
			'relation' => array(
				'self' => 1, 
				'attention' => 1,
				'friend' => 1
			));
		if (($sqlArr = $this->weiboService->_filterSql($uid, $filter)) === false) {
			return $this->errMessage(0, '$this->weiboService->_filterSql() failed.');
		}
		$sqlAdd = '';
		foreach ($sqlArr as $key => $value) {
			switch ($key) {
				case 'uidIn':
				case 'uidsIn':
					$sqlAdd .= " AND a.authorid" . $this->_sqlIn($value);
					break;
				case 'uidsNotIn':
					if ($value) $sqlAdd .= " AND a.authorid NOT IN (" . pwImplode($value) . ')';
					break;
				case 'uidNotIn':
					$sqlAdd .= " AND a.authorid!=" . pwEscape($value);
					break;
				case 'source':
					$sqlAdd .= " AND a.type" . $this->_sqlIn($value);
					break;
				case 'contenttype':
					$sqlAdd .= " AND b.contenttype=" . pwEscape($value);
					break;
			}
		}
		$sql = 'SELECT COUNT(*) FROM pw_weibo_relations a LEFT JOIN pw_weibo_content b ON a.mid=b.mid WHERE a.uid=' . S::sqlEscape($user->uid) . $sqlAdd .' AND a.mid > ' . S::sqlEscape($lastmid);
		$count = $this->db->get_value($sql);
		return $count;
	}

	/*
     * ȡûעĺѵĵ
     * @param int $uid
	 * @param int $offset
	 * @param int $limit
     * @return array
     */
	function getfollowedweibos($uid, $offset = 1, $limit = 20) {
		if (intval($uid) <= 0) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid');
		}
		$count = $this->weiboService->getUserAttentionWeibosNotMeCount($uid);
		if (!$count) return array(
			'count' => $count, 
			'weibos' => array());
		$result = $this->weiboService->getUserAttentionWeibosNotMe($uid, $offset, $limit);
		return $this->_buildWeibos($result, $count);
	}

	/*
     * ȡûעĺѵĵ
     * @param int $uid
	 * @param int $mid
	 * @param string $go
	 * @param int $limit
     * @return array
     */
	function getfollowedweiboslist($uid, $mid = 0, $go = 'up', $limit = 20) {
		if (intval($uid) <= 0 || (!empty($mid) && intval($mid) < 0) || intval($limit) < 1) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid or mid or limit');
		}
		$count = $this->weiboService->getUserAttentionWeibosNotMeCount($uid);
		if (!$count) return array(
			'count' => $count, 
			'weibos' => array());
		$sql = 'SELECT * FROM pw_weibo_relations a LEFT JOIN pw_weibo_content b ON a.mid=b.mid WHERE a.uid = ' . S::sqlEscape($uid) . ' and a.authorid != ' . S::sqlEscape($uid);
		if (!empty($mid)) {
			$sql .= ($go == 'up') ? ' AND a.mid > ' . S::sqlEscape($mid) . ' ORDER BY a.mid ASC ' : ' AND a.mid < ' . S::sqlEscape($mid) . ' ORDER BY a.mid DESC ';
			$sql .= S::sqlLimit(0, $limit);
		} else {
			$sql .= ' ORDER BY a.mid DESC ' . S::sqlLimit(0, $limit);
		}
		return $this->_buildWeiboList($sql, $mid, $go, $count);
	}

	/*
     * ȡû
     * @param int $uid
	 * @param int $offset
	 * @param int $limit
     * @return array
     */
	function getuserweibos($uid, $offset = 1, $limit = 20) {
		if (intval($uid) <= 0) return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid');
		$count = $this->weiboService->getUserWeibosCount($uid);
		if (!$count) return array(
			'count' => 0, 
			'weibos' => array());
		$result = $this->weiboService->getUserWeibos($uid, $offset, $limit);
		return $this->_buildWeibos($result, $count);
	}

	private function _attachList(&$value,$iftransmits=false) {
		require_once R_P . 'require/app_core.php';
		unset($value['password']);
		$value['content'] = preg_replace('/<a href=(.*?)>(@(.*?)+)<\/a>/is', '\\2', $value['content']);
		list($db_thumbw, $db_thumbh) = explode("\t", $GLOBALS['db_athumbsize']);
		if (isset($value['extra']['photos'][0]['thumb'])) {
			$_attachs = '<attachs ';
			$_src = $_thumb = '';
			$_src = $value['extra']['photos'][0]['middle'] . ',';
			$_thumb = $value['extra']['photos'][0]['thumb'];
			$_attachs .= "src=" . trim($_src, ',') . " thumb= " . trim($_thumb, ',') . " width='$db_thumbw' height='$db_thumbh' />";
			$value['content'] .= $_attachs;
			unset($value['extra']['photos']);
		} elseif ($value['extra']['photos']) {
			$firstPhoto = current(array_slice($value['extra']['photos'],0,1));
			$_attachs = '<attachs ';
			$_src = $_thumb = '';
			$_src = getphotourl($firstPhoto['path'], false, 'imgdel.jpg') . ',';
			$_thumb = $firstPhoto['ifthumb'] ? getphotourl($firstPhoto['path'], true, 'imgdel.jpg') : $_src;
			$_attachs .= "src=" . trim($_src, ',') . " thumb= " . trim($_thumb, ',') . " width='$db_thumbw' height='$db_thumbh' />";
			$value['content'] .= $_attachs;
			unset($value['extra']['photos']);
		}
		if (isset($value['transmits']) && !empty($value['transmits'])) {
			$this->_attachList($value['transmits']);
		}
	}

	/*
     * ȡû
     * @param int $uid
	 * @param int $mid
	 * @param string $go
	 * @param int $limit
     * @return array
     */
	function getuserweiboslist($uid, $mid = 0, $go = 'up', $limit = 20) {
		if (intval($uid) <= 0 || (!empty($mid) && intval($mid) < 0) || intval($limit) < 1) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid or mid or limit');
		}
		$count = $this->weiboService->getUserWeibosCount($uid);
		if (!$count) return array(
			'count' => 0, 
			'weibos' => array());
		$sql = 'SELECT * FROM pw_weibo_content WHERE uid = ' . S::sqlEscape($uid);
		if (!empty($mid)) {
			$sql .= ($go == 'up') ? ' AND mid > ' . S::sqlEscape($mid) . ' ORDER BY mid ASC ' : ' AND mid < ' . S::sqlEscape($mid) . ' ORDER BY mid DESC ';
			$sql .= S::sqlLimit(0, $limit);
		} else {
			$sql .= ' ORDER BY mid DESC ' . S::sqlLimit(0, $limit);
		}
		return $this->_buildWeiboList($sql, $mid, $go, $count);
	}

	/**
	 * @param mid
	 * @param go
	 * @param count
	 * @param result
	 * @param value
	 */
	private function _buildWeiboList($sql, $mid, $go, $count) {
		$query = $this->db->query($sql);
		while ($rt = $this->db->fetch_array($query)) {
			$result[] = $rt;
		}
		!empty($mid) && $go == 'up' && krsort($result);
		$result = $this->weiboService->buildData($result, 'uid');
		return $this->_buildWeibos($result, $count);
	}

	/*
     * ȡᵽû
     * @param int $uid
	 * @param int $offset
	 * @param int $limit
     * @return array
     */
	function getreferweibos($uid, $offset = 1, $limit = 20) {
		if (intval($uid) <= 0) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid');
		}
		$count = $this->weiboService->getRefersToMeCount($uid);
		if (!$count) return array(
			'count' => 0, 
			'weibos' => array());
		$user = new apiUserInfo();
		if ($user->uid && $user->uid == $uid && $user->info['newreferto'] > 0) {
			$userService = L::loadClass('UserService', 'user');
			$userService->update($user->uid, array(), array(
				'newreferto' => 0));
			$user->info['newreferto'] = 0;
		}
		$result = $this->weiboService->getRefersToMe($uid, $offset, $limit);
		return $this->_buildWeibos($result, $count);
	}

	/*
     * ȡᵽû
     * @param int $uid
	 * @param int $mid
	 * @param string $go
	 * @param int $limit
     * @return array
     */
	function getreferweiboslist($uid, $mid = 0, $go = 'up', $limit = 20) {
		if (intval($uid) <= 0 || (!empty($mid) && intval($mid) < 0) || intval($limit) < 1) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid or mid or limit');
		}
		$count = $this->weiboService->getRefersToMeCount($uid);
		if (!$count) return array(
			'count' => $count, 
			'weibos' => array());
		$sql = 'SELECT * FROM pw_weibo_referto a LEFT JOIN pw_weibo_content b ON a.mid = b.mid WHERE a.uid = ' . S::sqlEscape($uid);
		if (!empty($mid)) {
			$sql .= ($go == 'up') ? ' AND a.mid > ' . S::sqlEscape($mid) . ' ORDER BY a.mid ASC ' : ' AND a.mid < ' . S::sqlEscape($mid) . ' ORDER BY a.mid DESC ';
			$sql .= S::sqlLimit(0, $limit);
		} else {
			$sql .= ' ORDER BY a.mid DESC ' . S::sqlLimit(0, $limit);
		}
		$user = new apiUserInfo();
		if ($user->uid && $user->uid == $uid && $user->info['newreferto'] > 0) {
			$userService = L::loadClass('UserService', 'user');
			$userService->update($user->uid, array(), array(
				'newreferto' => 0));
			$user->info['newreferto'] = 0;
		}
		return $this->_buildWeiboList($sql, $mid, $go, $count);
	}

	/*
     * ɾ
     * @param int|array $mid
     * @return int|array
     */
	function delete($mid) {
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
        if (intval($mid) <= 0) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'mid');
		}
		$weibo = $weiboService->getWeibosByMid($mid);
		if ($weibo['uid'] != $user->uid) {
			return $this->errMessage(WEIBO_FOLLOW_UID_ERROR, 'ִûǵǰ¼û');
		}
		$return = $this->weiboService->deleteWeibos($mid);
		if ($return) return true;
		return $this->errMessage(WEIBO_DELETE_ERROR, '΢ɾ');
	}

	/*
     * ȡϸϢ
     * @param int|array $mids
     * @param int $comment Ϊ1ȡ20
     * @return array
     */
	function get($mids, $comments = 0) {
		if (!$mids || empty($mids)) return $this->errMessage(WEIBO_INVALID_PARAMS, 'mids');
		$weiboInfo = $this->weiboService->getWeibosByMid($mids);
		if (empty($weiboInfo)) return $this->errMessage(WEIBO_NOT_EXISTS, '²');
		if (!is_array($mids)) $weiboInfo = array(
			$weiboInfo);
		foreach ($weiboInfo as $key => $value) {
			if ($comments != 0) {
				$weiboCommentService = $this->_getWeiboCommentService();
				$value['commentcount'] = $weiboCommentService->getCommentsCountByMid($value['mid']);
				$value['comment'] = array();
				if ($value['commentcount'] > 0) {
					$data = $weiboCommentService->getCommentsByMid($value['mid']);
					$value['comment'] = $this->_buildComment($data);
				}
			}
			$value['sourceType'] = $this->weiboService->getType($value['type']);
			$value['sourceTypeDesc'] = $this->weiboService->getTypeDescript($value['type']);
			$value['extra'] = unserialize($value['extra']);
			if($value['extra']['fname']) $value['extra']['fname'] = strip_tags($value['extra']['fname']);
			$value['extra'] = serialize($value['extra']);
			$weiboInfo[$key] = $value;
		}
		$weiboInfo = $this->weiboService->buildData($weiboInfo);
		foreach ($weiboInfo as $key => $value) {
			$this->_attachList($weiboInfo[$key]);
		}
		return count($weiboInfo) > 1 ? array(
			'weibos' => $weiboInfo) : array(
			'weibo' => $weiboInfo[0]);
	}

	/*
     * ȡȫվ
     * @param int $offset
     * @param int $limit
     * @return array
     */
	function getallweibos($offset = 1, $limit = 20) {
		$result = $this->weiboService->getWeibos($offset, $limit);
		$weibos = array();
		foreach ($result as $value) {
			$this->_attachList($value);
			$value['sourceType'] = $this->weiboService->getType($value['type']);
			$value['sourceTypeDesc'] = $this->weiboService->getTypeDescript($value['type']);
			$weibos[] = $value;
		}
		$count = $this->weiboService->getWeibosCount();
		return array(
			'count' => $count, 
			'weibos' => $weibos);
	}

	/*
     * ȡȫվ
     * @param int $offset
     * @param int $limit
     * @return array
     */
	function getallweiboslist($mid = 0, $go = 'up', $limit = 20) {
		if ((!empty($mid) && intval($mid) < 0) || intval($limit) < 1) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'mid or limit');
		}
		$count = $this->weiboService->getWeibosCount();
		if (!$count) return array(
			'count' => 0, 
			'weibos' => array());
		$sql = 'SELECT * FROM pw_weibo_content WHERE 1';
		if (!empty($mid)) {
			$sql .= ($go == 'up') ? ' AND mid > ' . S::sqlEscape($mid) . ' ORDER BY mid ASC ' : ' AND mid < ' . S::sqlEscape($mid) . ' ORDER BY mid DESC ';
			$sql .= S::sqlLimit(0, $limit);
		} else {
			$sql .= ' ORDER BY mid DESC ' . S::sqlLimit(0, $limit);
		}
		return $this->_buildWeiboList($sql, $mid, $go, $count);
	}

	/*
     * ȡûעĺ
     * @param int $uid
     * @param int $offset
     * @param int $limit
     * @return array
     */
	function getfollows($uid, $offset = 1, $limit = 20) {
		if (intval($uid) <= 0) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid');
		}
		$attentionService = $this->_getAttentionService();
		$count = $attentionService->countFollows($uid);
		if (!$count) return array(
			'count' => $count, 
			'user' => array());
		$return = $attentionService->getFollowListInPage($uid, $offset, $limit);
		return $this->_buildFriendList($uid, $return, $attentionService, $count);
	}
	/**
	 * ȡûעĺ()
	 *
	 * @param unknown_type $uid
	 * @param unknown_type $followid
	 * @param unknown_type $go
	 * @param unknown_type $limit
	 * @return unknown
	 */
	function getfollowslist($uid, $followid, $go = 'up', $limit = 20) {
		if (intval($uid) <= 0) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid');
		}
		$attentionService = $this->_getAttentionService();
		$count = $attentionService->countFollows($uid);
		if (!$count) return array(
			'count' => $count, 
			'user' => array());
		$sql = "SELECT m.uid,m.username,m.icon as face,m.honor,m.memberid,m.groupid,md.thisvisit,md.lastvisit,md.fans 
				FROM pw_attention f LEFT JOIN pw_members m ON f.friendid = m.uid LEFT JOIN pw_memberdata md ON f.friendid = md.uid 
				WHERE f.uid = " . S::sqlEscape($uid);
		if (!empty($followid)) {
			$sql .= ($go == 'up') ? ' AND f.friendid > ' . S::sqlEscape($followid) . ' ORDER BY f.friendid ASC ' : ' AND f.friendid < ' . S::sqlEscape($followid) . ' ORDER BY f.joindate DESC ';
			$sql .= S::sqlLimit(0, $limit);
		} else {
			$sql .= ' ORDER BY f.joindate DESC ' . S::sqlLimit(0, $limit);
		}
		$query = $this->db->query($sql);
		while ($rt = $this->db->fetch_array($query)) {
			$return[] = $rt;
		}
		$return = $attentionService->_formatAttentionsData($return);
		return $this->_buildFriendList($uid, $return, $attentionService, $count);
	}

	/*
     * ȡĳûķ˿
     * @param int $uid
     * @param int $offset
     * @param int $limit
     * @return array
     */
	function getfans($uid, $offset = 1, $limit = 20) {
		if (intval($uid) <= 0) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid');
		}
		$attentionService = $this->_getAttentionService();
		$count = $attentionService->countFans($uid);
		if (!$count) return array(
			'count' => $count, 
			'user' => array());
		$return = $attentionService->getFansListInPage($uid, $offset, $limit);
		return $this->_buildFriendList($uid, $return, $attentionService, $count);
	}

	function getfanslist($uid, $fansid, $go = 'up', $limit = 20) {
		if (intval($uid) <= 0) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid');
		}
		$updateSQL['newfans'] = 0;
		$userService = L::loadClass('UserService', 'user'); /* @var $userService PW_UserService */
		$userService->update($uid, array(), $updateSQL);
		$attentionService = $this->_getAttentionService();
		$count = $attentionService->countFans($uid);
		if (!$count) return array(
			'count' => $count, 
			'user' => array());
		$sql = "SELECT m.uid,m.username,m.icon as face,m.honor,m.memberid,m.groupid,md.thisvisit,md.lastvisit,md.fans 
			FROM pw_attention f " . " LEFT JOIN pw_members m ON f.uid = m.uid" . " LEFT JOIN pw_memberdata md 
			ON f.uid = md.uid" . " WHERE f.friendid=" . S::sqlEscape($uid);
		if (!empty($fansid)) {
			$sql .= ($go == 'up') ? ' AND f.uid> ' . S::sqlEscape($fansid) . ' ORDER BY f.joindate ASC ' : ' AND f.uid < ' . S::sqlEscape($fansid) . ' ORDER BY f.joindate DESC ';
			$sql .= S::sqlLimit(0, $limit);
		} else {
			$sql .= ' ORDER BY f.joindate DESC ' . S::sqlLimit(0, $limit);
		}
		$query = $this->db->query($sql);
		while ($rt = $this->db->fetch_array($query)) {
			$return[] = $rt;
		}
		$return = $attentionService->_formatAttentionsData($return);
		return $this->_buildFriendList($uid, $return, $attentionService, $count);
	}

	/**
	 * Enter description here ...
	 * @param attentionService
	 * @param count
	 * @param value
	 */
	private function _buildFriendList($uid, $return, $attentionService, $count) {
		require_once(D_P.'data/bbscache/level.php');
		$attentionedUids = $myAttentionUids = array();
		foreach ($return as $value) {
			$attentionedUids[] = $value['uid'];
		}
		/* ȡûעûб */
		$user = new apiUserInfo();
		$myAttentionUids = $attentionService->getUidsInFollowListByFriendids($user->uid, $attentionedUids);
		$fans = array();
		foreach ($return as $value) {
			if ($myAttentionUids && in_array($value['uid'], $myAttentionUids))
				$value['isfollowed'] = 1;
			else
				$value['isfollowed'] = 0;
			$value['thisvisit'] = get_date($value['thisvisit']);
			$value['groupid'] == '-1' && $value['groupid'] = $value['memberid'];
			$value['level'] = $ltitle[$value['groupid']];
			$value = $this->_cleanFriendList($value);
			$fans[] = $value;
		}
		return array(
			'count' => $count, 
			'user' => $fans);
	}

	function _cleanFriendList($user) {
		$unset = array('memberid','groupid','thisvisit','lastvisit','fans');
		foreach ($unset as $key => $value) {
			unset($user[$value]);
		}
		return $user;
	}

	/*
     * ע
     * @param int $uid
     * @param int $touid
     * @return array|int
     */
	function follow($uid, $touid) {
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
        if (intval($uid) <= 0 || intval($touid) <= 0) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid or touid');
		}
		if ($uid != $user->uid) {
			return $this->errMessage(WEIBO_FOLLOW_UID_ERROR, 'ִûǵǰ¼û');
		}
		$attentionService = $this->_getAttentionService();
		if ($attentionService->isFollow($uid, $touid)) {
			return $this->errMessage(WEIBO_USER_ALREADY_FLOLLOW, 'ûѾע');
		}
		if ($attentionService->isInBlackList($touid, $uid)) {
			return $this->errMessage(WEIBO_USER_IN_PRIVACY, 'ûע');
		}
		$attentionService->addFollow($uid, $touid);
		return true;
	}

	/*
     * ע
     * @param int $uid
     * @param int $friendid
     * @return array|int
     */
	function unfollow($uid, $friendid) {
		$user = new apiUserInfo();
		if (!$user->isLogin()) {
			return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		}
        if (intval($uid) <= 0 || intval($friendid) <= 0){
            return $this->errMessage(WEIBO_INVALID_PARAMS,'uid or friendid');
        }
		if ($uid != $user->uid) {
			return $this->errMessage(WEIBO_FOLLOW_UID_ERROR, 'ִûǵǰ¼û');
		}
		$attentionService = $this->_getAttentionService();
		if (!$attentionService->isFollow($uid, $friendid)) {
			return $this->errMessage(WEIBO_USER_NOT_FLOLLOW, 'ûûбע');
		}
		$attentionService->delFollow($uid, $friendid);
		return true;
	}

	/**
	 * ȡ΢
	 * @param Integer $mid
	 * @param Integer $offset
	 * @param Integer $limit
	 * @return Array
	 */
	function getcomments($mid, $offset = 1, $limit = 20) {
		if (intval($mid) <= 0) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'mid');
		}
		require_once (R_P . 'require/showimg.php');
		$data = array();
		$weiboCommentService = $this->_getWeiboCommentService();
		$data = $weiboCommentService->getCommentsByMid($mid, $offset, $limit);
		$comment = $this->_buildComment($data);
		$count = $weiboCommentService->getCommentsCountByMid($mid);
		return array(
			'count' => $count, 
			'comment' => $comment);
	}

	function getcommentslist($mid, $cid, $go = 'up', $limit = 20) {
		if (intval($mid) <= 0) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'mid');
		}
		$weiboCommentService = $this->_getWeiboCommentService();
		$count = $weiboCommentService->getCommentsCountByMid($mid);
		if (!$count) return array(
			'count' => $count, 
			'comment' => array());
		$sql = 'SELECT * FROM pw_weibo_comment WHERE  mid = ' . S::sqlEscape($mid);
		if (!empty($cid)) {
			$sql .= ($go == 'up') ? ' AND cid > ' . S::sqlEscape($cid) . ' ORDER BY cid ASC ' : ' AND cid < ' . S::sqlEscape($cid) . ' ORDER BY cid DESC ';
			$sql .= S::sqlLimit(0, $limit);
		} else {
			$sql .= ' ORDER BY cid DESC ' . S::sqlLimit(0, $limit);
		}
		return $this->_buildWeiboCommentsList($sql, $cid, $go, $weiboCommentService, $count);
	}

	/**
	 * ûյ
	 * @param int $uid | ûID
	 * @param int $offset
	 * @param int $limit
	 * @return array
	 */
	function getusercomments($uid, $offset = 1, $limit = 20) {
		if (intval($uid) <= 0) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid');
		}
		$user = new apiUserInfo();
		if ($user->uid && $user->uid == $uid && $user->info['newcomment'] > 0) {
			$userService = L::loadClass('UserService', 'user');
			$userService->update($user->uid, array(), array(
				'newcomment' => 0));
			$user->info['newcomment'] = 0;
		}
		require_once (R_P . 'require/showimg.php');
		$weiboCommentService = $this->_getWeiboCommentService();
		$data = $weiboCommentService->getUserReceiveComments($uid, $offset, $limit);
		$comment = $this->_buildComment($data);
		$count = $weiboCommentService->getUserReceiveCommentsCount($uid);
		return array(
			'count' => $count, 
			'comment' => $comment);
	}

	function getusercommentslist($uid, $cid, $go = 'up', $limit = 20) {
		if (intval($uid) <= 0) {
			return $this->errMessage(WEIBO_INVALID_PARAMS, 'uid');
		}
		$weiboCommentService = $this->_getWeiboCommentService();
		$count = $weiboCommentService->getUserReceiveCommentsCount($uid);
		if (!$count) return array(
			'count' => $count, 
			'comment' => array());
		$user = new apiUserInfo();
		if ($user->uid && $user->uid == $uid && $user->info['newcomment'] > 0) {
			$userService = L::loadClass('UserService', 'user');
			$userService->update($user->uid, array(), array(
				'newcomment' => 0));
			$user->info['newcomment'] = 0;
		}
		$sql = 'SELECT * FROM pw_weibo_cmrelations a LEFT JOIN pw_weibo_comment b ON a.cid = b.cid 
			WHERE a.uid = ' . s::sqlEscape($uid);
		if (!empty($cid)) {
			$sql .= ($go == 'up') ? ' AND a.cid > ' . S::sqlEscape($cid) . ' ORDER BY a.cid ASC ' : ' AND a.cid < ' . S::sqlEscape($cid) . ' ORDER BY a.cid DESC ';
			$sql .= S::sqlLimit(0, $limit);
		} else {
			$sql .= ' ORDER BY a.cid DESC ' . S::sqlLimit(0, $limit);
		}
		return $this->_buildWeiboCommentsList($sql, $cid, $go, $weiboCommentService, $count);
	}

	/**
	 * @param cid
	 * @param go
	 * @param weiboCommentService
	 * @param count
	 */
	private function _buildWeiboCommentsList($sql, $cid, $go, $weiboCommentService, $count) {
		$result = array();
		$query = $this->db->query($sql);
		while ($rt = $this->db->fetch_array($query)) {
			$result[] = $rt;
		}
		require_once (R_P . 'require/showimg.php');
		$result = $weiboCommentService->_buildData($result, true);
		$result = $this->_filterComment($result);
		!empty($cid) && $go == 'up' && krsort($result);
		return array(
			'count' => $count, 
			'comment' => $result);
	}

	/**
	 * ΢
	 * @param Integer $uid
	 * @param Integer $mid
	 * @param Integer $content
	 * @param Array $extra
	 * @return Integer
	 */
	function comment($uid, $mid, $content, $ifsendweibo = false, $extra = array()) {
		if (intval($mid) <= 0 || intval($uid) <= 0 || empty($content)) return $this->errMessage(WEIBO_INVALID_PARAMS, 'mid or uid or content');
		$userInfo = new apiUserInfo();
		if ($userInfo->uid != $uid) return $this->errMessage(USER_NOT_LOGIN, 'ûδ¼');
		$weiboCommentService = $this->_getWeiboCommentService();
		if (($status = $weiboCommentService->commentCheck($content)) !== true) return $this->errMessage(WEIBO_INVALID_PARAMS, 'invalid params');
		require_once R_P . 'require/showimg.php';
		if (!$weiboCommentService->comment($uid, $mid, $content, $extra)) return $this->errMessage(WEIBO_COMMENT_SEND_FAIL, 'ʧ');
		/* ظɹ΢Ϣ */
		$weiboService = $this->_getWeiboService();
		$weiboService->updateCountNum(array(
			'replies' => 1), $mid);
		if ($ifsendweibo) {
			if (($weiboStatus = $weiboService->sendCheck($content, $userInfo->groupid)) !== true) {
				$this->errMessage(0, $weiboStatus);
			}
			$weiboService->send($uid, $content, 'transmit', $mid, array());
			$weiboService->updateCountNum(array(
				'transmit' => 1), $mid);
		}
		return true;
	}

	function _buildComment($data) {
		$comment = array();
		require_once(D_P.'data/bbscache/level.php');
		foreach ($uinfo as $key => $value){
			$uinfo[$key]['level'] = $ltitle[$value['groupid']];
		}
		foreach ($data as $key => $item) {
			$item['weibo']['groupid'] == '-1' && $item['weibo']['groupid'] = $item['weibo']['memberid'];
			$item['weibo']['level'] = $ltitle[$item['weibo']['groupid']];
			$_weibo = array('mid'=>$item['weibo']['mid'],'uid'=>$item['weibo']['uid'],'content'=>$item['weibo']['content'],'username'=>$item['weibo']['username'],'icon' => $item['icon'],'level' => $item['weibo']['level'], 'postdate' => $item['weibo']['postdate']);
			$item['icon'] = str_replace('/middle/','/small/',$item['icon']);
			$comment[] = array(
				'mid' => $item['mid'], 
				'cid' => $item['cid'], 
				'uid' => $item['uid'], 
				'username' => $item['username'], 
				'icon' => $item['icon'], 
				'content' => $item['content'], 
				'extra' => $item['extra'], 
				'postdate' => $item['postdate'], 
				'weibo' => $_weibo);
		}
		return $comment;
	}

	function _filterComment($data) {
		$comment = array();
		foreach ($data as $key => $item) {
			$_weibo = array('mid'=>$item['weibo']['mid'],'uid'=>$item['weibo']['uid'],'content'=>$item['weibo']['content'],'username'=>$item['weibo']['username'],'icon' => $item['weibo']['icon'],'level' => $item['weibo']['level'], 'postdate' => $item['weibo']['postdate'], 'gender' => $item['weibo']['gender']);
			if ($item['weibo']['type'] == 1) {
				$_weibo = array_merge($_weibo,array('type'=>$item['weibo']['type'],'transmits'=>$item['weibo']['transmits']));
			}
			$item['icon'] = str_replace('/middle/','/small/',$item['icon']);
			$comment[] = array(
				'mid' => $item['mid'], 
				'cid' => $item['cid'], 
				'uid' => $item['uid'], 
				'username' => $item['username'], 
				'icon' => $item['icon'], 
				'content' => $item['content'], 
				'extra' => $item['extra'], 
				'postdate' => $item['postdate'], 
				'weibo' => $_weibo);
		}
		return $comment;
	}


	/**
	 * @return PW_Comment
	 */
	function _getWeiboCommentService() {
		require_once(R_P . 'mclientapi/library/weibocomment.class.php');
		$weibocommentObj = new PW_MWeibocomment();
		return $weibocommentObj;
	}

	/**
	 * @return PW_Weibo
	 */
	function _getWeiboService() {
		//return L::loadClass('weibo', 'sns');
		require_once(R_P . 'mclientapi/library/weibo.class.php');
		$weiboObj = new PW_MWeibo();
		return $weiboObj;
	}

	/**
	 * @return PW_Attention
	 */
	function _getAttentionService() {
		return L::loadClass('Attention', 'friend');
	}
}