<?php
!defined('P_W') && exit('Forbidden');
require_once(R_P . 'require/common.php');
S::filter();

register_shutdown_function('errorHandle');

list($wind_version,$wind_repair,$wind_from) = explode(',',WIND_VERSION);
require_once(D_P . 'data/sql_config.php');
if ($database == 'mysqli' && Pwloaddl('mysqli') === false) {
	$database = 'mysql';
}
require_once S::escapePath(R_P . "require/db_$database.php");
require_once(D_P . 'data/bbscache/config.php');
require_once 'library/common.php';

$db          = new DB($dbhost, $dbuser, $dbpw, $dbname, $PW, $charset, $pconnect);
$timestamp   = getTimestamp();
$db_bbsurl   = getBbsUrl();
$attachpath  = getAttachPath();
$imgpath     = getImgPath($db_bbsurl);
$onlineip    = pwGetIp();
$imgdir		 = R_P . $db_picpath;
$attachdir	 = R_P . $db_attachname;
$_time		= array('hours'=>get_date($timestamp,'G'),'day'=>get_date($timestamp,'j'),'week'=>get_date($timestamp,'w'));

require_once 'library/request.class.php';
require_once(O_P . 'library/openapi.class.php');
$efone_key = L::config('efone_key','efone_config');
$openApi = new OpenApi($efone_key,$db_charset);
echo $openApi->response(new Request);


function errorHandle() {
	$handleType = array(E_ERROR, E_PARSE);
	if (function_exists('error_get_last')) {
		$error = error_get_last();
		if (!in_array($error['type'], $handleType))
			return;
	   	ob_clean();
   		if (is_object($GLOBALS['openApi']))
			$openApi = $GLOBALS['openApi'];
		else
			$openApi = new OpenApi($GLOBALS['db_siteownerid'], $GLOBALS['db_charset']);
   		echo $openApi->errMessage(API_FATAL_ERROR, $error['message']);
  	}
}

/**
 * չ
 *
 * @param string $module չģ
 * @param string $checkFunction ⺯
 * @return bool
 */
function Pwloaddl($module, $checkFunction = 'mysqli_get_client_info') {
	return extension_loaded($module) && $checkFunction && function_exists($checkFunction) ? true : false;
}