<?php
!defined('P_W') && exit('Forbidden');
class BaseApi {
	var $db;
	var $timestamp;
	var $openApi;
	var $_logDir;
	var $_logEnable = true;
	/**
	 * @var Logger
	 */
	var $_logger = null;

	function addLog($msg, $type = '') {
		if (!$this->_logEnable) return;
		if ($this->_logger === null) {
			require_once R_P . 'mclientapi/library/logger.class.php';
			$this->_logger = new Logger();
			$this->_logger->setLogFile(D_P . 'data/log.txt');
		}
		$this->_logger->info($msg, $type);
	}

	function BaseApi($openApi) {
		$this->timestamp = $GLOBALS['timestamp'];
		$this->db = & $GLOBALS['db'];
		$this->openApi = $openApi;
		$this->init();
	}

	function init() {}

	function errMessage($errCode, $errMesssage) {
		return array('errCode' => $errCode, 'errMessage' => $errMesssage);
	}

	function initUserGroupInfo($uid) {
		global $groupid, $_G;
		$userService = L::loadClass('UserService', 'user');
		$userInfo = $userService->get($uid);
		$groupid = $userInfo['groupid'];
		$groupid == '-1' && $groupid = $userInfo['memberid'];
		if ($groupid == 'guest') {
			require_once (D_P . 'data/groupdb/group_2.php');
		} elseif (file_exists(D_P . "data/groupdb/group_$groupid.php")) {
			require_once S::escapePath(D_P . "data/groupdb/group_$groupid.php");
		} else {
			require_once (D_P . 'data/groupdb/group_1.php');
		}
	}

	function _sqlIn($ids) {
		return (is_array($ids) && $ids) ? ' IN (' . S::sqlImplode($ids) . ')' : '=' . S::sqlEscape($ids);
	}
}