<?php
/**
 * ȡļ
 *
 * @param string $file
 */
function includefile($file) {
	if ($GLOBALS['wind_version'] && $GLOBALS['wind_version'] < '8.5') {
		include_once ($file);
	} else {
		pwCache::getData($file);
	}
}
function GetLang($lang, $EXT = 'php') {
	$tplpath = L::style('tplpath');
	$tplpath || $tplpath = 'wind';
	if (file_exists(R_P . "template/$tplpath/lang_$lang.$EXT")) {
		return R_P . "template/$tplpath/lang_$lang.$EXT";
	} elseif (file_exists(R_P . "template/wind/lang_$lang.$EXT")) {
		return R_P . "template/wind/lang_$lang.$EXT";
	} else {
		exit("Can not find lang_$lang.$EXT file");
	}
}

function getBbsUrl() {
	global $pwServer, $db_dir;
	$dirstrpos = strpos($pwServer['PHP_SELF'], $db_dir);
	if ($dirstrpos !== false) {
		$tmp = substr($pwServer['PHP_SELF'], 0, $dirstrpos);
		$pwServer['PHP_SELF'] = "$tmp.php";
	} else {
		$tmp = $pwServer['PHP_SELF'];
	}
	return S::escapeChar("http://" . $pwServer['HTTP_HOST'] . substr($tmp, 0, strrpos($tmp, '/')));
}

function getAttachPath() {
	global $db_attachurl, $db_bbsurl, $db_attachname;
	return ($db_attachurl != 'N') ? $db_attachurl : ($db_bbsurl . '/' . $db_attachname);
}

function getImgPath($bbsUrl) {
	global $db_http, $db_picpath;
	return ($db_http != 'N') ? $db_http : ($bbsUrl . '/' . $db_picpath);
}

function getTimestamp() {
	global $db_cvtime;
	return ($db_cvtime != 0) ? (time() + $db_cvtime * 60) : time();
}

function encryptString($string, $encode = true) {
	global $db_siteownerid;
	!$encode && $string = base64_decode($string);
	$code = '';
	$key = substr(md5(md5($db_siteownerid)), 8, 18);
	$keylen = strlen($key);
	$strlen = strlen($string);
	for ($i = 0; $i < $strlen; $i++) {
		$k = $i % $keylen;
		$code .= $string[$i] ^ $key[$k];
	}
	return ($encode ? base64_encode($code) : $code);
}

function isAllowMethod($httpMethod = 'GET') {
	global $pwServer;
	if (($pwServer['REQUEST_METHOD'] == 'POST' && strtolower($httpMethod) == 'post') || ($pwServer['REQUEST_METHOD'] != 'POST' && strtolower($httpMethod) == 'get'))
		return true;
	return false;
}

function Showmsg($msg_info) {
	global $openApi;
	$msg_info = getLangInfo('msg', $msg_info);
	echo $openApi->errMessage(-1, $msg_info);
	exit();
}

function mShowface($message) {
	global $face, $db_cvtimes;
	include_once (D_P . 'data/bbscache/postcache.php');
	$message = preg_replace("/\[s:(.+?)\]/eis", "mPostcache('\\1')", $message);
	return $message;
}

function mPostcache($key) {
	global $face, $imgpath, $tpc_author;
	is_array($face) && !$face[$key] && $face[$key] = current($face);
	if ($face[$key][2]) {
		return "<br /><img src=$imgpath/post/smile/{$face[$key][0]} text='[s=$key]'/><br />[<span class=\"s1 b\">$tpc_author</span>] {$face[$key][2]}<br />";
	} else {
		return "<img src=\"$imgpath/post/smile/{$face[$key][0]}\" smile=\"1\" text='[s=$key]'/>";
	}
}

function UnMShowFace($facename) {
	global $face;
	foreach ($face as $key => $value) {
		if ($value[0] == $facename) {
			$faceId = $key;
			break;
		}
	}
	return '[s:' . $faceId . ']';
}

/**
 * ״̬
 *
 * @param int $status
 * @param int $b
 * @param string $setv
 */
function setstatus(&$status, $b, $setv = '1') {
	--$b;
	for ($i = strlen($setv) - 1; $i >= 0; $i--) {
		if ($setv[$i]) {
			$status |= 1 << $b;
		} else {
			$status &= ~(1 << $b);
		}
		++$b;
	}
	//return $status;
}

class apiUserInfo {

	var $_db;
	var $uid;
	var $username;
	var $groupid;
	var $info = array();

	var $_G;
	var $_SYSTEM;
	var $_gp_gptype;

	function apiUserInfo($rights = array()) {
		$this->_db = & $GLOBALS['db'];
		$this->_G = null;
		$this->init($rights);
	}

	function getUserByUid($uid, $rights) {
		$sqladd = $sqltab = '';
		if ($rights) {
			$sqladd = ',sr.' . implode(',sr.', $rights);
			$sqltab = "LEFT JOIN pw_singleright sr ON m.uid=sr.uid";
		}
		$detail = $this->_db->get_one("SELECT m.uid,m.username,m.password,m.safecv,m.email,m.bday,m.oicq,m.groupid,m.memberid,m.groups,m.icon,m.regdate,m.honor,m.timedf, m.style,m.datefm,m.t_num,m.p_num,m.yz,m.newpm,m.userstatus,m.shortcut,m.medals,md.lastmsg,md.postnum,md.rvrc,md.money,md.credit,md.currency,md.lastvisit,md.thisvisit,md.onlinetime,md.lastpost,md.todaypost,md.monthpost,md.onlineip,md.uploadtime,md.uploadnum,md.starttime,md.pwdctime,md.monoltime,md.digests,md.f_num,md.creditpop,md.jobnum,md.lastgrab,md.follows,md.fans,md.newfans,md.newreferto,md.newcomment,md.postcheck $sqladd FROM pw_members m LEFT JOIN pw_memberdata md ON m.uid=md.uid $sqltab WHERE m.uid=" .
			S::sqlEscape($uid) . " AND m.groupid<>'0' AND md.uid IS NOT NULL");
		return $detail;
	}

	function init($rights) {
		global $winduid, $windid, $groupid, $winddb;
		list($uid, $password) = explode("\t", StrCode(GetCookie('winduser'), 'DECODE'));
		if ($uid && ($detail = $this->getUserByUid($uid, $rights)) && PwdCode($detail['password']) == $password) {
			$this->uid = $uid;
			$this->username = $detail['username'];
			$this->groupid = $groupid = $detail['groupid'] == '-1' ? $detail['memberid'] : $detail['groupid'];
			$detail['groups'] = $detail['groups'] ? explode(',', trim(',', $detail['groups'])) : array();
			list($detail['shortcut'], $detail['appshortcut']) = explode("\t", $detail['shortcut']);
			unset($detail['password']);
			$this->info = $detail;
			$winddb = $detail;
			$winduid = $uid;
			$windid = $this->username;
		} else {
			$this->username = '';
			$this->uid = 0;
			$this->groupid = 'guest';
		}
	}

	function isLogin() {
		return ($this->uid > 0);
	}

	function getRight($vKey) {
		$this->initRight();
		return $this->_G[$vKey];
	}

	function getSystemRight($vKey) {
		$this->initRight();
		return $this->_SYSTEM[$vKey];
	}

	function initRight() {
		global $gp_gptype, $SYSTEM;
		if (!is_null($this->_G))
			return;
		if ($this->groupid == 'guest') {
			require (D_P . 'data/groupdb/group_2.php');
		} elseif (file_exists(D_P . "data/groupdb/group_{$this->groupid}.php")) {
			require S::escapePath(D_P . "data/groupdb/group_{$this->groupid}.php");
		} else {
			require (D_P . 'data/groupdb/group_1.php');
		}
		$this->_G = $_G;
		$this->_SYSTEM = $SYSTEM;

		$this->_gp_gptype = $gp_gptype;
	}

	function allowcheck($allowgroup, $fid = 0, $singleRinght = '') {
		if (empty($allowgroup) || strpos($allowgroup, ",{$this->groupid},") !== false) {
			return true;
		}
		if (S::inArray($this->username, $GLOBALS['manager'])) {
			return true;
		}
		if ($this->info['groups']) {
			foreach ($this->info['groups'] as $value) {
				if (strpos($allowgroup, ",$value,") !== false) {
					return true;
				}
			}
		}
		if ($fid && $singleRinght && $this->info[$singleRinght] && strpos(',' . $this->info[$singleRinght] . ',', ",$fid,") !== false) {
			return true;
		}
		return false;
	}
}
