<?php
!function_exists('readover') && exit('Forbidden');

@set_time_limit(1000);

/**
 * ftp
 *
 * @package FTP
 */
class FTP {
	
	var $connid;
	var $rootPath;
	function FTP($ftp_server, $ftp_port = 21, $ftp_user, $ftp_pass, $ftp_dir = '', $ftp_timeout = 10) {
		$this->connid = ftp_connect($ftp_server, $ftp_port, $ftp_timeout);
		ftp_login($this->connid, $ftp_user, $ftp_pass);
		$this->rootPath = ftp_pwd($this->connid);
		return true;
	}
	/**
	 * ļ޸ʱ
	 *
	 * @param unknown_type $file
	 * @return unknown
	 */
	function filemtime($file) {
		$buff = ftp_mdtm($this->connid, $this->rootPath . '/' . $file);
		if ($buff != -1) {
			return $buff;
		} else {
			return FALSE;
		}
	}
	/**
	 * ļ
	 *
	 * @param unknown_type $localfile
	 * @param unknown_type $remotefile
	 * @return unknown
	 */
	function get($localfile, $remotefile) {
		$remotefile = $this->rootPath . '/' . $remotefile;
		$handle = fopen($localfile, 'w+');
		if (ftp_fget($this->connid, $handle, $remotefile, FTP_ASCII, 0)) {
			fclose($handle);
			return TRUE;
		} else {
			fclose($handle);
			return FALSE;
		}
	
	}
	/**
	 * Ŀ¼
	 *
	 * @param unknown_type $dir
	 * @return unknown
	 */
	function mkdir($dir) {
		if (ftp_mkdir($this->connid, $this->rootPath . '/' . $dir)) {
			return TRUE;
		} else {
			return FALSE;
		}
	}
	function put($localfile, $remotefile) {
		$fp = fopen($localfile, 'r');
		$directory = substr($remotefile, 0, strrpos($remotefile, '/'));
		$filename = str_replace("$directory/", '', $remotefile);
		$directory = $this->rootPath.'/'.$directory;
		$remotefile = $directory.'/'.$filename;
		//ftp_chdir($this->connid, $directory);
		if (ftp_fput($this->connid, $remotefile, $fp, FTP_ASCII)) {
			$return = TRUE;
		} else {
			echo 'ftp upload fail:'.$remotefile.'|'.$filename.'|'.$localfile;
			die();
			$return = FALSE;
		}
		fclose($fp);
		return $return;
	}
	/**
	 * 
	 *
	 */
	function close() {
		ftp_close($this->connid);
	}
}
?>