<?php
!defined('P_W') && exit('Forbidden');
define('API_CLOSED', 1);
define('API_CLASS_NOT_EXISTS', 2);
define('API_METHOD_NOT_EXISTS', 3);
define('API_HTTP_METHOD_NOT_MATCH', 4);
define('USER_NOT_LOGIN', 5);
define('API_FATAL_ERROR', 6);
define('SYSTEM_ERROR', 7);
define('API_SIGN_ERROR', 8);
define('TIME_OUT', 9);

require_once R_P . 'lib/utility/json.class.php';
require_once 'apixml.class.php';
require_once 'base.class.php';

class OpenApi {
	var $charset;
	var $apikey;
	var $classdb;
	var $format;
	var $json;
	var $log = true;
	var $_logger = null;
	var $openDefend = true;//Ƿȫ
	
	function OpenApi($siteownerid, $charset) {
		$this->charset = $charset;
		$this->apikey = $siteownerid;
		$this->classdb = array();
		$this->format = 'json';
		$this->json = new Services_JSON(true);
	
	}
	
	function response($requestObject) {
		if (!$this->config('ifopen')) {
			return $this->errMessage(API_CLOSED, 'ֻͻ˽ӿڹر');
		}
		$request = $this->_stripSlash($requestObject->getRequest());
		empty($request['format']) && $request['format'] = 'json';
		if (isset($request['format']) && in_array(strtolower($request['format']), array('xml', 'json'))) {
			$this->setFormat($request['format']);
		}
		header("Content-Type:application/" . $this->format . "; charset=gbk");
		ksort($request);
		reset($request);
		/**
		 * add by yanghexiang
		 */
		$activeKey = '';
		$defendAction = array('thread.post', 'thread.reply');
		if (in_array($callback, $defendAction)) {
			require_once 'activekey.class.php';
			$activeKeyClass = new ActiveKey();
			if ($this->openDefend === TRUE) {
				$activeKey = $activeKeyClass->get(); //ȡacktiveKey
				if(empty($activeKey)){
					return $this->errMessage(TIME_OUT,'ʱûвύ');
				}
				$activeKeyClass->set(); //activeKey
			} else {
				$activeKeyClass->delete();
			}
		}
		//end by yanghexiang
		$arg = 'callback=' . $request['callback'] . '&params=' . $request['params'];
		if (empty($this->apikey) || md5($activeKey . $arg . '&' . $this->apikey) != $request['sign'] && $request['callback'] != 'site.mobileversion') {
			return $this->errMessage(API_SIGN_ERROR, 'ǩ֤');
		}
		$callback = $request['callback'];
		$params = isset($request['params']) ? $this->json->decode($request['params']) : array();
		$params = (array) $params;
		if ($this->log) {
			if ($this->_logger === null) {
				require_once R_P . 'mclientapi/library/logger.class.php';
				$this->_logger = new Logger();
				$this->_logger->setLogFile(D_P . 'data/log.txt');
			}
			$this->_logger->info(pw_var_export($request), 'openapi.response');
		}
		$requestCharset = '';
		empty($request['charset']) && $request['charset'] = 'utf8';
		if ($params && isset($request['charset'])) {
			$params = pwConvert($params, $this->charset, $request['charset']);
		}
		$request['charset'] && $requestCharset = $request['charset'];
		return $this->callback($callback, $params, $requestCharset);
	}
	
	function callback($callback, $params, $requestCharset) {
		$callbackArr = explode('.', $callback);
		$method = array_pop($callbackArr);
		$method = str_replace('_','',$method);//˽з
		$classFile = array_pop($callbackArr);
		$classDir = !empty($callbackArr) ? str_replace('.', '/', implode('.', $callbackArr)) . '/' : '';
		$class = $classDir ? str_replace('/', '_', $classDir) . $classFile : $classFile;
		$classPath = O_P . 'api/' . $classDir . strtolower($classFile) . '.class.php';
		$class = $class . 'Api';
		if (!isset($this->classdb[$class])) {
			if (!file_exists($classPath)) {
				return $this->errMessage(API_CLASS_NOT_EXISTS, "($class)");
			}
			require_once S::escapePath($classPath);
			$this->classdb[$class] = new $class($this);
		}
		if (!method_exists($this->classdb[$class], $method)) {
			return $this->errMessage(API_METHOD_NOT_EXISTS, "ӿ($method of $class) ");
		}
		$httpMethod = isset($this->classdb[$class]->methodsType[$method]) ? $this->classdb[$class]->methodsType[$method] : 'GET';
		if (!isAllowMethod($httpMethod)) {
			return $this->errMessage(API_HTTP_METHOD_NOT_MATCH, "HTTP Method($method of $class) Not match");
		}
		!is_array($params) && $params = array();
		$return = call_user_func_array(array(&$this->classdb[$class], $method), $params);
		
		if (is_array($return) && $return['errCode']) {
			return $this->errMessage($return['errCode'], $return['errMessage']);
		} elseif ($method == 'mobileversion') {
			return $this->_format(array('response' => $return), $requestCharset);
		} else {
			return $this->_infoFormat($return, $requestCharset);
		}
	}
	
	function errMessage($errCode, $errMesssage) {
		return $this->_format(array('errCode' => $errCode, 'errMessage' => $errMesssage), 'utf8');
	}
	
	function setFormat($format) {
		$this->format = strtolower($format);
	}
	
	function config($vKey) {
		return L::config('efone_' . $vKey, 'efone_config');
	}
	
	function _infoFormat($data, $requestCharset) {
		if (gettype($data) == 'boolean') {
			$data = $data ? 'true' : 'false';
		}
		return $this->_format(array('errCode' => '0', 'info' => $data), $requestCharset);
	}
	
	function _format($data, $requestCharset = '') {
		if (!empty($requestCharset)) {
			$data = pwConvert($data, $requestCharset, $this->charset);
		}
		$data = $this->_escapeStrDecodeArray($data);
		$charset = empty($requestCharset) ? $this->charset : $requestCharset;
		if ($this->format == 'xml') {
			$array2xml = new Array2Xml($data, $charset);
			return $array2xml->getXml();
		}
		return $this->json->encode($data);
	}
	
	function _stripSlash($param) {
		if (is_array($param)) {
			foreach ($param as $key => $value) {
				$param[$key] = $this->_stripSlash($value);
			}
		} else {
			$param = stripslashes($param);
		}
		return $param;
	}
	
	function _escapeStrDecodeArray($param) {
		if (is_array($param)) {
			foreach ($param as $key => $value) {
				$param[$key] = $this->_escapeStrDecodeArray($value);
			}
		} else {
			$param = $this->_escapeStrDecode($param);
		}
		return $param;
	}
	/**
	 * ַת
	 * @param $string
	 * @return string
	 */
	function _escapeStrDecode($string) {
		$string = str_replace('&lt;', '<', $string);
		$string = str_replace('&gt;', "%3E", $string);
		$string = str_replace(array('&quot;', '&#39;', '    ', '&nbsp;&nbsp;', '&#160;'), array('"', "'", "\t", '  ', ' '), $string);
		return $string;
	}
}