<?php
!defined('P_W') && exit('Forbidden');
define('STATISTICS_NETTYPE_WIFI', 1);
define('STATISTICS_NETTYPE_GPRS', 0);

/**
 * ͳ
 *
 * @package DataAnalyse
 */
class PW_EStatistics {
	
	var $db;
	var $t;
	var $day;
	var $unday;
	var $headerInfo;

	function PW_EStatistics() {
		$this->__construct();
	}

	function __construct() {
		global $db,$timestamp;
		$this->db = & $db;
		$this->t   = $timestamp;
		$this->day = get_date($timestamp, 'Y-m-d');
		$this->month = get_date($timestamp,'Y-m').'-00';
		$this->unday = '0000-00-00';
		$this->headerInfo = S::getServer('HTTP_INFO');
	}

	function add($name,$num = 1) {
		$headerInfo = $this->_getHeaderInfo();
		if(empty($headerInfo)) return false;
		$phonesystem = $this->_getPhoneSystemType($headerInfo['SYS']);
		$mobileOperator = $headerInfo['NT'] == 0 ? $this->_getMobileOperator($headerInfo['PN']) : 0;
		$this->_add($name, $num, $headerInfo['NT'], $headerInfo['PT'], $phonesystem, $mobileOperator,$this->day);
	}

	function addByNettypeMonth($name,$netType,$num) {
		$headerInfo = $this->_getHeaderInfo();
		if(empty($headerInfo)) return false;
		$phonesystem = $this->_getPhoneSystemType($headerInfo['SYS']);
		$mobileOperator = $netType == 0 ? $this->_getMobileOperator($headerInfo['PN']) : 0;
		$this->_addMonth($name, $num, $netType, $headerInfo['PT'], $phonesystem, $mobileOperator,$this->month);
	}


	function addMonth($name,$num = 1) {
		global $pwSderver;
		$headerInfo = $this->_getHeaderInfo();
		if(empty($headerInfo)) return false;
		$phonesystem = $this->_getPhoneSystemType($headerInfo['SYS']);
		$mobileOperator = $headerInfo['NT'] == 0 ? $this->_getMobileOperator($headerInfo['PN']) : 0;
		$this->_addMonth($name, $num, $headerInfo['NT'], $headerInfo['PT'], $phonesystem, $mobileOperator,$this->month);
	}

	function _getHeaderInfo() {
		$array = array();
		$headerInfo = explode(';',$this->headerInfo);
		foreach ($headerInfo as $key => $value) {
			list($k,$v) = explode('=',$value);
			$result[$k] = $v;
		}
		$result = $this->_filterHeaderInfo($result);
		return $result;
	}

	function _getMobileOperator($name) {
		$mobileOperator = array('46000' => 1, '46002' => 1, '46007' => 1, '46001' => 2, '460003' => 3, '46003' => 3);
		return $mobileOperator[$name];
	}

	function _filterHeaderInfo($headerInfo) {
		$filter = array('SYS','IP','NT','PT','PN');
		foreach ($headerInfo as $key => $value) {
			if (!in_array($key,$filter)) continue;
			$result[$key] = $value;
		}
		return $result;
	}

	function _getPhoneSystemType($name) {
		$name = strtolower($name);
		$phone = array('android' => 1, 'iphone' => 2);
		return $phone[$name];
	}
    
	function _add($name, $num, $network, $phonetype, $phonesystem,$mobileoperator,$date) {
		$num = intval($num);
		$this->db->pw_update(
			'SELECT * FROM pw_efone_statistics WHERE name=' . pwEscape($name) . ' AND network=' . pwEscape($network) . ' AND phonetype=' . pwEscape($phonetype) . ' AND phonesystem= ' . pwEscape($phonesystem). ' AND mobileoperator=' . pwEscape($mobileoperator) . ' AND date=' . pwEscape($date),
			"UPDATE pw_efone_statistics SET value=value+$num,updatetime=" . pwEscape($this->t) . ' WHERE name=' . pwEscape($name) . ' AND network=' . pwEscape($network) . ' AND phonetype=' . pwEscape($phonetype) . ' AND phonesystem=' . pwEscape($phonesystem). ' AND mobileoperator=' . pwEscape($mobileoperator) . ' AND date=' . pwEscape($date),
			"REPLACE INTO pw_efone_statistics SET " . pwSqlSingle(array(
				'name' => $name,
				'network ' => $network,
				'phonetype ' => $phonetype,
				'phonesystem' => $phonesystem,
				'mobileoperator' => $mobileoperator,
				'date ' => $date ,
				'value' => $num,
				'updatetime' => $this->t
			))
		);
	}

	function _addMonth($name, $num, $network, $phonetype, $phonesystem,$mobileoperator,$date) {
		$num = intval($num);
		$this->db->pw_update(
			'SELECT * FROM pw_efone_statistics_month WHERE name=' . pwEscape($name) . ' AND network=' . pwEscape($network) . ' AND phonetype=' . pwEscape($phonetype) . ' AND phonesystem= ' . pwEscape($phonesystem). ' AND mobileoperator=' . pwEscape($mobileoperator) . ' AND date=' . pwEscape($date),
			"UPDATE pw_efone_statistics_month SET value=value+$num,updatetime=" . pwEscape($this->t) . ' WHERE name=' . pwEscape($name) . ' AND network=' . pwEscape($network) . ' AND phonetype=' . pwEscape($phonetype) . ' AND phonesystem= ' . pwEscape($phonesystem). ' AND mobileoperator=' . pwEscape($mobileoperator) . ' AND date=' . pwEscape($date),
			"REPLACE INTO pw_efone_statistics_month SET " . pwSqlSingle(array(
				'name' => $name,
				'network ' => $network,
				'phonetype ' => $phonetype,
				'phonesystem' => $phonesystem,
				'mobileoperator' => $mobileoperator,
				'date ' => $date ,
				'value' => $num,
				'updatetime' => $this->t
			))
		);
	
	}
}
?>