<?php
!defined('P_W') && exit('Forbidden');

require_once(R_P . 'lib/sns/weibo.class.php');
/**
 * SERVICE
 * 
 * @package PW_Weibo
 * @author suqian && sky_hold@163.com
 */
class PW_MWeibo extends pw_Weibo {

	var $_map = array();
	var $_mapflip = array();
	var $_mapDescript = array();
	var $_timestamp = 0;

	function __construct(){
		parent::__construct();
	}

	function PW_Weibo(){
		$this->__construct();
	}

	function buildData($data, $field = 'uid'){
		$uids = $tids = $tArr = array();
		foreach ($data as $key => $value) {
			$uids[] = $value[$field];
			$type = $this->getType($value['type']);
			if ($type == 'transmit' && $value['objectid']) {
				$tids[] = $value['objectid'];
			}
			
			$data[$key]['content'] = strip_tags($value['content'],'<a>');
		}
		if ($tids) {
			$tArr = $this->getWeibosByMid($tids);
			$uids = array_merge($uids, $this->_getFieldOfRecords($tArr, 'uid'));
		}
		
		$uinfo = $this->_getUserInfo($uids);
		$uinfo = $this->_bulidUinfoForLevel($uinfo);
		$uinfo = $this->_cleanUserInfo($uinfo);
		
		$weiboplatform = is_dir(R_P.'lib/sns/weiboplatform');
		if ($weiboplatform){
			/* platform weibo app */
			$siteBindService = L::loadClass('WeiboSiteBindService', 'sns/weibotoplatform/service'); /* @var $siteBindService PW_WeiboSiteBindService */
			if ($siteBindService->isOpen()) {
				$userBindService = L::loadClass('WeiboUserBindService', 'sns/weibotoplatform/service'); /* @var $userBindService PW_WeiboUserBindService */
				$usersBindInfo = $userBindService->getUsersLocalBindInfo(array_keys($uinfo));
			}
		}
		
		foreach ($data as $key => $value) {
			$value = $this->_formatRecord($value, $uinfo[$value[$field]]['groupid']);
			$type = $this->getType($value['type']);
			if ($type == 'transmit' && ($transmit = $tArr[$value['objectid']])) {
				$value['transmits'] = array_merge((array) $this->_formatRecord($transmit, $uinfo[$transmit['uid']]['groupid']), (array)$uinfo[$transmit['uid']]);

			}
			!is_array($uinfo[$value[$field]]) && $uinfo[$value[$field]] = array();
			$data[$key] = array_merge((array)$value, $uinfo[$value[$field]]);
			
			/* platform weibo app */
			if ($weiboplatform){
				if ($siteBindService->isOpen() && $siteBindService->isBind($type)) {
					$data[$key]['bindUserInfo'] = $usersBindInfo[$type][$value[$field]]['info'];
					$data[$key]['bindSiteInfo'] = $siteBindService->getBindType($type);
					$data[$key]['bindUserInfo']['url'] = $data[$key]['bindSiteInfo']['uidUrlPrefix'] . $data[$key]['bindUserInfo']['id'];
					if (isset($data[$key]['extra']['sinaPhotos'])) $data[$key]['extra']['photos'] = $data[$key]['extra']['sinaPhotos']; //for compatible
				}
			}
		}
		return $data;
	}

	function _bulidUinfoForLevel($uinfo) {
		require_once(D_P.'data/bbscache/level.php');
		foreach ($uinfo as $key => $value){
			$value['groupid'] == '-1' && $value['groupid'] = $value['memberid'];
			$uinfo[$key]['level'] = $ltitle[$value['groupid']];
		}
		return $uinfo;
	}

	function _cleanUserInfo($userInfo){
		$unset = array('email','registertime','introduce','oicq','aliww','icq','msn','yahoo','website','isverified','groupid','memberid','groups','regdate','signature','site','location','honor','lastaddrst','yz','timedf','style','datefm','t_num','p_num','attach','hack','newpm','banpm','msggroups','medals','userstatus','shortcut','authmobile','realname','apartment','home');
		foreach ($userInfo as $key=>$user) {
			foreach ($unset as $value) {
				unset($user[$value]);
			}
			$userInfo[$key] = $user;
		}
		return $userInfo;
	}

	function _formatRecord($value, $gid) {
		list($value['lastdate'], $value['postdate_s']) = getLastDate($value['postdate']);
		$value['extra'] = $value['extra'] ? unserialize($value['extra']) : array();
		!$value['authorid'] && $value['authorid'] = $value['uid'];
		if ($gid == '6') {
			if (isset($value['extra']['title'])) {
				$value['extra']['title'] = "<span style=\"color:black;background-color:#ffff66\">ѱԱΣ</span>";
				$value['content'] = '';
			} else {
				$value['content'] = "<span style=\"color:black;background-color:#ffff66\">ѱԱΣ</span>";
			}
			isset($value['extra']['photos']) && $value['extra']['photos'] = array();
		} else {
			$value['content'] = $this->_parseContent($value['content'], $value['extra']);
		}
		return $value;
	}

	/**
	 * 
	 * @param string $content 
	 * @param array $extra չϢ
	 * return string
	 */
	function _parseContent($content, &$extra) {
		global $topic;
		$this->_hasVideo = array();
		$content = $this->_parseLink($content);
		if ($this->_hasVideo) {
			$extra['_hasVideo'] = $this->_hasVideo;
		}
		if (strpos($content,'[s:') !== false && strpos($content,']') !== false) {
			require_once (R_P . 'mclientapi/library/msmileparser.class.php');
			$sParse = new PW_MSmileParser();
			$content = $sParse->parse($content);
		}
		
		if ($topic && !$extra['topics']) {
			$content = strip_tags($content);
			$content = preg_replace('/' . preg_quote($topic,'/') . '/i', "<span class='s2'>$topic</span>", $content);
		}
		return $content;
	}

	function _parseWebUrl($url) {
		global $db_dir,$db_ext;
		if (preg_match('/u\.php\?uid=(\d*)$/i', $url, $matches)) {
			return '<topic type="3" id="'.$matches[1].'">'.$url.'</topic>';
		} elseif (preg_match('/read\.php\?tid=(\d*)#?(\d*)(.*)?/i', $url, $matches) || preg_match('/read'.$db_dir.'tid-(\d*)'.$db_ext.'#?(\d*)(.*)?/i', $url, $matches)) {
			return '<topic type="1" id="'.$matches[1].','.$matches[2].'">'.$url.'</topic>';
		} elseif (preg_match('/thread\.php\?fid=(\d*)(.*)/i', $url, $matches) || preg_match('/thread'.$db_dir.'fid-(\d*)(.*)/i', $url, $matches)) {
			return '<topic type="2" id="'.$matches[1].'">'.$url.'</topic>';
		} 
		return '<a href="' . $url . '" target="_blank">' . $url . '</a>';
	}
}
?>