/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.backends.android;

import android.os.Build;
import android.os.Bundle;
import android.service.wallpaper.WallpaperService;
import android.util.Log;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import com.badlogic.gdx.ApplicationListener;
import com.badlogic.gdx.backends.android.AndroidApplicationConfiguration;
import com.badlogic.gdx.backends.android.AndroidGraphicsLiveWallpaper;
import com.badlogic.gdx.backends.android.AndroidLiveWallpaper;
import com.badlogic.gdx.backends.android.surfaceview.GLBaseSurfaceViewLW;

public abstract class AndroidLiveWallpaperService
extends WallpaperService {
    final String TAG = "AndroidLiveWallpaperService";
    static boolean DEBUG = false;
    protected static volatile int runningEngines = 0;

    public void onCreate() {
        if (DEBUG) {
            Log.d((String)"AndroidLiveWallpaperService", (String)" > LibdgxWallpaperService - onCreate()");
        }
        super.onCreate();
    }

    public WallpaperService.Engine onCreateEngine() {
        return new AndroidWallpaperEngine();
    }

    public abstract ApplicationListener createListener(boolean var1);

    public abstract AndroidApplicationConfiguration createConfig();

    public abstract void offsetChange(ApplicationListener var1, float var2, float var3, float var4, float var5, int var6, int var7);

    public void onDestroy() {
        if (DEBUG) {
            Log.d((String)"AndroidLiveWallpaperService", (String)" > LibdgxWallpaperService - onDestroy()");
        }
        super.onDestroy();
    }

    public class AndroidWallpaperEngine
    extends WallpaperService.Engine {
        protected AndroidLiveWallpaper app;
        protected ApplicationListener listener;
        protected GLBaseSurfaceViewLW view;

        public AndroidWallpaperEngine() {
            super((WallpaperService)AndroidLiveWallpaperService.this);
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.this.TAG, (String)(" > MyEngine() " + ((Object)((Object)this)).hashCode()));
            }
        }

        public Bundle onCommand(String pAction, int pX, int pY, int pZ, Bundle pExtras, boolean pResultRequested) {
            if (DEBUG) {
                Log.d((String)"AndroidLiveWallpaperService", (String)(" > onCommand(" + pAction + " " + pX + " " + pY + " " + pZ + " " + pExtras + " " + pResultRequested + ")"));
            }
            return super.onCommand(pAction, pX, pY, pZ, pExtras, pResultRequested);
        }

        public void onCreate(SurfaceHolder surfaceHolder) {
            ++runningEngines;
            if (DEBUG) {
                Log.d((String)"AndroidLiveWallpaperService", (String)(" > onCreate() " + ((Object)((Object)this)).hashCode() + ", running: " + runningEngines));
            }
            super.onCreate(surfaceHolder);
            this.app = new AndroidLiveWallpaper(AndroidLiveWallpaperService.this, this);
            AndroidApplicationConfiguration config = AndroidLiveWallpaperService.this.createConfig();
            this.listener = AndroidLiveWallpaperService.this.createListener(this.isPreview());
            this.app.initialize(this.listener, config);
            this.view = ((AndroidGraphicsLiveWallpaper)this.app.getGraphics()).getView();
            if (config.getTouchEventsForLiveWallpaper && Integer.parseInt(Build.VERSION.SDK) < 9) {
                this.setTouchEventsEnabled(true);
            }
        }

        public void onDestroy() {
            --runningEngines;
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.this.TAG, (String)(" > onDestroy() " + ((Object)((Object)this)).hashCode() + ", running: " + runningEngines));
            }
            this.view.onDestroy();
            if (this.listener != null) {
                this.listener.dispose();
            }
            this.app.onDestroy();
            super.onDestroy();
        }

        public void onPause() {
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.this.TAG, (String)(" > onPause() " + ((Object)((Object)this)).hashCode() + ", running: " + runningEngines));
            }
            this.app.onPause();
            this.view.onPause();
        }

        public void onResume() {
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.this.TAG, (String)(" > onResume() " + ((Object)((Object)this)).hashCode() + ", running: " + runningEngines));
            }
            this.app.onResume();
            this.view.onResume();
        }

        public void onSurfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.this.TAG, (String)(" > onSurfaceChanged() " + this.isPreview() + " " + ((Object)((Object)this)).hashCode() + ", running: " + runningEngines));
            }
            super.onSurfaceChanged(holder, format, width, height);
        }

        public void onSurfaceCreated(SurfaceHolder holder) {
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.this.TAG, (String)(" > onSurfaceCreated() " + ((Object)((Object)this)).hashCode() + ", running: " + runningEngines));
            }
            super.onSurfaceCreated(holder);
        }

        public void onSurfaceDestroyed(SurfaceHolder holder) {
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.this.TAG, (String)(" > onSurfaceDestroyed() " + ((Object)((Object)this)).hashCode() + ", running: " + runningEngines));
            }
            super.onSurfaceDestroyed(holder);
        }

        public void onVisibilityChanged(boolean visible) {
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.this.TAG, (String)(" > onVisibilityChanged(" + visible + ") " + ((Object)((Object)this)).hashCode()));
            }
            if (visible) {
                this.onResume();
            } else {
                this.onPause();
            }
            super.onVisibilityChanged(visible);
        }

        public void onTouchEvent(MotionEvent event) {
            this.app.input.onTouch(null, event);
        }

        public void onOffsetsChanged(final float xOffset, final float yOffset, final float xOffsetStep, final float yOffsetStep, final int xPixelOffset, final int yPixelOffset) {
            if (DEBUG) {
                Log.d((String)AndroidLiveWallpaperService.this.TAG, (String)(" > onOffsetChanged(" + xOffset + " " + yOffset + " " + xOffsetStep + " " + yOffsetStep + " " + xPixelOffset + " " + yPixelOffset + ") " + ((Object)((Object)this)).hashCode()));
            }
            this.app.postRunnable(new Runnable(){

                @Override
                public void run() {
                    AndroidLiveWallpaperService.this.offsetChange(AndroidWallpaperEngine.this.listener, xOffset, yOffset, xOffsetStep, yOffsetStep, xPixelOffset, yPixelOffset);
                }
            });
            super.onOffsetsChanged(xOffset, yOffset, xOffsetStep, yOffsetStep, xPixelOffset, yPixelOffset);
        }
    }
}

