local require = GLOBAL.require
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
Recipe = GLOBAL.Recipe
local STRINGS = GLOBAL.STRINGS
local ACTIONS = GLOBAL.ACTIONS
TECH = GLOBAL.TECH
local IsServer = GLOBAL.TheNet:GetIsServer()
local containers = require("containers")
local Mod_language =  GetModConfigData("modlanguage")
local Myorder =  GetModConfigData("personal_machine")
local Level_system =  GetModConfigData("level_system")
local Mood_system =  GetModConfigData("mood_system")
local Unique_skill =  GetModConfigData("unique_skill")
--local Pets_container =  GetModConfigData("pets_container")
local Collect_ability =  GetModConfigData("collect_ability")
local Container_Size =  GetModConfigData("container_size")
local Adds_cave =  GetModConfigData("recipe_critterlab")

PrefabFiles = {
"critters",
"forcefieldfxx",
"green_ferns",
"light_ferns",
"musha_ferns",
"musha_bulb",
"moonnutdrake3",
"moonnutdrake_lamb",
"critter_spores",
"critter_badge",
"ghosthound3",
"exp_pet",
"tunacan",
"bomb_collapse_fx",

}

Assets = {
Asset("ANIM", "anim/forcefieldx.zip"),
Asset("ANIM", "anim/green_ferns.zip"),
Asset("ANIM", "anim/light_ferns.zip"),
Asset("ANIM", "anim/moondrake_build.zip"),
Asset("ANIM", "anim/moondrake2_build.zip"),
Asset("ANIM", "anim/ghosthound.zip"),
Asset("ANIM", "anim/mypet80.zip"),
Asset("ANIM", "anim/mypet60.zip"),
Asset("ANIM", "anim/mypet40.zip"),
Asset("ANIM", "anim/mypet20.zip"),
Asset("ANIM", "anim/exp.zip"),
Asset("ANIM", "anim/swap_tunacan.zip"),
Asset("ANIM", "anim/tuna.zip"),	
Asset("ANIM", "anim/ui_chest_yamche2.zip"),	

Asset("IMAGE", "images/inventoryimages/critterlab.tex"),
Asset("ATLAS", "images/inventoryimages/critterlab.xml"),
}

ACTIONS.TURNON.priority = 3
ACTIONS.TURNOFF.priority = 2
ACTIONS.ABANDON.priority = 3
ACTIONS.PET.priority = 2

if Mod_language == "auto" then
	
	--ENG
	local KOR = 0
	local CHA = 0
	local RUS = 0
	
	for _, moddir in ipairs(GLOBAL.KnownModIndex:GetModsToLoad()) do
	local language = GLOBAL.KnownModIndex:GetModInfo(moddir).name
	if language == "한글 모드 서버 버전" or language == "한글 모드 클라이언트 버전" then 
	KOR = 1
	elseif language == "Chinese Language Pack" or language == "Chinese Plus" then
	CHA = 1
	elseif language == "Russian Language Pack" or language == "Russification Pack for DST" or language == "Russian For Mods (Client)" then
	RUS = 1
	end 
	end 

	if KOR == 1 then
	modimport("scripts/strings_critter_ko.lua")
	
	elseif CHA == 1 then
	modimport("scripts/strings_critter_cn.lua")
	
	elseif RUS == 1 then
	modimport("scripts/strings_critter_ru.lua")
	
	else
	modimport("scripts/strings_critter_en.lua")
	
	end

elseif Mod_language == "korean" then
	modimport("scripts/strings_critter_ko.lua")
	
elseif Mod_language == "chinese" then
	modimport("scripts/strings_critter_cn.lua")
	
elseif Mod_language == "russian" then
	modimport("scripts/strings_critter_ru.lua")
	
elseif Mod_language == "english" then
	modimport("scripts/strings_critter_en.lua")
		

end

local Musha = 0
for _, moddir in ipairs(GLOBAL.KnownModIndex:GetModsToLoad()) do
	local Musha_mod = GLOBAL.KnownModIndex:GetModInfo(moddir).name
	if Musha_mod == "[DST]Musha" then 
	Musha = 1
end end
	
if Musha == 0 then
 function never_eat(inst)
 if IsServer then
        inst:AddTag("no_edible")
		end end
AddPrefabPostInit("powcake", never_eat)
AddPrefabPostInit("mandrake", never_eat)
AddPrefabPostInit("cookedmandrake", never_eat)
AddPrefabPostInit("spoiled_food", never_eat)

local EventHandler = GLOBAL.EventHandler

local function DoHurtSound(inst)
    if inst.hurtsoundoverride ~= nil then
        inst.SoundEmitter:PlaySound(inst.hurtsoundoverride, nil, inst.hurtsoundvolume)
    elseif not inst:HasTag("mime") then
        inst.SoundEmitter:PlaySound((inst.talker_path_override or "dontstarve/characters/")..(inst.soundsname or inst.prefab).."/hurt", nil, inst.hurtsoundvolume)
    end
end
AddStategraphEvent("wilson", EventHandler("attacked", 
		function(inst, data)
        if not inst.components.health:IsDead() then
		if inst.on_sparkshield or inst.f_attack or inst.light_shield then
			inst.SoundEmitter:PlaySound("dontstarve/characters/wx78/spark")
			else
            if data.weapon ~= nil and data.weapon:HasTag("tranquilizer") and (inst.sg:HasStateTag("bedroll") or inst.sg:HasStateTag("knockout")) then
                return --Do nothing
            elseif inst.sg:HasStateTag("transform") or inst.sg:HasStateTag("dismounting") then
                -- don't interrupt transform or when bucked in the air
                inst.SoundEmitter:PlaySound("dontstarve/wilson/hit")
                DoHurtSound(inst)
            elseif inst.sg:HasStateTag("sleeping") then
                inst.SoundEmitter:PlaySound("dontstarve/wilson/hit")
                DoHurtSound(inst)
                if inst.sleepingbag ~= nil then
                    inst.sleepingbag.components.sleepingbag:DoWakeUp()
                    inst.sleepingbag = nil
                else
                    inst.sg.statemem.iswaking = true
                    inst.sg:GoToState("wakeup")
                end
            elseif data.attacker ~= nil
                and data.attacker:HasTag("groundspike")
                and not inst.components.rider:IsRiding()
                and not inst:HasTag("beaver") then
                inst.sg:GoToState("hit_spike", data.attacker)
            elseif data.attacker ~= nil
                and data.attacker.sg ~= nil
                and data.attacker.sg:HasStateTag("pushing") then
                inst.sg:GoToState("hit_push")
            elseif inst.sg:HasStateTag("shell") then
                inst.sg:GoToState("shell_hit")
            elseif inst.components.pinnable ~= nil and inst.components.pinnable:IsStuck() then
                inst.sg:GoToState("pinned_hit")
            elseif data.stimuli == "darkness" then
                inst.sg:GoToState("hit_darkness")
            elseif data.stimuli == "electric" and not inst.components.inventory:IsInsulated() then
                inst.sg:GoToState("electrocute")
            elseif inst.sg:HasStateTag("nointerrupt") then
                inst.SoundEmitter:PlaySound("dontstarve/wilson/hit")
                DoHurtSound(inst)
            else
                local t = GLOBAL.GetTime()
                local stunlock =
                    data.stimuli ~= "stun" and
                    data.attacker ~= nil and
                    --V2C: skip stunlock protection when idle
                    -- gjans: we transition to idle for 1 frame after being hit, hence the timeinstate check
                    not (inst.sg:HasStateTag("idle") and inst.sg.timeinstate > 0) and
                    data.attacker.components.combat ~= nil and
                    data.attacker.components.combat.playerstunlock or
                    nil
                if stunlock ~= nil and
                    t - (inst.sg.mem.laststuntime or 0) <
                    (   (stunlock == GLOBAL.PLAYERSTUNLOCK.NEVER and math.huge) or
                        (stunlock == GLOBAL.PLAYERSTUNLOCK.RARELY and GLOBAL.TUNING.STUNLOCK_TIMES.RARELY) or
                        (stunlock == GLOBAL.PLAYERSTUNLOCK.SOMETIMES and GLOBAL.TUNING.STUNLOCK_TIMES.SOMETIMES) or
                        (stunlock == GLOBAL.PLAYERSTUNLOCK.OFTEN and GLOBAL.TUNING.STUNLOCK_TIMES.OFTEN) or
                        0 --unsupported case
                    ) then
                    -- don't go to full hit state, just play sounds
                    inst.SoundEmitter:PlaySound("dontstarve/wilson/hit")
                    DoHurtSound(inst)
                else
                    inst.sg.mem.laststuntime = t
                    inst.sg:GoToState("hit", data.noimpactsound and "noimpactsound" or nil)
                end
            end
        end
		end
    end)
	)
	
end

function critterlab_hammer(inst)
	inst.critterlab_hammer = true
end

if Adds_cave == "on" then
local critterlab = AddRecipe("critterlab", { Ingredient("rocks", 10), Ingredient("beefalowool", 4), Ingredient("cutgrass", 10), }, RECIPETABS.TOWN, TECH.NONE, "critterlab_placer" ) 
critterlab.atlas = "images/inventoryimages/critterlab.xml"
critterlab.tagneeded = false
critterlab.builder_tag ="player"

AddPrefabPostInit("critterlab", critterlab_hammer)
end

function Leveling_system(inst)
if Level_system == "off" then
inst.level_off = true
end
if Level_system == "full_level" then
inst.full_level = true
end
end

if Level_system == "off" or Level_system == "full_level" then
AddPrefabPostInit("critter_kitten", Leveling_system)
AddPrefabPostInit("critter_puppy", Leveling_system)
AddPrefabPostInit("critter_lamb", Leveling_system)
AddPrefabPostInit("critter_perdling", Leveling_system)
AddPrefabPostInit("critter_dragonling", Leveling_system)
AddPrefabPostInit("critter_glomling", Leveling_system)
end

function moods_system(inst)
if Mood_system == "mood_full" then
inst.mood_full = true
end
end
if Mood_system == "mood_full" then
AddPrefabPostInit("critter_kitten", moods_system)
AddPrefabPostInit("critter_puppy", moods_system)
AddPrefabPostInit("critter_lamb", moods_system)
AddPrefabPostInit("critter_perdling", moods_system)
AddPrefabPostInit("critter_dragonling", moods_system)
AddPrefabPostInit("critter_glomling", moods_system)
end

function Unique_skills(inst)
if Unique_skill == "off" then
inst.unique_off = true
end
end
if Unique_skill == "off" then
AddPrefabPostInit("critter_kitten", Unique_skills)
AddPrefabPostInit("critter_puppy", Unique_skills)
AddPrefabPostInit("critter_lamb", Unique_skills)
AddPrefabPostInit("critter_perdling", Unique_skills)
AddPrefabPostInit("critter_dragonling", Unique_skills)
AddPrefabPostInit("critter_glomling", Unique_skills)
end

function Collect_skill(inst)
if Collect_ability == "off" then
inst.collect_off = true
end
end
if Collect_ability == "off" then
AddPrefabPostInit("critter_kitten", Collect_skill)
AddPrefabPostInit("critter_puppy", Collect_skill)
AddPrefabPostInit("critter_lamb", Collect_skill)
AddPrefabPostInit("critter_perdling", Collect_skill)
AddPrefabPostInit("critter_dragonling", Collect_skill)
AddPrefabPostInit("critter_glomling", Collect_skill)
end

--[[function MyPet_container(inst)
if Pets_container == "off" then
inst.cotainer_off = true
inst:RemoveComponent("container") 
end
end
if Pets_container == "on" or Pets_container == "off" then
AddPrefabPostInit("critter_kitten", MyPet_container)
AddPrefabPostInit("critter_puppy", MyPet_container)
AddPrefabPostInit("critter_lamb", MyPet_container)
AddPrefabPostInit("critter_perdling", MyPet_container)
AddPrefabPostInit("critter_dragonling", MyPet_container)
AddPrefabPostInit("critter_glomling", MyPet_container)
end]]

ACTIONS.FEED.fn = function(act)
    if act.doer ~= nil and act.target ~= nil and act.target.components.eater ~= nil and act.target.components.eater:CanEat(act.invobject) and not act.target:HasTag("critter") then
        act.target.components.eater:Eat(act.invobject, act.doer)
        local murdered =
            act.target:IsValid() and
            act.target.components.health ~= nil and
            act.target.components.health:IsDead() and
            act.target or nil

        if murdered ~= nil then
            murdered.causeofdeath = act.doer

            local owner = murdered.components.inventoryitem ~= nil and murdered.components.inventoryitem.owner or nil
            if owner ~= nil then
       
                local grandowner = murdered.components.inventoryitem:GetGrandOwner()
                local x, y, z = grandowner.Transform:GetWorldPosition()
                murdered.components.inventoryitem:RemoveFromOwner(true)
                murdered.Transform:SetPosition(x, y, z)

                if murdered.components.health.murdersound ~= nil and grandowner.SoundEmitter ~= nil then
                    grandowner.SoundEmitter:PlaySound(murdered.components.health.murdersound)
                end

                if murdered.components.lootdropper ~= nil then
                    local container = owner.components.inventory or owner.components.container
                    if container ~= nil then
                        local stacksize = murdered.components.stackable ~= nil and murdered.components.stackable:StackSize() or 1
                        for i = 1, stacksize do
                            local loots = murdered.components.lootdropper:GenerateLoot()
                            for k, v in pairs(loots) do
                                local loot = SpawnPrefab(v)
                                if loot ~= nil then
                                    container:GiveItem(loot, murdered.prevslot)
                                end
                            end
                        end
                    end
                end
            end

            act.doer:PushEvent("killed", { victim = murdered })

            if owner ~= nil then
                murdered:Remove()
            end
        end
        return true
		
	elseif act.doer ~= nil and act.target ~= nil and act.target.components.eater ~= nil and act.target.components.eater:CanEat(act.invobject) and act.target:HasTag("critter") then
		local pet = act.target
		if pet.components.perishable:GetPercent() < 0.95 then
				pet.components.eater:Eat(act.invobject, act.doer)
				pet.master_gift = true
				return true
		elseif pet.components.perishable:GetPercent() >= 0.95 then
				local random_half = math.random(1, 3)
					if random_half == 1 then
				pet.components.talker:Say(STRINGS.CRITTER_REFUSE)
					elseif random_half == 2 then
				pet.components.talker:Say(STRINGS.CRITTER_REFUSE2)
					elseif random_half == 3 then
				pet.components.talker:Say(STRINGS.CRITTER_REFUSE3)
					end
					pet.sg:GoToState("hungry")
				return false
		
		else
			pet.components.talker:Say(STRINGS.CRITTER_REFUSE3)
			pet.sg:GoToState("hungry")
			return false
		end
    end
end

ACTIONS.ABANDON.fn = function(act)
    if act.doer.components.petleash ~= nil then
        if not (act.doer.components.builder ~= nil and act.doer.components.builder.accessible_tech_trees.ORPHANAGE > 0) then
            local x, y, z = act.doer.Transform:GetWorldPosition()
            if #TheSim:FindEntities(x, y, z, 10, { "critterlab" }) <= 0 then
                return false
            end
        end
		if act.target.components.container then
		act.target.components.container:DropEverything() 
		end
		if act.target.components.inventory then
		act.target.components.inventory:DropEverything() 
		end
        act.doer.components.petleash:DespawnPet(act.target)
        return true
    end
end

if Myorder == "on" then
ACTIONS.TURNON.fn = function(act)
    local tar = act.target or act.invobject
	local owner = act.target.components.follower and act.target.components.follower.leader
   if tar and tar.components.machine and not tar.components.machine:IsOn() and not tar:HasTag("critter") then
        tar.components.machine:TurnOn(tar)
        return true
		
	elseif tar and tar.components.machine and not tar.components.machine:IsOn() and tar:HasTag("critter") and owner == act.doer and not tar.components.container:IsFull() then
		tar.components.machine:TurnOn(tar)
        return true
		
	elseif tar and tar.components.machine and not tar.components.machine:IsOn() and tar:HasTag("critter") and owner == act.doer and tar.components.container:IsFull() then
		tar.components.talker:Say(STRINGS.CRITTER_INV_FULL)
		act.doer.components.talker:Say(STRINGS.CRITTER_REFUSE_INV)
        return false	
		
	elseif tar and tar.components.machine and not tar.components.machine:IsOn() and tar:HasTag("critter") and owner ~= act.doer then
        return false	
    end
	
end
end

ACTIONS.RUMMAGE.fn = function(act)
    local targ = act.target or act.invobject
	

    if targ ~= nil and targ.components.container ~= nil and not targ:HasTag("critter") and not targ:HasTag("yamcheb") then
 
        if targ.components.container:IsOpenedBy(act.doer) then
            targ.components.container:Close()
            act.doer:PushEvent("closecontainer", { container = targ })
            return true
        elseif targ.components.container:IsOpen() then
            return false, "INUSE"
        elseif targ.components.container.canbeopened then
            --Silent fail for opening containers in the dark
            if GLOBAL.CanEntitySeeTarget(act.doer, targ) then
                act.doer:PushEvent("opencontainer", { container = targ })
                targ.components.container:Open(act.doer)
            end
            return true
        end
		
	elseif targ ~= nil and targ.components.container ~= nil and (targ:HasTag("critter") or targ:HasTag("yamcheb")) then
		local owner = act.target.components.follower.leader
	if act.doer == owner then
 
        if targ.components.container:IsOpenedBy(act.doer) then
            targ.components.container:Close()
            act.doer:PushEvent("closecontainer", { container = targ })
            return true
        --elseif targ.components.container:IsOpen() then
            --return false, "INUSE"
        elseif targ.components.container.canbeopened then
            --Silent fail for opening containers in the dark
            if GLOBAL.CanEntitySeeTarget(act.doer, targ) then
                act.doer:PushEvent("opencontainer", { container = targ })
                targ.components.container:Open(act.doer)
            end
            return true
        end
	else
		return false
		
		end

	
end	
end

ACTIONS.PET.fn = function(act)
local owner = act.target.components.follower.leader
local targ = act.target
if targ ~= nil and targ.components.container ~= nil and act.doer.components.petleash ~= nil --[[and not targ.collect_work]] --[[and not targ.cotainer_off]] then

	if targ.components.container:IsOpenedBy(act.doer) and act.doer == owner then	
        targ.components.crittertraits:OnPet(act.doer)
		if not targ.level_off and not targ.level1 then
		act.doer.components.sanity:DoDelta(1)
		end
		if targ.feeling and targ.feeling < 100 then
		targ.feeling = targ.feeling + 1
		end
        targ.components.container:Close()
		act.doer:PushEvent("closecontainer", { container = targ })
        return true
	--[[elseif targ.components.container:IsOpen() then
        return false, "INUSE"]]	
    elseif targ.components.container.canbeopened and act.doer == owner then
        targ.components.crittertraits:OnPet(act.doer)
		if not targ.level_off and not targ.level1 then
		act.doer.components.sanity:DoDelta(1)
		end
		if targ.feeling and targ.feeling < 100 then
		targ.feeling = targ.feeling + 1
		end
		act.doer:PushEvent("opencontainer", { container = targ })
        targ.components.container:Open(act.doer)
        return true
	elseif act.doer ~= owner then	
		if not targ.level_off and not targ.level1 then
		act.doer.components.sanity:DoDelta(1)
		end
		if targ.feeling and targ.feeling < 100 then
		targ.feeling = targ.feeling + 0.5
		end
		return true
    end

--[[elseif targ ~= nil and targ.components.container ~= nil and act.doer.components.petleash ~= nil and targ.collect_work and not targ.cotainer_off then	
targ.components.crittertraits:OnPet(act.doer)
act.doer.components.talker:Say(STRINGS.CRITTER_REFUSE_INV)
		if not targ.level_off and not targ.level1 then
		act.doer.components.sanity:DoDelta(1)
		end
		return true]]
		
--[[elseif targ ~= nil and act.doer.components.petleash ~= nil and targ.cotainer_off then		
targ.components.crittertraits:OnPet(act.doer)
targ.yamcheinfo = true
		if not targ.level_off and not targ.level1 then
		act.doer.components.sanity:DoDelta(1)
		end
		return true]]
end
end

ACTIONS.PICKUP.fn = function(act)
if not act.doer:HasTag("critter") and not act.doer:HasTag("yamcheb") then
    if act.doer.components.inventory ~= nil and
        act.target ~= nil and
        act.target.components.inventoryitem ~= nil and
        (act.target.components.inventoryitem.canbepickedup or
        (act.target.components.inventoryitem.canbepickedupalive and not act.doer:HasTag("player"))) and
        not (act.target:IsInLimbo() or
            (act.target.components.burnable ~= nil and act.target.components.burnable:IsBurning()) or
            (act.target.components.projectile ~= nil and act.target.components.projectile:IsThrown())) then

		if act.doer.components.itemtyperestrictions ~= nil and not act.doer.components.itemtyperestrictions:IsAllowed(act.target) then
			return false, "restriction"
		end

        act.doer:PushEvent("onpickupitem", { item = act.target })

        --special case for trying to carry two backpacks
        if not act.target.components.inventoryitem.cangoincontainer and act.target.components.equippable and act.doer.components.inventory:GetEquippedItem(act.target.components.equippable.equipslot) then
            local item = act.doer.components.inventory:GetEquippedItem(act.target.components.equippable.equipslot)
            if item.components.inventoryitem and item.components.inventoryitem.cangoincontainer then
                
                --act.doer.components.inventory:SelectActiveItemFromEquipSlot(act.target.components.equippable.equipslot)
                act.doer.components.inventory:GiveItem(act.doer.components.inventory:Unequip(act.target.components.equippable.equipslot))
            else
                act.doer.components.inventory:DropItem(act.doer.components.inventory:GetEquippedItem(act.target.components.equippable.equipslot))
            end
            act.doer.components.inventory:Equip(act.target)
            return true
        end

        if act.doer:HasTag("player") and
            (   act.target.components.equippable ~= nil and
                not act.doer.components.inventory:GetEquippedItem(act.target.components.equippable.equipslot) or
                act.doer.components.inventory:GetNumSlots() <= 0
            ) then
            act.doer.components.inventory:Equip(act.target)
        else
            act.doer.components.inventory:GiveItem(act.target, nil, act.target:GetPosition())
        end
        return true
    end
elseif act.doer:HasTag("critter") or act.doer:HasTag("yamcheb") then	
	if act.doer.components.container ~= nil and
        act.target ~= nil and
        act.target.components.inventoryitem ~= nil and
        (act.target.components.inventoryitem.canbepickedup or
        (act.target.components.inventoryitem.canbepickedupalive )) and
        not (act.target:IsInLimbo() or
            (act.target.components.burnable ~= nil and act.target.components.burnable:IsBurning()) or
            (act.target.components.projectile ~= nil and act.target.components.projectile:IsThrown())) then

		if act.doer.components.itemtyperestrictions ~= nil and not act.doer.components.itemtyperestrictions:IsAllowed(act.target) then
			return false, "restriction"
		end

        act.doer:PushEvent("onpickupitem", { item = act.target })

    act.doer.components.container:GiveItem(act.target, nil, act.target:GetPosition())
        end
        return true
    


end
end

ACTIONS.HARVEST.fn = function(act)
    if act.target.components.crop ~= nil then
        local harvested = act.target.components.crop:Harvest(act.doer)
        return harvested
    elseif act.target.components.harvestable ~= nil then
        return act.target.components.harvestable:Harvest(act.doer)
    elseif act.target.components.stewer ~= nil then
        return act.target.components.stewer:Harvest(act.doer)
    elseif act.target.components.dryer ~= nil then
        return act.target.components.dryer:Harvest(act.doer)
    elseif act.target.components.occupiable ~= nil and act.target.components.occupiable:IsOccupied() then
        local item = act.target.components.occupiable:Harvest(act.doer)
        if item ~= nil then
			if not act.doer:HasTag("critter") and not act.doer:HasTag("yamcheb") then
			act.doer.components.inventory:GiveItem(item)
			elseif act.doer:HasTag("critter") or act.doer:HasTag("yamcheb") then
			act.doer.components.container:GiveItem(item)
			end
			return true
        end
    end
end

--[[
local oldwidgetsetup = containers.widgetsetup
containers.widgetsetup = function(container, prefab)
  if not prefab and container.inst.prefab == "critter_lamb" then  prefab = "chester" end   
  if not prefab and container.inst.prefab == "critter_puppy" then  prefab = "chester" end   
  if not prefab and container.inst.prefab == "critter_kitten" then  prefab = "chester" end   
  if not prefab and container.inst.prefab == "critter_perdling" then  prefab = "chester" end  
  if not prefab and container.inst.prefab == "critter_dragonling" then  prefab = "chester" end  
  if not prefab and container.inst.prefab == "critter_glomling" then  prefab = "chester" end  
 oldwidgetsetup(container, prefab)
end
]]


---------------------------------------------------------------
if Container_Size == "6" then
local params = {}
local OVERRIDE_WIDGETSETUP = false
local containers_widgetsetup_base = containers.widgetsetup
function containers.widgetsetup(container, prefab)
    local t = params[prefab or container.inst.prefab]
    if t ~= nil then
        for k, v in pairs(t) do
            container[k] = v
        end
        container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0)
        if OVERRIDE_WIDGETSETUP then
            container.type = "chest_yamche44"
        end
    else
        containers_widgetsetup_base(container, prefab)
    end
end
local function chest_yamche44()
    local container =
    {
        widget =
        {
            slotpos = {},
            animbank = "ui_chest_3x3",
            animbuild = "ui_chest_yamche2",
            pos = GLOBAL.Vector3(0, 180, 0),
            side_align_tip = 160,
        },
        type = "chest",
    }
for y = 2, 0, -1 do
    for x = 0, 1 do
        table.insert(container.widget.slotpos, GLOBAL.Vector3(80*x-76*2+78, 80*y-78*2+78,0))
    end
end

    return container
end
params.chest_yamche44 = chest_yamche44()
for k, v in pairs(params) do
    containers.MAXITEMSLOTS = math.max(containers.MAXITEMSLOTS, v.widget.slotpos ~= nil and #v.widget.slotpos or 0)
end
local containers_widgetsetup_custom = containers.widgetsetup
local MAXITEMSLOTS = containers.MAXITEMSLOTS
AddPrefabPostInit("world_network", function(inst)
    if containers.widgetsetup ~= containers_widgetsetup_custom then
        OVERRIDE_WIDGETSETUP = true
        local containers_widgetsetup_base2 = containers.widgetsetup
        function containers.widgetsetup(container, prefab)
            containers_widgetsetup_base2(container, prefab)
            if container.type == "chest_yamche44" then
                container.type = "chest"
    end end end
    if containers.MAXITEMSLOTS < MAXITEMSLOTS then
        containers.MAXITEMSLOTS = MAXITEMSLOTS
    end
end)
end

if Container_Size == "9" then
local params = {}
local OVERRIDE_WIDGETSETUP = false
local containers_widgetsetup_base = containers.widgetsetup
function containers.widgetsetup(container, prefab)
    local t = params[prefab or container.inst.prefab]
    if t ~= nil then
        for k, v in pairs(t) do
            container[k] = v
        end
        container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0)
        if OVERRIDE_WIDGETSETUP then
            container.type = "chest_yamche44"
        end
    else
        containers_widgetsetup_base(container, prefab)
    end
end
local function chest_yamche44()
    local container =
    {
        widget =
        {
            slotpos = {},
            animbank = "ui_chest_3x3",
            animbuild = "ui_chest_3x3",
            pos = GLOBAL.Vector3(0, 180, 0),
            side_align_tip = 160,
        },
        type = "chest",
    }
for y = 2, 0, -1 do
    for x = 0, 2 do
        table.insert(container.widget.slotpos, GLOBAL.Vector3(80 * x - 80 * 2 + 80, 80 * y - 80 * 2 + 80, 0))
    end
end

    return container
end
params.chest_yamche44 = chest_yamche44()
for k, v in pairs(params) do
    containers.MAXITEMSLOTS = math.max(containers.MAXITEMSLOTS, v.widget.slotpos ~= nil and #v.widget.slotpos or 0)
end
local containers_widgetsetup_custom = containers.widgetsetup
local MAXITEMSLOTS = containers.MAXITEMSLOTS
AddPrefabPostInit("world_network", function(inst)
    if containers.widgetsetup ~= containers_widgetsetup_custom then
        OVERRIDE_WIDGETSETUP = true
        local containers_widgetsetup_base2 = containers.widgetsetup
        function containers.widgetsetup(container, prefab)
            containers_widgetsetup_base2(container, prefab)
            if container.type == "chest_yamche44" then
                container.type = "chest"
    end end end
    if containers.MAXITEMSLOTS < MAXITEMSLOTS then
        containers.MAXITEMSLOTS = MAXITEMSLOTS
    end
end)
end

---------------------------------------------------------------
--box3
if Container_Size == "12" then
local params = {}
local OVERRIDE_WIDGETSETUP = false
local containers_widgetsetup_base = containers.widgetsetup
function containers.widgetsetup(container, prefab)
    local t = params[prefab or container.inst.prefab]
    if t ~= nil then
        for k, v in pairs(t) do
            container[k] = v
        end
        container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0)
        if OVERRIDE_WIDGETSETUP then
            container.type = "chest_yamche44"
        end
    else
        containers_widgetsetup_base(container, prefab)
    end
end
local function chest_yamche44()
    local container =
    {
        widget =
        {
            slotpos = {},
            animbank = "ui_chest_3x3",
            animbuild = "ui_chest_3x3",
            pos = GLOBAL.Vector3(0, 180, 0),
            side_align_tip = 160,
        },
        type = "chest",
    }
for y = 3, 0, -1 do
    for x = 0, 2 do
        table.insert(container.widget.slotpos, GLOBAL.Vector3(75*x-75*2+75, 60*y-60*2+32,0))
    end
end

    return container
end
params.chest_yamche44 = chest_yamche44()
for k, v in pairs(params) do
    containers.MAXITEMSLOTS = math.max(containers.MAXITEMSLOTS, v.widget.slotpos ~= nil and #v.widget.slotpos or 0)
end
local containers_widgetsetup_custom = containers.widgetsetup
local MAXITEMSLOTS = containers.MAXITEMSLOTS
AddPrefabPostInit("world_network", function(inst)
    if containers.widgetsetup ~= containers_widgetsetup_custom then
        OVERRIDE_WIDGETSETUP = true
        local containers_widgetsetup_base2 = containers.widgetsetup
        function containers.widgetsetup(container, prefab)
            containers_widgetsetup_base2(container, prefab)
            if container.type == "chest_yamche44" then
                container.type = "chest"
    end end end
    if containers.MAXITEMSLOTS < MAXITEMSLOTS then
        containers.MAXITEMSLOTS = MAXITEMSLOTS
    end
end)
end

--box5
if Container_Size == "16" then
local params = {}
local OVERRIDE_WIDGETSETUP = false
local containers_widgetsetup_base = containers.widgetsetup
function containers.widgetsetup(container, prefab)
    local t = params[prefab or container.inst.prefab]
    if t ~= nil then
        for k, v in pairs(t) do
            container[k] = v
        end
        container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0)
        if OVERRIDE_WIDGETSETUP then
            container.type = "chest_yamche44"
        end
    else
        containers_widgetsetup_base(container, prefab)
    end
end
local function chest_yamche44()
    local container =
    {
        widget =
        {
            slotpos = {},
            animbank = "ui_chest_3x3",
            animbuild = "ui_chest_3x3",
            pos = GLOBAL.Vector3(0, 180, 0),
            side_align_tip = 160,
        },
        type = "chest",
    }
for y = 3, 0, -1 do
    for x = 0, 3 do
        table.insert(container.widget.slotpos, GLOBAL.Vector3(60*x-60*2+30, 60*y-60*2+30,0))
    end
end
    return container
end
params.chest_yamche44 = chest_yamche44()
for k, v in pairs(params) do
    containers.MAXITEMSLOTS = math.max(containers.MAXITEMSLOTS, v.widget.slotpos ~= nil and #v.widget.slotpos or 0)
end
local containers_widgetsetup_custom = containers.widgetsetup
local MAXITEMSLOTS = containers.MAXITEMSLOTS
AddPrefabPostInit("world_network", function(inst)
    if containers.widgetsetup ~= containers_widgetsetup_custom then
        OVERRIDE_WIDGETSETUP = true
        local containers_widgetsetup_base2 = containers.widgetsetup
        function containers.widgetsetup(container, prefab)
            containers_widgetsetup_base2(container, prefab)
            if container.type == "chest_yamche44" then
                container.type = "chest"
    end end end
    if containers.MAXITEMSLOTS < MAXITEMSLOTS then
        containers.MAXITEMSLOTS = MAXITEMSLOTS
    end
end)
end


if Container_Size == "20" then
local params = {}
local OVERRIDE_WIDGETSETUP = false
local containers_widgetsetup_base = containers.widgetsetup
function containers.widgetsetup(container, prefab)
    local t = params[prefab or container.inst.prefab]
    if t ~= nil then
        for k, v in pairs(t) do
            container[k] = v
        end
        container:SetNumSlots(container.widget.slotpos ~= nil and #container.widget.slotpos or 0)
        if OVERRIDE_WIDGETSETUP then
            container.type = "chest_yamche44"
        end
    else
        containers_widgetsetup_base(container, prefab)
    end
end
local function chest_yamche44()
    local container =
    {
        widget =
        {
            slotpos = {},
            animbank = "ui_chester_shadow_3x4",
			animbuild = "ui_chester_shadow_3x4",
            pos = GLOBAL.Vector3(0, 180, 0),
            side_align_tip = 160,
        },
        type = "chest",
    }
for y = 4, 0, -1 do
    for x = 0, 3 do
        table.insert(container.widget.slotpos, GLOBAL.Vector3(60*x-60*2+30, 60*y-60*2+2,0))
    end
end
    return container
end
params.chest_yamche44 = chest_yamche44()
for k, v in pairs(params) do
    containers.MAXITEMSLOTS = math.max(containers.MAXITEMSLOTS, v.widget.slotpos ~= nil and #v.widget.slotpos or 0)
end
local containers_widgetsetup_custom = containers.widgetsetup
local MAXITEMSLOTS = containers.MAXITEMSLOTS
AddPrefabPostInit("world_network", function(inst)
    if containers.widgetsetup ~= containers_widgetsetup_custom then
        OVERRIDE_WIDGETSETUP = true
        local containers_widgetsetup_base2 = containers.widgetsetup
        function containers.widgetsetup(container, prefab)
            containers_widgetsetup_base2(container, prefab)
            if container.type == "chest_yamche44" then
                container.type = "chest"
    end end end
    if containers.MAXITEMSLOTS < MAXITEMSLOTS then
        containers.MAXITEMSLOTS = MAXITEMSLOTS
    end
end)
end


---------------------------------------------------------------
