local assets =
{
Asset("ANIM", "anim/mypet80.zip"),
Asset("ANIM", "anim/mypet60.zip"),
Asset("ANIM", "anim/mypet40.zip"),
Asset("ANIM", "anim/mypet20.zip"),
}

local FADE_FRAMES = 5
local FADE_INTENSITY = .8
local FADE_RADIUS = 1
local FADE_FALLOFF = .5

local function OnUpdateFade(inst)
    local k
    if inst._fade:value() <= FADE_FRAMES then
        inst._fade:set_local(math.min(inst._fade:value() + 1, FADE_FRAMES))
        k = inst._fade:value() / FADE_FRAMES
    else
        inst._fade:set_local(math.min(inst._fade:value() + 1, FADE_FRAMES * 2 + 1))
        k = (FADE_FRAMES * 2 + 1 - inst._fade:value()) / FADE_FRAMES
    end

    if inst._fade:value() == FADE_FRAMES or inst._fade:value() > FADE_FRAMES * 2 then
        inst._fadetask:Cancel()
        inst._fadetask = nil
    end
end

local function OnFadeDirty(inst)
    if inst._fadetask == nil then
        inst._fadetask = inst:DoPeriodicTask(FRAMES, OnUpdateFade)
    end
    OnUpdateFade(inst)
end

local function FadeOut(inst)
    inst._fade:set(FADE_FRAMES + 1)
    if inst._fadetask == nil then
        inst._fadetask = inst:DoPeriodicTask(FRAMES, OnUpdateFade)
    end
end

local function fadeout_page(inst)
 local parent = inst.entity:GetParent()
	if parent ~= nil then
	if parent.mypet_reset then 
		parent.mypet_80 = false
		parent.mypet_60 = false
		parent.mypet_40 = false
		parent.mypet_20 = false
		--local fx = SpawnPrefab("statue_transition_2")
		--fx.Transform:SetScale(0.4, 0.4, 0.4)
		--fx.Transform:SetPosition(inst:GetPosition():Get())
		inst:Remove()
	elseif parent.mypet_80 then
		if not inst:HasTag("mypet_80") then
		inst:Remove()
		end
	elseif parent.mypet_60 then	
		if not inst:HasTag("mypet_60") then
		inst:Remove()
		end
	elseif parent.mypet_40 then	
		if not inst:HasTag("mypet_40") then
		inst:Remove()
		end	
	elseif parent.mypet_20 then	
		if not inst:HasTag("mypet_20") then
		inst:Remove()
		end	
	end
	end 
end
local function fadeout_time(inst)
 local parent = inst.entity:GetParent()
	if parent ~= nil then
		--[[local fx = SpawnPrefab("statue_transition_2")
		fx.Transform:SetScale(0.4, 0.4, 0.4)
		fx.Transform:SetPosition(inst:GetPosition():Get())]]
		inst:Remove()
		
	end
end

local function mypet20()

	local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddFollower()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    inst:AddTag("FX")
    inst:AddTag("NOCLICK") 
	 inst:AddTag("mypet_20")
    inst.Transform:SetFourFaced()

    inst.AnimState:SetBank("sporebomb")
    inst.AnimState:SetBuild("mypet20")
    inst.AnimState:PlayAnimation("sporebomb_pre")
    inst.AnimState:SetLightOverride(.3)
    inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
    inst.AnimState:SetFinalOffset(3)

	inst.Transform:SetScale(0.8,0.8,0.8)

    inst._fade = net_smallbyte(inst.GUID, "sporebomb._fade", "fadedirty")

    inst._fadetask = inst:DoPeriodicTask(FRAMES, OnUpdateFade)
	
	inst.entity:SetPristine()

    if not TheWorld.ismastersim then
	 inst:ListenForEvent("fadedirty", OnFadeDirty)
  
        return inst
    end
	
	inst.AnimState:PushAnimation("sporebomb_loop")
	
	inst:DoPeriodicTask(1, function()	
	fadeout_page(inst) 	end)
	inst:DoTaskInTime(10, function()	
	fadeout_time(inst) 	end)
	
	return inst
end

local function mypet40()

	local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddFollower()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    inst:AddTag("FX")
    inst:AddTag("NOCLICK") 
	 inst:AddTag("mypet_40")
    inst.Transform:SetFourFaced()

    inst.AnimState:SetBank("sporebomb")
    inst.AnimState:SetBuild("mypet40")
    inst.AnimState:PlayAnimation("sporebomb_pre")
    --inst.AnimState:SetLightOverride(.3)
    --inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
    inst.AnimState:SetFinalOffset(3)

	inst.Transform:SetScale(0.8,0.8,0.8)

    inst._fade = net_smallbyte(inst.GUID, "sporebomb._fade", "fadedirty")

    inst._fadetask = inst:DoPeriodicTask(FRAMES, OnUpdateFade)
	
	inst.entity:SetPristine()

    if not TheWorld.ismastersim then
	 inst:ListenForEvent("fadedirty", OnFadeDirty)
  
        return inst
    end
	
	inst.AnimState:PushAnimation("sporebomb_loop")
	
	inst:DoPeriodicTask(1, function()	
	fadeout_page(inst) 	end)
	inst:DoTaskInTime(10, function()	
	fadeout_time(inst) 	end)
	
	return inst
end

local function mypet60()

	local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddFollower()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    inst:AddTag("FX")
    inst:AddTag("NOCLICK") 
	 inst:AddTag("mypet_60")
    inst.Transform:SetFourFaced()

    inst.AnimState:SetBank("sporebomb")
    inst.AnimState:SetBuild("mypet60")
    inst.AnimState:PlayAnimation("sporebomb_pre")
    --inst.AnimState:SetLightOverride(.3)
    --inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
    inst.AnimState:SetFinalOffset(3)

	inst.Transform:SetScale(0.8,0.8,0.8)

    inst._fade = net_smallbyte(inst.GUID, "sporebomb._fade", "fadedirty")

    inst._fadetask = inst:DoPeriodicTask(FRAMES, OnUpdateFade)
	
	inst.entity:SetPristine()

    if not TheWorld.ismastersim then
	 inst:ListenForEvent("fadedirty", OnFadeDirty)
  
        return inst
    end
	
	inst.AnimState:PushAnimation("sporebomb_loop")
	
	inst:DoPeriodicTask(1, function()	
	fadeout_page(inst) 	end)
	inst:DoTaskInTime(10, function()	
	fadeout_time(inst) 	end)
	
	return inst
end

local function mypet80()

	local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddFollower()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    inst:AddTag("FX")
    inst:AddTag("NOCLICK") 
	inst:AddTag("mypet_80") 
    inst.Transform:SetFourFaced()

    inst.AnimState:SetBank("sporebomb")
    inst.AnimState:SetBuild("mypet80")
    inst.AnimState:PlayAnimation("sporebomb_pre")
    --inst.AnimState:SetLightOverride(.3)
    --inst.AnimState:SetBloomEffectHandle("shaders/anim.ksh")
    inst.AnimState:SetFinalOffset(3)

	inst.Transform:SetScale(0.8,0.8,0.8)

    inst._fade = net_smallbyte(inst.GUID, "sporebomb._fade", "fadedirty")

    inst._fadetask = inst:DoPeriodicTask(FRAMES, OnUpdateFade)
	
	inst.entity:SetPristine()

    if not TheWorld.ismastersim then
	 inst:ListenForEvent("fadedirty", OnFadeDirty)
  
        return inst
    end
	
	inst.AnimState:PushAnimation("sporebomb_loop")
	
	inst:DoPeriodicTask(1, function()	
	fadeout_page(inst) 	end)
	inst:DoTaskInTime(10, function()	
	fadeout_time(inst) 	end)
	
	return inst
end

return Prefab("mypet80", mypet80, assets),
		Prefab("mypet60", mypet60, assets),
		Prefab("mypet40", mypet40, assets),
		Prefab("mypet20", mypet20, assets)
