﻿using HarmonyLib;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using TaleWorlds.CampaignSystem;
using TaleWorlds.CampaignSystem.SandBox.CampaignBehaviors;
using TaleWorlds.Core;
using TaleWorlds.Library;
using TaleWorlds.Localization;
using TaleWorlds.MountAndBlade;

namespace ForceBanditFight
{
    public class ForceBanditFightModule : MBSubModuleBase
    {
        protected override void OnSubModuleLoad()
        {
            base.OnSubModuleLoad();
            var harmony = new Harmony("ForceBanditFight");
            harmony.PatchAll();
        }
    }
}

[HarmonyPatch(typeof(BanditsCampaignBehavior))]
[HarmonyPatch("AddDialogs")]
class PatchBanditDialog
{
    static void Postfix(BanditsCampaignBehavior __instance, CampaignGameStarter campaignGameSystemStarter)
    {
        campaignGameSystemStarter.AddPlayerLine("common_bandit_join_player_force_fight",
            "bandits_we_can_join_you",
            "bandit_start_fight",
            "I will drink from your skull!",
            null,
            null,
            100,
            null,
            null);
    }
}