

local SentientFan = Class(function(self, inst)
    self.inst = inst
    self.time_to_convo = 10

    self.inst:ListenForEvent("ondropped", function() self:OnDropped() end)
    self.inst:ListenForEvent("equipped", function(_, data) self:OnEquipped(data.owner) end)
	self.inst:ListenForEvent("finishedwork", function(_, data) self:OnFinishedWork(data.target, data.action) end, GetPlayer())
    local dt = 5
    self.inst:DoPeriodicTask(dt, function() self:OnUpdate(dt) end)
    self.warnlevel = 0

end)

function SentientFan:OnFinishedWork(target, action)
    if action == ACTIONS.CHOP and  math.random() < .15 and self.inst.components.inventoryitem.owner == GetPlayer() then
        self:Say(STRINGS.WHARANGFAN.on_chopped)
    end
	if action == ACTIONS.MINE and  math.random() < .15 and self.inst.components.inventoryitem.owner == GetPlayer() then
        self:Say(STRINGS.WHARANGFAN.on_mine)
    end
	if action == ACTIONS.HAMMER and  math.random() < .15 and self.inst.components.inventoryitem.owner == GetPlayer() then
        self:Say(STRINGS.WHARANGFAN.on_hammer)
    end
	if action == ACTIONS.DIG and  math.random() < .15 and self.inst.components.inventoryitem.owner == GetPlayer() then
        self:Say(STRINGS.WHARANGFAN.on_dig)
    end
	if action == ACTIONS.NET and  math.random() < .15 and self.inst.components.inventoryitem.owner == GetPlayer() then
        self:Say(STRINGS.WHARANGFAN.on_net)
    end
end

function SentientFan:OnDropped()
    if GetPlayer().components.beaverness and GetPlayer().components.beaverness:IsBeaver() then
        self:Say(STRINGS.WHARANGFAN.transform_beaver)
    else
		self:Say(STRINGS.WHARANGFAN.on_dropped)
    end
end

function SentientFan:OnEquipped(picked_up_by)
    if picked_up_by == GetPlayer() then
        self:Say(STRINGS.WHARANGFAN.on_pickedup) 
    end
end

function SentientFan:OnUpdate(dt)
    self.time_to_convo = self.time_to_convo - dt
    if self.time_to_convo <= 0 then
        self:MakeConversation()
    end
end

function SentientFan:Say(list, sound_override)
    self.sound_override = sound_override
    self.inst.components.talker:Say(list[math.random(#list)])
    self.time_to_convo = math.random(60, 120)
end


function SentientFan:MakeConversation()
    
    local grand_owner = self.inst.components.inventoryitem:GetGrandOwner()
    local owner = self.inst.components.inventoryitem.owner

    local quiplist = nil
    if owner == GetPlayer() then
        if self.inst.components.equippable:IsEquipped() then
            --currently equipped
            quiplist = STRINGS.WHARANGFAN.equipped
        else
            --in player inventory
        end
    --elseif owner == nil then
        --on the ground
    --    quiplist = STRINGS.WHARANGFAN.on_ground
    --elseif grand_owner ~= owner and grand_owner == GetPlayer() then
        --in a backpack
    --    quiplist = STRINGS.WHARANGFAN.in_container
    --elseif owner and owner.components.container then
    --    --in a container
    --    quiplist = STRINGS.WHARANGFAN.in_container
    --else
        --owned by someone else
    --    quiplist = STRINGS.WHARANGFAN.other_owner
    end

    if quiplist then
        self:Say(quiplist)
    end
end

return SentientFan