local WallDoors = Class(function(self, inst)
	self.inst = inst
	self.openwallfn = nil
	self.closewallfn = nil
	self.isopen = false
	self.caninteractfn = nil
end)

function WallDoors:OnSave()
	local data = {}	
	data.isopen = self.isopen
	return data
end

function WallDoors:OnLoad(data)
	if data then
		self.isopen = data.isopen
		if self:IsOpen() then self:OpenWall() else self:CloseWall() end
	end
end

function WallDoors:OpenWall()
	if self.openwallfn then
		self.openwallfn(self.inst)
	end
	self.isopen = true
end

function WallDoors:CanInteract()
	if self.caninteractfn then
		return self.caninteractfn(self.inst)
	else
		return true
	end
end

function WallDoors:CloseWall()
	if self.closewallfn then
		self.closewallfn(self.inst)
	end
	self.isopen = false
end

function WallDoors:IsOpen()
	return self.isopen
end

function WallDoors:CollectSceneActions(doer, actions, right)
	if right and self:CanInteract() then
		if self:IsOpen() then
			table.insert(actions, ACTIONS.CLOSEWALL)
		else
			table.insert(actions, ACTIONS.OPENWALL)
		end	
	end
end

return WallDoors