local assets =
{
	Asset("ANIM", "anim/firepit_ghost_fire.zip"),
	Asset("SOUND", "sound/common.fsb"),
}

local function GetHeatFn(inst)
if IsDLCEnabled(REIGN_OF_GIANTS) then
local heats = { 85, 100, 115, 130 }
return heats[inst.components.firefx.level] or 20
elseif not IsDLCEnabled(REIGN_OF_GIANTS) then
local heats = { 85, 135, 145, 235 }
return heats[inst.components.firefx.level] or 20
end
end

local function fn(Sim)

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local light = inst.entity:AddLight()

    anim:SetBank("firepit_ghost_fire")
    anim:SetBuild("firepit_ghost_fire")
	anim:SetBloomEffectHandle( "shaders/anim.ksh" )
    inst.AnimState:SetRayTestOnBB(true)
    
    inst:AddTag("fx")

    inst:AddComponent("heater")
    inst.components.heater.heatfn = GetHeatFn

    inst:AddComponent("firefx")
    inst.components.firefx.levels =
    {
        {anim="level1", sound="dontstarve/common/campfire", radius=2, intensity=.8, falloff=.33, colour = {192/255,255/255,192/255}, soundintensity=.1},
        {anim="level2", sound="dontstarve/common/campfire", radius=3, intensity=.8, falloff=.33, colour = {192/255,255/255,192/255}, soundintensity=.3},
        {anim="level3", sound="dontstarve/common/campfire", radius=4, intensity=.8, falloff=.33, colour = {192/255,255/255,192/255}, soundintensity=.6},
        {anim="level4", sound="dontstarve/common/campfire", radius=5, intensity=.8, falloff=.33, colour = {192/255,255/255,192/255}, soundintensity=1},
    }
    
    anim:SetFinalOffset(-1)
    inst.components.firefx:SetLevel(1)
    inst.components.firefx.usedayparamforsound = true
    return inst
end

STRINGS.NAMES.FIREPIT_GHOST_FIRE = ""

return Prefab( "common/fx/firepit_ghost_fire", fn, assets) 
